/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.utils;

import com.huawei.utils.AssertFailed;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Debug {
    private static String indentString = "    ";
    private static final String lineSeparator = System.getProperty("line.separator");
    public static PrintWriter out = new PrintWriter(System.out);
    private static final byte[] hexNumber = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final String fullInfo = "!@*#~^?'/\"";
    static /* synthetic */ Class class$com$huawei$utils$Debug;
    static /* synthetic */ Class class$java$lang$String;

    private Debug() {
    }

    public static final void myAssert(boolean condition) {
        if (!condition) {
            throw new AssertFailed();
        }
    }

    public static void setDumpStream(OutputStream os) {
        out = new PrintWriter(os);
    }

    public static void setDumpStream(Writer w2) {
        out = new PrintWriter(w2);
    }

    public static void setDumpIndent(String indent) {
        indentString = indent;
    }

    public static String getDumpIndent() {
        return indentString;
    }

    public static final void dump() {
        out.println(Debug.dumpHead());
        out.flush();
    }

    public static final void dump(int i2) {
        out.println(Debug.dumpHead() + i2);
        out.flush();
    }

    public static final void dump(long l2) {
        out.println(Debug.dumpHead() + l2);
        out.flush();
    }

    public static final void dump(float f2) {
        out.println(Debug.dumpHead() + f2);
        out.flush();
    }

    public static final void dump(double d2) {
        out.println(Debug.dumpHead() + d2);
        out.flush();
    }

    public static final void dump(boolean b2) {
        out.println(Debug.dumpHead() + b2);
        out.flush();
    }

    public static final void dump(char ch) {
        out.println(Debug.dumpHead() + ch);
        out.flush();
    }

    public static final void dump(byte[] data, int offset, int length) {
        Debug.dump(Debug.dumpHead(), data, offset, length);
    }

    public static final void dump(byte[] data) {
        Debug.dump(Debug.dumpHead(), data);
    }

    public static final void dump(Object obj) {
        Debug.dump(Debug.dumpHead(), 3, new Vector(), obj);
    }

    public static final void dump(Object obj, String prefix) {
        Debug.dump(prefix + Debug.dumpHead(), 3, new Vector(), obj);
    }

    public static final void dump(Object obj, int depth) {
        Debug.dump(Debug.dumpHead(), depth, new Vector(), obj);
    }

    private static final void dump(String prefix, int depth, Vector checkCircuit, Vector v2) {
        if (v2 == null) {
            Debug.dump(prefix, "null");
            return;
        }
        Debug.dumpBegin(prefix, checkCircuit, v2);
        for (int i2 = 0; i2 < v2.size(); ++i2) {
            Object item = v2.elementAt(i2);
            StringBuffer itemPrefix = new StringBuffer();
            itemPrefix.append(Debug.indent(prefix));
            itemPrefix.append('[');
            itemPrefix.append(i2);
            itemPrefix.append("] ");
            itemPrefix.append(Debug.formatClassName(item.getClass(), item));
            itemPrefix.append(" @");
            itemPrefix.append(System.identityHashCode(item));
            Debug.dump(itemPrefix.toString(), depth, checkCircuit, item);
        }
        Debug.dumpEnd(prefix, checkCircuit, v2);
    }

    private static final void dumpServletRequest(String prefix, Object request) {
        try {
            if (request == null) {
                Debug.dump(prefix, "null");
                return;
            }
            Debug.dumpBegin(prefix, new Vector(), request);
            Class<?> c2 = request.getClass();
            Method m1 = null;
            m1 = c2.getMethod("getParameterNames", new Class[0]);
            Enumeration e2 = (Enumeration)m1.invoke(request, new Object[0]);
            while (e2.hasMoreElements()) {
                String name = e2.nextElement().toString();
                Method m2 = c2.getMethod("getParameterValues", class$java$lang$String == null ? Debug.class$("java.lang.String") : class$java$lang$String);
                String[] values = (String[])m2.invoke(request, name);
                StringBuffer sb2 = new StringBuffer();
                for (int i2 = 0; i2 < values.length; ++i2) {
                    sb2.append(values[i2]);
                    if (i2 == values.length - 1) continue;
                    sb2.append(" ; ");
                }
                Debug.dump(Debug.indent(prefix), name + " = " + sb2);
            }
            Debug.dumpEnd(prefix, new Vector(), request);
        }
        catch (Exception ex) {
            ex.printStackTrace(out);
        }
    }

    private static final void dump(String prefix, int depth, Vector checkCircuit, Enumeration e2) {
        if (e2 == null) {
            Debug.dump(prefix, "null");
            return;
        }
        Debug.dumpBegin(prefix, checkCircuit, e2);
        int i2 = 0;
        while (e2.hasMoreElements()) {
            Debug.dump(Debug.indent(prefix) + '[' + i2++ + "] ", depth, checkCircuit, e2.nextElement());
        }
        Debug.dumpEnd(prefix, checkCircuit, e2);
    }

    private static final void dump(String prefix, Throwable t2) {
        if (t2 == null) {
            Debug.dump(prefix, "null");
            return;
        }
        Debug.dumpBegin(prefix, new Vector(), t2);
        t2.printStackTrace(out);
        Debug.dumpEnd(prefix, new Vector(), t2);
    }

    private static final void dump(String prefix, byte[] data, int offset, int length) {
        if (data == null) {
            Debug.dump(prefix, "null");
            return;
        }
        if (offset < 0 || data.length < offset + length) {
            Debug.dump(prefix, "IndexOutOfBounds:data.length=" + data.length + " offset=" + offset + " length=" + length);
            return;
        }
        Debug.dumpBegin(prefix, new Vector(), data);
        int end = offset + length;
        Debug.dump(Debug.indent(prefix), "[HEX]  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f | 0123456789abcdef");
        Debug.dump(Debug.indent(prefix), "------------------------------------------------------------------------");
        for (int i2 = offset; i2 < end; i2 += 16) {
            byte[] row = new byte[]{48, 48, 48, 48, 58, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 48, 48, 32, 124, 32, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46};
            Debug.setHex(row, 3, i2);
            for (int j2 = i2; j2 < i2 + 16; ++j2) {
                if (j2 < end) {
                    int b2 = data[j2];
                    if (b2 < 0) {
                        b2 += 256;
                    }
                    Debug.setHex(row, 7 + (j2 - i2) * 3, b2);
                    if (b2 < 32 || b2 >= 127) continue;
                    row[56 + j2 - i2] = (byte)b2;
                    continue;
                }
                row[6 + (j2 - i2) * 3] = 32;
                row[7 + (j2 - i2) * 3] = 32;
                row[56 + (j2 - i2)] = 32;
            }
            Debug.dump(Debug.indent(prefix), new String(row));
        }
        Debug.dumpEnd(prefix, new Vector(), data);
    }

    private static final void dump(String prefix, byte[] b2) {
        Debug.dump(prefix, b2, 0, b2.length > 512 ? 512 : b2.length);
    }

    private static final void dump(String prefix, int depth, Vector checkCircuit, Map map) {
        if (map == null) {
            Debug.dump(prefix, "null");
        }
        Debug.dumpBegin(prefix, checkCircuit, map);
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            Object key = i2.next();
            Object value = map.get(key);
            if (value instanceof String) {
                Debug.dump(Debug.indent(prefix), key.toString() + " = " + value);
                continue;
            }
            Debug.dump(Debug.indent(prefix) + key.toString() + " = ", depth, checkCircuit, map.get(key));
        }
        Debug.dumpEnd(prefix, checkCircuit, map);
    }

    private static final void dump(String prefix, String str) {
        out.println(prefix + str);
        out.flush();
    }

    private static final void dump(String prefix, int depth, Vector checkCircuit, Object[] objs) {
        if (objs == null) {
            Debug.dump(prefix, "null");
            return;
        }
        Debug.dumpBegin(prefix, checkCircuit, objs);
        for (int i2 = 0; i2 < objs.length; ++i2) {
            Debug.dump(Debug.indent(prefix) + '[' + i2 + "] ", depth, checkCircuit, objs[i2]);
        }
        Debug.dumpEnd(prefix, checkCircuit, objs);
    }

    private static void dump(String prefix, int depth, Vector checkCircuit, Object obj) {
        if (obj == null) {
            Debug.dump(prefix, "null");
            return;
        }
        try {
            if (obj instanceof String || obj instanceof Number || obj instanceof Character || obj instanceof Boolean) {
                Debug.dump(prefix, obj.toString());
                return;
            }
            if (checkCircuit.contains(new Integer(System.identityHashCode(obj)))) {
                StringBuffer sb2 = new StringBuffer();
                sb2.append(Debug.formatClassName(obj.getClass(), obj));
                sb2.append(" @");
                sb2.append(System.identityHashCode(obj));
                sb2.append(' ');
                Debug.dump(prefix, " {Circle recursion!}");
                return;
            }
            if (Debug.getDepth(prefix) > depth) {
                String toStr;
                String str = Debug.formatClassName(obj.getClass(), obj) + " @" + System.identityHashCode(obj);
                if (prefix.trim().endsWith(str.trim())) {
                    str = "";
                }
                try {
                    toStr = obj.toString();
                    if (toStr.indexOf(64) > 0) {
                        toStr = " {Stack overflow!}";
                    }
                }
                catch (StackOverflowError t2) {
                    toStr = " {Stack overflow!}";
                }
                Debug.dump(prefix, str + toStr);
                return;
            }
            if (obj instanceof Vector) {
                Debug.dump(prefix, depth, checkCircuit, (Vector)obj);
                return;
            }
            if (obj instanceof Map) {
                Debug.dump(prefix, depth, checkCircuit, (Map)obj);
                return;
            }
            if (obj instanceof Enumeration) {
                Debug.dump(prefix, depth, checkCircuit, (Enumeration)obj);
                return;
            }
            if (obj instanceof Object[]) {
                Debug.dump(prefix, depth, checkCircuit, (Object[])obj);
                return;
            }
            if (obj instanceof Throwable) {
                Debug.dump(prefix, (Throwable)obj);
                return;
            }
            if (obj instanceof byte[]) {
                Debug.dump(prefix, (byte[])obj);
                return;
            }
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                Debug.dumpBegin(prefix, checkCircuit, obj);
                StringBuffer content = new StringBuffer();
                for (int i2 = 0; i2 < len; ++i2) {
                    content.append(Debug.fixLength(Array.get(obj, i2).toString(), 4));
                    if (i2 % 8 != 7 || i2 >= len - 1) continue;
                    content.append(lineSeparator + Debug.indent(prefix));
                }
                Debug.dump(Debug.indent(prefix), content.toString());
                Debug.dumpEnd(prefix, checkCircuit, obj);
                return;
            }
            if (Class.forName("javax.servlet.ServletRequest").isInstance(obj)) {
                Debug.dumpServletRequest(prefix, obj);
                return;
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Debug.dumpBegin(prefix, checkCircuit, obj);
        for (Class<?> c2 = obj.getClass(); c2 != null; c2 = c2.getSuperclass()) {
            Field[] f2;
            try {
                f2 = c2.getDeclaredFields();
            }
            catch (SecurityException ex2) {
                Debug.dump(Debug.indent(prefix), "Can't dump object member for security reason.");
                return;
            }
            for (int i3 = 0; i3 < f2.length; ++i3) {
                String m2 = Modifier.toString(f2[i3].getModifiers());
                if (m2.indexOf("static") > 0) continue;
                String n2 = f2[i3].getName();
                Object v2 = "[unkonwn]";
                try {
                    f2[i3].setAccessible(true);
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
                try {
                    v2 = f2[i3].get(obj);
                    if (v2 != null) {
                        if (v2 instanceof String) {
                            v2 = "\"" + v2 + '\"';
                        } else if (v2 instanceof Character) {
                            char cv = ((Character)v2).charValue();
                            if (cv < ' ') {
                                StringBuffer sbv = new StringBuffer();
                                sbv.append("\\u");
                                sbv.append(Integer.toHexString(cv));
                                while (sbv.length() < 6) {
                                    sbv.insert(2, '0');
                                }
                                v2 = sbv;
                            }
                            v2 = "'" + v2 + '\'';
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Class<?> ct = f2[i3].getType();
                String t3 = Debug.formatClassName(ct, v2);
                Debug.dump(Debug.indent(prefix) + (m2 + ' ' + t3 + ' ' + n2).trim() + " = ", depth, checkCircuit, v2);
            }
        }
        Debug.dumpEnd(prefix, checkCircuit, obj);
    }

    private static void dumpBegin(String prefix, Vector checkCircuit, Object obj) {
        String className = Debug.formatClassName(obj.getClass(), obj);
        int address = System.identityHashCode(obj);
        checkCircuit.addElement(new Integer(address));
        if (obj instanceof Array) {
            className = className.substring(2) + '[' + Array.getLength(obj) + "] ";
        }
        if (className.startsWith("java.lang.")) {
            className = className.substring(10);
        }
        if (prefix.trim().endsWith("@" + address)) {
            out.println(prefix + " {");
        } else {
            out.println(prefix + className + " @" + address + " {");
        }
    }

    private static void dumpEnd(String prefix, Vector checkCircuit, Object obj) {
        char c2;
        checkCircuit.removeElement(new Integer(System.identityHashCode(obj)));
        int p2 = prefix.lastIndexOf(indentString);
        if (p2 > 0) {
            prefix = prefix.substring(0, p2) + indentString;
        }
        for (int i2 = 0; i2 < prefix.length() && ((c2 = prefix.charAt(i2)) == '\t' || c2 == ' '); ++i2) {
            out.print(c2);
        }
        out.println("}");
        out.flush();
    }

    public static String locate(String esc) {
        StringWriter sw = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(sw));
        StringTokenizer st = new StringTokenizer(sw.toString(), "\n");
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (str.indexOf("Exception") != -1 || str.indexOf((class$com$huawei$utils$Debug == null ? Debug.class$("com.huawei.utils.Debug") : class$com$huawei$utils$Debug).getName()) != -1 || esc != null && str.indexOf(esc) != -1) continue;
            if (esc == fullInfo) {
                return str;
            }
            int i2 = str.indexOf(40);
            int j2 = str.indexOf(41);
            if (i2 == -1 || j2 == -1) break;
            return str.substring(i2, j2 + 1);
        }
        return "";
    }

    private static void setHex(byte[] src, int lowByte, int value) {
        for (int i2 = 0; i2 < 8; ++i2) {
            src[lowByte - i2] = hexNumber[value & 0xF];
            if ((value >>>= 4) == 0) break;
        }
    }

    private static String indent(String prefix) {
        char c2;
        int p2 = prefix.lastIndexOf(indentString);
        if (p2 > 0) {
            prefix = prefix.substring(0, p2) + indentString;
        }
        StringBuffer sb2 = new StringBuffer();
        for (int i2 = 0; i2 < prefix.length() && ((c2 = prefix.charAt(i2)) == '\t' || c2 == ' '); ++i2) {
            sb2.append(c2);
        }
        sb2.append(indentString);
        return sb2.toString();
    }

    private static String formatClassName(Class c2, Object obj) {
        String t2 = c2.getName();
        if (t2.charAt(t2.length() - 1) == ';') {
            t2 = t2.substring(0, t2.length() - 1);
        }
        boolean isArray = false;
        boolean firstDimension = true;
        while (t2.startsWith("[")) {
            isArray = true;
            if (firstDimension && obj != null) {
                t2 = t2.substring(1) + '[' + Array.getLength(obj) + ']';
                firstDimension = false;
                continue;
            }
            t2 = t2.substring(1) + "[]";
        }
        if (isArray) {
            char ch = t2.charAt(0);
            t2 = t2.substring(1);
            switch (ch) {
                case 'B': {
                    t2 = "byte" + t2;
                    break;
                }
                case 'C': {
                    t2 = "char" + t2;
                    break;
                }
                case 'F': {
                    t2 = "float" + t2;
                    break;
                }
                case 'I': {
                    t2 = "int" + t2;
                    break;
                }
                case 'J': {
                    t2 = "long" + t2;
                    break;
                }
                case 'S': {
                    t2 = "short" + t2;
                    break;
                }
                case 'Z': {
                    t2 = "boolean" + t2;
                }
            }
        }
        if (t2.startsWith("java.lang.")) {
            t2 = t2.substring(10);
        } else if (t2.startsWith("class ")) {
            t2 = t2.substring(7);
        }
        return t2;
    }

    private static String fixLength(String str, int len) {
        StringBuffer sb2 = new StringBuffer(len);
        sb2.append(str);
        int n2 = len - str.length() % len;
        for (int i2 = 0; i2 < n2; ++i2) {
            sb2.append(' ');
        }
        return sb2.toString();
    }

    private static String dumpHead() {
        StringBuffer sb2 = new StringBuffer();
        sb2.append(sdf.format(new Date()));
        sb2.append(Debug.locate(null));
        sb2.append(' ');
        return sb2.toString();
    }

    private static int getDepth(String prefix) {
        int count = 0;
        int indentLen = indentString.length();
        int i2 = -indentLen;
        do {
            ++count;
        } while ((i2 = prefix.indexOf(indentString, i2 + indentLen)) >= 0);
        return count;
    }
}

