/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.utils;

import com.huawei.utils.Args;
import com.huawei.utils.Base64;
import com.huawei.utils.Debug;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Cfg {
    private static DocumentBuilderFactory factory;
    private static DocumentBuilder builder;
    private static final String XML_HEAD;
    private static String indent;
    private boolean isDirty;
    private Document doc;
    private Element root;
    private String file;

    public Cfg(String url) throws IOException {
        this(url, false);
    }

    public Cfg(String url, boolean create) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        this.file = url.indexOf(58) > 1 ? url : new File(url).toURL().toString();
        new URL(this.file);
        try {
            this.load();
        }
        catch (FileNotFoundException ex) {
            if (!create) {
                throw ex;
            }
            this.loadXMLParser();
            this.doc = builder.newDocument();
            this.root = this.doc.createElement("config");
            this.doc.appendChild(this.root);
            this.isDirty = true;
            this.flush();
            return;
        }
    }

    public Args getArgs(String key) {
        HashMap<String, String> args = new HashMap<String, String>();
        String[] children = this.childrenNames(key);
        for (int i2 = 0; i2 < children.length; ++i2) {
            args.put(children[i2], this.get(key + '/' + children[i2], null));
        }
        return new Args(args);
    }

    private static void writeIndent(PrintWriter pw, int level) {
        for (int i2 = 0; i2 < level; ++i2) {
            pw.print(indent);
        }
    }

    private static void writeNode(Node node, PrintWriter pw, int deep) {
        switch (node.getNodeType()) {
            case 8: {
                Cfg.writeIndent(pw, deep);
                pw.print("<!--");
                pw.print(node.getNodeValue());
                pw.println("-->");
                return;
            }
            case 3: {
                String value = node.getNodeValue().trim();
                if (value.length() == 0) {
                    return;
                }
                Cfg.writeIndent(pw, deep);
                block13: for (int i2 = 0; i2 < value.length(); ++i2) {
                    char c2 = value.charAt(i2);
                    switch (c2) {
                        case '<': {
                            pw.print("&lt;");
                            continue block13;
                        }
                        case '>': {
                            pw.print("&lt;");
                            continue block13;
                        }
                        case '&': {
                            pw.print("&amp;");
                            continue block13;
                        }
                        case '\'': {
                            pw.print("&apos;");
                            continue block13;
                        }
                        case '\"': {
                            pw.print("&quot;");
                            continue block13;
                        }
                        default: {
                            pw.print(c2);
                        }
                    }
                }
                pw.println();
                return;
            }
            case 1: {
                if (!node.hasChildNodes()) {
                    return;
                }
                for (int i3 = 0; i3 < deep; ++i3) {
                    pw.print(indent);
                }
                String nodeName = node.getNodeName();
                pw.print('<');
                pw.print(nodeName);
                NamedNodeMap nnm = node.getAttributes();
                if (nnm != null) {
                    for (int i4 = 0; i4 < nnm.getLength(); ++i4) {
                        Node attr = nnm.item(i4);
                        pw.print(' ');
                        pw.print(attr.getNodeName());
                        pw.print("=\"");
                        pw.print(attr.getNodeValue());
                        pw.print('\"');
                    }
                }
                if (node.hasChildNodes()) {
                    int i5;
                    Node n2;
                    NodeList children = node.getChildNodes();
                    if (children.getLength() == 0) {
                        pw.print('<');
                        pw.print(nodeName);
                        pw.println("/>");
                        return;
                    }
                    if (children.getLength() == 1 && (n2 = children.item(0)).getNodeType() == 3) {
                        String v2 = n2.getNodeValue();
                        if (v2 != null) {
                            v2 = v2.trim();
                        }
                        if (v2 == null || v2.length() == 0) {
                            pw.println(" />");
                            return;
                        }
                        pw.print('>');
                        pw.print(v2);
                        pw.print("</");
                        pw.print(nodeName);
                        pw.println('>');
                        return;
                    }
                    pw.println(">");
                    for (i5 = 0; i5 < children.getLength(); ++i5) {
                        Cfg.writeNode(children.item(i5), pw, deep + 1);
                    }
                    for (i5 = 0; i5 < deep; ++i5) {
                        pw.print(indent);
                    }
                    pw.print("</");
                    pw.print(nodeName);
                    pw.println(">");
                } else {
                    pw.println("/>");
                }
                return;
            }
            case 9: {
                pw.println(XML_HEAD);
                NodeList nl = node.getChildNodes();
                for (int i6 = 0; i6 < nl.getLength(); ++i6) {
                    Cfg.writeNode(nl.item(i6), pw, 0);
                }
                return;
            }
        }
    }

    private Node findNode(String key) {
        Node ancestor = this.root;
        StringTokenizer st = new StringTokenizer(key, "/");
        block0: while (st.hasMoreTokens()) {
            String nodeName = st.nextToken();
            NodeList nl = ancestor.getChildNodes();
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node n2 = nl.item(i2);
                if (!nodeName.equals(n2.getNodeName())) continue;
                ancestor = n2;
                if (st.hasMoreTokens()) continue block0;
                return n2;
            }
        }
        return null;
    }

    private Node createNode(String key) {
        Node ancestor = this.root;
        StringTokenizer st = new StringTokenizer(key, "/");
        block0: while (st.hasMoreTokens()) {
            String nodeName = st.nextToken();
            NodeList nl = ancestor.getChildNodes();
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node n2 = nl.item(i2);
                if (!nodeName.equals(n2.getNodeName())) continue;
                ancestor = n2;
                if (st.hasMoreTokens()) continue block0;
                return ancestor;
            }
            while (true) {
                Element n3 = this.doc.createElement(nodeName);
                ancestor.appendChild(n3);
                ancestor = n3;
                if (!st.hasMoreTokens()) {
                    return ancestor;
                }
                nodeName = st.nextToken();
            }
        }
        return null;
    }

    private Node createNode(Node ancestor, String key) {
        StringTokenizer st = new StringTokenizer(key, "/");
        block0: while (st.hasMoreTokens()) {
            String nodeName = st.nextToken();
            NodeList nl = ancestor.getChildNodes();
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                if (!nodeName.equals(nl.item(i2).getNodeName())) continue;
                ancestor = nl.item(i2);
                continue block0;
            }
            return null;
        }
        return ancestor;
    }

    public String get(String key, String def) {
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        Node node = this.findNode(key);
        if (node == null) {
            return def;
        }
        NodeList nl = node.getChildNodes();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            if (nl.item(i2).getNodeType() != 3) continue;
            return nl.item(i2).getNodeValue().trim();
        }
        node.appendChild(this.doc.createTextNode(def));
        return def;
    }

    public void put(String key, String value) {
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        value = value.trim();
        Node node = this.createNode(key);
        NodeList nl = node.getChildNodes();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            String childValue;
            Node child = nl.item(i2);
            if (child.getNodeType() != 3 || (childValue = child.getNodeValue().trim()).length() == 0) continue;
            if (childValue.equals(value)) {
                return;
            }
            child.setNodeValue(value);
            this.isDirty = true;
            return;
        }
        if (nl.getLength() == 0) {
            node.appendChild(this.doc.createTextNode(value));
        } else {
            Node f2 = node.getFirstChild();
            if (f2.getNodeType() == 3) {
                f2.setNodeValue(value);
            } else {
                node.insertBefore(this.doc.createTextNode(value), f2);
            }
        }
        this.isDirty = true;
    }

    public boolean getBoolean(String key, boolean def) {
        String str = String.valueOf(def);
        String resstr = this.get(key, str);
        Boolean resboolean = Boolean.valueOf(resstr);
        boolean result = resboolean;
        return result;
    }

    public int getInt(String key, int def) {
        int result;
        String str = String.valueOf(def);
        String resstr = this.get(key, str);
        try {
            result = Integer.parseInt(resstr);
        }
        catch (NumberFormatException e2) {
            return def;
        }
        return result;
    }

    public float getFloat(String key, float def) {
        float result;
        String str = String.valueOf(def);
        String resstr = this.get(key, str);
        try {
            result = Float.parseFloat(resstr);
        }
        catch (NumberFormatException e2) {
            return def;
        }
        return result;
    }

    public double getDouble(String key, double def) {
        double result;
        String str = String.valueOf(def);
        String resstr = this.get(key, str);
        try {
            result = Double.parseDouble(resstr);
        }
        catch (NumberFormatException e2) {
            return def;
        }
        return result;
    }

    public long getLong(String key, long def) {
        long result;
        String str = String.valueOf(def);
        String resstr = this.get(key, str);
        try {
            result = Long.parseLong(resstr);
        }
        catch (NumberFormatException e2) {
            return def;
        }
        return result;
    }

    public byte[] getByteArray(String key, byte[] def) {
        String str = new String(def);
        String resstr = this.get(key, str);
        byte[] result = resstr.getBytes();
        return result;
    }

    public void putBoolean(String key, boolean value) {
        String str = String.valueOf(value);
        this.put(key, str);
    }

    public void putInt(String key, int value) {
        String str = String.valueOf(value);
        this.put(key, str);
    }

    public void putFloat(String key, float value) {
        String str = String.valueOf(value);
        this.put(key, str);
    }

    public void putDouble(String key, double value) {
        String str = String.valueOf(value);
        this.put(key, str);
    }

    public void putLong(String key, long value) {
        String str = String.valueOf(value);
        this.put(key, str);
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, Base64.encode(value));
    }

    public void removeNode(String key) {
        Node node = this.findNode(key);
        if (node == null) {
            return;
        }
        Node parentnode = node.getParentNode();
        if (parentnode != null) {
            parentnode.removeChild(node);
            this.isDirty = true;
        }
    }

    public void clear(String key) {
        Node node = this.findNode(key);
        if (node == null) {
            throw new RuntimeException("InvalidName");
        }
        Node lastnode = null;
        while (node.hasChildNodes()) {
            lastnode = node.getLastChild();
            node.removeChild(lastnode);
        }
        if (lastnode != null) {
            this.isDirty = true;
        }
    }

    public String[] childrenNames(String key) {
        Node node = this.findNode(key);
        if (node == null) {
            return new String[0];
        }
        NodeList nl = node.getChildNodes();
        LinkedList<String> list = new LinkedList<String>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Node child = nl.item(i2);
            if (child.getNodeType() != 1 || !child.hasChildNodes()) continue;
            list.add(child.getNodeName());
        }
        String[] ret = new String[list.size()];
        for (int i3 = 0; i3 < ret.length; ++i3) {
            ret[i3] = (String)list.get(i3);
        }
        return ret;
    }

    public boolean nodeExist(String key) {
        Node theNode = this.findNode(key);
        if (theNode == null) {
            return false;
        }
        return theNode.hasChildNodes();
    }

    private void loadXMLParser() throws IOException {
        if (builder == null) {
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setIgnoringComments(true);
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new IOException("XML Parser load error:" + ex.getLocalizedMessage());
            }
        }
    }

    public void load() throws IOException {
        this.loadXMLParser();
        try {
            InputSource is = new InputSource(new InputStreamReader(new URL(this.file).openStream()));
            is.setEncoding(System.getProperty("file.encoding"));
            this.doc = builder.parse(is);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            String message = ex.getMessage();
            Exception e2 = ex.getException();
            if (e2 != null) {
                message = message + "embedded exception:" + e2;
            }
            throw new IOException("XML file parse error:" + message);
        }
        this.root = this.doc.getDocumentElement();
        if (!"config".equals(this.root.getNodeName())) {
            throw new IOException("Config file format error, root node must be <config>");
        }
    }

    public void flush() throws IOException {
        if (this.isDirty) {
            String proc = new URL(this.file).getProtocol().toLowerCase();
            if (!proc.equalsIgnoreCase("file")) {
                throw new UnsupportedOperationException("Unsupport write config URL on protocal " + proc);
            }
            String fileName = new URL(this.file).getPath();
            Debug.dump(new URL(this.file).getPath());
            Debug.dump(new URL(this.file).getFile());
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName), 2048);
            PrintWriter pw = new PrintWriter(bos);
            Cfg.writeNode(this.doc, pw, 0);
            pw.flush();
            pw.close();
            this.isDirty = false;
        }
    }

    private String change(String str) throws IOException {
        if (str.indexOf(38) != -1 || str.indexOf(60) != -1 || str.indexOf(62) != -1) {
            byte temp;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
            byte[] ba1 = new byte[]{38, 97, 109, 112, 59};
            byte[] ba2 = new byte[]{38, 108, 116, 59};
            byte[] ba3 = new byte[]{38, 103, 116, 59};
            block5: while ((temp = (byte)bis.read()) != -1) {
                switch (temp) {
                    case 38: {
                        bos.write(ba1);
                        continue block5;
                    }
                    case 60: {
                        bos.write(ba2);
                        continue block5;
                    }
                    case 62: {
                        bos.write(ba3);
                        continue block5;
                    }
                }
                bos.write(temp);
            }
            return bos.toString();
        }
        return str;
    }

    public static void main(String[] args) throws Exception {
        String line;
        Cfg c2 = new Cfg("testcfg.xml", true);
        c2.put("a/b", "\u6c49\u5b57");
        c2.put("c", "");
        c2.put("a", "avalusaaaaaaaaae");
        c2.flush();
        c2 = new Cfg("testcfg.xml", true);
        System.out.println("Config file content:");
        BufferedReader in = new BufferedReader(new FileReader("testcfg.xml"));
        while ((line = in.readLine()) != null) {
            System.out.println(line);
        }
    }

    static {
        XML_HEAD = "<?xml version=\"1.0\" encoding=\"" + System.getProperty("file.encoding") + "\"?>";
        indent = "  ";
    }
}

