/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.utils;

public class Base64 {
    private static char[] Base64Code = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static byte[] Base64Decode = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 63, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    private Base64() {
    }

    public static String encode(byte[] b2) {
        int code = 0;
        StringBuffer sb2 = new StringBuffer((b2.length - 1) / 3 << 6);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            code |= b2[i2] << 16 - i2 % 3 * 8 & 255 << 16 - i2 % 3 * 8;
            if (i2 % 3 != 2 && i2 != b2.length - 1) continue;
            sb2.append(Base64Code[(code & 0xFC0000) >>> 18]);
            sb2.append(Base64Code[(code & 0x3F000) >>> 12]);
            sb2.append(Base64Code[(code & 0xFC0) >>> 6]);
            sb2.append(Base64Code[code & 0x3F]);
            code = 0;
        }
        if (b2.length % 3 > 0) {
            sb2.setCharAt(sb2.length() - 1, '=');
        }
        if (b2.length % 3 == 1) {
            sb2.setCharAt(sb2.length() - 2, '=');
        }
        return sb2.toString();
    }

    public static byte[] decode(String code) {
        if (code == null) {
            return null;
        }
        int len = code.length();
        if (len % 4 != 0) {
            throw new IllegalArgumentException("Base64 string length must be 4*n");
        }
        if (code.length() == 0) {
            return new byte[0];
        }
        int pad = 0;
        if (code.charAt(len - 1) == '=') {
            ++pad;
        }
        if (code.charAt(len - 2) == '=') {
            ++pad;
        }
        int retLen = len / 4 * 3 - pad;
        byte[] ret = new byte[retLen];
        for (int i2 = 0; i2 < len; i2 += 4) {
            int j2 = i2 / 4 * 3;
            char ch1 = code.charAt(i2);
            char ch2 = code.charAt(i2 + 1);
            char ch3 = code.charAt(i2 + 2);
            char ch4 = code.charAt(i2 + 3);
            int tmp = Base64Decode[ch1] << 18 | Base64Decode[ch2] << 12 | Base64Decode[ch3] << 6 | Base64Decode[ch4];
            ret[j2] = (byte)((tmp & 0xFF0000) >> 16);
            if (i2 < len - 4) {
                ret[j2 + 1] = (byte)((tmp & 0xFF00) >> 8);
                ret[j2 + 2] = (byte)(tmp & 0xFF);
                continue;
            }
            if (j2 + 1 < retLen) {
                ret[j2 + 1] = (byte)((tmp & 0xFF00) >> 8);
            }
            if (j2 + 2 >= retLen) continue;
            ret[j2 + 2] = (byte)(tmp & 0xFF);
        }
        return ret;
    }
}

