/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.api.smsend.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;

public class Tools {
    private static char[] Base64Code = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static boolean checkPathname(String pathname) {
        File file = new File(pathname);
        return file.exists();
    }

    public static boolean checkStringNumber(String number) {
        if (number == null || number.trim().length() <= 0) {
            return false;
        }
        char[] temp = number.toCharArray();
        if (temp[0] < '1' || temp[0] > '9') {
            return false;
        }
        for (int i2 = 1; i2 < temp.length; ++i2) {
            if (temp[i2] >= '0' && temp[i2] <= '9') continue;
            return false;
        }
        return true;
    }

    public static long getFileSize(String pathname) {
        if (pathname == null || pathname.trim().length() < 1) {
            return 0L;
        }
        File file = new File(pathname);
        return file.length() / 1024L + 1L;
    }

    public static ArrayList readFileLine(String pathname, String flag) throws IOException {
        File config = new File(pathname);
        if (!config.exists()) {
            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader configIn = new BufferedReader(new FileReader(config));
        String tempStr = "";
        while ((tempStr = configIn.readLine()) != null) {
            if ("".equals(tempStr) || tempStr.indexOf(flag) < 0) continue;
            list.add(tempStr);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createFile(String pathname, String fileContent) {
        boolean flag = false;
        try {
            File file = new File(pathname);
            file.delete();
            BufferedWriter out = new BufferedWriter(new FileWriter(pathname));
            out.write(fileContent);
            out.close();
            flag = true;
            return flag;
        }
        catch (IOException e2) {
            flag = false;
            return flag;
        }
        finally {
            return flag;
        }
    }

    public static String createDateTime(Date date, String formate) {
        String nowDateTime = "";
        SimpleDateFormat formatter = new SimpleDateFormat(formate);
        nowDateTime = formatter.format((Object)date);
        return nowDateTime;
    }

    public static Timestamp checkDateTime(int year, int month, int day, int hour, int minute) {
        try {
            if (year < 2005 || year > 3000) {
                return null;
            }
            Timestamp dateTime = new Timestamp(year - 1900, month - 1, day, hour, minute, 0, 0);
            String timeStr = dateTime.toString();
            if (Integer.parseInt(timeStr.substring(0, 4)) == year && Integer.parseInt(timeStr.substring(5, 7)) == month && Integer.parseInt(timeStr.substring(8, 10)) == day && hour >= 0 && hour <= 23 && minute >= 0 && minute <= 59) {
                return dateTime;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String digest(String str) {
        try {
            byte[] salt = "webplat".getBytes();
            MessageDigest md5 = MessageDigest.getInstance("SHA");
            md5.update(salt);
            return Tools.encode(md5.digest(str.getBytes()));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException(ex.toString());
        }
    }

    public static String encode(byte[] b2) {
        int code = 0;
        StringBuffer sb2 = new StringBuffer((b2.length - 1) / 3 << 6);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            code |= b2[i2] << 16 - i2 % 3 * 8 & 255 << 16 - i2 % 3 * 8;
            if (i2 % 3 != 2 && i2 != b2.length - 1) continue;
            sb2.append(Base64Code[(code & 0xFC0000) >>> 18]);
            sb2.append(Base64Code[(code & 0x3F000) >>> 12]);
            sb2.append(Base64Code[(code & 0xFC0) >>> 6]);
            sb2.append(Base64Code[code & 0x3F]);
            code = 0;
        }
        if (b2.length % 3 > 0) {
            sb2.setCharAt(sb2.length() - 1, '=');
        }
        if (b2.length % 3 == 1) {
            sb2.setCharAt(sb2.length() - 2, '=');
        }
        return sb2.toString();
    }

    public static int mkdir(String dir) {
        int result = 0;
        try {
            File file = new File(dir);
            boolean bool = false;
            boolean exist = false;
            bool = file.exists();
            if (!bool && !(exist = file.mkdirs())) {
                result = -1;
            }
            return result;
        }
        catch (Exception e2) {
            result = -1;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ftpFile(String localFileName, String serverFileName, String ftpUserName, String ftpPasswrod, String ftpHost, String serverDirectory, int ftpPort) throws Exception {
        FtpClient ftpConn = null;
        FilterOutputStream outs = null;
        FileInputStream fins = null;
        if (ftpHost.indexOf(":") != -1) {
            ftpPort = Integer.parseInt(ftpHost.split(":")[1]);
        }
        try {
            ftpConn = new FtpClient();
            ftpConn.openServer(ftpHost, ftpPort);
            ftpConn.login(ftpUserName, ftpPasswrod);
            ftpConn.binary();
            ftpConn.cd(serverDirectory);
            outs = ftpConn.put(serverFileName);
            fins = new FileInputStream(localFileName);
            byte[] buffer = new byte[1024];
            int readed = 0;
            while ((readed = fins.read(buffer)) != -1) {
                ((TelnetOutputStream)outs).write(buffer, 0, readed);
            }
        }
        finally {
            if (outs != null) {
                outs.close();
            }
            if (fins != null) {
                fins.close();
            }
            if (ftpConn != null) {
                ftpConn.closeServer();
            }
        }
    }

    public static boolean checkFile(String filePath) throws Exception {
        String mobile = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePath));
            while ((mobile = br.readLine()) != null) {
                if (mobile.length() == 0) {
                    throw new Exception("a group contains a mobile telephone");
                }
                String tMobile = mobile.trim();
                if ("".equals(tMobile)) continue;
                String[] s2 = tMobile.split("\\s");
                if (s2.length != 1) {
                    throw new Exception("a group contains a mobile telephone");
                }
                String s1 = s2[0];
                if (Tools.checkPhoneCode(s1)) continue;
                throw new Exception("mobile telephone error,please check mobile");
            }
            br.close();
        }
        catch (Exception e2) {
            throw new Exception(e2.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception eeeee) {}
        }
        return true;
    }

    public static boolean checkPhoneCode(String phone) {
        if (phone == null) {
            return false;
        }
        phone = phone.trim();
        try {
            if (phone.indexOf(".") > -1 || phone.indexOf("-") > -1 || phone.indexOf("+") > -1) {
                return false;
            }
            Float.parseFloat(phone);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return (phone.startsWith("13") || phone.startsWith("159")) && phone.trim().length() == 11 || phone.startsWith("8613") && phone.trim().length() == 13;
    }

    public static boolean deleteUpFile(String filePath) {
        boolean isDeleted = false;
        File webLocalFile = new File(filePath);
        if (webLocalFile.isFile()) {
            isDeleted = webLocalFile.delete();
        }
        webLocalFile = null;
        return isDeleted;
    }
}

