/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.api;

import com.huawei.api.ConnectionMgr;
import com.huawei.api.ProvsionBean;
import com.huawei.api.SMAPIConfig;
import com.huawei.api.SMException;
import com.huawei.api.SMReceivedBean;
import com.huawei.api.SMTools;
import com.huawei.api.SendShorBean;
import com.huawei.api.bean.AbstractMsgBean;
import com.huawei.api.bean.CMPP3Bean;
import com.huawei.api.bean.CMPP3PriorityBean;
import com.huawei.api.bean.ProvsionExBean;
import com.huawei.api.bean.ReversedProvsionExBean;
import com.huawei.api.bean.SMExBean;
import com.huawei.api.bean.WapPushBean;
import com.huawei.api.smsend.common.Tools;
import com.huawei.api.smsend.db.DBSQL;
import com.huawei.api.smsend.system.SMLog;
import com.huawei.utils.SecurityTools;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SMEntryEx {
    private static String dbURL = null;
    private static String dbName = null;
    private static String dbPassword = null;
    private static String sessionCreatorID = "";
    private static String loginUserName = "";
    private static String loginPassword = "";

    public static void init(String userDBURL, String userDBName, String userDBPassword) {
        dbURL = userDBURL;
        dbName = userDBName;
        dbPassword = userDBPassword;
        ConnectionMgr.initConn(userDBURL, userDBName, userDBPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logIn(String EIEUserName, String EIEUerPassword) throws SMException {
        loginPassword = EIEUerPassword;
        loginUserName = EIEUserName;
        Connection conn = null;
        String result = null;
        try {
            conn = ConnectionMgr.getConnection();
            result = SMTools.checkLogin(loginUserName, loginPassword, conn);
        }
        catch (Exception ex) {
            SMLog.error("", ex);
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        if (result == null) {
            SMLog.info("user login failed\uff0cplease check user and password");
            throw new SMException("10065");
        }
        sessionCreatorID = result;
    }

    private static boolean isLogin() throws Exception {
        if ("".equalsIgnoreCase(sessionCreatorID) || sessionCreatorID == null) {
            throw new Exception("Your had exit session,please login in");
        }
        return true;
    }

    public static void logOut() {
        sessionCreatorID = null;
    }

    public static void cleanUp() throws SMException {
        SMEntryEx.logOut();
        ConnectionMgr.close();
    }

    protected static void paramErrors(AbstractMsgBean abstractMsgBean) throws SMException {
        String regex = "\\d+";
        Pattern p2 = Pattern.compile(regex);
        Matcher m2 = null;
        switch (abstractMsgBean.getApiMsgType()) {
            case 1: {
                m2 = p2.matcher(abstractMsgBean.getOrgAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getOrgAddr()) || abstractMsgBean.getOrgAddr() == null || abstractMsgBean.getOrgAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is OrgAddr");
                    throw new SMException("100502");
                }
                m2 = p2.matcher(abstractMsgBean.getDestAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getDestAddr()) || abstractMsgBean.getDestAddr() == null || abstractMsgBean.getDestAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is DestAddr");
                    throw new SMException("100503");
                }
                if (abstractMsgBean.getSmContent() == null || "".equals(abstractMsgBean.getSmContent().trim()) || abstractMsgBean.getSmContent().trim().getBytes().length > SMAPIConfig.SMCONTENT_LEN) {
                    SMLog.info("Parameter Invalid,This Parameter is DestAddr");
                    throw new SMException("100505");
                }
                if (abstractMsgBean.getNeedStateReport() >= 0 && abstractMsgBean.getNeedStateReport() <= 1) break;
                SMLog.info("Parameter Invalid,This Parameter is NeedStateReport");
                throw new SMException("100506");
            }
            case 2: {
                m2 = p2.matcher(abstractMsgBean.getOrgAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getOrgAddr()) || abstractMsgBean.getOrgAddr() == null || abstractMsgBean.getOrgAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is OrgAddr");
                    throw new SMException("100502");
                }
                m2 = p2.matcher(abstractMsgBean.getDestAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getDestAddr()) || abstractMsgBean.getDestAddr() == null || abstractMsgBean.getDestAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is DestAddr");
                    throw new SMException("100503");
                }
                if (abstractMsgBean.getSmContent() == null || "".equals(abstractMsgBean.getSmContent().trim()) || abstractMsgBean.getSmContent().trim().getBytes().length > SMAPIConfig.SMCONTENT_LEN) {
                    SMLog.info("Parameter Invalid,This Parameter is DestAddr");
                    throw new SMException("100505");
                }
                if (abstractMsgBean.getNeedStateReport() < 0 || abstractMsgBean.getNeedStateReport() > 1) {
                    SMLog.info("Parameter Invalid,This Parameter is NeedStateReport");
                    throw new SMException("100506");
                }
                if (abstractMsgBean.getSendLevel() >= 0 && abstractMsgBean.getSendLevel() <= 3) break;
                SMLog.info("Parameter Invalid,This Parameter is SendLelve");
                throw new SMException("Parameter Invalid,This Parameter is SendLelve");
            }
            case 3: {
                if (abstractMsgBean.getSmContent() == null || "".equals(abstractMsgBean.getSmContent()) || !ProvsionBean.OPERATION_PROVSION_FAIL.equalsIgnoreCase(abstractMsgBean.getSmContent()) || !ProvsionBean.OPERATION_PROVSION_SUCCESSFUL.equalsIgnoreCase(abstractMsgBean.getSmContent())) {
                    SMLog.info("Parameter Invalid,This Parameter is smcontent,the smcontent only is '0' or '1'");
                    throw new SMException("Parameter Invalid,This Parameter is smcontent,the smcontent only is '0' or '1'");
                }
                if (abstractMsgBean.getMessageID() != null && !"".equalsIgnoreCase(abstractMsgBean.getMessageID())) break;
                SMLog.info("Parameter Invalid,This Parameter is TransactionID");
                throw new SMException("Parameter Invalid,This Parameter is TransactionID");
            }
            case 4: {
                if (abstractMsgBean.getDestAddr() == null || "".equalsIgnoreCase(abstractMsgBean.getDestAddr())) {
                    SMLog.info("Parameter Invalid,This Parameter is destUserID");
                    throw new SMException("Parameter Invalid,This Parameter is destUserID");
                }
                if (abstractMsgBean.getSmType() != 3 && abstractMsgBean.getSmType() != 4) {
                    SMLog.info("Parameter Invalid,This Parameter is SMType");
                    throw new SMException("Parameter Invalid,This Parameter is SMType");
                }
                if (abstractMsgBean.getSmContent() == null || "".equals(abstractMsgBean.getSmContent().trim())) {
                    SMLog.info("Parameter Invalid,This Parameter is feeUserID");
                    throw new SMException("100505");
                }
                if (abstractMsgBean.getServiceID() == null || "".equalsIgnoreCase(abstractMsgBean.getServiceID())) {
                    SMLog.info("Parameter Invalid,This Parameter is serviceID");
                    throw new SMException("Parameter Invalid,This Parameter is serviceID");
                }
                if (abstractMsgBean.getTaskName() != null && !"".equalsIgnoreCase(abstractMsgBean.getTaskName())) break;
                SMLog.info("Parameter Invalid,This Parameter is spID");
                throw new SMException("Parameter Invalid,This Parameter is spID");
            }
            case 5: {
                m2 = p2.matcher(abstractMsgBean.getOrgAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getOrgAddr()) || abstractMsgBean.getOrgAddr() == null || abstractMsgBean.getOrgAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is OrgAddr");
                    throw new SMException("100502");
                }
                m2 = p2.matcher(abstractMsgBean.getDestAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getDestAddr()) || abstractMsgBean.getDestAddr() == null || abstractMsgBean.getDestAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is DestAddr");
                    throw new SMException("100503");
                }
                if (abstractMsgBean.getSmContent() == null || "".equals(abstractMsgBean.getSmContent().trim()) || abstractMsgBean.getSmContent().trim().getBytes().length > SMAPIConfig.SMCONTENT_LEN) {
                    SMLog.info("Parameter Invalid,This Parameter is smcontent");
                    throw new SMException("100505");
                }
                if (abstractMsgBean.getNeedStateReport() >= 0 && abstractMsgBean.getNeedStateReport() <= 1) break;
                SMLog.info("Parameter Invalid,This Parameter is NeedStateReport");
                throw new SMException("100506");
            }
            case 6: {
                m2 = p2.matcher(abstractMsgBean.getOrgAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getOrgAddr()) || abstractMsgBean.getOrgAddr() == null || abstractMsgBean.getOrgAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is OrgAddr");
                    throw new SMException("100502");
                }
                m2 = p2.matcher(abstractMsgBean.getDestAddr());
                if ("".equalsIgnoreCase(abstractMsgBean.getDestAddr()) || abstractMsgBean.getDestAddr() == null || abstractMsgBean.getDestAddr().trim().length() > 21 || !m2.matches()) {
                    SMLog.info("Parameter Invalid,This Parameter is DestAddr");
                    throw new SMException("100503");
                }
                if (abstractMsgBean.getSmContent() == null || "".equals(abstractMsgBean.getSmContent().trim()) || abstractMsgBean.getSmContent().trim().getBytes().length > 140) {
                    SMLog.info("Parameter Invalid,This Parameter is smcontent");
                    throw new SMException("100505");
                }
                if (abstractMsgBean.getNeedStateReport() >= 0 && abstractMsgBean.getNeedStateReport() <= 1) break;
                SMLog.info("Parameter Invalid,This Parameter is NeedStateReport");
                throw new SMException("100506");
            }
        }
    }

    protected static AbstractMsgBean encapsulateMsg(Object msg) {
        AbstractMsgBean amb = new AbstractMsgBean();
        if (msg instanceof CMPP3Bean) {
            CMPP3Bean cmpp3Bean = (CMPP3Bean)msg;
            amb.setDestAddr(cmpp3Bean.getDestAddr());
            amb.setFeeCode(cmpp3Bean.getFeeCode());
            amb.setFeeType(cmpp3Bean.getFeeType());
            amb.setMessageID(cmpp3Bean.getMessageID());
            amb.setNeedStateReport(cmpp3Bean.getNeedStateReport());
            amb.setServiceID(cmpp3Bean.getServiceID());
            amb.setOrgAddr(cmpp3Bean.getOrgAddr());
            amb.setSmContent(cmpp3Bean.getSmContent());
            amb.setSmType(cmpp3Bean.getSmType());
            amb.setApiMsgType(1);
        } else if (msg instanceof CMPP3PriorityBean) {
            CMPP3PriorityBean cmppProversion3Bean = (CMPP3PriorityBean)msg;
            amb.setDestAddr(cmppProversion3Bean.getDestAddr());
            amb.setFeeCode(cmppProversion3Bean.getFeeCode());
            amb.setFeeType(cmppProversion3Bean.getFeeType());
            amb.setMessageID(cmppProversion3Bean.getMessageID());
            amb.setNeedStateReport(cmppProversion3Bean.getNeedStateReport());
            amb.setServiceID(cmppProversion3Bean.getServiceID());
            amb.setOrgAddr(cmppProversion3Bean.getOrgAddr());
            amb.setSmContent(cmppProversion3Bean.getSmContent());
            amb.setSmType(cmppProversion3Bean.getSmType());
            amb.setSendLevel(cmppProversion3Bean.getSendLevel());
            amb.setApiMsgType(2);
        } else if (msg instanceof ProvsionExBean) {
            ProvsionExBean provsionBean = (ProvsionExBean)msg;
            amb.setMessageID(provsionBean.getTransactionID());
            amb.setSmContent(provsionBean.getSmContent());
            amb.setApiMsgType(3);
        } else if (msg instanceof ReversedProvsionExBean) {
            ReversedProvsionExBean reversedProvsionBean = (ReversedProvsionExBean)msg;
            amb.setDestAddr(reversedProvsionBean.getDestUserId());
            amb.setSmContent(reversedProvsionBean.getFeeUserId());
            amb.setServiceID(reversedProvsionBean.getServiceID());
            amb.setSmType(reversedProvsionBean.getSmType());
            amb.setTaskName(reversedProvsionBean.getSpID());
            amb.setApiMsgType(4);
        } else if (msg instanceof SMExBean) {
            SMExBean smBean = (SMExBean)msg;
            amb.setDestAddr(smBean.getDestAddr());
            amb.setFeeCode(String.valueOf(smBean.getFeeCode()));
            amb.setFeeType(smBean.getFeeType());
            amb.setNeedStateReport(smBean.getNeedStateReport());
            amb.setServiceID(smBean.getServiceID());
            amb.setOrgAddr(smBean.getOrgAddr());
            amb.setSmContent(smBean.getSmContent());
            amb.setApiMsgType(5);
        } else if (msg instanceof WapPushBean) {
            WapPushBean wappushBean = (WapPushBean)msg;
            amb.setDestAddr(wappushBean.getDestAddr());
            amb.setFeeCode(String.valueOf(wappushBean.getFeeCode()));
            amb.setFeeType(wappushBean.getFeeType());
            amb.setNeedStateReport(wappushBean.getNeedStateReport());
            amb.setServiceID(wappushBean.getServiceID());
            amb.setOrgAddr(wappushBean.getOrgAddr());
            amb.setSmContent(wappushBean.getSmContent() + wappushBean.getUrl());
            amb.setApiMsgType(6);
        }
        return amb;
    }

    protected static boolean selectForbiddenWord(String content) throws SMException {
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            String sql = "Select * from tbl_ForbiddenWord";
            cstmt = conn.prepareStatement(sql);
            rs = cstmt.executeQuery();
            if (rs == null) {
                boolean bl = false;
                return bl;
            }
            while (rs.next()) {
                String fors = rs.getString("ForbiddenWord");
                if ("".equals(fors)) continue;
                if (content.indexOf(fors) <= -1) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return false;
    }

    public static int submitCMPP3SM(CMPP3Bean cmpp3Bean) throws Exception {
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        try {
            ab2 = SMEntryEx.encapsulateMsg(cmpp3Bean);
            SMEntryEx.paramErrors(ab2);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntryEx.selectForbiddenWord(cmpp3Bean.getSmContent());
        if (hasForbiddenWord) {
            SMLog.error("Short Message contain forbidden phrase");
            throw new SMException("100505");
        }
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            int n2 = SMEntryEx.saveToDB(ab2, conn);
            return n2;
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static int submitCMPP3SMPriority(CMPP3PriorityBean cmpp3ProversionBean) throws Exception {
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        try {
            ab2 = SMEntryEx.encapsulateMsg(cmpp3ProversionBean);
            SMEntryEx.paramErrors(ab2);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntryEx.selectForbiddenWord(ab2.getSmContent());
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            int n2 = SMEntryEx.saveToDB(ab2, conn);
            return n2;
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static int submitProvsionSM(ProvsionExBean pbean) throws Exception {
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        try {
            ab2 = SMEntryEx.encapsulateMsg(pbean);
            SMEntryEx.paramErrors(ab2);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        int returnValue = -1;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            returnValue = SMEntryEx.saveToDB(ab2, conn);
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return returnValue;
    }

    public static String submitReversedProvsionSM(ReversedProvsionExBean ssbean) throws Exception {
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        try {
            ab2 = SMEntryEx.encapsulateMsg(ssbean);
            SMEntryEx.paramErrors(ab2);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        String returnValue = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            returnValue = SMTools.getRandom();
            returnValue = returnValue.substring(returnValue.length() - 10, returnValue.length());
            ab2.setMessageID(returnValue);
            int i2 = SMEntryEx.saveToDB(ab2, conn);
            if (i2 > 0) {
                String string = returnValue;
                return string;
            }
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return returnValue;
    }

    public static int submitShortMessage(SMExBean smBean) throws Exception {
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        try {
            ab2 = SMEntryEx.encapsulateMsg(smBean);
            SMEntryEx.paramErrors(ab2);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntryEx.selectForbiddenWord(ab2.getSmContent());
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            int n2 = SMEntryEx.saveToDB(ab2, conn);
            return n2;
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static int submitWapPushSM(WapPushBean wapPushBean) throws Exception {
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        try {
            if (wapPushBean.getUrl() == null || "".equals(wapPushBean.getUrl()) || wapPushBean.getUrl().indexOf(",") > 0 || wapPushBean.getUrl().indexOf(".") < 0) {
                SMLog.info("Parameter Invalid,This Parameter is URL");
                throw new Exception("Parameter Invalid,This Parameter is URL");
            }
            ab2 = SMEntryEx.encapsulateMsg(wapPushBean);
            SMEntryEx.paramErrors(ab2);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntryEx.selectForbiddenWord(ab2.getSmContent());
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            int n2 = SMEntryEx.saveToDB(ab2, conn);
            return n2;
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static int submitShortMessageState(SMExBean smBean) throws Exception {
        int smID = 0;
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        try {
            ab2 = SMEntryEx.encapsulateMsg(smBean);
            SMEntryEx.paramErrors(ab2);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntryEx.selectForbiddenWord(ab2.getSmContent());
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        Connection conn = null;
        PreparedStatement cstmt = null;
        try {
            String selectSql;
            ResultSet result;
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            int value = SMEntryEx.saveToDB(ab2, conn);
            if (value == 1 && (result = (cstmt = conn.prepareStatement(selectSql = DBSQL.SELECT_TASK_ID)).executeQuery()).next()) {
                smID = Integer.parseInt(result.getString("ID"));
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException(e3.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return smID;
    }

    public static ReversedProvsionExBean getReversedProvsionSM(String transcationID) throws SMException {
        ReversedProvsionExBean returnValue = null;
        try {
            returnValue = SMEntryEx.queryReversedProvsionSM(transcationID);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        return returnValue;
    }

    private static ReversedProvsionExBean queryReversedProvsionSM(String transcationID) throws SMException {
        ReversedProvsionExBean ssbean = new ReversedProvsionExBean();
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            String sql = DBSQL.QUERY_TBL_SMRECEIVED;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.setString(1, transcationID);
            rs = cstmt.executeQuery();
            String smContent = "";
            while (rs.next()) {
                smContent = rs.getString("SM_Content");
            }
            if (smContent != null && !"".equalsIgnoreCase(smContent)) {
                String[] smContentTemp = smContent.split(" ");
                ssbean.setSmContent(smContentTemp[0]);
                if (smContentTemp.length > 1) {
                    ssbean.setLinkID(smContentTemp[1]);
                }
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return ssbean;
    }

    public static ProvsionExBean getProvsionSM() throws SMException {
        ProvsionExBean returnValue = null;
        try {
            returnValue = SMEntryEx.queryProvsionSM();
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        return returnValue;
    }

    private static ProvsionExBean queryProvsionSM() throws SMException {
        ProvsionExBean pbean = new ProvsionExBean();
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            Statement stat = conn.createStatement();
            SMReceivedBean bean = SMEntryEx.selectMessage(null, "2", stat);
            if (bean != null) {
                SMEntryEx.updateMessage(bean.getSMId(), stat);
                pbean.setActionID(bean.getActionID());
                pbean.setActionReasonID(bean.getActionReasonID());
                pbean.setDestAddr(bean.getDestAddr());
                pbean.setTransactionID(bean.getMessageID());
                pbean.setOrgAddr(bean.getOrgAddr());
                pbean.setServiceID(bean.getServiceID());
                pbean.setSmContent(bean.getSMContent());
                pbean.setSmType(2);
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return pbean;
    }

    public static SMReceivedBean getAMessage(String destAddrs) throws SMException {
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            String regex = "\\d+";
            Pattern p2 = Pattern.compile(regex);
            Matcher m2 = p2.matcher(destAddrs);
            if (destAddrs == null || "".equals(destAddrs.trim()) || !m2.matches() || destAddrs.trim().length() > 21) {
                throw new SMException("100510");
            }
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            SMReceivedBean bean = SMEntryEx.selectMessage(destAddrs, null, stmt);
            if (bean != null) {
                SMEntryEx.updateMessage(bean.getSMId(), stmt);
            }
            conn.commit();
            conn.setAutoCommit(true);
            SMReceivedBean sMReceivedBean = bean;
            return sMReceivedBean;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    private static void updateMessage(int smId, Statement cstmt) throws SMException {
        try {
            String sql = "Update tbl_SMReceived set Reserve1 = 1 Where SM_Id = " + smId;
            SMLog.info("\u66f4\u65b0\u63a5\u6536\u8868\u7684\u8bed\u53e5: " + sql);
            cstmt.executeUpdate(sql);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1004");
        }
    }

    private static SMReceivedBean selectMessage(String destAddrs, String smtype, Statement stmt) throws SMException {
        ResultSet rs = null;
        SMReceivedBean bean = null;
        String sql = "Select top 1 * from tbl_SMReceived ";
        try {
            if (destAddrs != null && smtype == null) {
                sql = sql + " Where DestAddr like '" + destAddrs + "%' and Reserve1 is null  order by recvTime desc";
            } else if (destAddrs == null && smtype != null) {
                sql = sql + " Where SMType = '" + smtype + "'  and actionReasonID='1' and Reserve1 is null  order by recvTime desc";
            }
            SMLog.info("\u67e5\u8be2\u8bed\u53e5 = " + sql);
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                bean = new SMReceivedBean();
                int id2 = rs.getInt("SM_Id");
                String orgAddr = rs.getString("OrgAddr");
                String destAddr = rs.getString("DestAddr");
                String sm_Content = rs.getString("SM_Content");
                Date recvTime = SMTools.toUtilDate(rs.getTimestamp("recvTime"));
                bean.setSMId(id2);
                bean.setDestAddr(destAddr);
                bean.setOrgAddr(orgAddr);
                bean.setSMContent(sm_Content);
                bean.setRecvTime(recvTime);
                bean.setActionID(rs.getInt("ActionID"));
                bean.setServiceID(rs.getString("ServiceID"));
                bean.setSMType(rs.getInt("SMType"));
                bean.setActionReasonID(rs.getInt("ActionReasonID"));
                bean.setMessageID(rs.getString("MessageID"));
            }
            return bean;
        }
        catch (Exception e2) {
            SMLog.error("\u67e5\u8be2tbl_SMReceived\u8868\u7684\u65f6\u95f4\u8d85\u8fc7\u8bbe\u5b9a\u7684\uff13\uff10\u79d2", e2);
            throw new SMException("1010");
        }
    }

    public static SendShorBean FetchUssdRequest() throws SMException {
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        SendShorBean bean = null;
        Connection conn = null;
        try {
            String fetchUssdReqSql = DBSQL.FETCH_USSD_REQUEST;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(fetchUssdReqSql);
            rs = cstmt.executeQuery();
            if (rs.next()) {
                bean = new SendShorBean();
                String CallerNO = rs.getString("CallerNO");
                bean.setCallerNO(CallerNO);
                String UpdateTime = rs.getString(2);
                bean.setUpdateTime(UpdateTime);
                String LastTrack = rs.getString(3);
                bean.setLastTrack(LastTrack);
                String CurrentIn = rs.getString(4);
                bean.setCurrentIn(CurrentIn);
                int MsgType = Integer.parseInt(rs.getString(5));
                bean.setMsgType(MsgType);
            }
            SendShorBean sendShorBean = bean;
            return sendShorBean;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10064");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static int SubmitUssdResponse(int SessionID, String CallerNO, String CurrentIn, String LastTrack, int MsgType, int FeeType, int FeeRate, String FeeNO) throws SMException {
        if (CallerNO == null || "".equals(CallerNO.trim()) || CallerNO.length() > 21) {
            throw new SMException("100501");
        }
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            int i2;
            conn = ConnectionMgr.getConnection();
            String updateUssdSql = DBSQL.UPDATEUSSDMSG;
            cstmt = conn.prepareStatement(updateUssdSql);
            Date time = new Date();
            Timestamp updatetime = SMTools.toSqlDate(time);
            cstmt.setTimestamp(1, updatetime);
            cstmt.setString(2, LastTrack);
            cstmt.setString(3, CurrentIn);
            cstmt.setInt(4, MsgType);
            cstmt.setInt(5, FeeType);
            cstmt.setInt(6, FeeRate);
            cstmt.setString(7, FeeNO);
            cstmt.setString(8, CallerNO);
            int n2 = i2 = cstmt.executeUpdate();
            return n2;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10063");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static SendShorBean getSessionIDFromUSSD() throws SMException {
        SendShorBean bean = new SendShorBean();
        try {
            for (int j2 = 0; j2 < 7; ++j2) {
                bean.setSessionIDList(j2);
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10065");
        }
        return bean;
    }

    public static void deleteMessage(int smId) throws SMException {
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            String sql = "Delete from tbl_SMReceived Where SM_Id = " + smId + "";
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.executeUpdate();
        }
        catch (Exception e2) {
            try {
                SMLog.error("", e2);
                throw new SMException("1004");
            }
            catch (Throwable throwable) {
                ConnectionMgr.closeDBConnection(conn);
                throw throwable;
            }
        }
        ConnectionMgr.closeDBConnection(conn);
    }

    protected static void operatorParamErrors(String id2, String code, String name, String password, String Type2, String smSendRight, String multiSendRight, String perSendRight, String limitType, String maxCount, String Modified) throws SMException {
        if (id2 == null || "".equals(id2.trim()) || id2.length() > 20) {
            throw new SMException("100512");
        }
        if (code == null || "".equals(id2.trim()) || code.length() > 20) {
            throw new SMException("100513");
        }
        if (name == null || "".equals(id2.trim()) || name.length() > 20) {
            throw new SMException("100513");
        }
        if (password == null || password.length() == 0 || password.length() > 20) {
            throw new SMException("100514");
        }
        if (!"1".equals(Type2)) {
            throw new SMException("100515");
        }
        if (!"0".equals(smSendRight) && !"1".equals(smSendRight)) {
            throw new SMException("100516");
        }
        if (!"0".equals(multiSendRight) && !"1".equals(multiSendRight)) {
            throw new SMException("100517");
        }
        if (!"0".equals(perSendRight) && !"1".equals(perSendRight)) {
            throw new SMException("100518");
        }
        if (!("0".equals(limitType) || "1".equals(limitType) || "2".equals(limitType))) {
            throw new SMException("100519");
        }
        if (!"1".equals(Modified)) {
            throw new SMException("100521");
        }
    }

    public static int insertOperatorInfo(String id2, String code, String name, String password, String Type2, String smSendRight, String multiSendRight, String perSendRight, String limitType, String maxCount, String Modified) throws SMException {
        int i2 = 0;
        int roleID = -1;
        try {
            SMEntryEx.operatorParamErrors(id2, code, name, password, Type2, smSendRight, multiSendRight, perSendRight, limitType, maxCount, Modified);
        }
        catch (SMException e2) {
            throw new SMException(e2.getErrorType());
        }
        password = SecurityTools.digest(password);
        CallableStatement cstmt = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            roleID = SMEntryEx.insertRole(smSendRight, multiSendRight, perSendRight, conn);
            if (roleID != -1) {
                String sql = DBSQL.INSERT_OPERATOR;
                cstmt = conn.prepareCall(sql);
                cstmt.setString(1, id2);
                cstmt.setString(2, name);
                cstmt.setString(3, code);
                cstmt.setString(4, password);
                cstmt.setString(5, Type2);
                cstmt.setInt(6, roleID);
                cstmt.setString(7, limitType);
                cstmt.setString(8, maxCount);
                cstmt.setString(9, Modified);
                i2 = cstmt.executeUpdate();
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e3) {
            SMLog.error("", e3);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1006");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return i2;
    }

    private static int insertRole(String smSendRight, String multiSendRight, String perSendRight, Connection conn) throws SMException {
        int roleID = -1;
        Statement statement = null;
        ResultSet rs = null;
        Date time = new Date();
        long l2 = time.getTime();
        String name = "API" + l2;
        String description = "\u6b64\u89d2\u8272\u662f\u901a\u8fc7\u77ed\u4fe1API\u589e\u52a0\u7684\uff0c\u8bf7\u52ff\u968f\u4fbf\u5220\u9664\uff01";
        int[] right = new int[]{-1, -1, -1, 1};
        if ("0".equals(smSendRight)) {
            right[0] = 1;
        }
        if ("0".equals(multiSendRight)) {
            right[1] = 2;
        }
        if ("0".equals(perSendRight)) {
            right[2] = 3;
        }
        try {
            String sql = "insert into tbl_role (name,description) values('" + name + "','" + description + "')";
            statement = conn.createStatement();
            statement.executeUpdate(sql);
            sql = "select * from tbl_role where name = '" + name + "'";
            rs = statement.executeQuery(sql);
            if (rs.next()) {
                roleID = rs.getInt(1);
            }
            if (roleID != -1) {
                for (int i2 = 0; i2 < right.length; ++i2) {
                    if (right[i2] == -1) continue;
                    sql = "insert into tbl_RoleJoinAuthority (roleID,authorityid) values('" + roleID + "','" + right[i2] + "')";
                    statement.executeUpdate(sql);
                }
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10061");
        }
        return roleID;
    }

    private static int updateRoleAuthority(String id2, String smSendRight, String multiSendRight, String perSendRight) throws SMException {
        int roleID = -1;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        int[] right = new int[]{-1, -1, -1, 18};
        if ("0".equals(smSendRight)) {
            right[0] = 1;
        }
        if ("0".equals(multiSendRight)) {
            right[1] = 2;
        }
        if ("0".equals(perSendRight)) {
            right[2] = 3;
        }
        try {
            String sql = "select roleID from tbl_Operator where Operator_ID = '" + id2 + "'";
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                roleID = rs.getInt(1);
            }
            if (roleID != -1) {
                sql = "delete from tbl_RoleJoinAuthority where roleID = '" + roleID + "'";
                stmt.executeUpdate(sql);
                for (int i2 = 0; i2 < right.length; ++i2) {
                    if (right[i2] == -1) continue;
                    sql = "insert into  tbl_RoleJoinAuthority (roleID,authorityid) values('" + roleID + "','" + right[i2] + "')";
                    stmt.executeUpdate(sql);
                }
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            try {
                SMLog.error("", e2);
                ConnectionMgr.rollBackConn(conn);
                throw new SMException("10061");
            }
            catch (Throwable throwable) {
                ConnectionMgr.closeDBConnection(conn);
                throw throwable;
            }
        }
        ConnectionMgr.closeDBConnection(conn);
        return roleID;
    }

    public static int updateOperatorInfo(String id2, String code, String name, String smSendRight, String multiSendRight, String perSendRight, String limitType, String maxCount) throws SMException {
        int i2 = 0;
        if (id2 == null || id2.length() == 0 || id2.length() > 20) {
            throw new SMException("100512");
        }
        if (code == null || code.length() == 0 || code.length() > 20) {
            throw new SMException("100513");
        }
        if (name == null || name.length() == 0 || name.length() > 20) {
            throw new SMException("100513");
        }
        if (!"0".equals(smSendRight) && !"1".equals(smSendRight)) {
            throw new SMException("100516");
        }
        if (!"0".equals(multiSendRight) && !"1".equals(multiSendRight)) {
            throw new SMException("100517");
        }
        if (!"0".equals(perSendRight) && !"1".equals(perSendRight)) {
            throw new SMException("100518");
        }
        if (!("0".equals(limitType) || "1".equals(limitType) || "2".equals(limitType))) {
            throw new SMException("100519");
        }
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            String sql = "";
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            SMEntryEx.updateRoleAuthority(id2, smSendRight, multiSendRight, perSendRight);
            sql = "update tbl_Operator set Operator_Code =?, Operator_Name=?, limitType=?, maxCount=? where Operator_ID=?";
            cstmt = conn.prepareStatement(sql);
            cstmt.setString(1, code);
            cstmt.setString(2, name);
            cstmt.setString(3, limitType);
            cstmt.setString(4, maxCount);
            cstmt.setString(5, id2);
            i2 = cstmt.executeUpdate();
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("10061");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return i2;
    }

    public static SendShorBean searchOperatorInfo(String id2) throws SMException {
        String sql = "";
        String code = "";
        String name = "";
        String type = "";
        String password = "";
        String right = "";
        String limitType = "";
        String maxCount = "";
        int roleID = -1;
        Statement stmt = null;
        ResultSet rs = null;
        SendShorBean bean = new SendShorBean();
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            sql = "select * from tbl_Operator where Operator_ID='" + id2 + "'";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                code = rs.getString("Operator_Code");
                bean.setOperator_Code(code);
                name = rs.getString("Operator_Name");
                bean.setOperator_Name(name);
                password = rs.getString("Password");
                bean.setPassword(password);
                type = rs.getString("OperatorType");
                bean.setType(type);
                limitType = rs.getString("LimitType");
                bean.setLimitType(limitType);
                maxCount = rs.getString("maxCount");
                bean.setMaxCount(maxCount);
                roleID = rs.getInt("roleID");
            }
            bean.setSmsendRight("1");
            bean.setMultiSendRight("1");
            bean.setPerSendRight("1");
            if (roleID != -1) {
                sql = "select * from tbl_RoleJoinAuthority where roleID = " + roleID;
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    right = rs.getString("authorityid");
                    if ("1".equals(right)) {
                        bean.setSmsendRight("0");
                    }
                    if ("2".equals(right)) {
                        bean.setMultiSendRight("0");
                    }
                    if (!"3".equals(right)) continue;
                    bean.setPerSendRight("0");
                }
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1003");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return bean;
    }

    public static int delOperatorInfo(String id2) throws SMException {
        int i2 = 0;
        String sql = "";
        ResultSet rs = null;
        int roleID = -1;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            sql = "select roleID from tbl_Operator where Operator_ID = '" + id2 + "'";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                roleID = rs.getInt(1);
            }
            if (roleID != -1) {
                sql = "delete from tbl_role where ID = " + roleID;
                stmt.executeUpdate(sql);
                sql = "delete from tbl_RoleJoinAuthority where roleID = " + roleID;
                stmt.executeUpdate(sql);
            }
            sql = "delete from tbl_Operator where Operator_ID= '" + id2 + "'";
            i2 = stmt.executeUpdate(sql);
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("10062");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return i2;
    }

    public static Connection getConnection() {
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
        }
        catch (Exception ex) {
            SMLog.error("", ex);
        }
        return conn;
    }

    private static int saveToDB(AbstractMsgBean ab2, Connection connTemp) throws SMException {
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            String sql = DBSQL.INSERT_INTO_TBL_SMSENDTASK;
            conn = connTemp;
            cstmt = conn.prepareStatement(sql);
            String operator = sessionCreatorID;
            cstmt.setString(1, operator);
            cstmt.setInt(2, ab2.getSmSendedNum());
            cstmt.setString(3, ab2.getOperationType() == null ? "API" : ab2.getOperationType());
            cstmt.setString(4, ab2.getOrgAddr() == null ? "" : ab2.getOrgAddr());
            cstmt.setString(5, ab2.getDestAddr() == null ? "" : ab2.getDestAddr());
            cstmt.setString(6, ab2.getSmContent() == null ? "" : ab2.getSmContent());
            cstmt.setTimestamp(7, SMTools.toSqlDate(new Date(System.currentTimeMillis())));
            cstmt.setInt(8, ab2.getNeedStateReport());
            cstmt.setString(9, ab2.getServiceID() == null ? "EIE" : ab2.getServiceID());
            cstmt.setString(10, ab2.getFeeType() == null ? "01" : ab2.getFeeType());
            cstmt.setString(11, ab2.getFeeCode() == null ? "10" : ab2.getFeeCode());
            cstmt.setInt(12, ab2.getSmType());
            cstmt.setString(13, ab2.getMessageID() == null ? "0" : ab2.getMessageID());
            cstmt.setInt(14, ab2.getDestAddrType());
            cstmt.setTimestamp(15, SMTools.toSqlDate(SMTools.toSqlDate(new Date(System.currentTimeMillis()))));
            cstmt.setInt(16, ab2.getTaskStatus());
            cstmt.setInt(17, ab2.getSendLevel());
            cstmt.setInt(18, ab2.getSendState());
            cstmt.setInt(19, ab2.getTryTimes() == 0 ? 3 : ab2.getTryTimes());
            cstmt.setInt(20, ab2.getSendType());
            cstmt.setString(21, ab2.getTaskName() == null ? "" : ab2.getTaskName());
            int i2 = cstmt.executeUpdate();
            return i2;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1003");
        }
    }

    public static int submitShortMessageMulti(String fileName, String orgAddr, String smContent, String ftpUser, String ftpPassword, int needStateReport) throws Exception {
        SMEntryEx.isLogin();
        AbstractMsgBean ab2 = new AbstractMsgBean();
        boolean hasForbiddenWord = SMEntryEx.selectForbiddenWord(smContent);
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        if (!SMTools.isFile(fileName)) {
            throw new Exception("File not Found!");
        }
        if ("".equals(orgAddr) || orgAddr == null) {
            throw new Exception("orgAddr not null!");
        }
        if ("".equals(smContent) || smContent == null) {
            throw new Exception("smContent not null!");
        }
        if ("".equals(ftpUser) || ftpUser == null) {
            throw new Exception("ftpUser not null!");
        }
        if ("".equals(ftpPassword) || ftpPassword == null) {
            throw new Exception("ftpUser not null!");
        }
        Tools.checkFile(fileName);
        String fileNameTemp = String.valueOf(System.currentTimeMillis()) + ".txt";
        Tools.ftpFile(fileName, fileNameTemp, ftpUser, ftpPassword, SMAPIConfig.getFtpHost(), SMAPIConfig.getMutiSavePath(), SMAPIConfig.getFtpPort());
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            ab2.setDestAddr(fileNameTemp);
            ab2.setOrgAddr(orgAddr);
            ab2.setSmContent(smContent);
            ab2.setNeedStateReport(needStateReport);
            int n2 = SMEntryEx.saveToDB(ab2, conn);
            return n2;
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            Tools.deleteUpFile(SMAPIConfig.getMutiSavePath() + fileNameTemp);
            throw new SMException(e2.getErrorType());
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

