/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.api;

import com.huawei.api.ConnectionMgr;
import com.huawei.api.ProvsionBean;
import com.huawei.api.ReversedProvsionBean;
import com.huawei.api.SMAPIConfig;
import com.huawei.api.SMException;
import com.huawei.api.SMReceivedBean;
import com.huawei.api.SMTools;
import com.huawei.api.SendShorBean;
import com.huawei.api.bean.AbstractMsgBean;
import com.huawei.api.smsend.db.DBSQL;
import com.huawei.api.smsend.system.SMLog;
import com.huawei.utils.SecurityTools;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SMEntry {
    private static String dbIP = null;
    private static String dbName = null;
    private static String dbPassword = null;
    private static String sessionCreatorID = "";
    private static String loginUserName = "";
    private static String loginPassword = "";

    public static void init(String dbIPxx, String dbNamexx, String dbPasswordxx) {
        dbIP = dbIPxx;
        dbName = dbNamexx;
        dbPassword = dbPasswordxx;
        ConnectionMgr.initConn(dbIPxx, dbNamexx, dbPasswordxx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logIn(String userNamexx, String userPasswordxx) throws SMException {
        loginPassword = userPasswordxx;
        loginUserName = userNamexx;
        Connection conn = null;
        String result = null;
        try {
            conn = ConnectionMgr.getConnection();
            result = SMTools.checkLogin(loginUserName, loginPassword, conn);
        }
        catch (Exception ex) {
            SMLog.error("", ex);
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        if (result == null) {
            SMLog.info("\u7528\u6237\u767b\u9646\u9274\u6743\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u548c\u5bc6\u7801");
            throw new SMException("10065");
        }
        sessionCreatorID = result;
    }

    public static void logOut() {
        sessionCreatorID = null;
        ConnectionMgr.close();
    }

    public static void cleanUp() throws SMException {
    }

    private static int insertShorState(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode) throws SMException {
        int id2 = 0;
        Connection conn = null;
        PreparedStatement cstmt = null;
        try {
            conn = ConnectionMgr.getConnection();
            int i2 = SMEntry.insertSM(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode);
            if (i2 == 1) {
                Timestamp time = SMTools.toSqlDate(atTime);
                String selectSql = DBSQL.SELECT_TASK_ID;
                cstmt = conn.prepareStatement(selectSql);
                ResultSet result = cstmt.executeQuery();
                if (result.next()) {
                    id2 = Integer.parseInt(result.getString("ID"));
                }
            }
            int n2 = id2;
            return n2;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1003");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static int submitShortMessageState(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode) throws SMException {
        try {
            SMEntry.paramErrors(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode, true);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntry.selectForbiddenWord(content);
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        try {
            return SMEntry.insertShorState(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode);
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
    }

    public static int submitShortMessage(String user, String password, Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode) throws SMException {
        try {
            SMEntry.paramErrors(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode, true);
        }
        catch (SMException e2) {
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntry.selectForbiddenWord(content);
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        try {
            return SMEntry.insertSM(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode);
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
    }

    public static int submitShortMessage(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode) throws SMException {
        try {
            SMEntry.paramErrors(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode, true);
        }
        catch (SMException e2) {
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntry.selectForbiddenWord(content);
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        try {
            return SMEntry.insertSM(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode);
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
    }

    public static int submitCMPP3SMPriority(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode, int SMType, String messageID, int sendLevel) throws SMException {
        try {
            SMEntry.paramErrors(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode, true);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntry.selectForbiddenWord(content);
        if (hasForbiddenWord) {
            throw new SMException("100505");
        }
        try {
            return SMEntry.insertCMPP3SMPriority(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode, SMType, messageID, sendLevel);
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
    }

    private static int insertCMPP3SMPriority(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode, int SMType, String messageID, int sendLevel) throws SMException {
        int returnValue = 0;
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            String sql = DBSQL.INSERT_INTO_TBL_SMSENDTASK;
            cstmt = conn.prepareStatement(sql);
            String operator = sessionCreatorID;
            cstmt.setString(1, operator);
            cstmt.setInt(2, 0);
            cstmt.setString(3, "API");
            cstmt.setString(4, sourceAddr);
            cstmt.setString(5, destAddr);
            cstmt.setString(6, content);
            cstmt.setTimestamp(7, SMTools.toSqlDate(atTime));
            cstmt.setInt(8, needStateReport);
            cstmt.setString(9, serviceID);
            cstmt.setString(10, feeType);
            cstmt.setString(11, feeCode);
            cstmt.setInt(12, SMType);
            cstmt.setString(13, messageID);
            cstmt.setInt(14, 0);
            cstmt.setTimestamp(15, SMTools.toSqlDate(atTime));
            cstmt.setInt(16, 0);
            cstmt.setInt(17, sendLevel);
            cstmt.setInt(18, 0);
            cstmt.setInt(19, 3);
            cstmt.setInt(20, 1);
            cstmt.setString(21, "");
            returnValue = cstmt.executeUpdate();
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1003");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return returnValue;
    }

    public static String submitReversedProvsionSM(ReversedProvsionBean ssbean) throws SMException {
        SMEntry.checkParamErrors(null, ssbean);
        try {
            return SMEntry.insertReversedProvsionSM(ssbean);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
    }

    private static String insertReversedProvsionSM(ReversedProvsionBean ssbean) throws SMException {
        String returnValue = null;
        if (ssbean.getSmType() != 3 && ssbean.getSmType() != 4) {
            SMLog.info("\u6d88\u606f\u7c7b\u578b\u9519\u8bef\uff0cSMType\u5b57\u6bb5\u7684\u503c\u53ea\u80fd\u662f3\uff1a\u53cd\u5411\u5b9a\u8d2d\uff0c4\uff1a\u53cd\u5411\u53d6\u6d88");
            throw new SMException("\u6d88\u606f\u7c7b\u578b\u9519\u8bef\uff0cSMType\u5b57\u6bb5\u7684\u503c\u53ea\u80fd\u662f3\uff1a\u53cd\u5411\u5b9a\u8d2d\uff0c4\uff1a\u53cd\u5411\u53d6\u6d88");
        }
        Connection conn = null;
        PreparedStatement cstmt = null;
        try {
            returnValue = SMTools.getRandom();
            returnValue = returnValue.substring(returnValue.length() - 10, returnValue.length());
            String sql = DBSQL.INSERT_INTO_TBL_SMSENDTASK;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.setString(1, "SPToMISC");
            cstmt.setInt(2, 0);
            cstmt.setString(3, "API");
            cstmt.setString(4, "EIE");
            cstmt.setString(5, ssbean.getDestUserId());
            cstmt.setString(6, ssbean.getFeeUserId());
            cstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            cstmt.setInt(8, 0);
            cstmt.setString(9, ssbean.getServiceID());
            cstmt.setString(10, "01");
            cstmt.setString(11, "10");
            cstmt.setInt(12, ssbean.getSmType());
            cstmt.setString(13, returnValue);
            cstmt.setInt(14, 0);
            cstmt.setTimestamp(15, new Timestamp(System.currentTimeMillis()));
            cstmt.setInt(16, 0);
            cstmt.setInt(17, 0);
            cstmt.setInt(18, 0);
            cstmt.setInt(19, 3);
            cstmt.setInt(20, 1);
            cstmt.setString(21, ssbean.getSpID());
            int i2 = cstmt.executeUpdate();
            if (i2 <= 0) {
                returnValue = null;
            }
        }
        catch (Exception e2) {
            try {
                SMLog.error("", e2);
                throw new SMException("1003");
            }
            catch (Throwable throwable) {
                ConnectionMgr.closeDBConnection(conn);
                throw throwable;
            }
        }
        ConnectionMgr.closeDBConnection(conn);
        return returnValue;
    }

    public static ReversedProvsionBean getReversedProvsionSM(String transcationID) throws SMException {
        ReversedProvsionBean returnValue = null;
        try {
            returnValue = SMEntry.queryReversedProvsionSM(transcationID);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        return returnValue;
    }

    private static ReversedProvsionBean queryReversedProvsionSM(String transcationID) throws SMException {
        ReversedProvsionBean ssbean = new ReversedProvsionBean();
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            String sql = DBSQL.QUERY_TBL_SMRECEIVED;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.setString(1, transcationID);
            rs = cstmt.executeQuery();
            String smContent = "";
            while (rs.next()) {
                smContent = rs.getString("SM_Content");
            }
            if (smContent != null && !"".equalsIgnoreCase(smContent)) {
                String[] smContentTemp = smContent.split(" ");
                ssbean.setSmContent(smContentTemp[0]);
                if (smContentTemp.length > 1) {
                    ssbean.setLinkID(smContentTemp[1]);
                }
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return ssbean;
    }

    public static ProvsionBean getProvsionSM() throws SMException {
        ProvsionBean returnValue = null;
        try {
            returnValue = SMEntry.queryProvsionSM();
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        return returnValue;
    }

    private static ProvsionBean queryProvsionSM() throws SMException {
        ProvsionBean pbean = new ProvsionBean();
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            Statement stat = conn.createStatement();
            SMReceivedBean bean = SMEntry.selectMessage(null, "2", stat);
            if (bean != null) {
                SMEntry.updateMessage(bean.getSMId(), stat);
                pbean.setActionID(bean.getActionID());
                pbean.setActionReasonID(bean.getActionReasonID());
                pbean.setDestAddr(bean.getDestAddr());
                pbean.setTransactionID(bean.getMessageID());
                pbean.setOrgAddr(bean.getOrgAddr());
                pbean.setServiceID(bean.getServiceID());
                pbean.setSmContent(bean.getSMContent());
                pbean.setSmType(2);
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return pbean;
    }

    public static int submitProvsionSM(ProvsionBean pbean) throws SMException {
        int returnValue = -1;
        try {
            if ((ProvsionBean.OPERATION_PROVSION_FAIL.equals(pbean.getSmContent()) || ProvsionBean.OPERATION_PROVSION_SUCCESSFUL.equals(pbean.getSmContent())) && pbean.getTransactionID() != null) {
                returnValue = SMEntry.insertProvsionSM(pbean);
            } else {
                returnValue = -1;
                SMLog.info("\u6b63\u5411\u5b9a\u8d2d\u7684\u5185\u5bb9\u9519\u8bef\u6216TransactionID\u4e0d\u80fd\u591f\u4e3a\u7a7a");
            }
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        return returnValue;
    }

    private static int insertProvsionSM(ProvsionBean pbean) throws SMException {
        int returnValue = 0;
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            String sql = DBSQL.INSERT_INTO_TBL_SMSENDTASK;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.setString(1, "SPToMISC");
            cstmt.setInt(2, 0);
            cstmt.setString(3, "API");
            cstmt.setString(4, "0000");
            cstmt.setString(5, "0000");
            cstmt.setString(6, pbean.getSmContent());
            cstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            cstmt.setInt(8, 0);
            cstmt.setString(9, "");
            cstmt.setString(10, "01");
            cstmt.setString(11, "10");
            cstmt.setInt(12, 5);
            cstmt.setString(13, pbean.getTransactionID());
            cstmt.setInt(14, 0);
            cstmt.setTimestamp(15, new Timestamp(System.currentTimeMillis()));
            cstmt.setInt(16, 0);
            cstmt.setInt(17, 0);
            cstmt.setInt(18, 0);
            cstmt.setInt(19, 3);
            cstmt.setInt(20, 1);
            cstmt.setString(21, "00");
            int i2 = cstmt.executeUpdate();
            returnValue = i2 > 0 ? 0 : -1;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1003");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return returnValue;
    }

    public static int submitCMPP3SM(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode, int SMType, String messageID) throws SMException {
        try {
            SMEntry.paramErrors(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode, true);
        }
        catch (SMException e2) {
            SMLog.error("", e2);
            throw new SMException(e2.getErrorType());
        }
        boolean hasForbiddenWord = SMEntry.selectForbiddenWord(content);
        if (hasForbiddenWord) {
            SMLog.error("\u77ed\u4fe1\u5185\u5bb9\u4e2d\u542b\u6709\u7981\u6b62\u77ed\u8bed");
            throw new SMException("100505");
        }
        try {
            return SMEntry.insertCMPP3SM(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode, SMType, messageID);
        }
        catch (SMException e3) {
            SMLog.error("", e3);
            throw new SMException(e3.getErrorType());
        }
    }

    public static SendShorBean querySentShortMessagesState(Timestamp subTime, int sm_id) throws SMException {
        SendShorBean sendShorBean;
        if (subTime == null) {
            throw new SMException("100511");
        }
        String tbl = "tbl_SMResult_";
        try {
            int fy = Integer.parseInt(subTime.toString().substring(0, 4));
            int fm = Integer.parseInt(subTime.toString().substring(5, 7));
            int fd2 = Integer.parseInt(subTime.toString().substring(8, 10));
            Timestamp thisDay = new Timestamp(System.currentTimeMillis());
            int thisyear = Integer.parseInt(thisDay.toString().substring(0, 4));
            if (thisyear != fy) {
                throw new SMException("100511");
            }
            tbl = fm < 10 ? tbl + "0" + fm : tbl + fm;
            tbl = fd2 < 10 ? tbl + "0" + fd2 : tbl + fd2;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("100511");
        }
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        SendShorBean bean = null;
        Connection conn = null;
        try {
            String sql = "select * from " + tbl + " Where SM_ID = ?";
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.setInt(1, sm_id);
            rs = cstmt.executeQuery();
            while (rs.next()) {
                bean = new SendShorBean();
                int SM_Type = rs.getInt("SM_Type");
                bean.setSM_Type(SM_Type);
                int SM_ID = rs.getInt("SM_ID");
                bean.setSM_ID(SM_ID);
                Timestamp SubTime = rs.getTimestamp("SubTime");
                bean.setSubTime(SubTime);
                String OrgAddr = rs.getString("OrgAddr");
                bean.setOrgAddr(OrgAddr);
                String DestAddr = rs.getString("DestAddr");
                bean.setDestAddr(DestAddr);
                String SM_Content = rs.getString("SM_Content");
                bean.setSM_Content(SM_Content);
                Timestamp SendTime = rs.getTimestamp("SendTime");
                bean.setSendTime(SendTime);
                String MsgID = rs.getString("MsgID");
                bean.setMsgID(MsgID);
                String Service_ID = rs.getString("Service_ID");
                bean.setService_ID(Service_ID);
                String Fee_UserType = rs.getString("Fee_UserType");
                bean.setFee_UserType(Fee_UserType);
                String Fee_Terminal_ID = rs.getString("Fee_Terminal_ID");
                bean.setFee_Terminal_ID(Fee_Terminal_ID);
                int Msg_Fmt = rs.getInt("Msg_Fmt");
                bean.setMsg_Fmt(Msg_Fmt);
                String FeeType = rs.getString("FeeType");
                bean.setFeeType(FeeType);
                int FeeCode = rs.getInt("FeeCode");
                bean.setFeeCode(FeeCode);
                Timestamp ValId_Time = rs.getTimestamp("ValId_Time");
                bean.setValId_Time(ValId_Time);
                Timestamp Sent_Time = rs.getTimestamp("Sent_Time");
                bean.setSent_Time(Sent_Time);
                String Msg_Status = rs.getString("Msg_Status");
                bean.setMsg_Status(Msg_Status);
                int TryTimes = rs.getInt("TryTimes");
                bean.setTryTimes(TryTimes);
                String Recv_Status = rs.getString("Recv_Status");
                bean.setRecv_Status(Recv_Status);
                Timestamp Recv_Time = rs.getTimestamp("Recv_Time");
                bean.setRecv_Time(Recv_Time);
            }
            sendShorBean = bean;
        }
        catch (Exception e3) {
            try {
                SMLog.error("", e3);
                throw new SMException("1004");
            }
            catch (Throwable throwable) {
                ConnectionMgr.closeDBConnection(conn);
                throw throwable;
            }
        }
        ConnectionMgr.closeDBConnection(conn);
        return sendShorBean;
    }

    public static ArrayList querySentShortMessages(Timestamp fromTime, Timestamp toTime, String orgAddr) throws SMException {
        ArrayList<SendShorBean> arrayList;
        String regex;
        Pattern p2;
        Matcher m2;
        if (fromTime == null || toTime == null) {
            throw new SMException("100511");
        }
        if (fromTime.compareTo(toTime) > 0) {
            throw new SMException("100511");
        }
        if (orgAddr != null && !(m2 = (p2 = Pattern.compile(regex = "\\d+")).matcher(orgAddr)).matches()) {
            throw new SMException("100502");
        }
        String tbl = "tbl_SMResult_";
        try {
            int fy = Integer.parseInt(fromTime.toString().substring(0, 4));
            int ty = Integer.parseInt(toTime.toString().substring(0, 4));
            int fm = Integer.parseInt(fromTime.toString().substring(5, 7));
            int tm = Integer.parseInt(toTime.toString().substring(5, 7));
            int fd2 = Integer.parseInt(fromTime.toString().substring(8, 10));
            int td2 = Integer.parseInt(toTime.toString().substring(8, 10));
            Timestamp thisDay = new Timestamp(System.currentTimeMillis());
            int thisyear = Integer.parseInt(thisDay.toString().substring(0, 4));
            if (thisyear != fy || thisyear != ty) {
                throw new SMException("100511");
            }
            if (fm != tm || fd2 != td2) {
                throw new SMException("100511");
            }
            tbl = fm < 10 ? tbl + "0" + fm : tbl + fm;
            tbl = fd2 < 10 ? tbl + "0" + fd2 : tbl + fd2;
        }
        catch (Exception e2) {
            throw new SMException("100511");
        }
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        ArrayList<SendShorBean> list = new ArrayList<SendShorBean>();
        Connection conn = null;
        try {
            String sql = null;
            sql = orgAddr == null ? "select * from " + tbl + " Where sendTime >= ? and sendTime <=?" + " Order by Sendtime" : "select * from " + tbl + " Where sendTime >= ? and sendTime <=? and orgAddr=?" + " Order by Sendtime";
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.setTimestamp(1, fromTime);
            cstmt.setTimestamp(2, toTime);
            if (orgAddr != null) {
                cstmt.setString(3, orgAddr);
            }
            rs = cstmt.executeQuery();
            while (rs.next()) {
                SendShorBean bean = new SendShorBean();
                int SM_Type = rs.getInt("SM_Type");
                bean.setSM_Type(SM_Type);
                int SM_ID = rs.getInt("SM_ID");
                bean.setSM_ID(SM_ID);
                Timestamp SubTime = rs.getTimestamp("SubTime");
                bean.setSubTime(SubTime);
                String OrgAddr = rs.getString("OrgAddr");
                bean.setOrgAddr(OrgAddr);
                String DestAddr = rs.getString("DestAddr");
                bean.setDestAddr(DestAddr);
                String SM_Content = rs.getString("SM_Content");
                bean.setSM_Content(SM_Content);
                Timestamp SendTime = rs.getTimestamp("SendTime");
                bean.setSendTime(SendTime);
                String MsgID = rs.getString("MsgID");
                bean.setMsgID(MsgID);
                String Service_ID = rs.getString("Service_ID");
                bean.setService_ID(Service_ID);
                String Fee_UserType = rs.getString("Fee_UserType");
                bean.setFee_UserType(Fee_UserType);
                String Fee_Terminal_ID = rs.getString("Fee_Terminal_ID");
                bean.setFee_Terminal_ID(Fee_Terminal_ID);
                int Msg_Fmt = rs.getInt("Msg_Fmt");
                bean.setMsg_Fmt(Msg_Fmt);
                String FeeType = rs.getString("FeeType");
                bean.setFeeType(FeeType);
                int FeeCode = rs.getInt("FeeCode");
                bean.setFeeCode(FeeCode);
                Timestamp ValId_Time = rs.getTimestamp("ValId_Time");
                bean.setValId_Time(ValId_Time);
                Timestamp Sent_Time = rs.getTimestamp("SubTime");
                bean.setSent_Time(Sent_Time);
                String Msg_Status = rs.getString("Msg_Status");
                bean.setMsg_Status(Msg_Status);
                int TryTimes = rs.getInt("TryTimes");
                bean.setTryTimes(TryTimes);
                String Recv_Status = rs.getString("Recv_Status");
                bean.setRecv_Status(Recv_Status);
                Timestamp Recv_Time = rs.getTimestamp("Recv_Time");
                bean.setRecv_Time(Recv_Time);
                list.add(bean);
            }
            arrayList = list;
        }
        catch (Exception e3) {
            try {
                SMLog.error("", e3);
                throw new SMException("1004");
            }
            catch (Throwable throwable) {
                ConnectionMgr.closeDBConnection(conn);
                throw throwable;
            }
        }
        ConnectionMgr.closeDBConnection(conn);
        return arrayList;
    }

    private static int insertSM(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode) throws SMException {
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            int i2;
            String sql = DBSQL.INSERT_INTO_TBL_SMSENDTASK;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            String operator = sessionCreatorID;
            cstmt.setString(1, operator);
            cstmt.setInt(2, 0);
            cstmt.setString(3, "API");
            cstmt.setString(4, sourceAddr);
            cstmt.setString(5, destAddr);
            cstmt.setString(6, content);
            cstmt.setTimestamp(7, SMTools.toSqlDate(atTime));
            cstmt.setInt(8, needStateReport);
            cstmt.setString(9, serviceID);
            cstmt.setString(10, feeType);
            cstmt.setString(11, feeCode);
            cstmt.setInt(12, 0);
            cstmt.setString(13, "0");
            cstmt.setInt(14, 0);
            cstmt.setTimestamp(15, SMTools.toSqlDate(atTime));
            cstmt.setInt(16, 0);
            cstmt.setInt(17, 0);
            cstmt.setInt(18, 0);
            cstmt.setInt(19, 3);
            cstmt.setInt(20, 1);
            cstmt.setString(21, "taskname");
            int n2 = i2 = cstmt.executeUpdate();
            return n2;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1003");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    private static int insertCMPP3SM(Date atTime, String sourceAddr, String destAddr, String content, int needStateReport, String serviceID, String feeType, String feeCode, int SMType, String messageID) throws SMException {
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            int i2;
            String sql = DBSQL.INSERT_INTO_TBL_SMSENDTASK;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            String operator = sessionCreatorID;
            cstmt.setString(1, operator);
            cstmt.setInt(2, 0);
            cstmt.setString(3, "API");
            cstmt.setString(4, sourceAddr);
            cstmt.setString(5, destAddr);
            cstmt.setString(6, content);
            cstmt.setTimestamp(7, SMTools.toSqlDate(atTime));
            cstmt.setInt(8, needStateReport);
            cstmt.setString(9, serviceID);
            cstmt.setString(10, feeType);
            cstmt.setString(11, feeCode);
            cstmt.setInt(12, SMType);
            cstmt.setString(13, messageID == null ? null : messageID);
            cstmt.setInt(14, 0);
            cstmt.setTimestamp(15, SMTools.toSqlDate(atTime));
            cstmt.setInt(16, 0);
            cstmt.setInt(17, 0);
            cstmt.setInt(18, 0);
            cstmt.setInt(19, 3);
            cstmt.setInt(20, 1);
            cstmt.setString(21, "");
            int n2 = i2 = cstmt.executeUpdate();
            return n2;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1003");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    protected static void operatorParamErrors(String id2, String code, String name, String password, String Type2, String smSendRight, String multiSendRight, String perSendRight, String limitType, String maxCount, String Modified) throws SMException {
        if (id2 == null || "".equals(id2.trim()) || id2.length() > 20) {
            throw new SMException("100512");
        }
        if (code == null || "".equals(id2.trim()) || code.length() > 20) {
            throw new SMException("100513");
        }
        if (name == null || "".equals(id2.trim()) || name.length() > 20) {
            throw new SMException("100513");
        }
        if (password == null || password.length() == 0 || password.length() > 20) {
            throw new SMException("100514");
        }
        if (!"1".equals(Type2)) {
            throw new SMException("100515");
        }
        if (!"0".equals(smSendRight) && !"1".equals(smSendRight)) {
            throw new SMException("100516");
        }
        if (!"0".equals(multiSendRight) && !"1".equals(multiSendRight)) {
            throw new SMException("100517");
        }
        if (!"0".equals(perSendRight) && !"1".equals(perSendRight)) {
            throw new SMException("100518");
        }
        if (!("0".equals(limitType) || "1".equals(limitType) || "2".equals(limitType))) {
            throw new SMException("100519");
        }
        if (!"1".equals(Modified)) {
            throw new SMException("100521");
        }
    }

    public static int insertOperatorInfo(String id2, String code, String name, String password, String Type2, String smSendRight, String multiSendRight, String perSendRight, String limitType, String maxCount, String Modified) throws SMException {
        int i2 = 0;
        int roleID = -1;
        try {
            SMEntry.operatorParamErrors(id2, code, name, password, Type2, smSendRight, multiSendRight, perSendRight, limitType, maxCount, Modified);
        }
        catch (SMException e2) {
            throw new SMException(e2.getErrorType());
        }
        password = SecurityTools.digest(password);
        CallableStatement cstmt = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            roleID = SMEntry.insertRole(smSendRight, multiSendRight, perSendRight, conn);
            if (roleID != -1) {
                String sql = DBSQL.INSERT_OPERATOR;
                cstmt = conn.prepareCall(sql);
                cstmt.setString(1, id2);
                cstmt.setString(2, name);
                cstmt.setString(3, code);
                cstmt.setString(4, password);
                cstmt.setString(5, Type2);
                cstmt.setInt(6, roleID);
                cstmt.setString(7, limitType);
                cstmt.setString(8, maxCount);
                cstmt.setString(9, Modified);
                i2 = cstmt.executeUpdate();
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e3) {
            SMLog.error("", e3);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1006");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return i2;
    }

    private static int insertRole(String smSendRight, String multiSendRight, String perSendRight, Connection conn) throws SMException {
        int roleID = -1;
        Statement statement = null;
        ResultSet rs = null;
        Date time = new Date();
        long l2 = time.getTime();
        String name = "API" + l2;
        String description = "\u6b64\u89d2\u8272\u662f\u901a\u8fc7\u77ed\u4fe1API\u589e\u52a0\u7684\uff0c\u8bf7\u52ff\u968f\u4fbf\u5220\u9664\uff01";
        int[] right = new int[]{-1, -1, -1, 1};
        if ("0".equals(smSendRight)) {
            right[0] = 1;
        }
        if ("0".equals(multiSendRight)) {
            right[1] = 2;
        }
        if ("0".equals(perSendRight)) {
            right[2] = 3;
        }
        try {
            String sql = "insert into tbl_role (name,description) values('" + name + "','" + description + "')";
            statement = conn.createStatement();
            statement.executeUpdate(sql);
            sql = "select * from tbl_role where name = '" + name + "'";
            rs = statement.executeQuery(sql);
            if (rs.next()) {
                roleID = rs.getInt(1);
            }
            if (roleID != -1) {
                for (int i2 = 0; i2 < right.length; ++i2) {
                    if (right[i2] == -1) continue;
                    sql = "insert into tbl_RoleJoinAuthority (roleID,authorityid) values('" + roleID + "','" + right[i2] + "')";
                    statement.executeUpdate(sql);
                }
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10061");
        }
        return roleID;
    }

    private static int updateRoleAuthority(String id2, String smSendRight, String multiSendRight, String perSendRight) throws SMException {
        int roleID = -1;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        int[] right = new int[]{-1, -1, -1, 18};
        if ("0".equals(smSendRight)) {
            right[0] = 1;
        }
        if ("0".equals(multiSendRight)) {
            right[1] = 2;
        }
        if ("0".equals(perSendRight)) {
            right[2] = 3;
        }
        try {
            String sql = "select roleID from tbl_Operator where Operator_ID = '" + id2 + "'";
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                roleID = rs.getInt(1);
            }
            if (roleID != -1) {
                sql = "delete from tbl_RoleJoinAuthority where roleID = '" + roleID + "'";
                stmt.executeUpdate(sql);
                for (int i2 = 0; i2 < right.length; ++i2) {
                    if (right[i2] == -1) continue;
                    sql = "insert into  tbl_RoleJoinAuthority (roleID,authorityid) values('" + roleID + "','" + right[i2] + "')";
                    stmt.executeUpdate(sql);
                }
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            try {
                SMLog.error("", e2);
                ConnectionMgr.rollBackConn(conn);
                throw new SMException("10061");
            }
            catch (Throwable throwable) {
                ConnectionMgr.closeDBConnection(conn);
                throw throwable;
            }
        }
        ConnectionMgr.closeDBConnection(conn);
        return roleID;
    }

    public static int updateOperatorInfo(String id2, String code, String name, String smSendRight, String multiSendRight, String perSendRight, String limitType, String maxCount) throws SMException {
        int i2 = 0;
        if (id2 == null || id2.length() == 0 || id2.length() > 20) {
            throw new SMException("100512");
        }
        if (code == null || code.length() == 0 || code.length() > 20) {
            throw new SMException("100513");
        }
        if (name == null || name.length() == 0 || name.length() > 20) {
            throw new SMException("100513");
        }
        if (!"0".equals(smSendRight) && !"1".equals(smSendRight)) {
            throw new SMException("100516");
        }
        if (!"0".equals(multiSendRight) && !"1".equals(multiSendRight)) {
            throw new SMException("100517");
        }
        if (!"0".equals(perSendRight) && !"1".equals(perSendRight)) {
            throw new SMException("100518");
        }
        if (!("0".equals(limitType) || "1".equals(limitType) || "2".equals(limitType))) {
            throw new SMException("100519");
        }
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            String sql = "";
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            SMEntry.updateRoleAuthority(id2, smSendRight, multiSendRight, perSendRight);
            sql = "update tbl_Operator set Operator_Code =?, Operator_Name=?, limitType=?, maxCount=? where Operator_ID=?";
            cstmt = conn.prepareStatement(sql);
            cstmt.setString(1, code);
            cstmt.setString(2, name);
            cstmt.setString(3, limitType);
            cstmt.setString(4, maxCount);
            cstmt.setString(5, id2);
            i2 = cstmt.executeUpdate();
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("10061");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return i2;
    }

    public static SendShorBean searchOperatorInfo(String id2) throws SMException {
        String sql = "";
        String code = "";
        String name = "";
        String type = "";
        String password = "";
        String right = "";
        String limitType = "";
        String maxCount = "";
        int roleID = -1;
        Statement stmt = null;
        ResultSet rs = null;
        SendShorBean bean = new SendShorBean();
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            sql = "select * from tbl_Operator where Operator_ID='" + id2 + "'";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                code = rs.getString("Operator_Code");
                bean.setOperator_Code(code);
                name = rs.getString("Operator_Name");
                bean.setOperator_Name(name);
                password = rs.getString("Password");
                bean.setPassword(password);
                type = rs.getString("OperatorType");
                bean.setType(type);
                limitType = rs.getString("LimitType");
                bean.setLimitType(limitType);
                maxCount = rs.getString("maxCount");
                bean.setMaxCount(maxCount);
                roleID = rs.getInt("roleID");
            }
            bean.setSmsendRight("1");
            bean.setMultiSendRight("1");
            bean.setPerSendRight("1");
            if (roleID != -1) {
                sql = "select * from tbl_RoleJoinAuthority where roleID = " + roleID;
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    right = rs.getString("authorityid");
                    if ("1".equals(right)) {
                        bean.setSmsendRight("0");
                    }
                    if ("2".equals(right)) {
                        bean.setMultiSendRight("0");
                    }
                    if (!"3".equals(right)) continue;
                    bean.setPerSendRight("0");
                }
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1003");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return bean;
    }

    public static int delOperatorInfo(String id2) throws SMException {
        int i2 = 0;
        String sql = "";
        ResultSet rs = null;
        int roleID = -1;
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            conn.setAutoCommit(false);
            sql = "select roleID from tbl_Operator where Operator_ID = '" + id2 + "'";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                roleID = rs.getInt(1);
            }
            if (roleID != -1) {
                sql = "delete from tbl_role where ID = " + roleID;
                stmt.executeUpdate(sql);
                sql = "delete from tbl_RoleJoinAuthority where roleID = " + roleID;
                stmt.executeUpdate(sql);
            }
            sql = "delete from tbl_Operator where Operator_ID= '" + id2 + "'";
            i2 = stmt.executeUpdate(sql);
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("10062");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return i2;
    }

    protected static void paramErrors(Date atTime, String sourceAddr, String destAddrOrFile, String content, int needStateReport, String serviceID, String feeType, String feeCode, boolean isShort) throws SMException {
        String regex = "\\d+";
        Pattern p2 = Pattern.compile(regex);
        Matcher m2 = null;
        if (atTime == null) {
            throw new SMException("100501");
        }
        m2 = p2.matcher(sourceAddr);
        if (sourceAddr == null || "".equals(sourceAddr.trim()) || sourceAddr.trim().length() > 21 || !m2.matches()) {
            throw new SMException("100502");
        }
        if (isShort) {
            m2 = p2.matcher(destAddrOrFile);
            if (destAddrOrFile == null || "".equals(destAddrOrFile.trim()) || destAddrOrFile.trim().length() > 21 || !m2.matches()) {
                throw new SMException("100503");
            }
        } else if (!isShort && !SMTools.isFile(destAddrOrFile)) {
            throw new SMException("100504");
        }
        if (content == null || "".equals(content.trim()) || content.trim().length() > SMAPIConfig.SMCONTENT_LEN) {
            throw new SMException("100505");
        }
        if (needStateReport < 0 || needStateReport > 1) {
            throw new SMException("100506");
        }
        if (serviceID == null || "".equals(serviceID.trim()) || serviceID != null && serviceID.length() > 10) {
            throw new SMException("100507");
        }
        if (!("01".equals(feeType) || "02".equals(feeType) || "03".equals(feeType))) {
            throw new SMException("100508");
        }
        m2 = p2.matcher(feeCode);
        if (feeCode == null || "".equals(feeCode.trim()) || !m2.matches() || feeCode != null && feeCode.length() > 6) {
            throw new SMException("100509");
        }
    }

    static void checkParamErrors(ProvsionBean pbean, ReversedProvsionBean ppbean) throws SMException {
        String regex = "\\d+";
        Pattern p2 = Pattern.compile(regex);
        Matcher m2 = null;
        m2 = p2.matcher(ppbean.getDestUserId());
        if (ppbean.getDestUserId() == null || "".equals(ppbean.getDestUserId().trim()) || ppbean.getDestUserId().trim().length() > 21 || !m2.matches()) {
            throw new SMException("100502");
        }
    }

    private static int submitShortMessageMulti(String user, String password, Date atTime, String sourceAddr, String destAddrFiles, String content, int needStateReport, String serviceID, String feeType, String feeCode) throws SMException {
        try {
            SMEntry.paramErrors(atTime, sourceAddr, destAddrFiles, content, needStateReport, serviceID, feeType, feeCode, false);
        }
        catch (SMException e2) {
            throw new SMException(e2.getErrorType());
        }
        try {
            ArrayList list = SMTools.readFileToList(destAddrFiles);
            Iterator it = list.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                String destAddr = (String)it.next();
                int count = SMEntry.insertSM(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode);
                ++i2;
            }
            return i2;
        }
        catch (SMException e3) {
            SMLog.error("\u7fa4\u53d1\u77ed\u4fe1\u5931\u8d25: ", e3);
            throw new SMException(e3.getErrorType());
        }
    }

    public static int submitShortMessageMulti(Date atTime, String sourceAddr, String destAddrFiles, String content, int needStateReport, String serviceID, String feeType, String feeCode) throws SMException {
        try {
            SMEntry.paramErrors(atTime, sourceAddr, destAddrFiles, content, needStateReport, serviceID, feeType, feeCode, false);
        }
        catch (SMException e2) {
            throw new SMException(e2.getErrorType());
        }
        try {
            ArrayList list = SMTools.readFileToList(destAddrFiles);
            Iterator it = list.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                String destAddr = (String)it.next();
                int count = SMEntry.insertSM(atTime, sourceAddr, destAddr, content, needStateReport, serviceID, feeType, feeCode);
                ++i2;
            }
            return i2;
        }
        catch (SMException e3) {
            SMLog.error("\u7fa4\u53d1\u77ed\u4fe1\u5931\u8d25: ", e3);
            throw new SMException(e3.getErrorType());
        }
    }

    public static SMReceivedBean getAMessage(String destAddrs) throws SMException {
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            String regex = "\\d+";
            Pattern p2 = Pattern.compile(regex);
            Matcher m2 = p2.matcher(destAddrs);
            if (destAddrs == null || "".equals(destAddrs.trim()) || !m2.matches() || destAddrs.trim().length() > 21) {
                throw new SMException("100510");
            }
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            SMReceivedBean bean = SMEntry.selectMessage(destAddrs, null, stmt);
            if (bean != null) {
                SMEntry.updateMessage(bean.getSMId(), stmt);
            }
            conn.commit();
            conn.setAutoCommit(true);
            SMReceivedBean sMReceivedBean = bean;
            return sMReceivedBean;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            ConnectionMgr.rollBackConn(conn);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    protected static boolean selectForbiddenWord(String content) throws SMException {
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
            String sql = "Select * from tbl_ForbiddenWord";
            cstmt = conn.prepareStatement(sql);
            rs = cstmt.executeQuery();
            if (rs == null) {
                boolean bl = false;
                return bl;
            }
            while (rs.next()) {
                String fors = rs.getString("ForbiddenWord");
                if ("".equals(fors)) continue;
                if (content.indexOf(fors) <= -1) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1010");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
        return false;
    }

    private static SMReceivedBean selectMessage(String destAddrs, String smtype, Statement stmt) throws SMException {
        ResultSet rs = null;
        SMReceivedBean bean = null;
        String sql = "Select top 1 * from tbl_SMReceived ";
        try {
            if (destAddrs != null && smtype == null) {
                sql = sql + " Where DestAddr like '" + destAddrs + "%' and Reserve1 is null  order by recvTime desc";
            } else if (destAddrs == null && smtype != null) {
                sql = sql + " Where SMType = '" + smtype + "'  and actionReasonID='1' and Reserve1 is null  order by recvTime desc";
            }
            SMLog.info("\u67e5\u8be2\u8bed\u53e5 = " + sql);
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                bean = new SMReceivedBean();
                int id2 = rs.getInt("SM_Id");
                String orgAddr = rs.getString("OrgAddr");
                String destAddr = rs.getString("DestAddr");
                String sm_Content = rs.getString("SM_Content");
                Date recvTime = SMTools.toUtilDate(rs.getTimestamp("recvTime"));
                bean.setSMId(id2);
                bean.setDestAddr(destAddr);
                bean.setOrgAddr(orgAddr);
                bean.setSMContent(sm_Content);
                bean.setRecvTime(recvTime);
                bean.setActionID(rs.getInt("ActionID"));
                bean.setServiceID(rs.getString("ServiceID"));
                bean.setSMType(rs.getInt("SMType"));
                bean.setActionReasonID(rs.getInt("ActionReasonID"));
                bean.setMessageID(rs.getString("MessageID"));
            }
            return bean;
        }
        catch (Exception e2) {
            SMLog.error("\u67e5\u8be2tbl_SMReceived\u8868\u7684\u65f6\u95f4\u8d85\u8fc7\u8bbe\u5b9a\u7684\uff13\uff10\u79d2", e2);
            throw new SMException("1010");
        }
    }

    public static void deleteMessage(int smId) throws SMException {
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            String sql = "Delete tbl_SMReceived Where SM_Id = " + smId + "";
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(sql);
            cstmt.executeUpdate();
        }
        catch (Exception e2) {
            try {
                SMLog.error("", e2);
                throw new SMException("1004");
            }
            catch (Throwable throwable) {
                ConnectionMgr.closeDBConnection(conn);
                throw throwable;
            }
        }
        ConnectionMgr.closeDBConnection(conn);
    }

    private static void updateMessage(int smId, Statement cstmt) throws SMException {
        try {
            String sql = "Update tbl_SMReceived set Reserve1 = 1 Where SM_Id = " + smId;
            SMLog.info("\u66f4\u65b0\u63a5\u6536\u8868\u7684\u8bed\u53e5: " + sql);
            cstmt.executeUpdate(sql);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("1004");
        }
    }

    public static SendShorBean FetchUssdRequest() throws SMException {
        PreparedStatement cstmt = null;
        ResultSet rs = null;
        SendShorBean bean = null;
        Connection conn = null;
        try {
            String fetchUssdReqSql = DBSQL.FETCH_USSD_REQUEST;
            conn = ConnectionMgr.getConnection();
            cstmt = conn.prepareStatement(fetchUssdReqSql);
            rs = cstmt.executeQuery();
            if (rs.next()) {
                bean = new SendShorBean();
                String CallerNO = rs.getString("CallerNO");
                bean.setCallerNO(CallerNO);
                String UpdateTime = rs.getString(2);
                bean.setUpdateTime(UpdateTime);
                String LastTrack = rs.getString(3);
                bean.setLastTrack(LastTrack);
                String CurrentIn = rs.getString(4);
                bean.setCurrentIn(CurrentIn);
                int MsgType = Integer.parseInt(rs.getString(5));
                bean.setMsgType(MsgType);
            }
            SendShorBean sendShorBean = bean;
            return sendShorBean;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10064");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static int SubmitUssdResponse(int SessionID, String CallerNO, String CurrentIn, String LastTrack, int MsgType, int FeeType, int FeeRate, String FeeNO) throws SMException {
        if (CallerNO == null || "".equals(CallerNO.trim()) || CallerNO.length() > 21) {
            throw new SMException("100501");
        }
        PreparedStatement cstmt = null;
        Connection conn = null;
        try {
            int i2;
            conn = ConnectionMgr.getConnection();
            String updateUssdSql = DBSQL.UPDATEUSSDMSG;
            cstmt = conn.prepareStatement(updateUssdSql);
            Date time = new Date();
            Timestamp updatetime = SMTools.toSqlDate(time);
            cstmt.setTimestamp(1, updatetime);
            cstmt.setString(2, LastTrack);
            cstmt.setString(3, CurrentIn);
            cstmt.setInt(4, MsgType);
            cstmt.setInt(5, FeeType);
            cstmt.setInt(6, FeeRate);
            cstmt.setString(7, FeeNO);
            cstmt.setString(8, CallerNO);
            int n2 = i2 = cstmt.executeUpdate();
            return n2;
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10063");
        }
        finally {
            ConnectionMgr.closeDBConnection(conn);
        }
    }

    public static SendShorBean getSessionIDFromUSSD() throws SMException {
        SendShorBean bean = new SendShorBean();
        try {
            for (int j2 = 0; j2 < 7; ++j2) {
                bean.setSessionIDList(j2);
            }
        }
        catch (Exception e2) {
            SMLog.error("", e2);
            throw new SMException("10065");
        }
        return bean;
    }

    public static Connection getConnection() {
        Connection conn = null;
        try {
            conn = ConnectionMgr.getConnection();
        }
        catch (Exception ex) {
            SMLog.error("", ex);
        }
        return conn;
    }

    public static void main(String[] args) {
        try {
            AbstractMsgBean ab2 = new AbstractMsgBean();
            System.out.println(ab2.getOperationType() == null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

