/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.api;

import com.huawei.api.SMAPIConfig;
import com.huawei.api.SMException;
import com.huawei.api.smsend.db.DBSQL;
import com.huawei.api.smsend.system.SMLog;
import com.huawei.utils.Args;
import com.huawei.utils.Cfg;
import com.huawei.utils.db.DBPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnectionMgr {
    private static String url = null;
    private static String user = null;
    private static String pass = null;
    private static String forDriver = null;
    private static DBPool dbpool = null;
    public static Args sqlArgs;

    public static void initConn(String urlTemp, String userTemp, String passTemp) {
        if (dbpool != null) {
            return;
        }
        Args args = new Args();
        args.set("user", userTemp);
        args.set("password", passTemp);
        try {
            url = ConnectionMgr.createURL(SMAPIConfig.getDbDriver(), urlTemp);
        }
        catch (Exception e2) {
            SMLog.error("", e2);
        }
        args.set("url", url);
        args.set("watch-interval", "5");
        args.set("max-free-connection", "5");
        args.set("max-connection", "5");
        args.set("login-timeout", "30");
        args.set("test-sql", DBSQL.TESTSQL);
        args.set("connection-timeout", "30");
        args.set("driver", SMAPIConfig.getDbDriver());
        try {
            dbpool = new DBPool(args);
        }
        catch (Exception ex) {
            SMLog.error("", ex);
            dbpool.close();
            dbpool = null;
        }
    }

    public static Connection getConnection() throws SMException {
        Connection conn = null;
        try {
            conn = dbpool.getConnection();
        }
        catch (Exception ex) {
            SMLog.error("\u9519\u8bef\u7c7b\u578b:1000  \u9519\u8bef\u63cf\u8ff0: There is an exception while loading database driver", ex);
            throw new SMException("1000");
        }
        return conn;
    }

    public static void close() {
        if (dbpool != null) {
            dbpool.close();
            dbpool = null;
        }
    }

    public static void closeDBConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                SMLog.error("", ex);
            }
        }
    }

    public static void rollBackConn(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (Exception ex) {
                SMLog.error("", ex);
            }
            try {
                conn.setAutoCommit(true);
            }
            catch (Exception ex) {
                SMLog.error("", ex);
            }
        }
    }

    private static synchronized Connection innerCreateConnection() throws SMException {
        Connection conn = null;
        try {
            Class.forName(forDriver).newInstance();
            DriverManager.setLoginTimeout(30);
            conn = DriverManager.getConnection(url, user, pass);
        }
        catch (SQLException e2) {
            SMLog.error("\u9519\u8bef\u578b\u578b:1001  \u9519\u8bef\u63cf\u8ff0: Invalid database, user name or password!", e2);
            SMLog.info("\u53ef\u80fd\u6570\u636e\u5e93\u88ab\u963b\u585e\uff0c\u5bfc\u81f4\u7a0b\u5e8f\u4e0d\u80fd\u591f\u8fde\u63a5\u4e0a\u6570\u636e\u5e93", e2);
            throw new SMException("1001");
        }
        catch (Exception e3) {
            SMLog.error("\u9519\u8bef\u7c7b\u578b:1000  \u9519\u8bef\u63cf\u8ff0: There is an exception while loading database driver", e3);
            throw new SMException("1000");
        }
        return conn;
    }

    private static String createURL(String driver, String url) throws Exception {
        String returnURL = "";
        String filePath = "smsendsql.xml";
        Cfg cfg = new Cfg(filePath);
        if (driver.equalsIgnoreCase("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            sqlArgs = cfg.getArgs("msdesql");
            returnURL = url.startsWith("jdbc:microsoft:sqlserver://") ? url : "jdbc:microsoft:sqlserver://" + url + ":1433;SelectMethod=cursor;DatabaseName=db_customsms";
        } else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            sqlArgs = cfg.getArgs("mysql");
            returnURL = url.startsWith("jdbc:mysql://") ? url : "jdbc:mysql://" + url + "/db_customsms";
        } else if (driver.equalsIgnoreCase("com.ibm.db2.jcc.DB2Driver")) {
            sqlArgs = cfg.getArgs("db2sql");
            returnURL = url.startsWith("jdbc:db2://") ? url : "jdbc:db2://" + url + ":50000/WAS50";
        } else {
            SMLog.info("Database Driver  Error,Please check Database Driver");
            SMLog.info("driver : " + driver + " , url : " + url);
            throw new Exception("Database Driver Error,Please check Database Driver");
        }
        return returnURL;
    }

    public static void main(String[] args) throws ClassNotFoundException, SMException, InstantiationException, IllegalAccessException {
        Connection con = null;
        Statement stmt = null;
        try {
            SMAPIConfig.setDbDriver("com.mysqlaa.jdbc.Driver");
            ConnectionMgr.initConn("127.0.0.1", "customsms", "123456");
            con = ConnectionMgr.getConnection();
            String sql = "select top 1 operator_id from tbl_operator";
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                System.out.println("----" + rs.getString("operator_id"));
            }
        }
        catch (SQLException ex1) {
            ex1.printStackTrace();
        }
        System.out.println("Connection Successful!");
    }
}

