/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.AbstractColumn;
import com.caucho.jdbc.mysql.AbstractResultSet;
import com.caucho.jdbc.mysql.Column;
import com.caucho.jdbc.mysql.DatabaseConnection;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.QDate;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

class ResultSet
extends AbstractResultSet {
    private static QDate date = new QDate();
    private int nColumns;
    private Column[] columns;
    private byte[] buf = new byte[8192];
    private int[] offsets;
    private int[] lengths;
    private int topColumn;
    private int topOffset;
    private DatabaseConnection dbConn;
    private ByteInputStream byteInputStream;
    private VfsStream streamImpl;
    private ReadStream readStream;
    int len;

    void init(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        this.dbConn = databaseConnection;
        this.rowNumber = 0;
        this.byteInputStream = null;
        if (this.readStream != null) {
            try {
                this.readStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public AbstractColumn getColumn(int n2) {
        return this.columns[n2 - 1];
    }

    public int findColumn(String string) throws SQLException {
        this.cb.clear();
        this.cb.append(string);
        int n2 = 0;
        while (n2 < this.nColumns) {
            if (this.columns[n2].name.equals((CharSegment)this.cb)) {
                return n2 + 1;
            }
            ++n2;
        }
        throw new SQLException("No such column `" + string + "'");
    }

    protected int getOffset(int n2) throws SQLException {
        while (this.topColumn < n2 - 1) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        return this.offsets[n2 - 1];
    }

    protected int getLength(int n2) throws SQLException {
        while (this.topColumn < n2 - 1) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        int n3 = this.lengths[n2 - 1];
        this.wasNull = n3 < 0;
        return n3;
    }

    protected byte[] getBuffer(int n2) throws SQLException {
        int n3 = this.getLength(n2);
        if (n3 > 256) {
            return null;
        }
        if (this.topColumn < n2) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        if (this.rowNumber > 0) {
            return n3 <= 256 ? this.buf : null;
        }
        if (this.rowNumber == 0) {
            throw new SQLException("expected next() before getting column");
        }
        throw new SQLException("can't get column after next() returns false");
    }

    protected InputStream getInputStream(int n2) throws SQLException {
        while (this.topColumn < n2 - 1) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        int n3 = this.lengths[n2 - 1];
        if (this.rowNumber == 0) {
            throw new SQLException("expected next() before getting column");
        }
        if (this.rowNumber < 0) {
            throw new SQLException("can't get column after next() returns false");
        }
        if (n3 <= 256) {
            return null;
        }
        if (this.topColumn != n2 - 1) {
            throw new SQLException("input stream no longer live");
        }
        this.byteInputStream = new ByteInputStream(this.dbConn, n3);
        return this.byteInputStream;
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        if (this.readStream == null) {
            this.streamImpl = new VfsStream(null, null);
            this.readStream = new ReadStream();
            this.readStream.setReuseBuffer(true);
            this.readStream.init((StreamImpl)this.streamImpl, null);
        }
        this.streamImpl.init(this.getBinaryStream(n2), null);
        this.readStream.init((StreamImpl)this.streamImpl, null);
        return this.readStream.getReader();
    }

    public boolean getBoolean(int n2) throws SQLException {
        int n3 = this.getLength(n2);
        int n4 = this.getOffset(n2);
        byte[] byArray = this.getBuffer(n2);
        Column column = this.columns[n2 - 1];
        switch (column.type) {
            case 0: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                if (n3 == 0) {
                    return false;
                }
                if (n3 > 1) {
                    return true;
                }
                return byArray[n4] != 48;
            }
            case 4: 
            case 5: {
                if (n3 == 0) {
                    return false;
                }
                int n5 = 0;
                while (n5 < n3) {
                    if (byArray[n4 + n5] != 48 && byArray[n4 + n5] != 46) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
        }
        if (n3 == 1) {
            return byArray[n4] != 48 && byArray[n4] != 110 && byArray[n4] != 78 && byArray[n4] != 102 && byArray[n4] != 70;
        }
        return n3 > 1;
    }

    public int getInt(int n2) throws SQLException {
        switch (this.columns[n2 - 1].type) {
            case 4: 
            case 5: {
                return (int)this.getDouble(n2);
            }
        }
        return super.getInt(n2);
    }

    public long getLong(int n2) throws SQLException {
        switch (this.columns[n2 - 1].type) {
            case 4: 
            case 5: {
                return (long)this.getDouble(n2);
            }
        }
        return super.getLong(n2);
    }

    /*
     * Unable to fully structure code
     */
    protected long getDateAsLong(int var1_1) throws SQLException {
        block34: {
            block35: {
                block33: {
                    var2_2 = this.getOffset(var1_1);
                    var3_3 = this.getLength(var1_1);
                    var4_4 = var2_2 + var3_3;
                    var5_5 = this.getBuffer(var1_1);
                    var6_6 = 0;
                    var7_7 = 0;
                    var8_8 = 0;
                    var9_9 = 0;
                    var10_10 = 0;
                    var11_11 = 0;
                    var12_12 = var2_2;
                    var13_13 = 32;
                    if (!this.wasNull && var3_3 >= 0) ** GOTO lbl16
                    return 0L;
lbl-1000:
                    // 1 sources

                    {
                        ++var12_12;
lbl16:
                        // 2 sources

                        ** while (var12_12 < var4_4 && (var5_5[var12_12] == 32 || var5_5[var12_12] == 9))
                    }
lbl17:
                    // 1 sources

                    var14_14 = var12_12;
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 4) {
                        var6_6 = 10 * var6_6 + var5_5[var12_12] - 48;
                        ++var12_12;
                    }
                    if (var13_13 != 45) break block33;
                    if (var6_6 <= 100) {
                        var6_6 = var6_6 < 50 ? (var6_6 += 2000) : (var6_6 += 1900);
                    }
                    ++var12_12;
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                        var7_7 = 10 * var7_7 + var13_13 - 48;
                        ++var12_12;
                    }
                    if (var13_13 != 45 || var7_7 > 12) {
                        throw new SQLException("bad date " + this.getString(var1_1));
                    }
                    ++var12_12;
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                        var8_8 = 10 * var8_8 + var13_13 - 48;
                        ++var12_12;
                    }
                    if (var8_8 <= 0 || var8_8 > 31) {
                        throw new SQLException("bad date " + this.getString(var1_1));
                    }
                    --var8_8;
                    while (var12_12 < var4_4 && ((var13_13 = var5_5[var12_12]) < 48 || var13_13 > 57)) {
                        ++var12_12;
                    }
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                        var9_9 = 10 * var9_9 + var13_13 - 48;
                        ++var12_12;
                    }
                    break block34;
                }
                if (var12_12 - var14_14 < 4 || var13_13 < 48 || var13_13 > 57) break block35;
                var14_14 = var12_12;
                while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                    var7_7 = 10 * var7_7 + var13_13 - 48;
                    ++var12_12;
                }
                if (var7_7 > 12) {
                    throw new SQLException("bad date " + this.getString(var1_1));
                }
                if (var13_13 == 45) {
                    ++var12_12;
                }
                var14_14 = var12_12;
                while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                    var8_8 = 10 * var8_8 + var13_13 - 48;
                    ++var12_12;
                }
                if (--var8_8 >= 0 && var8_8 < 31) ** GOTO lbl67
                throw new SQLException("bad date " + this.getString(var1_1));
lbl-1000:
                // 1 sources

                {
                    ++var12_12;
lbl67:
                    // 2 sources

                    ** while (var12_12 < var4_4 && ((var13_13 = var5_5[var12_12]) == 32 || var13_13 == 84))
                }
lbl68:
                // 1 sources

                var14_14 = var12_12;
                while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                    var9_9 = 10 * var9_9 + var13_13 - 48;
                    ++var12_12;
                }
                break block34;
            }
            if (var6_6 > 23) {
                throw new SQLException("bad date " + this.getString(var1_1));
            }
            var9_9 = var6_6;
            var6_6 = 0;
            if (var13_13 != 58) {
                throw new SQLException("bad date at `" + (char)var13_13 + "' " + var12_12 + " " + var14_14 + " " + this.getString(var1_1));
            }
        }
        if (var13_13 == 58) {
            ++var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                var10_10 = 10 * var10_10 + var13_13 - 48;
                ++var12_12;
            }
            if (var10_10 >= 60) {
                throw new SQLException("bad date " + this.getString(var1_1));
            }
        } else if (var13_13 >= 48 && var13_13 <= 57) {
            var14_14 = var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                var10_10 = 10 * var10_10 + var13_13 - 48;
                ++var12_12;
            }
        }
        if (var13_13 == 58) {
            ++var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                var11_11 = 10 * var11_11 + var13_13 - 48;
                ++var12_12;
            }
            if (var11_11 >= 60) {
                throw new SQLException("bad date " + this.getString(var1_1));
            }
        } else if (var13_13 >= 48 && var13_13 <= 57) {
            var14_14 = var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                var11_11 = 10 * var11_11 + var13_13 - 48;
                ++var12_12;
            }
        }
        var15_15 = 0L;
        var17_16 = ResultSet.date;
        synchronized (var17_16) {
            ResultSet.date.setTime(0L);
            if (var6_6 > 0) {
                ResultSet.date.setDate((long)var6_6, (long)(var7_7 - 1), (long)var8_8);
            }
            ResultSet.date.setTime((long)var9_9, (long)var10_10, (long)var11_11, 0L);
            var15_15 = ResultSet.date.getTime() - ResultSet.date.getZoneOffset();
        }
        return var15_15;
    }

    void clear() {
    }

    void setColumns(int n2) {
        this.nColumns = n2;
        if (this.columns == null || n2 > this.columns.length) {
            int n3 = n2 < 16 ? 16 : n2;
            this.columns = new Column[n3];
            this.offsets = new int[n3];
            this.lengths = new int[n3];
        }
    }

    void allocColumn(int n2) {
        Column column = this.columns[n2];
        if (column == null) {
            this.columns[n2] = column = new Column();
        }
        column.table.clear();
        column.name.clear();
    }

    CharBuffer getName(int n2) {
        return this.columns[n2].name;
    }

    CharBuffer getTable(int n2) {
        return this.columns[n2].table;
    }

    void setColumn(int n2, int n3, int n4, int n5, int n6) {
        Column column = this.columns[n2];
        if (column == null) {
            this.columns[n2] = column = new Column();
        }
        column.init(n3, n4, n5, n6);
    }

    public boolean next() throws SQLException {
        if (this.dbConn == null) {
            return false;
        }
        if (this.rowNumber < 0) {
            this.dbConn.completeResult();
            this.dbConn = null;
            return false;
        }
        try {
            int n2 = this.dbConn.next();
            if (n2 == Integer.MIN_VALUE) {
                this.rowNumber = -1;
                this.dbConn.completeResult();
                this.dbConn = null;
                return false;
            }
            ++this.rowNumber;
            this.offsets[0] = 0;
            this.lengths[0] = n2;
            this.topColumn = 0;
            this.topOffset = 0;
            if (n2 <= 256) {
                this.readColumns();
            }
            return true;
        }
        catch (IOException iOException) {
            this.rowNumber = -1;
            if (this.dbConn != null) {
                this.dbConn.completeResult();
            }
            this.dbConn = null;
            throw new SQLException("io: " + iOException);
        }
    }

    void readColumns() throws IOException {
        int n2 = this.dbConn.getReadLength();
        int n3 = this.topOffset;
        int n4 = this.topColumn;
        do {
            int n5;
            if ((n5 = this.lengths[this.topColumn++]) > 0) {
                if (n5 <= 256) {
                    this.dbConn.read(this.buf, n3, n5);
                    n3 += n5;
                } else if (this.byteInputStream != null) {
                    this.byteInputStream.close();
                } else {
                    this.dbConn.skip(n5);
                }
            }
            if (this.topColumn >= this.nColumns) break;
            this.len = this.dbConn.readLength();
            this.offsets[this.topColumn] = n3;
            this.lengths[this.topColumn] = this.len;
        } while (this.len <= 256);
        this.topOffset = n3;
    }

    int getNColumns() {
        return this.nColumns;
    }

    void readColumn(int n2, int n3) throws IOException {
        int n4;
        this.offsets[n2] = n2 == 0 ? 0 : ((n4 = this.lengths[n2 - 1]) < 0 ? this.offsets[n2 - 1] : this.offsets[n2 - 1] + n4);
        if (n3 > 0) {
            this.dbConn.read(this.buf, this.offsets[n2], n3);
            this.lengths[n2] = n3;
        } else {
            this.lengths[n2] = -1;
        }
    }

    public void close() throws SQLException {
        while (this.dbConn != null && this.rowNumber >= 0 && this.next()) {
        }
        this.rowNumber = -1;
    }

    ResultSet() {
    }

    static class ByteInputStream
    extends InputStream {
        DatabaseConnection dbConn;
        int length;

        public int read() throws IOException {
            if (this.length > 0) {
                --this.length;
                int n2 = this.dbConn.read();
                return n2;
            }
            return -1;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.length <= 0) {
                return -1;
            }
            if (this.length < n3) {
                n3 = this.length;
            }
            int n4 = this.dbConn.read(byArray, n2, n3);
            this.length -= n4;
            return n4;
        }

        public void close() throws IOException {
            if (this.length > 0) {
                this.dbConn.skip(this.length);
            }
            this.length = -1;
        }

        ByteInputStream(DatabaseConnection databaseConnection, int n2) {
            this.dbConn = databaseConnection;
            this.length = n2;
        }
    }
}

