/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.Connection;
import com.caucho.jdbc.mysql.SQLExceptionWrapper;
import com.caucho.jdbc.mysql.Statement;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private static WriteStream dbg = LogStream.open((String)"/caucho.com/jdbc/statement");
    private static LruCache cache = new LruCache(256);
    private CharBuffer cb = new CharBuffer();
    private char[][] staticChunks;
    private CharBuffer[] parameters;
    private Object[] values;

    static PreparedStatement create(Connection connection, String string) {
        PreparedStatement preparedStatement = new PreparedStatement();
        preparedStatement.init(connection);
        char[][] cArray = (char[][])cache.get((Object)string);
        if (cArray == null) {
            int n2;
            ArrayList<char[]> arrayList = new ArrayList<char[]>();
            CharBuffer charBuffer = new CharBuffer();
            int n3 = 0;
            while (n3 < string.length()) {
                n2 = string.charAt(n3);
                if (n2 == 63) {
                    char[] cArray2 = new char[charBuffer.getLength()];
                    System.arraycopy(charBuffer.getBuffer(), 0, cArray2, 0, cArray2.length);
                    arrayList.add(cArray2);
                    charBuffer.clear();
                } else if (n2 == 39) {
                    charBuffer.append('\'');
                    ++n3;
                    while (n3 < string.length() && string.charAt(n3) != '\'') {
                        charBuffer.append(string.charAt(n3));
                        ++n3;
                    }
                    charBuffer.append('\'');
                } else {
                    charBuffer.append((char)n2);
                }
                ++n3;
            }
            char[] cArray3 = new char[charBuffer.getLength()];
            System.arraycopy(charBuffer.getBuffer(), 0, cArray3, 0, cArray3.length);
            arrayList.add(cArray3);
            cArray = new char[arrayList.size()][];
            n2 = 0;
            while (n2 < arrayList.size()) {
                cArray[n2] = (char[])arrayList.get(n2);
                ++n2;
            }
            cache.put((Object)string, (Object)cArray);
        }
        preparedStatement.staticChunks = cArray;
        preparedStatement.parameters = new CharBuffer[cArray.length - 1];
        preparedStatement.values = new Object[cArray.length - 1];
        int n4 = 0;
        while (n4 < preparedStatement.parameters.length) {
            preparedStatement.parameters[n4] = new CharBuffer();
            preparedStatement.values[n4] = null;
            ++n4;
        }
        return preparedStatement;
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    public void clearParameters() throws SQLException {
        int n2 = 0;
        while (n2 < this.parameters.length) {
            this.parameters[n2].clear();
            ++n2;
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append("null");
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.setNull(n2, n3);
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(bl ? "'t'" : "'f'");
    }

    public void setByte(int n2, byte by) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append((int)by);
    }

    public void setShort(int n2, short s2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append((int)s2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(l2);
    }

    public void setFloat(int n2, float f2) throws SQLException {
        char c2;
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(f2);
        int n3 = charBuffer.indexOf('E');
        if (n3 > 0 && n3 + 1 < charBuffer.length() && (c2 = charBuffer.charAt(n3 + 1)) != '+' && c2 != '-') {
            charBuffer.insert(n3 + 1, '+');
        }
    }

    public void setDouble(int n2, double d2) throws SQLException {
        char c2;
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(d2);
        int n3 = charBuffer.indexOf('E');
        if (n3 > 0 && n3 + 1 < charBuffer.length() && (c2 = charBuffer.charAt(n3 + 1)) != '+' && c2 != '-') {
            charBuffer.insert(n3 + 1, '+');
        }
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append((Object)bigDecimal);
    }

    public void setString(int n2, String string) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        if (string == null) {
            charBuffer.append("null");
        } else {
            charBuffer.append('\'');
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                char c2 = string.charAt(n4);
                if (c2 == '\'') {
                    charBuffer.append("\\'");
                } else if (c2 == '\"') {
                    charBuffer.append("\\\"");
                } else if (c2 == '\u0000') {
                    charBuffer.append("\\0");
                } else if (c2 == '\\') {
                    charBuffer.append("\\\\");
                } else {
                    charBuffer.append(c2);
                }
                ++n4;
            }
            charBuffer.append('\'');
            if (this.encoding != null) {
                try {
                    byte[] byArray = charBuffer.toString().getBytes(this.encoding);
                    charBuffer.clear();
                    charBuffer.append(byArray, 0, byArray.length);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLExceptionWrapper(unsupportedEncodingException);
                }
            }
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        if (byArray == null) {
            charBuffer.append("null");
            return;
        }
        charBuffer.append('\'');
        int n3 = 0;
        while (n3 < byArray.length) {
            byte by = byArray[n3];
            if (by == 39) {
                charBuffer.append("\\'");
            } else if (by == 34) {
                charBuffer.append("\\\"");
            } else if (by == 0) {
                charBuffer.append("\\0");
            } else if (by == 92) {
                charBuffer.append("\\\\");
            } else {
                charBuffer.append((char)by);
            }
            ++n3;
        }
        charBuffer.append('\'');
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.setDate(n2, date);
    }

    public void setDate(int n2, Date date) throws SQLException {
        if (date != null) {
            this.setTime(n2, date.getTime());
        } else {
            this.setNull(n2, 0);
        }
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.setTime(n2, time);
    }

    public void setTime(int n2, Time time) throws SQLException {
        if (time != null) {
            this.setTime(n2, time.getTime());
        } else {
            this.setNull(n2, 0);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n2, timestamp);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        if (timestamp != null) {
            this.setTime(n2, timestamp.getTime());
        } else {
            this.setNull(n2, 0);
        }
    }

    private final void setTime(int n2, long l2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(QDate.formatLocal((long)l2, (String)"'%Y-%m-%d %H:%M:%S'"));
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        TempBuffer tempBuffer;
        TempBuffer tempBuffer2 = tempBuffer = TempBuffer.allocate();
        if (this.values[n2 - 1] instanceof TempBuffer) {
            TempBuffer.freeAll((TempBuffer)((TempBuffer)this.values[n2]));
        }
        this.values[n2 - 1] = tempBuffer;
        byte[] byArray = tempBuffer.getBuffer();
        int n4 = 0;
        byArray[n4++] = 39;
        try {
            int n5;
            while ((n5 = inputStream.read()) >= 0) {
                if (n4 + 3 >= byArray.length) {
                    tempBuffer2.setLength(n4);
                    TempBuffer tempBuffer3 = TempBuffer.allocate();
                    tempBuffer2.setNext(tempBuffer3);
                    tempBuffer2 = tempBuffer3;
                    byArray = tempBuffer3.getBuffer();
                    n4 = 0;
                }
                if (n5 == 39) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 39;
                    continue;
                }
                if (n5 == 34) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 34;
                    continue;
                }
                if (n5 == 92) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 92;
                    continue;
                }
                if (n5 == 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 48;
                    continue;
                }
                byArray[n4++] = (byte)n5;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
        byArray[n4++] = 39;
        tempBuffer2.setLength(n4);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        TempBuffer tempBuffer;
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        TempBuffer tempBuffer2 = tempBuffer = TempBuffer.allocate();
        if (this.values[n2 - 1] instanceof TempBuffer) {
            TempBuffer.freeAll((TempBuffer)((TempBuffer)this.values[n2]));
        }
        this.values[n2 - 1] = tempBuffer;
        byte[] byArray = tempBuffer.getBuffer();
        int n4 = 0;
        byArray[n4++] = 39;
        try {
            int n5;
            while ((n5 = reader.read()) >= 0) {
                if (n4 + 3 >= byArray.length) {
                    tempBuffer2.setLength(n4);
                    TempBuffer tempBuffer3 = TempBuffer.allocate();
                    tempBuffer2.setNext(tempBuffer3);
                    tempBuffer2 = tempBuffer3;
                    byArray = tempBuffer3.getBuffer();
                    n4 = 0;
                }
                if (n5 == 39) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 39;
                    continue;
                }
                if (n5 == 34) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 34;
                    continue;
                }
                if (n5 == 92) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 92;
                    continue;
                }
                if (n5 == 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = 48;
                    continue;
                }
                byArray[n4++] = (byte)n5;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
        byArray[n4++] = 39;
        tempBuffer2.setLength(n4);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(object);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n2);
        charBuffer.append(object);
    }

    public void setObject(int n2, Object object) throws SQLException {
        if (object instanceof String) {
            this.setString(n2, (String)object);
        } else if (object instanceof Time) {
            this.setTime(n2, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n2, (Timestamp)object);
        } else if (object instanceof Date) {
            this.setDate(n2, (Date)object);
        } else {
            CharBuffer charBuffer = this.getParameterBuffer(n2);
            charBuffer.append(object);
        }
    }

    public void setRef(int n2, Ref ref) throws SQLException {
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
    }

    public void setClob(int n2, Clob clob) throws SQLException {
    }

    public void setArray(int n2, Array array) throws SQLException {
    }

    private final CharBuffer getParameterBuffer(int n2) throws SQLException {
        this.parameters[n2 - 1].clear();
        this.values[n2 - 1] = null;
        return this.parameters[n2 - 1];
    }

    public void addBatch() throws SQLException {
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        if (this.wasResultSet) {
            return this.resultSet;
        }
        throw new SQLException("missing result set");
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        return this.updateCount;
    }

    public boolean execute() throws SQLException {
        this.cb.clear();
        int n2 = 0;
        while (n2 < this.parameters.length) {
            this.cb.append(this.staticChunks[n2]);
            if (this.values[n2] != null) {
                if (this.values[n2] instanceof TempBuffer) {
                    TempBuffer tempBuffer = (TempBuffer)this.values[n2];
                    while (tempBuffer != null) {
                        this.cb.append(tempBuffer.getBuffer(), 0, tempBuffer.getLength());
                        tempBuffer = tempBuffer.getNext();
                    }
                }
            } else if (this.parameters[n2].getLength() == 0) {
                this.cb.append("null");
            } else {
                this.cb.append(this.parameters[n2]);
            }
            ++n2;
        }
        this.cb.append(this.staticChunks[this.parameters.length]);
        this.clearParameters();
        return this.execute(this.cb);
    }

    public void close() {
        if (this.conn == null) {
            return;
        }
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Statement.freeResultSets.free((Object)this.resultSet);
        this.conn = null;
        this.dbConn = null;
    }

    public void setURL(int n2, URL uRL) {
        throw new UnsupportedOperationException();
    }

    public ParameterMetaData getParameterMetaData() {
        throw new UnsupportedOperationException();
    }

    PreparedStatement() {
    }
}

