/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.DatabaseConnection;
import com.caucho.jdbc.mysql.DatabaseMetaData;
import com.caucho.jdbc.mysql.PreparedStatement;
import com.caucho.jdbc.mysql.SQLExceptionWrapper;
import com.caucho.jdbc.mysql.Statement;
import com.caucho.util.FreeList;
import com.caucho.vfs.ByteToChar;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Map;
import java.util.Properties;

class Connection
implements java.sql.Connection {
    private static FreeList freeStatements = new FreeList(64);
    private Statement[] statements = new Statement[16];
    private boolean isReadOnly = false;
    private String encoding;
    private DatabaseConnection dbConn;
    private ByteToChar byteToChar;

    static Connection create(String string, Properties properties) throws SQLException {
        String string2;
        int n2 = string.indexOf("://");
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf(47, n2 += 3);
        if (n3 < 0) {
            return null;
        }
        int n4 = 3306;
        int n5 = string.indexOf(58, n2);
        if (n5 > 0 && n5 < n3) {
            string2 = string.substring(n2, n5);
            n4 = Integer.parseInt(string.substring(n5 + 1, n3));
        } else {
            string2 = string.substring(n2, n3);
        }
        String string3 = string.substring(n3 + 1);
        String string4 = null;
        String string5 = null;
        if (properties != null) {
            string4 = properties.getProperty("user");
            string5 = properties.getProperty("password");
        }
        try {
            DatabaseConnection databaseConnection = new DatabaseConnection(string2, n4, string4, string5);
            databaseConnection.setDatabase(string3);
            return new Connection(databaseConnection, properties);
        }
        catch (IOException iOException) {
            if (string4 != null && !"".equals(string4)) {
                throw new SQLExceptionWrapper("Can't connect to " + string2 + ":" + n4 + " for user " + string4 + ". " + String.valueOf(iOException));
            }
            throw new SQLExceptionWrapper("Can't connect to " + string2 + ":" + n4 + ". " + String.valueOf(iOException));
        }
    }

    String getVersion() throws SQLException {
        if (this.dbConn.isClosed()) {
            throw new SQLException("can't getVersion() after close");
        }
        return this.dbConn.getVersion();
    }

    String getEncoding() {
        return this.encoding;
    }

    ByteToChar getByteToChar() {
        return this.byteToChar;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.dbConn;
    }

    public void clearWarnings() {
    }

    public void close() throws SQLException {
        try {
            int n2 = this.statements.length - 1;
            while (n2 >= 0) {
                Statement statement = this.statements[n2];
                this.statements[n2] = null;
                if (statement != null) {
                    statement.close();
                }
                --n2;
            }
        }
        finally {
            Object var2_3 = null;
            this.dbConn.close();
        }
    }

    void free(Statement statement) {
        int n2 = this.statements.length - 1;
        while (n2 >= 0) {
            if (this.statements[n2] == statement) {
                this.statements[n2] = null;
            }
            --n2;
        }
        freeStatements.free((Object)statement);
    }

    public void commit() throws SQLException {
        try {
            this.dbConn.commit();
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
    }

    public void rollback() throws SQLException {
        try {
            this.dbConn.rollback();
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.dbConn.rollback();
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return null;
    }

    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    public int getHoldability() throws SQLException {
        return 0;
    }

    public void setHoldability(int n2) throws SQLException {
    }

    public java.sql.Statement createStatement() throws SQLException {
        if (this.dbConn.isClosed()) {
            throw new SQLException("connection closed");
        }
        Statement statement = (Statement)freeStatements.allocate();
        if (statement == null) {
            statement = new Statement();
        }
        statement.init(this);
        int n2 = this.statements.length - 1;
        while (n2 >= 0) {
            if (this.statements[n2] == null) {
                this.statements[n2] = statement;
                break;
            }
            --n2;
        }
        return statement;
    }

    public java.sql.Statement createStatement(int n2, int n3) throws SQLException {
        return this.createStatement();
    }

    public java.sql.Statement createStatement(int n2, int n3, int n4) throws SQLException {
        return this.createStatement();
    }

    public boolean getAutoCommit() {
        return this.dbConn.getAutoCommit();
    }

    public void setAutoCommit(boolean bl) {
        this.dbConn.setAutoCommit(bl);
    }

    public String getCatalog() {
        return this.dbConn.getDatabase();
    }

    public void setCatalog(String string) throws SQLException {
        this.dbConn.setDatabase(string);
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        return new DatabaseMetaData(this);
    }

    public int getTransactionIsolation() {
        return 0;
    }

    public void setTransactionIsolation(int n2) {
    }

    public Map getTypeMap() {
        return null;
    }

    public void setTypeMap(Map map) {
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public boolean isClosed() {
        return this.dbConn.isClosed();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public String nativeSQL(String string) {
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.dbConn.isClosed()) {
            throw new SQLException("can't prepareCall() after close");
        }
        throw new UnsupportedOperationException("prepareCall not supported");
    }

    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        return this.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLException {
        return this.prepareCall(string);
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.dbConn.isClosed()) {
            throw new SQLException("can't prepareStatement() after close");
        }
        return PreparedStatement.create(this, string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        return this.prepareStatement(string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.prepareStatement(string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.prepareStatement(string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n2) throws SQLException {
        return this.prepareStatement(string);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        return this.prepareStatement(string);
    }

    private Connection(DatabaseConnection databaseConnection, Properties properties) throws IOException, SQLException {
        this.dbConn = databaseConnection;
        this.encoding = properties.getProperty("encoding");
        try {
            this.byteToChar = ByteToChar.create();
            this.byteToChar.setEncoding(this.encoding);
        }
        catch (Exception exception) {
            throw new SQLExceptionWrapper(exception);
        }
    }
}

