/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.AbstractColumn;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;

class Column
extends AbstractColumn {
    static final int TYPE_DECIMAL = 0;
    static final int TYPE_TINY = 1;
    static final int TYPE_SHORT = 2;
    static final int TYPE_LONG = 3;
    static final int TYPE_FLOAT = 4;
    static final int TYPE_DOUBLE = 5;
    static final int TYPE_NULL = 6;
    static final int TYPE_TIMESTAMP = 7;
    static final int TYPE_LONGLONG = 8;
    static final int TYPE_INT24 = 9;
    static final int TYPE_DATE = 10;
    static final int TYPE_TIME = 11;
    static final int TYPE_DATETIME = 12;
    static final int TYPE_YEAR = 13;
    static final int TYPE_NEWDATE = 14;
    static final int TYPE_ENUM = 247;
    static final int TYPE_SET = 248;
    static final int TYPE_TINY_BLOB = 249;
    static final int TYPE_MEDIUM_BLOB = 250;
    static final int TYPE_LONG_BLOB = 251;
    static final int TYPE_BLOB = 252;
    static final int TYPE_VAR_STRING = 253;
    static final int TYPE_STRING = 254;
    static final int FLAG_NULL = 1;
    static final int FLAG_PRIMARY = 2;
    static final int FLAG_UNIQUE = 4;
    static final int FLAG_MULTIPLE = 8;
    static final int FLAG_BLOB = 16;
    static final int FLAG_SIGNED = 32;
    static final int FLAG_ZERO_FILL = 64;
    static final int FLAG_BINARY = 128;
    static final int FLAG_ENUM = 256;
    static final int FLAG_AUTO_INC = 512;
    static final int FLAG_TIMESTAMP = 1024;
    static final int FLAG_SET = 2048;
    CharBuffer table = new CharBuffer();
    CharBuffer name = new CharBuffer();
    int length;
    int type;
    int flags;
    int decimals;

    void init(int n2, int n3, int n4, int n5) {
        this.length = n2;
        this.type = n3;
        this.flags = n4;
        this.decimals = n5;
    }

    public String getColumnName() {
        return this.name.toString();
    }

    public int getPrecision() {
        switch (this.type) {
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: 
            case 9: {
                return 10;
            }
            case 7: 
            case 8: {
                return 20;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 20;
            }
        }
        return this.length;
    }

    public int getScale() {
        switch (this.type) {
            case 4: {
                return 16;
            }
        }
        return 0;
    }

    public int isNullable() throws SQLException {
        if ((this.flags & 1) == 0) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned() throws SQLException {
        return (this.flags & 0x20) == 0;
    }

    public int getColumnType() {
        switch (this.type) {
            case 0: {
                return 3;
            }
            case 1: {
                return -6;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 93;
            }
            case 8: {
                return -5;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 12: {
                return 93;
            }
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                return -3;
            }
            case 253: 
            case 254: {
                return 12;
            }
        }
        return 12;
    }

    public String getColumnTypeName() {
        switch (this.type) {
            case 6: {
                return "NULL";
            }
            case 1: {
                return "TINYINT";
            }
            case 2: {
                return "SMALLINT";
            }
            case 3: 
            case 9: {
                return "INT";
            }
            case 8: {
                return "BIGINT";
            }
            case 4: {
                return "FLOAT";
            }
            case 5: {
                return "DOUBLE";
            }
            case 253: 
            case 254: {
                return "VARCHAR";
            }
        }
        return "VARCHAR";
    }

    Column() {
    }
}

