/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSGenericLaunchEntry;
import FirstSteps.FSLaunchEntry;
import FirstSteps.FSSQLDialog;
import FirstSteps.FSStringPool;
import FirstSteps.FSUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;

public class FSWebBrowserLaunchEntry
extends FSGenericLaunchEntry {
    private String mAnchor = new String("");
    private String mRelativeDir = new String("");
    private String mPreferredLangDir = new String("");
    private String mDefaultLangDir = new String("");
    private String mFilename = new String("");
    private String mDB2Path = new String("");

    public FSWebBrowserLaunchEntry(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, FSLaunchEntry.LIGHT_BACKGROUND_COLOR);
    }

    public FSWebBrowserLaunchEntry(String string, String string2, String string3, String string4, Color color) {
        super(string, string2, string3, color);
        this.setCommand(string4);
        this.setAvailable(true);
    }

    public FSWebBrowserLaunchEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this(string, string2, string3, string4, string5, string6, string7, FSLaunchEntry.LIGHT_BACKGROUND_COLOR);
    }

    public FSWebBrowserLaunchEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7, Color color) {
        super(string, string2, string3, color);
        this.mRelativeDir = string4;
        this.mPreferredLangDir = string5;
        this.mDefaultLangDir = string6;
        this.mFilename = string7;
        boolean bl = this.setupCommandToRun(this.mRelativeDir, this.mPreferredLangDir, this.mDefaultLangDir, this.mFilename);
        this.setAvailable(bl);
        if (!bl) {
            this.setDescriptionText(new String(FSStringPool.get(95)));
            this.setCursors(Cursor.getDefaultCursor());
        }
    }

    public FSWebBrowserLaunchEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Color color) {
        this(string, string2, string3, string4, string5, string6, string7, color);
        this.mAnchor = string8;
    }

    public boolean setupCommandToRun(String string, String string2, String string3, String string4) {
        boolean bl;
        String string5;
        if (this.mDB2Path.equals(new String(""))) {
            this.mDB2Path = FSUtilities.GetDB2Path();
        }
        if (string != null) {
            string5 = this.mDB2Path + File.separator + string + File.separator + string2 + File.separator + string4;
            bl = new File(string5).exists();
            if (!bl) {
                string5 = this.mDB2Path + File.separator + string + File.separator + string3 + File.separator + string4;
                bl = new File(string5).exists();
            }
        } else {
            string5 = string4;
            bl = new File(string5).exists();
        }
        if (bl) {
            this.setCommand(string5);
        }
        return bl;
    }

    public void execute() {
        if (this.isAvailable()) {
            this.setNotClickable();
            try {
                FSUtilities.openBrowser(this.getCommand(), this.mAnchor);
            }
            catch (IOException iOException) {
                new FSSQLDialog(null, iOException.getMessage());
            }
            this.setClickable();
        }
    }

    public boolean isAvailable() {
        if (this.available) {
            return true;
        }
        return this.setupCommandToRun(this.mRelativeDir, this.mPreferredLangDir, this.mDefaultLangDir, this.mFilename);
    }
}

