/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSStringPool;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class FSUtilities {
    public static final int FILE_NOT_FOUND = 1;
    public static final int BROWSER_NOT_FOUND = 2;
    public static final int UNABLE_TO_LAUNCH_BROWSER = 3;
    public static final String BACKGROUND_IMAGE = "FirstSteps/images/fsback.gif";
    public static final String BRANDED_BANNER_IMAGE = "FirstSteps/images/lp_frs_branded_banner.gif";
    public static final String GEARS1_IMAGE = "com/ibm/db2/tools/common/images/cp40g1.gif";
    public static final String GEARS2_IMAGE = "com/ibm/db2/tools/common/images/cp40g2.gif";
    public static final String GEARS3_IMAGE = "com/ibm/db2/tools/common/images/cp40g3.gif";
    public static final String GEARS4_IMAGE = "com/ibm/db2/tools/common/images/cp40g4.gif";
    public static final String COMPLETE_IMAGE = "FirstSteps/images/cmplt.gif";
    public static final String NOT_COMPLETE_IMAGE = "FirstSteps/images/ntcmplt.gif";
    public static final String IN_PROGRESS_IMAGE = "FirstSteps/images/inprgs.gif";
    public static final String SMALL_ICON_IMAGE = "FirstSteps/images/dbfrstp16.gif";
    public static final String LARGE_ICON_IMAGE = "FirstSteps/images/dbfrstp32.gif";
    public static final String PRODUCT_UPDATE_EXE_PATH = "cfg\\install\\db2updateutil.exe";
    public static final String PRODUCT_UPDATE_CHECK_OPTION = "-ismes";
    public static final String DEFAULT_LOCALE = "en_US";
    public static final String BIN_DIR = "bin";
    public static final String[] serverLVLs = new String[]{"db2ese.lvl", "db2pe.lvl", "db2wse.lvl", "db2wse2.lvl", "db2exp.lvl", "db2se.lvl"};
    public static final String[] connectLVLs = new String[]{"db2conee.lvl", "db2conpe.lvl"};

    public static Image getImage(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (null != image) {
            return image;
        }
        Object[] objectArray = new String[]{string};
        String string2 = MessageFormat.format(FSStringPool.get(118), objectArray);
        JOptionPane.showMessageDialog(null, string2, FSStringPool.get(113), 0);
        return null;
    }

    public static int DropDatabase(String string) {
        int n2;
        CommonTrace commonTrace = CommonTrace.create("FirstSteps.FSUtilities", "DropDatabase");
        try {
            n2 = FSUtilities.DropDatabaseNative(string);
        }
        catch (Error error) {
            CommonTrace.write(commonTrace, "error:" + error);
            n2 = -1;
        }
        CommonTrace.exit(commonTrace, n2);
        return n2;
    }

    public static boolean IsFSAutoStarted() {
        boolean bl;
        CommonTrace commonTrace = CommonTrace.create("FirstSteps.FSUtilities", "IsFSAutoStarted");
        try {
            bl = FSUtilities.IsFSAutoStartedNative();
        }
        catch (Error error) {
            CommonTrace.write(commonTrace, "error:" + error);
            bl = false;
        }
        CommonTrace.exit(commonTrace, bl);
        return bl;
    }

    public static int SetFSAutoStart(boolean bl) {
        int n2;
        CommonTrace commonTrace = CommonTrace.create("FirstSteps.FSUtilities", "SetFSAutoStart");
        try {
            n2 = FSUtilities.SetFSAutoStartNative(bl);
        }
        catch (Error error) {
            CommonTrace.write(commonTrace, "error:" + error);
            n2 = -1;
        }
        CommonTrace.exit(commonTrace, n2);
        return n2;
    }

    public static String GetDB2Path() {
        String string;
        CommonTrace commonTrace = CommonTrace.create("FirstSteps.FSUtilities", "GetDB2Path");
        try {
            string = FSUtilities.GetDB2PathNative();
        }
        catch (Error error) {
            CommonTrace.write(commonTrace, "error:" + error);
            string = new String("");
        }
        CommonTrace.exit(commonTrace, string);
        return string;
    }

    public static boolean DoesDatabaseExist(String string) {
        boolean bl;
        CommonTrace commonTrace = CommonTrace.create("FirstSteps.FSUtilities", "DoesDatabaseExist");
        try {
            bl = FSUtilities.DoesDatabaseExistNative(string);
        }
        catch (Error error) {
            CommonTrace.write(commonTrace, "error:" + error);
            bl = false;
        }
        CommonTrace.exit(commonTrace, bl);
        return bl;
    }

    public static boolean IsClientOnly() {
        CommonTrace commonTrace = CommonTrace.create("FirstSteps.FSUtilities", "IsClientOnly");
        String string = FSUtilities.GetDB2Path() + File.separator + "cfg" + File.separator;
        int n2 = 0;
        while (n2 < serverLVLs.length) {
            File file = new File(string + serverLVLs[n2]);
            if (file.exists()) {
                CommonTrace.exit(commonTrace, 0);
                return false;
            }
            ++n2;
        }
        CommonTrace.exit(commonTrace, 1);
        return true;
    }

    public static native int DropDatabaseNative(String var0);

    public static native boolean IsFSAutoStartedNative();

    public static native int SetFSAutoStartNative(boolean var0);

    public static native String GetDB2PathNative();

    public static native boolean DoesDatabaseExistNative(String var0);

    public static boolean isUnix() {
        String string = System.getProperty("os.name").toUpperCase();
        return string.equals("AIX") || string.equals("UNIX") || string.equals("SOLARIS") || string.equals("SUNOS") || string.equals("HP-UX") || string.equals("LINUX") || string.equals("IRIX") || string.equals("DYNIX");
    }

    public static boolean isAIX() {
        String string = System.getProperty("os.name").toUpperCase();
        return string.equals("AIX");
    }

    public static boolean isSUN() {
        String string = System.getProperty("os.name").toUpperCase();
        return string.equals("SOLARIS") || string.equals("SUNOS");
    }

    public static boolean isHP() {
        String string = System.getProperty("os.name").toUpperCase();
        return string.equals("HP-UX");
    }

    public static boolean isConnectOnly() {
        String string = FSUtilities.GetDB2Path() + File.separator + "cfg" + File.separator;
        int n2 = 0;
        while (n2 < serverLVLs.length) {
            File file = new File(string + serverLVLs[n2]);
            if (file.exists()) {
                return false;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < connectLVLs.length) {
            File file = new File(string + connectLVLs[n3]);
            if (file.exists()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean isOS2() {
        String string = System.getProperty("os.name").toUpperCase();
        return string.equals("OS/2");
    }

    public static boolean isWin32() {
        String string = System.getProperty("os.name").toUpperCase();
        return string.startsWith("WINDOW");
    }

    public static boolean isClientOnly() {
        return true;
    }

    public static int openBrowser(String string, String string2) throws IOException {
        Object object;
        String string3 = System.getProperty("os.name").toUpperCase();
        String string4 = System.getProperty("file.separator");
        String string5 = null;
        if (!string.toLowerCase().startsWith("http:")) {
            object = new File(string);
            String string6 = ((File)object).getAbsolutePath();
            string6 = string6.replace('\\', string4.charAt(0));
            string6 = string6.replace('/', string4.charAt(0));
            string5 = string6 + string2;
            if (!((File)object).exists()) {
                Object[] objectArray = new String[]{((File)object).getAbsolutePath()};
                String string7 = MessageFormat.format(FSStringPool.get(112), objectArray);
                throw new FileNotFoundException(string7);
            }
        } else {
            string5 = string + string2;
        }
        if (FSUtilities.isUnix()) {
            object = null;
            try {
                object = Runtime.getRuntime().exec("netscape " + string5);
            }
            catch (IOException iOException) {
                try {
                    object = Runtime.getRuntime().exec("konqueror " + string5);
                }
                catch (IOException iOException2) {
                    throw new IOException(FSStringPool.get(109));
                }
            }
        } else if (string3.startsWith("WINDOWS")) {
            FSUtilities.executeCommand("rundll32 url.dll,FileProtocolHandler " + string5);
        } else if (string3.equals("OS/2")) {
            FSUtilities.executeCommand("netscape " + string5);
        } else {
            throw new IOException(FSStringPool.get(110));
        }
        return 0;
    }

    private static Process executeCommand(String string) throws IOException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            throw new IOException(FSStringPool.get(109));
        }
        return process;
    }

    public static boolean isDoubleByteLanguage() {
        String string = AssistManager.getPreferredLanguage().getCountry();
        return string.equals("TW") || string.equals("CN") || string.equals("JP") || string.equals("KR");
    }

    static {
        try {
            String string = System.getProperty("user.home");
            if (string.startsWith("/")) {
                String string2 = System.getProperty("db2path") + "/lib/db2fstep";
                System.load(string2);
            } else {
                System.loadLibrary("db2fstep");
            }
        }
        catch (Error error) {
            Object[] objectArray = new String[]{"db2fstep", error.getMessage()};
            String string = MessageFormat.format(FSStringPool.get(93), objectArray);
            JOptionPane.showMessageDialog(null, string, FSStringPool.get(113), 0);
        }
    }
}

