/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSAnimatedProgressTimer;
import FirstSteps.FSDBCreator;
import FirstSteps.FSEtchedLine;
import FirstSteps.FSMainPanel;
import FirstSteps.FSProgress;
import FirstSteps.FSSampleDatabaseObject;
import FirstSteps.FSStringPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FSSamplesProgressDialog
extends JDialog
implements ActionListener,
Observer {
    private JButton OKButton = new JButton(FSStringPool.get(84));
    private JButton CancelButton = new JButton(FSStringPool.get(85));
    private FSAnimatedProgressTimer timer = new FSAnimatedProgressTimer();
    Vector samples;
    private Thread createThread;

    public FSSamplesProgressDialog(JFrame jFrame, boolean bl, Vector vector) {
        super((Frame)jFrame, bl);
        this.samples = vector;
        JPanel jPanel = new JPanel(new BorderLayout());
        FSProgress fSProgress = new FSProgress(vector);
        jPanel.add("Center", fSProgress);
        jPanel.add("South", this.timer);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(new Insets(10, 8, 5, 8)));
        jPanel2.add("Center", jPanel);
        jPanel2.add("South", this.makeBottomPanel(new JPanel()));
        this.getContentPane().add(jPanel2);
        FSDBCreator fSDBCreator = new FSDBCreator(this.getFrame(), vector);
        fSDBCreator.addObserver(fSProgress);
        fSDBCreator.addObserver(this);
        this.createThread = new Thread(fSDBCreator);
        this.createThread.start();
        this.setTitle(FSStringPool.get(74));
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        ((Component)this).setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FSMainPanel.enablePanelButtons(true);
            }
        });
        this.setResizable(true);
        this.show();
    }

    private JFrame getFrame() {
        Container container = this.getParent();
        do {
            if (!(container instanceof JFrame)) continue;
            return (JFrame)container;
        } while ((container = container.getParent()) != null);
        return null;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof FSDBCreator && object instanceof Integer && (Integer)object == -5) {
            this.OKButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.OKButton);
            this.OKButton.grabFocus();
            this.CancelButton.setEnabled(false);
            this.timer.suspend();
        }
    }

    public JPanel makeBottomPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        FSEtchedLine fSEtchedLine = new FSEtchedLine();
        fSEtchedLine.setEdges(15, 15);
        jPanel.add("North", fSEtchedLine);
        jPanel.add("Center", this.makeButtonPanel(new JPanel()));
        return jPanel;
    }

    public JPanel makeButtonPanel(JPanel jPanel) {
        jPanel.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        jPanel.setLayout(new FlowLayout(2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 6, 0));
        this.OKButton.addActionListener(this);
        this.OKButton.setEnabled(false);
        jPanel2.add(this.OKButton);
        this.CancelButton.addActionListener(this);
        jPanel2.add(this.CancelButton);
        this.CancelButton.grabFocus();
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.OKButton) {
            FSMainPanel.enablePanelButtons(true);
            this.dispose();
        } else if (actionEvent.getSource() == this.CancelButton) {
            this.timer.setReverse(true);
            this.CancelButton.setEnabled(false);
            int n2 = 0;
            while (n2 < this.samples.size()) {
                ((FSSampleDatabaseObject)this.samples.elementAt(n2)).stopCreate();
                ((FSSampleDatabaseObject)this.samples.elementAt(n2)).setSelected(false);
                ++n2;
            }
        }
    }
}

