/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSDescriptionPanel;
import FirstSteps.FSSampleDatabaseObject;
import FirstSteps.FSStringPool;
import com.ibm.db2.tools.common.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class FSSampleDatabasePanel
extends JPanel {
    private MultiLineLabel HeaderText;
    private FSDescriptionPanel dp = new FSDescriptionPanel();
    private Vector databases;
    private int focusIndex = 0;

    public FSSampleDatabasePanel(Vector vector) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.HeaderText = FSSampleDatabaseObject.isAvailable("bin", "dwcsmp.exe") && FSSampleDatabaseObject.isAvailable("bin", "db2sampl.exe") ? new MultiLineLabel(FSStringPool.get(71)) : new MultiLineLabel(FSStringPool.get(72));
        this.HeaderText.setFont(new Font("sansserif", 0, 12));
        this.HeaderText.setOpaque(false);
        this.databases = vector;
        this.add("North", this.HeaderText);
        this.add("Center", this.makeMainPanel());
        this.HeaderText.setForcedWidth(this.getPreferredSize().width - 16);
    }

    public void setupFocusToFirstComponent() {
        ((FSSampleDatabaseObject)this.databases.elementAt(this.focusIndex)).grabFocus();
    }

    private JPanel makeMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add("West", this.makeLabelsPanel());
        jPanel.add("Center", this.makeDescriptionPanel());
        return jPanel;
    }

    private JPanel makeDescriptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(new Insets(30, 5, 20, 10)));
        this.dp.setFont(new Font("sansserif", 0, 12));
        this.dp.setPreferredSize(new Dimension(300, 200));
        this.dp.setForcedWidth(280);
        this.dp.setBorder(new TitledBorder(new EtchedBorder(), FSStringPool.get(30)));
        jPanel.add("North", this.dp);
        return jPanel;
    }

    private JPanel makeLabelsPanel() {
        boolean bl = false;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(new Insets(60, 5, 5, 10)));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n2 = 0;
        while (n2 < this.databases.size()) {
            FSSampleDatabaseObject fSSampleDatabaseObject = (FSSampleDatabaseObject)this.databases.elementAt(n2);
            boolean bl2 = fSSampleDatabaseObject.isCreated();
            if (fSSampleDatabaseObject.isAvailable() || bl2) {
                this.focusIndex = n2;
                if (!bl) {
                    bl = true;
                }
                if (bl2) {
                    fSSampleDatabaseObject.setEnabled(false);
                    fSSampleDatabaseObject.setSelected(true);
                } else {
                    fSSampleDatabaseObject.setEnabled(true);
                    fSSampleDatabaseObject.setSelected(false);
                }
                jPanel.add(fSSampleDatabaseObject);
                fSSampleDatabaseObject.setDescriptionPanel(this.dp);
                jPanel.add(Box.createRigidArea(new Dimension(0, 3)));
            }
            ++n2;
        }
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    public Vector getDatabasesToCreate() {
        Vector<FSSampleDatabaseObject> vector = new Vector<FSSampleDatabaseObject>(3);
        int n2 = 0;
        while (n2 < this.databases.size()) {
            FSSampleDatabaseObject fSSampleDatabaseObject = (FSSampleDatabaseObject)this.databases.elementAt(n2);
            if (fSSampleDatabaseObject.isEnabled() && fSSampleDatabaseObject.isSelected()) {
                vector.addElement(fSSampleDatabaseObject);
            }
            ++n2;
        }
        return vector;
    }
}

