/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSCheckBox;
import FirstSteps.FSOutputMonitorStream;
import FirstSteps.FSProgressEntry;
import FirstSteps.FSStringPool;
import FirstSteps.FSUtilities;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.CUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FSSampleDatabaseObject
extends FSCheckBox
implements FSProgressEntry {
    private static Icon SuccessIcon;
    private static Icon FailureIcon;
    private static Icon ProgressIcon;
    private String dbName;
    protected String createCommand;
    private String detailsText = null;
    private String statusText = null;
    private String progressDisplayText = null;
    private String helpText = null;
    private Process createProcess = null;
    private int status = -6;
    private SampleObservable observable = new SampleObservable();
    protected boolean available = false;
    private boolean interrupted = false;
    public static final String RELATIVE_DIR = "bin";
    public static final String WAREHOUSE_SAMPLE = "dwcsmp.exe";
    public static final String DB2UDB_SAMPLE = "db2sampl.exe";

    public FSSampleDatabaseObject(String string, String string2, String string3, String string4) {
        this(string, string2, string3, "", string4, "", "");
    }

    public FSSampleDatabaseObject(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string2, string3);
        int n2;
        this.progressDisplayText = string6;
        this.helpText = string7;
        try {
            SuccessIcon = new ImageIcon(FSUtilities.getImage("FirstSteps/images/cmplt.gif"));
            ProgressIcon = new ImageIcon(FSUtilities.getImage("FirstSteps/images/inprgs.gif"));
            FailureIcon = new ImageIcon(FSUtilities.getImage("FirstSteps/images/ntcmplt.gif"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.detailsText = new String("");
        this.statusText = new String("");
        this.dbName = string;
        this.createCommand = FSUtilities.GetDB2Path() + File.separator + string4 + File.separator + string5;
        if (FSUtilities.isUnix() && (n2 = this.createCommand.lastIndexOf(".")) > 0) {
            this.createCommand = this.createCommand.substring(0, n2);
        }
        if (this.isCreated()) {
            this.setSelected(true);
            this.setEnabled(false);
        }
    }

    public String getHelpText() {
        return this.helpText;
    }

    public boolean isCreated() {
        try {
            boolean bl = FSUtilities.DoesDatabaseExist(this.dbName);
            return bl;
        }
        catch (Error error) {
            System.out.println("An error occurred");
            return false;
        }
    }

    public boolean isAvailable() {
        if (this.available) {
            return true;
        }
        return new File(this.createCommand).exists();
    }

    public static boolean isAvailable(String string, String string2) {
        int n2;
        String string3 = new String(FSUtilities.GetDB2Path() + File.separator + string + File.separator + string2);
        if (FSUtilities.isUnix() && (n2 = string3.lastIndexOf(".")) > 0) {
            string3 = string3.substring(0, n2);
        }
        return new File(string3).exists();
    }

    public int create() {
        FSOutputMonitorStream fSOutputMonitorStream;
        FSOutputMonitorStream fSOutputMonitorStream2;
        CommonTrace commonTrace = CommonTrace.create(this, "create");
        this.interrupted = false;
        this.status = -1;
        this.observable.externalSetChanged();
        this.observable.notifyObservers(this);
        try {
            this.createProcess = Runtime.getRuntime().exec(this.createCommand);
        }
        catch (IOException iOException) {
            this.status = -3;
            this.setSelected(false);
            this.setEnabled(true);
            this.detailsText = iOException.getMessage();
            CommonTrace.write(commonTrace, this.detailsText);
            CommonTrace.write(commonTrace, 10);
            this.observable.externalSetChanged();
            this.observable.notifyObservers(this);
            return -3;
        }
        Integer n2 = new Integer(CUtil.sqloGetPreferredOEMCP());
        if (!FSUtilities.isUnix()) {
            try {
                fSOutputMonitorStream2 = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.createProcess.getInputStream(), n2.toString())));
                fSOutputMonitorStream = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.createProcess.getErrorStream(), n2.toString())));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                CommonTrace.write(commonTrace, "UnsupportedEncodingException " + n2.toString() + " " + unsupportedEncodingException);
                fSOutputMonitorStream2 = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.createProcess.getInputStream())));
                fSOutputMonitorStream = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.createProcess.getErrorStream())));
            }
        } else {
            fSOutputMonitorStream2 = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.createProcess.getInputStream())));
            fSOutputMonitorStream = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.createProcess.getErrorStream())));
        }
        fSOutputMonitorStream2.start();
        fSOutputMonitorStream.start();
        try {
            this.createProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            CommonTrace.write(commonTrace, "Interrupted 20:" + interruptedException);
            this.interrupted = true;
        }
        if (this.interrupted) {
            this.status = -7;
            this.observable.externalSetChanged();
            this.observable.notifyObservers(this);
            int n3 = 0;
            while ((n3 = FSUtilities.DropDatabase(this.dbName)) == -1035) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            CommonTrace.write(commonTrace, "drop ended with =" + n3);
            this.status = -4;
        } else {
            this.detailsText = fSOutputMonitorStream2.getOutputText().trim();
            int n4 = this.detailsText.indexOf("SQL3274");
            int n5 = this.createProcess.exitValue();
            CommonTrace.write(commonTrace, "exitValue =" + n5);
            this.status = n5 == 0 ? (this.detailsText.length() > 0 ? -8 : -2) : (n5 == 3274 || n4 != -1 ? -8 : -3);
        }
        this.observable.externalSetChanged();
        this.observable.notifyObservers(this);
        if (this.isCreated()) {
            CommonTrace.write(commonTrace, "database was created");
            this.setSelected(true);
            this.setEnabled(false);
        } else {
            CommonTrace.write(commonTrace, "database not created");
            this.setSelected(false);
            this.setEnabled(true);
        }
        CommonTrace.exit(commonTrace, this.status);
        return this.status;
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observable.deleteObserver(observer);
    }

    public void stopCreate() {
        if (this.createProcess != null) {
            this.interrupted = true;
            this.createProcess.destroy();
        }
    }

    public void waitForCreate() throws InterruptedException {
        if (this.createProcess != null) {
            this.createProcess.waitFor();
        }
    }

    public Icon getCurrentIcon() {
        if (this.status == -1 || this.status == -7) {
            return ProgressIcon;
        }
        if (this.status == -2) {
            return SuccessIcon;
        }
        if (this.status == -3 || this.status == -4) {
            return FailureIcon;
        }
        if (this.status == -8) {
            return SuccessIcon;
        }
        return null;
    }

    public String getStatusText() {
        if (this.status == -1) {
            return FSStringPool.get(81);
        }
        if (this.status == -2) {
            return FSStringPool.get(79);
        }
        if (this.status == -8) {
            return FSStringPool.get(79);
        }
        if (this.status == -3) {
            return FSStringPool.get(80);
        }
        if (this.status == -4) {
            return FSStringPool.get(83);
        }
        if (this.status == -7) {
            return FSStringPool.get(82);
        }
        if (this.status == -6) {
            return "";
        }
        return "";
    }

    public String getLargestStatusText() {
        String string = new String();
        String[] stringArray = new String[]{FSStringPool.get(81), FSStringPool.get(79), FSStringPool.get(80), FSStringPool.get(83)};
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].length() > string.length()) {
                string = stringArray[n2];
            }
            ++n2;
        }
        return string;
    }

    public String getDetailsText() {
        return this.detailsText;
    }

    public String getProgressDisplayText() {
        return this.progressDisplayText;
    }

    public class SampleObservable
    extends Observable {
        public void externalSetChanged() {
            this.setChanged();
        }
    }
}

