/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSEtchedLine;
import FirstSteps.FSStringPool;
import FirstSteps.FSUserPasswordReceiver;
import com.ibm.db2.tools.common.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class FSSampleDatabaseLogin
extends JDialog
implements ActionListener {
    private JTextField useridField = new JTextField(20);
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    private static final JLabel useridLabel = new JLabel(FSStringPool.get(97));
    private JPasswordField passwordField = new JPasswordField(20);
    private static final JLabel passwordLabel = new JLabel(FSStringPool.get(98));
    private static final MultiLineLabel descriptionText = new MultiLineLabel(FSStringPool.get(96));
    private JButton OKButton = new JButton(FSStringPool.get(84));
    private JButton CancelButton = new JButton(FSStringPool.get(85));
    private FSUserPasswordReceiver receiver = null;

    public FSSampleDatabaseLogin(JFrame jFrame, FSUserPasswordReceiver fSUserPasswordReceiver, Component component) {
        super((Frame)jFrame, true);
        this.setTitle(FSStringPool.get(100));
        descriptionText.setOpaque(false);
        descriptionText.setFont(new Font("sansserif", 0, 12));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", descriptionText);
        jPanel.add("Center", this.makeEntriesPanel(new JPanel()));
        jPanel.add("South", this.makeBottomPanel(new JPanel()));
        this.getContentPane().add(jPanel);
        this.OKButton.setActionCommand(OK);
        this.CancelButton.setActionCommand(CANCEL);
        this.receiver = fSUserPasswordReceiver;
        this.OKButton.addActionListener(this);
        this.CancelButton.addActionListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.useridField.getKeymap().removeKeyStrokeBinding(keyStroke);
        this.passwordField.getKeymap().removeKeyStrokeBinding(keyStroke);
        this.getRootPane().setDefaultButton(this.OKButton);
        descriptionText.setForcedWidth(this.getPreferredSize().width - 16);
        this.pack();
        try {
            Point point = this.getJDialog(component).getLocation();
            Dimension dimension = this.getJDialog(component).getSize();
            Dimension dimension2 = this.getSize();
            point.translate((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            ((Component)this).setLocation(point);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setResizable(false);
        this.useridField.grabFocus();
    }

    JDialog getJDialog(Component component) {
        Container container = component.getParent();
        do {
            if (!(container instanceof JDialog)) continue;
            return (JDialog)container;
        } while ((container = container.getParent()) != null);
        return null;
    }

    public String getUsername() {
        return this.useridField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.receiver != null) {
            if (string.equals(OK)) {
                this.dispose();
                this.receiver.setUserPass(this.getUsername(), this.getPassword());
            } else if (string.equals(CANCEL)) {
                this.dispose();
                this.receiver.setUserPass(null, null);
            }
        }
    }

    private JPanel makeEntriesPanel(JPanel jPanel) {
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(new Insets(8, 4, 8, 4)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.add(useridLabel);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(passwordLabel);
        jPanel3.add(this.useridField);
        this.useridField.setMaximumSize(new Dimension(this.useridField.getMaximumSize().width, this.useridField.getPreferredSize().height));
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(this.passwordField);
        this.passwordField.setMaximumSize(new Dimension(this.passwordField.getMaximumSize().width, this.passwordField.getPreferredSize().height));
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalStrut(12));
        jPanel.add(jPanel3);
        jPanel.add(Box.createGlue());
        return jPanel;
    }

    private JPanel makeBottomPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        FSEtchedLine fSEtchedLine = new FSEtchedLine();
        fSEtchedLine.setEdges(0, 0);
        jPanel.add("North", fSEtchedLine);
        jPanel.add("South", this.makeButtonPanel(new JPanel()));
        return jPanel;
    }

    private JPanel makeButtonPanel(JPanel jPanel) {
        jPanel.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        jPanel.setLayout(new FlowLayout(2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 6, 0));
        jPanel2.add(this.OKButton);
        jPanel2.add(this.CancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }
}

