/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSCatalogueSampleDatabases;
import FirstSteps.FSCheckProductUpdates;
import FirstSteps.FSCreateSampleDatabase;
import FirstSteps.FSCreateYourOwnDatabase;
import FirstSteps.FSDescriptionPanel;
import FirstSteps.FSExit;
import FirstSteps.FSGenericLaunchEntry;
import FirstSteps.FSImagePanel;
import FirstSteps.FSLaunchEntry;
import FirstSteps.FSLine;
import FirstSteps.FSStringPool;
import FirstSteps.FSUtilities;
import FirstSteps.FSViewGettingStartedInformation;
import FirstSteps.FSWallpaper;
import FirstSteps.FSWorkWithDB2Urls;
import FirstSteps.FSWorkWithSampleDatabase;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

class FSMainPanel
extends JPanel
implements ActionListener {
    private FSDescriptionPanel descPanel;
    private final GridBagConstraints c = new GridBagConstraints();
    private JCheckBox rebootCB = null;
    public static final Color MENU_BACKGROUND = new Color(102, 102, 136);
    public static final Color SEPERATOR_LINE = new Color(255, 255, 255);
    private static final Color BUTTON_COLOUR = new Color(196, 211, 196);
    private static final Color BOTTOM_PANEL_COLOUR = new Color(221, 221, 221);
    private static final int DEFAULT_HEIGHT = 400;
    private String welcomeString;
    private FSWallpaper wallPaper;
    private String country = null;
    private static FSLaunchEntry createSampleDatabase = null;
    private static FSLaunchEntry workWithSampleDatabase = null;
    private static FSLaunchEntry exit_ = null;
    private static FSLaunchEntry catalogueSampleDatabase = null;
    private static FSLaunchEntry createYourOwnDatabase = null;
    private Locale locale = AssistManager.getPreferredLanguage();
    private FSImagePanel upperPanel = null;
    FSLaunchEntry workWithDB2Urls = null;

    public FSMainPanel() {
        this.country = this.locale.getCountry();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.add("North", this.makeUpperPanel());
        Image image = FSUtilities.getImage("FirstSteps/images/fsback.gif");
        this.wallPaper = new FSWallpaper(image);
        this.wallPaper.setLayout(new BorderLayout());
        this.wallPaper.add("Center", this.makeMainPanel());
        this.wallPaper.setOpaque(false);
        this.add("Center", this.wallPaper);
        this.add("South", this.makeBottomPanel());
    }

    private JPanel makeBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(BOTTOM_PANEL_COLOUR);
        jPanel.setBorder(new EmptyBorder(new Insets(0, 15, 0, 0)));
        jPanel.setPreferredSize(new Dimension(400, 30));
        return jPanel;
    }

    private JPanel makeUpperPanel() {
        JLabel jLabel = new JLabel();
        if (FSUtilities.isConnectOnly()) {
            this.welcomeString = FSStringPool.get(8);
            jLabel.setText(FSStringPool.get(91));
        } else {
            jLabel.setText(FSStringPool.get(90));
            this.welcomeString = FSUtilities.IsClientOnly() ? FSStringPool.get(7) : FSStringPool.get(6);
        }
        this.descPanel = new FSDescriptionPanel(this.welcomeString, FSStringPool.get(5));
        this.upperPanel = new FSImagePanel("FirstSteps/images/lp_frs_branded_banner.gif");
        this.upperPanel.setLayout(new BoxLayout(this.upperPanel, 1));
        jLabel.setOpaque(false);
        jLabel.setFont(new Font("Helvetica", 0, 18));
        jLabel.setVerticalAlignment(3);
        jLabel.setVerticalTextPosition(3);
        jLabel.setForeground(Color.black);
        this.upperPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 92;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 54, 0, 0);
        this.upperPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(FSStringPool.get(92));
        jLabel2.setOpaque(false);
        jLabel2.setFont(new Font("Helvetica", 0, 10));
        jLabel2.setVerticalTextPosition(3);
        jLabel2.setForeground(Color.black);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 6;
        this.upperPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(FSStringPool.get(0));
        jLabel3.setOpaque(false);
        if (this.country.equals("CZ")) {
            jLabel3.setFont(new Font("Helvetica", 1, 16));
        } else {
            jLabel3.setFont(new Font("Helvetica", 1, 22));
        }
        jLabel3.setVerticalTextPosition(3);
        jLabel3.setForeground(new Color(45, 136, 59));
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 15;
        this.upperPanel.add((Component)jLabel3, gridBagConstraints);
        this.upperPanel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                FSMainPanel.this.descPanel.updateDescription(FSMainPanel.this.welcomeString, FSStringPool.get(5));
                FSMainPanel.this.upperPanel.grabFocus();
            }
        });
        return this.upperPanel;
    }

    private JPanel makeMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        jPanel.add(this.makeLabelsPanel());
        jPanel.add(this.makeDescriptionPanel());
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel makeDescriptionPanel() {
        JPanel jPanel = new JPanel();
        this.descPanel.setBorder(new EmptyBorder(new Insets(25, 10, 10, 10)));
        this.descPanel.setPreferredSize(new Dimension(400, 400));
        this.descPanel.setForcedWidth(380);
        this.descPanel.setOpaque(false);
        this.descPanel.setForeground(Color.black);
        this.descPanel.setTitleFont(new Font("sansserif", 1, 20));
        this.descPanel.setBodyFont(new Font("sansserif", 1, 12));
        if (this.country.equals("TW") || this.country.equals("CN") || this.country.equals("JP") || this.country.equals("KR")) {
            this.descPanel.setTitleFont(new Font("sansserif", 0, 15));
            this.descPanel.setBodyFont(new Font("sansserif", 0, 13));
        }
        jPanel.setOpaque(false);
        jPanel.add(this.descPanel);
        return jPanel;
    }

    private JPanel makeLabelsPanel() {
        Serializable serializable;
        FSGenericLaunchEntry fSGenericLaunchEntry;
        boolean bl = false;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        int n2 = 195;
        Dimension dimension = null;
        int n3 = 0;
        int n4 = 1;
        jPanel2.setBackground(BUTTON_COLOUR);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.registerKeyboardAction(this, "DOWN", KeyStroke.getKeyStroke("DOWN"), 2);
        this.registerKeyboardAction(this, "UP", KeyStroke.getKeyStroke("UP"), 2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel.setOpaque(false);
        if (FSUtilities.IsClientOnly()) {
            catalogueSampleDatabase = new FSCatalogueSampleDatabases();
            if (catalogueSampleDatabase.isAvailable()) {
                catalogueSampleDatabase.setDescriptionPanel(this.descPanel);
                jPanel.add(catalogueSampleDatabase);
                jPanel.add(new FSLine(SEPERATOR_LINE));
                bl = true;
                dimension = catalogueSampleDatabase.getPreferredSize();
                n3 += dimension.height + n4;
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
            }
        } else {
            createSampleDatabase = new FSCreateSampleDatabase();
            if (createSampleDatabase.isAvailable()) {
                createSampleDatabase.setDescriptionPanel(this.descPanel);
                jPanel.add(createSampleDatabase);
                jPanel.add(new FSLine(SEPERATOR_LINE));
                bl = true;
                dimension = createSampleDatabase.getPreferredSize();
                n3 += dimension.height + n4;
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
            }
        }
        if (!FSUtilities.IsClientOnly() && !FSUtilities.isConnectOnly() && (createYourOwnDatabase = new FSCreateYourOwnDatabase()).isAvailable()) {
            createYourOwnDatabase.setDescriptionPanel(this.descPanel);
            jPanel.add(createYourOwnDatabase);
            jPanel.add(new FSLine(SEPERATOR_LINE));
            dimension = createYourOwnDatabase.getPreferredSize();
            n3 += dimension.height + n4;
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
        }
        if ((workWithSampleDatabase = new FSWorkWithSampleDatabase()).isAvailable()) {
            workWithSampleDatabase.setDescriptionPanel(this.descPanel);
            jPanel.add(workWithSampleDatabase);
            jPanel.add(new FSLine(SEPERATOR_LINE));
            dimension = workWithSampleDatabase.getPreferredSize();
            n3 += dimension.height + n4;
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
        }
        if (!FSUtilities.isUnix()) {
            fSGenericLaunchEntry = new FSCheckProductUpdates();
            fSGenericLaunchEntry.setDescriptionPanel(this.descPanel);
            jPanel.add(fSGenericLaunchEntry);
            jPanel.add(new FSLine(SEPERATOR_LINE));
            dimension = fSGenericLaunchEntry.getPreferredSize();
            n3 += dimension.height + n4;
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
        }
        fSGenericLaunchEntry = new FSViewGettingStartedInformation();
        fSGenericLaunchEntry.setDescriptionPanel(this.descPanel);
        jPanel.add(fSGenericLaunchEntry);
        jPanel.add(new FSLine(SEPERATOR_LINE));
        dimension = fSGenericLaunchEntry.getPreferredSize();
        n3 += dimension.height + n4;
        if (dimension.width > n2) {
            n2 = dimension.width;
        }
        this.workWithDB2Urls = new FSWorkWithDB2Urls();
        this.workWithDB2Urls.setDescriptionPanel(this.descPanel);
        jPanel.add(this.workWithDB2Urls);
        jPanel.add(new FSLine(SEPERATOR_LINE));
        dimension = this.workWithDB2Urls.getPreferredSize();
        n3 += dimension.height + n4;
        if (dimension.width > n2) {
            n2 = dimension.width;
        }
        this.workWithDB2Urls.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 39) {
                    FSMainPanel.this.descPanel.getDescriptionText().grabFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.descPanel.getDescriptionText().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 37) {
                    FSMainPanel.this.workWithDB2Urls.grabFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        exit_ = new FSExit();
        exit_.setDescriptionPanel(this.descPanel);
        exit_.setNextFocusableComponent(this.rebootCB);
        jPanel.add(exit_);
        jPanel.add(new FSLine(SEPERATOR_LINE));
        dimension = exit_.getPreferredSize();
        n3 += dimension.height + n4;
        if (dimension.width > n2) {
            n2 = dimension.width;
        }
        jPanel.setMaximumSize(new Dimension(n2, n3));
        jPanel.setPreferredSize(new Dimension(n2, n3));
        jPanel.setMinimumSize(new Dimension(n2, n3));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalGlue());
        if (n3 < 400) {
            serializable = new FSLine(SEPERATOR_LINE);
            serializable.setMaximumSize(new Dimension(serializable.getMaximumSize().width, 1));
            jPanel2.add((Component)serializable);
        }
        jPanel2.setMaximumSize(new Dimension(n2, jPanel2.getMaximumSize().height));
        jPanel2.setMinimumSize(new Dimension(n2, n3));
        serializable = this.wallPaper.getPreferredSize();
        if (n3 > ((Dimension)serializable).height) {
            this.wallPaper.setPreferredSize(new Dimension(((Dimension)serializable).width, n3 - 2));
        }
        return jPanel2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("DOWN")) {
            this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 9));
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke("DOWN"));
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke("UP"));
        } else if (actionEvent.getActionCommand().equals("UP")) {
            this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 1, 9));
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke("DOWN"));
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke("UP"));
        }
    }

    public static void enablePanelButtons(boolean bl) {
        if (bl) {
            if (createSampleDatabase != null) {
                createSampleDatabase.setClickable();
            }
            if (exit_ != null) {
                exit_.setClickable();
            }
        } else {
            if (createSampleDatabase != null) {
                createSampleDatabase.setNotClickable();
            }
            if (exit_ != null) {
                exit_.setNotClickable();
            }
        }
    }
}

