/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSDescriptionPanel;
import FirstSteps.FSFocusableJPanel;
import FirstSteps.FSNonFocusTextArea;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.MultiLineEvent;
import com.ibm.db2.tools.common.MultiLineListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public abstract class FSLaunchEntry
extends FSFocusableJPanel
implements MouseListener,
KeyListener,
FocusListener,
MultiLineListener {
    private String description = null;
    private String descriptionTitle = null;
    private FSDescriptionPanel descriptionPanel = null;
    protected FSNonFocusTextArea textArea;
    protected static Color DARK_BACKGROUND_COLOR = new Color(163, 185, 163);
    protected static Color LIGHT_BACKGROUND_COLOR = new Color(196, 211, 196);
    private Color bgColor;
    private boolean clickable = true;
    private boolean executeFlag = false;
    private static final int BUTTON_HEIGHT = 60;

    public FSLaunchEntry() {
        this(LIGHT_BACKGROUND_COLOR);
    }

    public FSLaunchEntry(Color color) {
        this(null, null, null, color);
    }

    public FSLaunchEntry(String string, String string2, String string3) {
        this(string, string2, string3, LIGHT_BACKGROUND_COLOR);
    }

    public FSLaunchEntry(String string, String string2, String string3, Color color) {
        this.textArea = string != null ? new FSNonFocusTextArea(string) : new FSNonFocusTextArea();
        this.textArea.setOpaque(false);
        this.textArea.setMaximumSize(new Dimension(this.textArea.getMaximumSize().width, this.textArea.getMinimumSize().height));
        this.textArea.setEditable(false);
        this.textArea.addMouseListener(this);
        this.textArea.addFocusListener(this);
        this.setBorder(new EmptyBorder(new Insets(0, 10, 0, 0)));
        this.setOpaque(true);
        this.setCursors(Cursor.getPredefinedCursor(12));
        this.bgColor = color;
        this.setBackground(color);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(this.textArea);
        this.add(Box.createVerticalGlue());
        this.description = string2 != null ? string2 : new String();
        this.descriptionTitle = string3 != null ? string3 : new String();
        this.setPreferredSize(new Dimension(this.getPreferredSize().width + 40, 60));
        this.setAlignmentX(0.0f);
    }

    public void setCursors(Cursor cursor) {
        this.textArea.setCursor(cursor);
        this.setCursor(cursor);
    }

    public boolean isAvailable() {
        return true;
    }

    public void setDescriptionText(String string) {
        this.description = string;
    }

    public void setDescriptionTitle(String string) {
        this.descriptionTitle = string;
    }

    public void setButtonText(String string) {
        this.textArea.setText(string);
        this.textArea.setMaximumSize(new Dimension(this.textArea.getMaximumSize().width, this.textArea.getMinimumSize().height));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width + 40, 60));
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.descriptionTitle;
    }

    public void setDescriptionPanel(FSDescriptionPanel fSDescriptionPanel) {
        this.descriptionPanel = fSDescriptionPanel;
        if (this.descriptionPanel != null) {
            fSDescriptionPanel.registerListener(this);
        }
    }

    public void setClickable() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "setClickable()");
        }
        this.clickable = true;
        this.setCursors(Cursor.getPredefinedCursor(12));
        this.setFocusTraversable(true);
        this.textArea.setForeground(Color.black);
        if (this.hasFocus()) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(this.bgColor);
        }
        this.textArea.setBackground(Color.white);
        if (this.descriptionPanel != null) {
            this.descriptionPanel.updateDescription(this.description, this.descriptionTitle);
        }
        this.repaint();
        CommonTrace.exit(commonTrace);
    }

    public void setNotClickable() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "setNotClickable()");
        }
        this.clickable = false;
        this.setCursors(Cursor.getDefaultCursor());
        this.setFocusTraversable(false);
        this.setBackground(this.bgColor);
        this.textArea.setForeground(Color.gray);
        this.repaint();
        CommonTrace.exit(commonTrace);
    }

    public abstract void execute();

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Object object;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "mouseEntered(MouseEvent e)", new Object[]{mouseEvent});
        }
        if (((object = mouseEvent.getSource()) == this.textArea || object == this) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.executeFlag = true;
        }
        if (this.clickable) {
            if (!this.hasFocus()) {
                this.grabFocus();
            } else {
                this.descriptionPanel.updateDescription(this.description, this.descriptionTitle);
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "mouseExited(MouseEvent e)", new Object[]{mouseEvent});
        }
        this.executeFlag = false;
        CommonTrace.exit(commonTrace);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "mousePressed(MouseEvent e)", new Object[]{mouseEvent});
        }
        this.executeFlag = true;
        CommonTrace.exit(commonTrace);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "mouseReleased(MouseEvent e)", new Object[]{mouseEvent});
        }
        if (this.executeFlag && this.clickable) {
            this.execute();
        }
        CommonTrace.exit(commonTrace);
    }

    public void focusGained(FocusEvent focusEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "focusGained(FocusEvent fe)", new Object[]{focusEvent});
        }
        if (this.clickable) {
            this.setBackground(Color.white);
            this.repaint();
            if (this.descriptionPanel != null) {
                this.descriptionPanel.updateDescription(this.description, this.descriptionTitle);
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public void focusLost(FocusEvent focusEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("first_steps", "FSLaunchEntry", this, "focusLost(FocusEvent fe)", new Object[]{focusEvent});
        }
        if (this.clickable) {
            this.setBackground(this.bgColor);
            this.repaint();
        }
        CommonTrace.exit(commonTrace);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2;
        if (this.clickable && ((n2 = keyEvent.getKeyCode()) == 10 || n2 == 32)) {
            this.textArea.setForeground(Color.black);
            this.execute();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void linkStateChanged(MultiLineEvent multiLineEvent) {
        if (multiLineEvent.getEventType() == 1000) {
            // empty if block
        }
    }
}

