/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSLaunchEntry;
import FirstSteps.FSOutputMonitorStream;
import FirstSteps.FSSQLDialog;
import FirstSteps.FSStringPool;
import FirstSteps.FSUtilities;
import com.ibm.db2.tools.common.GeneratedStringPool;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class FSGenericLaunchEntry
extends FSLaunchEntry
implements Observer {
    private String command = new String("");
    protected boolean available = false;
    private Process process = null;
    private String args = new String("");

    public FSGenericLaunchEntry(String string, String string2, String string3) {
        this(string, string2, string3, FSLaunchEntry.LIGHT_BACKGROUND_COLOR);
    }

    public FSGenericLaunchEntry(String string, String string2, String string3, Color color) {
        super(string, string2, string3, color);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
    }

    public FSGenericLaunchEntry(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this(string, string2, string3, string4, string5, bl, FSLaunchEntry.LIGHT_BACKGROUND_COLOR);
    }

    public FSGenericLaunchEntry(String string, String string2, String string3, String string4, String string5, boolean bl, Color color) {
        super(string, string2, string3, color);
        int n2;
        this.command = string4 != null ? FSUtilities.GetDB2Path() + File.separator + string4 + File.separator + string5 : string5;
        if (bl && FSUtilities.isUnix() && (n2 = this.command.lastIndexOf(".")) > 0) {
            this.command = this.command.substring(0, n2);
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
    }

    public boolean isAvailable() {
        if (this.available) {
            return true;
        }
        return new File(this.command).exists();
    }

    public void setAvailable(boolean bl) {
        this.available = bl;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public void notifyWhenDone(Observer observer) {
        WaitThread waitThread = new WaitThread(observer, this);
        new Thread(waitThread).start();
    }

    public void setArguments(String string) {
        this.args = " " + string;
    }

    protected Process execCommand() throws IOException {
        return Runtime.getRuntime().exec(this.command + this.args);
    }

    public void execute() {
        try {
            this.setNotClickable();
            this.process = this.execCommand();
            FSOutputMonitorStream fSOutputMonitorStream = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.process.getInputStream())));
            FSOutputMonitorStream fSOutputMonitorStream2 = new FSOutputMonitorStream(new BufferedReader(new InputStreamReader(this.process.getErrorStream())));
            fSOutputMonitorStream.start();
            fSOutputMonitorStream2.start();
            this.notifyWhenDone(this);
        }
        catch (IOException iOException) {
            Object[] objectArray = new String[]{this.command, iOException.getMessage()};
            new FSSQLDialog(null, MessageFormat.format(FSStringPool.get(108), objectArray));
            this.process = null;
            this.setClickable();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof FSLaunchEntry) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FSGenericLaunchEntry.this.setClickable();
                    }
                });
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{this.getClass().getName() + " tpoint 1", exception.getMessage()};
                new FSSQLDialog(null, GeneratedStringPool.insertTokens(FSStringPool.get(124), stringArray));
            }
        }
    }

    private class WaitThread
    extends Observable
    implements Runnable {
        Object parent;

        public WaitThread(Observer observer, Object object) {
            this.addObserver(observer);
            this.parent = object;
        }

        public void run() {
            this.setChanged();
            if (FSGenericLaunchEntry.this.process != null) {
                try {
                    FSGenericLaunchEntry.this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.notifyObservers(this.parent);
        }
    }
}

