/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSEtchedLine;
import FirstSteps.FSHelpDialog;
import FirstSteps.FSMainPanel;
import FirstSteps.FSSampleDatabaseObject;
import FirstSteps.FSSampleDatabasePanel;
import FirstSteps.FSSamplesProgressDialog;
import FirstSteps.FSStringPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FSCreateSampleDialog
extends JDialog
implements ActionListener,
KeyListener {
    private JButton OKButton = new JButton(FSStringPool.get(84));
    private JButton CancelButton = new JButton(FSStringPool.get(85));
    private JButton HelpButton = new JButton(FSStringPool.get(86));
    private FSSampleDatabasePanel sampleDatabasePanel;
    private JFrame frame;
    private Vector databases;

    public FSCreateSampleDialog(JFrame jFrame, String string, boolean bl, Vector vector) {
        super(jFrame, string, bl);
        this.frame = jFrame;
        this.databases = vector;
        this.getContentPane().setLayout(new BorderLayout());
        this.sampleDatabasePanel = new FSSampleDatabasePanel(vector);
        this.getContentPane().add("Center", this.sampleDatabasePanel);
        this.getContentPane().add("South", this.makeBottomPanel());
        this.OKButton.addActionListener(this);
        this.CancelButton.addActionListener(this);
        this.HelpButton.addActionListener(this);
        this.addKeyListener(this);
        this.pack();
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.sampleDatabasePanel.setupFocusToFirstComponent();
        Dimension dimension = this.getToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        ((Component)this).setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FSMainPanel.enablePanelButtons(true);
            }
        });
        ((Component)this).setVisible(true);
    }

    public JPanel makeBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        FSEtchedLine fSEtchedLine = new FSEtchedLine();
        fSEtchedLine.setEdges(15, 15);
        jPanel.add("North", fSEtchedLine);
        jPanel.add("Center", this.makeButtonPanel());
        return jPanel;
    }

    public JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        jPanel.setLayout(new FlowLayout(2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 6, 0));
        jPanel2.add(this.OKButton);
        jPanel2.add(this.CancelButton);
        jPanel2.add(this.HelpButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.OKButton) {
            FSMainPanel.enablePanelButtons(true);
            Vector vector = null;
            vector = this.sampleDatabasePanel.getDatabasesToCreate();
            this.dispose();
            if (vector != null && !vector.isEmpty()) {
                FSMainPanel.enablePanelButtons(false);
                new FSSamplesProgressDialog(this.frame, false, vector);
            }
        } else if (actionEvent.getSource() == this.CancelButton) {
            FSMainPanel.enablePanelButtons(true);
            this.dispose();
        } else if (actionEvent.getSource() == this.HelpButton) {
            String string = FSStringPool.get(102);
            int n2 = 0;
            while (n2 < this.databases.size()) {
                FSSampleDatabaseObject fSSampleDatabaseObject = (FSSampleDatabaseObject)this.databases.elementAt(n2);
                boolean bl = fSSampleDatabaseObject.isCreated();
                if (fSSampleDatabaseObject.isAvailable() || bl) {
                    string = string + "\n\n\n" + fSSampleDatabaseObject.getHelpText();
                }
                ++n2;
            }
            FSHelpDialog.showDialog(null, false, string);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (n2 == 112) {
            String string = FSStringPool.get(102);
            int n3 = 0;
            while (n3 < this.databases.size()) {
                FSSampleDatabaseObject fSSampleDatabaseObject = (FSSampleDatabaseObject)this.databases.elementAt(n3);
                boolean bl = fSSampleDatabaseObject.isCreated();
                if (fSSampleDatabaseObject.isAvailable() || bl) {
                    string = string + "\n\n\n" + fSSampleDatabaseObject.getHelpText();
                }
                ++n3;
            }
            FSHelpDialog.showDialog(null, false, string);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

