/*
 * Decompiled with CFR 0.152.
 */
package FirstSteps;

import FirstSteps.FSStringPool;
import FirstSteps.FSTurningGears;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FSAnimatedProgressTimer
extends Panel
implements Runnable {
    private long elapsedTime;
    private long startTime = new Date().getTime();
    private volatile boolean executeFlag = true;
    private boolean isThreaded = false;
    private boolean hideDialog = true;
    private volatile boolean fClosed = false;
    private volatile boolean bReverse = false;
    private String title;
    private JLabel lblElapsedTimeDesc;
    private JLabel lblElapsedTime;
    private FSTurningGears gears;
    Thread anime = null;
    private static final int MIN_TIME_BEFORE_DISPLAY = 3000;
    private static final int FRAMES_PER_SECOND = 10;
    private int timeBetweenFrames = 100;

    public FSAnimatedProgressTimer() {
        this.elapsedTime = new Date().getTime() - this.startTime;
        this.makeLayout();
        this.anime = new Thread((Runnable)this, "ProgressIndicator");
        this.anime.start();
    }

    public void setReverse(boolean bl) {
        this.bReverse = bl;
    }

    private void makeLayout() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.lblElapsedTimeDesc = new JLabel(FSStringPool.get(78), 2);
        this.lblElapsedTime = new JLabel(this.getStringValue(this.elapsedTime), 2);
        this.gears = new FSTurningGears();
        jPanel.add("Center", this.makeCenterGridPanel(new JPanel()));
        jPanel.add("South", new JPanel());
        jPanel.add("East", this.gears);
        this.setSize(new Dimension(this.getPreferredSize().width + 30, this.getPreferredSize().height + 30));
        this.add(jPanel);
    }

    private Container makeCenterGridPanel(Container container) {
        if (container instanceof JPanel) {
            ((JPanel)container).setBorder(new EmptyBorder(0, 0, 0, 10));
        }
        container.setLayout(new GridLayout(2, 1, 0, 0));
        container.add(this.makeElapsedTimeLabelPanel(new JPanel()));
        container.add(this.makeElapsedTimePanel(new JPanel()));
        return container;
    }

    private Container makeElapsedTimeLabelPanel(Container container) {
        container.setLayout(new BorderLayout());
        container.add("South", this.lblElapsedTimeDesc);
        return container;
    }

    private Container makeElapsedTimePanel(Container container) {
        container.setLayout(new BorderLayout());
        container.add("North", this.lblElapsedTime);
        return container;
    }

    public void run() {
        try {
            this.isThreaded = true;
            this.executeFlag = true;
            this.elapsedTime = new Date().getTime() - this.startTime;
            this.lblElapsedTime.setText(this.getStringValue(this.elapsedTime));
            while (this.executeFlag) {
                try {
                    if (!this.fClosed) {
                        Thread.sleep(this.timeBetweenFrames);
                        if (this.bReverse) {
                            this.gears.reverse();
                        } else {
                            this.gears.advance();
                        }
                        this.elapsedTime = new Date().getTime() - this.startTime;
                        this.lblElapsedTime.setText(this.getStringValue(this.elapsedTime));
                        continue;
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    this.stop();
                    break;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getStringValue(long l2) {
        String string = ":";
        int n2 = (int)(l2 / 1000L);
        int n3 = n2 % 3600 % 60;
        int n4 = n2 % 3600 / 60;
        int n5 = n2 / 3600;
        return new String(FSAnimatedProgressTimer.fixWidth(n5) + string + FSAnimatedProgressTimer.fixWidth(n4) + string + FSAnimatedProgressTimer.fixWidth(n3));
    }

    private static String fixWidth(int n2) {
        if (n2 == 0) {
            return "00";
        }
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public void stop() {
        this.fClosed = true;
    }

    public void suspend() {
        if (this.anime != null) {
            this.executeFlag = false;
        }
    }

    public void resume() {
        this.startTime = new Date().getTime();
        this.elapsedTime = new Date().getTime() - this.startTime;
        this.anime = new Thread((Runnable)this, "ResumedProgressIndicator");
        this.anime.start();
    }

    public boolean suspended() {
        return this.anime == null;
    }
}

