/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2CallableStatement;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2Socket;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.net.Socket;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected static final short STMT_TYPE_QUERY = 24;
    protected static final short STMT_TYPE_CALL = 25;
    protected static final short STMT_TYPE_OTHER = 26;
    protected static final short STMT_TYPE_SQLJ = 27;
    protected int statementHandle;
    protected DB2Connection connection;
    protected SQLWarning warnings = null;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int rowCount = 0;
    protected int colCount = 0;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected String[] colNames4JSQL = null;
    protected int colCount4JSQL = 0;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected DB2ResultSet resultSet = null;
    protected boolean moreResults = true;
    protected boolean prefetchedMoreResults = false;
    protected int CLIBlockSize = 0;
    private boolean counted = false;
    private static int statementCount = 0;
    private static int peakStatementCount = 0;
    protected String sql = null;
    protected int SQL_SUCCESS = 0;
    protected int SQL_SUCCESS_WITH_INFO = 1;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected StringBuffer stmtBatch = new StringBuffer();
    protected int batchSize = 0;
    protected int[] batchReturn = null;

    public DB2Statement(DB2Connection dB2Connection, boolean bl, int n2, int n3) throws SQLException {
        this.connection = dB2Connection;
        this.internalStmt = bl;
        this.sqlExcptGen = dB2Connection.sqlExcptGen;
        this.rsType = n2;
        this.rsConcur = n3;
        this.checkResultSetType(n2, n3);
        int n4 = this.rsType;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
        int n5 = 0;
        try {
            this.db2req.write((short)11);
            this.db2req.write((short)this.rsType);
            this.db2req.sendAndRecv();
            n5 = this.db2req.readInt();
            this.statementHandle = this.db2req.readInt();
            if (this.rsType != 1003 && (n4 = (int)this.db2req.readShort()) != this.rsType) {
                this.rsType = 1003;
                this.connection.addWarning(new SQLWarning("Cursor downgraded to TYPE_FORWARD_ONLY", "01S02", -99999));
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (n5 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n5);
        }
        this.incrementStatementCount();
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl) throws SQLException {
        this(dB2Connection, bl, 1003, 1007);
    }

    public DB2Statement(DB2Connection dB2Connection) throws SQLException {
        this(dB2Connection, false);
    }

    public DB2Statement() throws SQLException {
    }

    private synchronized void incrementStatementCount() {
        if (!this.counted) {
            DB2Statement.adjustStatementCount(1);
            this.counted = true;
        }
    }

    private synchronized void decrementStatementCount() {
        if (this.counted) {
            DB2Statement.adjustStatementCount(-1);
            this.counted = false;
        }
    }

    private static synchronized void adjustStatementCount(int n2) {
        if ((statementCount += n2) > peakStatementCount) {
            peakStatementCount = statementCount;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Peak statements", peakStatementCount);
            }
            DriverManager.println("DB2 Peak statements = " + peakStatementCount);
        }
    }

    public static int getStatementCount() {
        return statementCount;
    }

    public static int getPeakStatementCount() {
        return peakStatementCount;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.decrementStatementCount();
        if (null == this.connection) {
            return;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            if (this.connection.closed) {
                return;
            }
            if (this.resultSet != null) {
                this.resultSet.clearIsList();
                this.resultSet = null;
            }
            int n2 = 0;
            try {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)13);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n2 = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
            }
            this.statementHandle = 0;
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            if (!this.closed) {
                String string = null;
                string = this instanceof DB2CallableStatement ? "DB2CallableStatement closed in finalizer: \"" + this.sql + "\"" : (this instanceof DB2PreparedStatement ? "DB2PreparedStatement closed in finalizer: \"" + this.sql + "\"" : "DB2Statement closed in finalizer, last SQL: \"" + this.sql + "\"");
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, string);
                }
                DriverManager.println(string);
                this.close();
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "finalize()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "finalize()");
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        if (this.maxFieldSize == n2) {
            return;
        }
        try {
            int n3;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)17);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
            }
            if (n3 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n3);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxFieldSize = n2;
    }

    public int getMaxRows() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.maxRows;
    }

    public synchronized void setMaxRows(int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.maxRows == n2) {
            return;
        }
        if (n2 < 0 || n2 > 0 && n2 < this.fetchSize) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n3;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)18);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
            }
            if (n3 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n3);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxRows = n2;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)19);
                this.db2req.write(this.statementHandle);
                short s2 = 0;
                if (bl) {
                    s2 = 1;
                }
                this.db2req.write(s2);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public int getQueryTimeout() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)21);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                if (n3 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n3);
                } else {
                    n2 = this.db2req.readInt();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    public void setQueryTimeout(int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n3;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)20);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
            }
            if (n3 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n3);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public void cancel() throws SQLException {
        Exception exception3;
        DB2Request dB2Request;
        DB2Socket dB2Socket;
        block28: {
            dB2Socket = null;
            dB2Request = null;
            int n2 = -99999;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "cancel()");
                }
                if (this.connection.closed) {
                    SQLExceptionGenerator.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                try {
                    String string = this.connection.getServer();
                    int n3 = new Integer(this.connection.getPortStr());
                    dB2Socket = new DB2Socket(new Socket(string, n3), this.connection);
                    DB2Request dB2Request2 = dB2Request = new DB2Request(dB2Socket);
                    synchronized (dB2Request2) {
                        dB2Request.write((short)23);
                        dB2Request.write(this.statementHandle);
                        dB2Request.sendAndRecv();
                        n2 = dB2Request.readInt();
                    }
                    if (n2 != 0 && n2 != 1) {
                        throw new DB2Exception("Cancel Failed");
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Exception exception22;
                block31: {
                    Object var9_10 = null;
                    try {
                        if (dB2Request != null) {
                            dB2Request.write((short)2);
                            dB2Request.sendAndRecv();
                            dB2Request.readInt();
                        }
                    }
                    catch (Exception exception22) {
                        if (!DB2Trace.TraceOn) break block31;
                        DB2Trace.data(10, "Exception occurred closing db2req2");
                        DB2Trace.data(10, "Exception", exception22.getMessage());
                    }
                }
                try {
                    if (dB2Request != null) {
                        dB2Request.close();
                    }
                }
                catch (Exception exception22) {
                    // empty catch block
                }
                try {
                    if (dB2Socket != null) {
                        dB2Socket.close();
                    }
                }
                catch (Exception exception22) {
                    // empty catch block
                }
                dB2Request = null;
                dB2Socket = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "cancel()");
                }
                throw throwable;
            }
            try {
                if (dB2Request != null) {
                    dB2Request.write((short)2);
                    dB2Request.sendAndRecv();
                    dB2Request.readInt();
                }
            }
            catch (Exception exception3) {
                if (!DB2Trace.TraceOn) break block28;
                DB2Trace.data(10, "Exception occurred closing db2req2");
                DB2Trace.data(10, "Exception", exception3.getMessage());
            }
        }
        try {
            if (dB2Request != null) {
                dB2Request.close();
            }
        }
        catch (Exception exception3) {
            // empty catch block
        }
        try {
            if (dB2Socket != null) {
                dB2Socket.close();
            }
        }
        catch (Exception exception3) {
            // empty catch block
        }
        dB2Request = null;
        dB2Socket = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "cancel()");
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    public void setCursorName(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)22);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.prefetchedMoreResults) {
            return null;
        }
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.resultSet == null) {
            this.resultSet = this.rsType != 1003 ? (DB2Trace.TraceOn ? new DB2ScrollableResultSetTrace(this, this.colCount, this.rowCount) : new DB2ScrollableResultSet(this, this.colCount, this.rowCount)) : (DB2Trace.TraceOn ? new DB2ResultSetTrace(this, this.colCount) : new DB2ResultSet(this, this.colCount));
        } else if (this.rsType != 1003) {
            ((DB2ScrollableResultSet)this.resultSet).reset(this.colCount, this.rowCount);
        } else {
            this.resultSet.currentRowId = 0;
        }
        if (this.colCount <= 0 || !this.moreResults) {
            return null;
        }
        return this.resultSet;
    }

    public int getUpdateCount() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.colCount > 0 || !this.moreResults) {
            return -1;
        }
        if (this.rowCount < 0) {
            return 0;
        }
        return this.rowCount;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        if (this.prefetchedMoreResults) {
            this.prefetchedMoreResults = false;
            return this.moreResults;
        }
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (!this.moreResults) {
            return false;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)15);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 == 100) {
                    this.moreResults = false;
                    boolean bl = false;
                    return bl;
                }
                if (n2 == this.SQL_SUCCESS || n2 == this.SQL_SUCCESS_WITH_INFO) {
                    if (n2 != this.SQL_SUCCESS) {
                        this.sqlExcptGen.check_return_code(this, n2);
                    }
                    this.colCount = this.db2req.readShort();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                    }
                    if (this.colCount == 0) {
                        this.rowCount = this.db2req.readInt();
                    }
                    boolean bl = true;
                    return bl;
                }
                this.sqlExcptGen.check_return_code(this, n2);
                this.moreResults = false;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            this.moreResults = false;
            return false;
        }
    }

    protected synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            SQLWarning sQLWarning2 = this.warnings;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
        }
    }

    protected int numberColumns() throws SQLException {
        if (this.colCount != -1) {
            return this.colCount;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)49);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                }
                this.colCount = this.db2req.readShort();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return this.colCount;
    }

    public boolean execute(String string) throws SQLException {
        this.sql = string;
        this.execute2(string);
        return this.colCount > 0;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        short s2;
        this.sql = string;
        if (null == string || 0 == string.trim().length()) {
            this.sqlExcptGen.throwNullError();
        }
        if (24 != (s2 = this.getStatementType(string)) && 25 != s2 && 27 != s2) {
            this.sqlExcptGen.throwInvalidQueryError();
        }
        this.execute2(string);
        this.getResultSet();
        return this.resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected short getStatementType(String string) {
        int n2;
        int n3;
        block23: {
            String string2;
            short s2;
            block22: {
                n3 = 26;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getStatementType( " + string + " )");
                    }
                    if (null != string) {
                        n2 = string.length();
                        int n4 = 0;
                        if (n2 > 0 && '#' == string.charAt(n4)) {
                            s2 = 27;
                            Object var8_6 = null;
                            if (!DB2Trace.TraceOn) return s2;
                            string2 = null;
                            break block22;
                        }
                        while (true) {
                            char c2;
                            if (n4 >= n2 || !Character.isWhitespace(c2 = string.charAt(n4)) && c2 != '{' && c2 != ';' && c2 != '?' && c2 != '(' && c2 != '=') {
                                n3 = string.regionMatches(true, n4, "select", 0, 6) || string.regionMatches(true, n4, "values", 0, 6) || string.regionMatches(true, n4, "with", 0, 4) ? 24 : (string.regionMatches(true, n4, "call", 0, 4) ? 25 : 26);
                            }
                            ++n4;
                        }
                    }
                    n2 = n3;
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    String string3 = null;
                    switch (n3) {
                        case 24: {
                            string3 = "STMT_TYPE_QUERY (24)";
                            break;
                        }
                        case 25: {
                            string3 = "STMT_TYPE_CALL (25)";
                            break;
                        }
                        case 27: {
                            string3 = "STMT_TYPE_SQLJ (27)";
                            break;
                        }
                        default: {
                            string3 = "STMT_TYPE_OTHER (26)";
                        }
                    }
                    DB2Trace.methodExit((Object)this, "getStatementType()", string3);
                    throw throwable;
                }
            }
            switch (n3) {
                case 24: {
                    string2 = "STMT_TYPE_QUERY (24)";
                    break;
                }
                case 25: {
                    string2 = "STMT_TYPE_CALL (25)";
                    break;
                }
                case 27: {
                    string2 = "STMT_TYPE_SQLJ (27)";
                    break;
                }
                default: {
                    string2 = "STMT_TYPE_OTHER (26)";
                }
            }
            DB2Trace.methodExit((Object)this, "getStatementType()", string2);
            return s2;
        }
        Object var8_7 = null;
        if (!DB2Trace.TraceOn) return (short)n2;
        String string4 = null;
        switch (n3) {
            case 24: {
                string4 = "STMT_TYPE_QUERY (24)";
                break;
            }
            case 25: {
                string4 = "STMT_TYPE_CALL (25)";
                break;
            }
            case 27: {
                string4 = "STMT_TYPE_SQLJ (27)";
                break;
            }
            default: {
                string4 = "STMT_TYPE_OTHER (26)";
            }
        }
        DB2Trace.methodExit((Object)this, "getStatementType()", string4);
        return (short)n2;
    }

    public int executeUpdate(String string) throws SQLException {
        this.sql = string;
        if (24 == this.getStatementType(string)) {
            this.sqlExcptGen.throwInvalidUpdateError();
        }
        this.execute2(string);
        return this.getUpdateCount();
    }

    protected void execute2(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (null == string || 0 == string.trim().length()) {
            this.sqlExcptGen.throwNullError();
        }
        this.warnings = null;
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        if (this.resultSet != null) {
            this.resultSet.realClose();
        }
        int n2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)12);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.write((short)this.rsType);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 == 100) {
                    this.rowCount = 0;
                    this.colCount = 0;
                    if (1004 == this.rsType && this.resultSet != null) {
                        ((DB2ScrollableResultSet)this.resultSet).resetRowNum(0);
                    }
                } else if (n2 == this.SQL_SUCCESS) {
                    int n3 = this.rsType;
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                    this.rsType = this.db2req.readShort();
                    if (this.rsType != n3 && this.resultSet != null && !(this.resultSet instanceof DB2ScrollableResultSet)) {
                        this.resultSet = null;
                    }
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                        if (1004 == this.rsType) {
                            ((DB2ScrollableResultSet)this.resultSet).resetRowNum(this.rowCount);
                        }
                    }
                } else if (n2 == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n2);
                    this.checkForCursorDowngrade();
                    this.getCounts();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                        if (1004 == this.rsType) {
                            ((DB2ScrollableResultSet)this.resultSet).resetRowNum(this.rowCount);
                        }
                    }
                } else {
                    this.sqlExcptGen.check_return_code(this, n2);
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void getCounts() throws SQLException {
        int n2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)16);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected String getTraceHandle() {
        int n2 = this.statementHandle >> 16;
        int n3 = this.statementHandle & 0xFFFF;
        String string = n2 + ":" + n3;
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFetchDirection(int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchDirection( " + n2 + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchDirection(n2);
            this.fetchDirection = n2;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "setFetchDirection()", this.fetchDirection);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "setFetchDirection()", this.fetchDirection);
    }

    public int getFetchDirection() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.fetchDirection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFetchSize(int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchSize( " + n2 + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchSize(n2);
            this.fetchSize = n2;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "setFetchSize()", this.fetchSize);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "setFetchSize()", this.fetchSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getFetchSize() throws SQLException {
        int n2;
        int n3 = this.CLIBlockSize;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFetchSize()");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (this.fetchSize > 0) {
                n3 = this.fetchSize;
            }
            n2 = n3;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getFetchSize()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getFetchSize()", n3);
        return n2;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.rsConcur;
    }

    public int getResultSetType() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.rsType;
    }

    public void addBatch(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.batchSize) {
            this.stmtBatch.append(string);
        } else {
            this.stmtBatch.append(";" + string);
        }
        ++this.batchSize;
    }

    public void clearBatch() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.batchSize = 0;
        this.stmtBatch = new StringBuffer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.batchSize) {
            this.batchReturn = new int[0];
            return this.batchReturn;
        }
        try {
            try {
                block21: {
                    DB2Request dB2Request = this.db2req;
                    synchronized (dB2Request) {
                        int n2;
                        block20: {
                            this.db2req.write((short)201);
                            this.db2req.write(this.statementHandle);
                            this.db2req.write(this.stmtBatch.toString());
                            this.db2req.write(this.batchSize);
                            this.db2req.sendAndRecv();
                            n2 = this.db2req.readInt();
                            this.batchReturn = new int[this.batchSize];
                            int n3 = 0;
                            while (true) {
                                if (n3 >= this.batchSize) {
                                    if (this.SQL_SUCCESS_WITH_INFO == n2) {
                                        break;
                                    }
                                    break block20;
                                }
                                this.batchReturn[n3] = this.db2req.readInt();
                                ++n3;
                            }
                            BatchUpdateException batchUpdateException = null;
                            String string = null;
                            String string2 = null;
                            int n4 = 0;
                            int n5 = this.db2req.readInt();
                            while (true) {
                                if (n5 <= 0) {
                                    if (batchUpdateException != null) {
                                        throw batchUpdateException;
                                    }
                                    break block21;
                                }
                                if (this.db2req.readBoolean()) {
                                    string = SQLExceptionGenerator.errMsgClass.getString("0641");
                                    string2 = "HY000";
                                    n4 = -99999;
                                } else {
                                    string = this.db2req.readString();
                                    string2 = this.db2req.readString();
                                    n4 = this.db2req.readInt();
                                }
                                if (null == batchUpdateException) {
                                    batchUpdateException = new BatchUpdateException(string, string2, n4, this.batchReturn);
                                } else {
                                    SQLException sQLException = new SQLException(string, string2, n4);
                                    batchUpdateException.setNextException(sQLException);
                                }
                                --n5;
                            }
                        }
                        if (n2 != this.SQL_SUCCESS) {
                            this.sqlExcptGen.check_batch_return_code(this, n2);
                        }
                    }
                }
                nArray = this.batchReturn;
                Object var12_12 = null;
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
                Object var12_13 = null;
                this.clearBatch();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    protected void checkResultSetType(int n2, int n3) throws SQLException {
        if (1008 == n3) {
            this.connection.addWarning(new SQLWarning("ResultSet.CONCUR_UPDATABLE not supported. ResultSet concurrency set to READ_ONLY.", "00000", -99999));
            this.rsConcur = 1007;
        } else if (1007 != n3) {
            this.sqlExcptGen.throwUnknownResultSetType(n3);
        }
        if (1005 == n2) {
            this.connection.addWarning(new SQLWarning("ResultSet.TYPE_SCROLL_SENSITIVE not supported. ResultSet type downgraded.", "00000", -99999));
            this.rsType = 1004;
        } else if (1003 != n2 && 1004 != n2) {
            this.sqlExcptGen.throwUnknownResultSetType(n2);
        }
    }

    protected int[] getBatchReturn() {
        return this.batchReturn;
    }

    protected void checkFetchDirection(int n2) throws SQLException {
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
        if (1003 == this.rsType && n2 == 1001) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
    }

    protected void checkFetchSize(int n2) throws SQLException {
        if (this.maxRows != 0 && n2 > this.maxRows || n2 < 0) {
            this.sqlExcptGen.throwFetchSizeError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkForCursorDowngrade() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkForCursorDowngrade()");
                DB2Trace.data(10, "rsType", this.rsType);
            }
            if (this.rsType != 1003) {
                SQLWarning sQLWarning = this.getWarnings();
                while (sQLWarning != null) {
                    if (sQLWarning.getSQLState().equalsIgnoreCase("01S02")) {
                        this.rsType = 1003;
                        if (this.resultSet != null && this.resultSet instanceof DB2ScrollableResultSet) {
                            this.resultSet = null;
                        }
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "Cursor downgraded to TYPE_FORWARD_ONLY");
                        }
                    }
                    sQLWarning = sQLWarning.getNextWarning();
                }
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "checkForCursorDowngrade()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "checkForCursorDowngrade()");
    }
}

