/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.sql.SQLException;

public class DB2ScrollableResultSet
extends DB2ResultSet {
    private int rowNumber = 0;

    public DB2ScrollableResultSet(DB2Statement dB2Statement, int n2, int n3) throws SQLException {
        super(dB2Statement, n2, false);
        this.rowNumber = n3;
        this.rsType = 1004;
        this.currentRowId = 0;
    }

    protected void resetRowNum(int n2) {
        this.rowNumber = n2;
        this.currentRowId = 0;
    }

    protected void reset(int n2, int n3) throws SQLException {
        this.rowNumber = n3;
        super.reset(n2);
        this.currentRowId = 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId < 1;
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId > this.rowNumber;
    }

    public boolean isFirst() throws SQLException {
        return this.rowNumber > 0 && 1 == this.currentRowId;
    }

    public boolean isLast() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId == this.rowNumber;
    }

    public void beforeFirst() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.rowNumber || this.currentRowId < 1) {
            return;
        }
        int n2 = this.rowObj.absolute(0);
        if (n2 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n2);
        }
        this.currentRowId = 0;
    }

    public void afterLast() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.rowNumber || this.currentRowId > this.rowNumber) {
            return;
        }
        int n2 = this.rowObj.absolute(this.rowNumber + 1);
        if (n2 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n2);
        }
        this.currentRowId = this.rowNumber + 1;
    }

    public boolean first() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.rowNumber) {
            return false;
        }
        if (1 == this.currentRowId) {
            return true;
        }
        int n2 = this.rowObj.first();
        if (n2 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n2);
        }
        this.currentRowId = 1;
        return 100 != n2;
    }

    public boolean last() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.rowNumber) {
            return false;
        }
        if (this.currentRowId == this.rowNumber) {
            return true;
        }
        int n2 = this.rowObj.absolute(this.rowNumber);
        if (n2 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n2);
        }
        this.currentRowId = this.rowNumber;
        return 100 != n2;
    }

    public int getRow() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.rowNumber || this.currentRowId < 1 || this.currentRowId > this.rowNumber) {
            return 0;
        }
        return this.currentRowId;
    }

    public boolean absolute(int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == n2) {
            this.sqlExcptGen.throwInvalidAbsoluteCall();
        }
        if (0 == this.rowNumber) {
            return false;
        }
        if (n2 > this.rowNumber) {
            if (this.currentRowId > this.rowNumber) {
                return false;
            }
            n2 = this.rowNumber + 1;
        } else if (-n2 > this.rowNumber) {
            if (this.currentRowId < 1) {
                return false;
            }
            n2 = 0;
        } else if (n2 < 0) {
            n2 = this.rowNumber + n2 + 1;
        }
        if (n2 == this.currentRowId) {
            return true;
        }
        int n3 = this.rowObj.absolute(n2);
        if (n3 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n3);
        }
        this.currentRowId = n2;
        return this.currentRowId >= 1 && this.currentRowId <= this.rowNumber;
    }

    public boolean relative(int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.getRow()) {
            this.sqlExcptGen.throwInvalidRelativeCall();
        }
        if (0 == this.rowNumber) {
            return false;
        }
        int n3 = this.currentRowId + n2;
        if (n3 <= 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(n3);
    }

    public boolean previous() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.rowNumber || this.currentRowId < 1) {
            return false;
        }
        int n2 = this.rowObj.previous();
        if (n2 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n2);
        }
        --this.currentRowId;
        return this.currentRowId >= 1;
    }

    public boolean next() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (0 == this.rowNumber || this.currentRowId > this.rowNumber) {
            return false;
        }
        int n2 = this.rowObj.next();
        if (n2 != 0) {
            this.sqlExcptGen.check_return_code(this.statement, n2);
        }
        ++this.currentRowId;
        return this.currentRowId <= this.rowNumber;
    }

    public int getNumRows() {
        return this.rowNumber;
    }
}

