/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2CharReader;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2DataObject;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2OutputParameters;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DB2RowObject {
    protected DB2Connection connection = null;
    protected DB2Statement statement = null;
    private DB2ResultSet resultset = null;
    protected DB2Request db2req = null;
    protected SQLExceptionGenerator sqlExcptGen = null;
    protected int length = 0;
    protected short[] sqltype = null;
    private boolean cleared = true;
    private int currentRow = 0;
    private Object[] fetchedRows = null;
    private int firstFetchedIndex = 0;
    private int firstFetchedRow = 0;
    private int numFetchedRows = 0;
    private boolean unboundColumns = false;
    private boolean endOfData = false;

    public DB2RowObject() throws SQLException {
    }

    public DB2RowObject(DB2ResultSet dB2ResultSet) throws SQLException {
        this.connection = dB2ResultSet.statement.connection;
        this.resultset = dB2ResultSet;
        this.statement = dB2ResultSet.statement;
        this.db2req = dB2ResultSet.db2req;
        this.sqlExcptGen = dB2ResultSet.sqlExcptGen;
    }

    protected void reset() {
        this.cleared = true;
        this.currentRow = 0;
        this.firstFetchedIndex = 0;
        this.firstFetchedRow = 0;
        this.numFetchedRows = 0;
        this.endOfData = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void activate() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "activate()");
            }
            this.cleared = false;
            this.length = this.resultset.statement.colCount;
            if (null == this.sqltype || this.length > this.sqltype.length) {
                this.sqltype = new short[this.length];
            }
            if (null != this.fetchedRows) {
                int n2 = 0;
                while (n2 < this.fetchedRows.length) {
                    if (null != this.fetchedRows[n2] && ((DB2DataObject[])this.fetchedRows[n2]).length < this.length) {
                        DB2DataObject[] dB2DataObjectArray = new DB2DataObject[this.length];
                        System.arraycopy(this.fetchedRows[n2], 0, dB2DataObjectArray, 0, ((DB2DataObject[])this.fetchedRows[n2]).length);
                        this.fetchedRows[n2] = dB2DataObjectArray;
                    }
                    ++n2;
                }
            }
            this.unboundColumns = false;
            int n3 = 0;
            while (n3 < this.length) {
                this.sqltype[n3] = (short)this.resultset.rsMetaData.colBaseTypesNotAdjusted[n3];
                if (!this.resultset.preFetched[n3]) {
                    this.unboundColumns = true;
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "sqltype[" + n3 + "]", this.sqltype[n3]);
                }
                ++n3;
            }
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "length", this.length);
            DB2Trace.data(100, "unboundColumns", String.valueOf(this.unboundColumns));
            DB2Trace.methodExit(this, "activate()");
            throw throwable;
        }
        DB2Trace.data(100, "length", this.length);
        DB2Trace.data(100, "unboundColumns", String.valueOf(this.unboundColumns));
        DB2Trace.methodExit(this, "activate()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int forwardOnlyNext() throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "forwardOnlyNext()");
            }
            this.resultset.clearWarnings();
            if (this.cleared) {
                this.activate();
            }
            ++this.currentRow;
            if (this.currentRow < this.firstFetchedRow || this.currentRow > this.firstFetchedRow + this.numFetchedRows - 1) {
                if (this.endOfData) {
                    this.currentRow = this.firstFetchedRow + this.numFetchedRows;
                    n3 = 100;
                } else {
                    n2 = 1;
                    if (this.unboundColumns) {
                        n2 = 1;
                    } else if (this.resultset.fetchSize > 0) {
                        n2 = this.resultset.fetchSize;
                    } else if (this.statement.CLIBlockSize > 0) {
                        n2 = this.statement.CLIBlockSize;
                    }
                    try {
                        DB2Request dB2Request = this.db2req;
                        synchronized (dB2Request) {
                            this.db2req.write((short)34);
                            this.db2req.write(this.resultset.stmtHandle);
                            this.db2req.write(n2);
                            this.db2req.sendAndRecv();
                            n3 = this.getDataFromBuffer(this.currentRow, n2, 0, 0);
                        }
                    }
                    catch (IOException iOException) {
                        this.sqlExcptGen.socketException("08S01a");
                    }
                    if (100 == n3) {
                        this.endOfData = true;
                        if (this.currentRow >= this.firstFetchedRow && this.currentRow <= this.firstFetchedRow + this.numFetchedRows - 1) {
                            n3 = 0;
                        }
                    }
                }
            }
            n2 = n3;
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "endOfData", String.valueOf(this.endOfData));
            DB2Trace.data(100, "currentRow", this.currentRow);
            DB2Trace.methodExit((Object)this, "forwardOnlyNext()", n3);
            throw throwable;
        }
        DB2Trace.data(100, "endOfData", String.valueOf(this.endOfData));
        DB2Trace.data(100, "currentRow", this.currentRow);
        DB2Trace.methodExit((Object)this, "forwardOnlyNext()", n3);
        return n2;
    }

    protected int next() throws SQLException {
        return this.fetchScroll(this.currentRow + 1);
    }

    protected int getDataFromBuffer() throws IOException {
        this.currentRow = 1;
        return this.getDataFromBuffer(1, 1, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getDataFromBuffer(int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7;
        block41: {
            int n8;
            block39: {
                n7 = 0;
                try {
                    int n9;
                    Object[] objectArray;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getDataFromBuffer( " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + " )");
                    }
                    if (n3 < 1) {
                        n8 = n7;
                        Object var20_8 = null;
                        if (!DB2Trace.TraceOn) return n8;
                        break block39;
                    }
                    short s2 = 0;
                    short s3 = 0;
                    short s4 = 0;
                    short s5 = 0;
                    short s6 = 0;
                    short s7 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    if (null == this.fetchedRows || this.fetchedRows.length < n4 + n3 + n5) {
                        block40: {
                            objectArray = new Object[n4 + n3 + n5];
                            if (null != this.fetchedRows) {
                                n9 = 0;
                                n6 = this.firstFetchedIndex;
                                while (true) {
                                    if (n9 >= this.fetchedRows.length) {
                                        this.firstFetchedIndex = 0;
                                        n9 = this.fetchedRows.length;
                                        break block40;
                                    }
                                    objectArray[n9] = this.fetchedRows[n6 % this.fetchedRows.length];
                                    ++n9;
                                    ++n6;
                                }
                            }
                            n9 = 0;
                        }
                        while (true) {
                            if (n9 >= objectArray.length) {
                                this.fetchedRows = objectArray;
                                break;
                            }
                            objectArray[n9] = new DB2DataObject[this.length];
                            ++n9;
                        }
                    }
                    if (n4 > 0 || n5 > 0) {
                        n6 = this.firstFetchedIndex - this.firstFetchedRow;
                        n11 = (n2 + n6 + this.fetchedRows.length) % this.fetchedRows.length;
                    } else {
                        n11 = 0;
                    }
                    this.firstFetchedIndex = (n11 - n4 + this.fetchedRows.length) % this.fetchedRows.length;
                    this.firstFetchedRow = n2 - n4;
                    this.numFetchedRows = n4;
                    int n12 = n2;
                    block19: while (n12 < n2 + n3) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "row", n12);
                            DB2Trace.data(10, "index", n11);
                        }
                        if (null != this.resultset && (n7 = this.db2req.readInt()) != 0 && n7 != 1) break;
                        objectArray = (DB2DataObject[])this.fetchedRows[n11];
                        n9 = 0;
                        while (true) {
                            if (n9 >= this.length) {
                                ++this.numFetchedRows;
                                n11 = (n11 + 1) % this.fetchedRows.length;
                                ++n12;
                                continue block19;
                            }
                            if (this.resultset == null || this.resultset.preFetched[n9]) {
                                int n13 = this.db2req.readInt();
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(30, "sqltype[" + n9 + "]", this.sqltype[n9]);
                                    DB2Trace.data(30, "sqlind", n13);
                                }
                                if (null == objectArray[n9]) {
                                    objectArray[n9] = new DB2DataObject();
                                }
                                if (n13 == -1) {
                                    ((DB2DataObject)objectArray[n9]).set(null);
                                } else {
                                    switch (this.sqltype[n9]) {
                                        case 5: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readShort());
                                            break;
                                        }
                                        case 4: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readInt());
                                            break;
                                        }
                                        case -5: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readLong());
                                            break;
                                        }
                                        case 91: {
                                            s2 = this.db2req.readShort();
                                            s3 = this.db2req.readShort();
                                            s4 = this.db2req.readShort();
                                            ((DB2DataObject)objectArray[n9]).setDate(s2, s3, s4);
                                            break;
                                        }
                                        case 92: {
                                            s5 = this.db2req.readShort();
                                            s6 = this.db2req.readShort();
                                            s7 = this.db2req.readShort();
                                            ((DB2DataObject)objectArray[n9]).setTime(s5, s6, s7);
                                            break;
                                        }
                                        case 93: {
                                            s2 = this.db2req.readShort();
                                            s3 = this.db2req.readShort();
                                            s4 = this.db2req.readShort();
                                            s5 = this.db2req.readShort();
                                            s6 = this.db2req.readShort();
                                            s7 = this.db2req.readShort();
                                            n10 = this.db2req.readInt();
                                            ((DB2DataObject)objectArray[n9]).setTimestamp(s2, s3, s4, s5, s6, s7, n10);
                                            break;
                                        }
                                        case 6: 
                                        case 8: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readDouble());
                                            break;
                                        }
                                        case 7: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readFloat());
                                            break;
                                        }
                                        case -400: 
                                        case -97: 
                                        case -96: 
                                        case -95: 
                                        case -10: 
                                        case -9: 
                                        case -8: 
                                        case -1: 
                                        case 1: 
                                        case 2: 
                                        case 3: 
                                        case 12: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readString());
                                            break;
                                        }
                                        case -4: 
                                        case -3: 
                                        case -2: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readBytes());
                                            break;
                                        }
                                        case -351: 
                                        case 31: 
                                        case 41: {
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readInt());
                                            break;
                                        }
                                        case -98: {
                                            if (null == this.resultset) {
                                                ((DB2DataObject)objectArray[n9]).set(this.db2req.readBytes());
                                                break;
                                            }
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readInt());
                                            break;
                                        }
                                        case -350: 
                                        case -99: {
                                            if (null == this.resultset) {
                                                ((DB2DataObject)objectArray[n9]).set(this.db2req.readString());
                                                break;
                                            }
                                            ((DB2DataObject)objectArray[n9]).set(this.db2req.readInt());
                                            break;
                                        }
                                        default: {
                                            ((DB2DataObject)objectArray[n9]).set(null);
                                        }
                                    }
                                }
                            }
                            ++n9;
                        }
                    }
                    if (this.numFetchedRows - n4 == n3) {
                        this.numFetchedRows += n5;
                    }
                    n6 = n7;
                    break block41;
                }
                catch (Throwable throwable) {
                    Object var20_10 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(100, "firstFetchedIndex", this.firstFetchedIndex);
                    DB2Trace.data(100, "firstFetchedRow", this.firstFetchedRow);
                    DB2Trace.data(100, "numFetchedRows", this.numFetchedRows);
                    DB2Trace.data(100, "currentRow", this.currentRow);
                    DB2Trace.methodExit((Object)this, "getDataFromBuffer()", n7);
                    throw throwable;
                }
            }
            DB2Trace.data(100, "firstFetchedIndex", this.firstFetchedIndex);
            DB2Trace.data(100, "firstFetchedRow", this.firstFetchedRow);
            DB2Trace.data(100, "numFetchedRows", this.numFetchedRows);
            DB2Trace.data(100, "currentRow", this.currentRow);
            DB2Trace.methodExit((Object)this, "getDataFromBuffer()", n7);
            return n8;
        }
        Object var20_9 = null;
        if (!DB2Trace.TraceOn) return n6;
        DB2Trace.data(100, "firstFetchedIndex", this.firstFetchedIndex);
        DB2Trace.data(100, "firstFetchedRow", this.firstFetchedRow);
        DB2Trace.data(100, "numFetchedRows", this.numFetchedRows);
        DB2Trace.data(100, "currentRow", this.currentRow);
        DB2Trace.methodExit((Object)this, "getDataFromBuffer()", n7);
        return n6;
    }

    private DB2DataObject getElement(int n2) {
        DB2DataObject[] dB2DataObjectArray = null;
        if (this.currentRow >= this.firstFetchedRow && this.currentRow <= this.firstFetchedRow + this.numFetchedRows) {
            int n3 = (this.firstFetchedIndex + this.currentRow - this.firstFetchedRow) % this.fetchedRows.length;
            dB2DataObjectArray = (DB2DataObject[])this.fetchedRows[n3];
        }
        return dB2DataObjectArray[n2];
    }

    protected boolean elementIsNull(int n2) throws SQLException {
        if (this.resultset != null && this.resultset.getRow() == 0) {
            throw new DB2Exception("Current row is invalid", "24000");
        }
        DB2DataObject dB2DataObject = this.getElement(n2);
        return null == dB2DataObject || dB2DataObject.isNull();
    }

    protected String getString(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        String string = null;
        switch (this.sqltype[n2]) {
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = this.getStringValueData(n2);
                break;
            }
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                if (null == this.resultset) {
                    string = this.getStringValueData(n2);
                    break;
                }
                string = this.resultset.getStringData(n2 + 1);
                break;
            }
            default: {
                string = this.getDataAsString(n2);
            }
        }
        return string;
    }

    protected boolean getBoolean(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return false;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        boolean bl = false;
        switch (this.sqltype[n2]) {
            case -5: 
            case 4: 
            case 5: {
                long l2 = this.getLongValueData(n2);
                if (l2 == 0L) break;
                bl = true;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte by = this.getByteValueData(n2);
                if (by == 0) break;
                bl = true;
                break;
            }
            case 7: {
                float f2 = this.getFloatValueData(n2);
                if (f2 == 0.0f) break;
                bl = true;
                break;
            }
            case 6: 
            case 8: {
                double d2 = this.getDoubleValueData(n2);
                if (d2 == 0.0) break;
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n2);
                if (bigDecimal.compareTo(new BigDecimal(0.0)) == 0) break;
                bl = true;
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case -99: 
            case -1: 
            case 1: 
            case 12: {
                String string = this.getStringValueData(n2);
                if (string == null) {
                    bl = false;
                    break;
                }
                if ((string = string.trim()).equals("1")) {
                    bl = true;
                    break;
                }
                bl = new Boolean(string);
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    long l3 = Long.parseLong(string.trim());
                    if (l3 == 0L) break;
                    bl = true;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return bl;
    }

    protected byte getByte(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        byte by = 0;
        switch (this.sqltype[n2]) {
            case -5: 
            case 4: 
            case 5: {
                long l2 = this.getLongValueData(n2);
                by = (byte)l2;
                if ((long)by == l2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                by = this.getByteValueData(n2);
                break;
            }
            case 7: {
                float f2 = this.getFloatValueData(n2);
                by = (byte)f2;
                if ((float)by == f2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d2 = this.getDoubleValueData(n2);
                by = (byte)d2;
                if ((double)by == d2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                short s2 = this.getShort(n2);
                by = (byte)s2;
                if ((short)by == s2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    char c2 = string.trim().charAt(0);
                    by = (byte)c2;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return by;
    }

    protected short getShort(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        short s2 = 0;
        switch (this.sqltype[n2]) {
            case 5: {
                long l2 = this.getLongValueData(n2);
                s2 = (short)l2;
                break;
            }
            case -5: 
            case 4: {
                long l3 = this.getLongValueData(n2);
                if (l3 >= -32768L && l3 <= 32767L) {
                    s2 = (short)l3;
                    if ((long)s2 == l3) break;
                    this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                    break;
                }
                throw new NumberFormatException();
            }
            case 7: {
                float f2 = this.getFloatValueData(n2);
                s2 = new Double(f2).shortValue();
                if ((float)s2 == f2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d2 = this.getDoubleValueData(n2);
                s2 = new Double(d2).shortValue();
                if ((double)s2 == d2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n2);
                long l4 = bigDecimal.longValue();
                if (l4 >= -32768L && l4 <= 32767L) {
                    s2 = (short)l4;
                    if ((float)s2 == bigDecimal.floatValue()) break;
                    this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                    break;
                }
                throw new NumberFormatException();
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    s2 = Short.parseShort(string.trim());
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return s2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getInt(int n2) throws SQLException {
        int n3;
        int n4;
        block18: {
            int n5;
            block17: {
                n4 = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getInt( " + n2 + " )");
                    }
                    if (this.elementIsNull(n2)) {
                        if (this.resultset != null) {
                            this.resultset.nullTag = true;
                        }
                        n5 = 0;
                        Object var7_10 = null;
                        if (!DB2Trace.TraceOn) return n5;
                        break block17;
                    }
                    if (this.resultset != null) {
                        this.resultset.nullTag = false;
                    }
                    switch (this.sqltype[n2]) {
                        case 4: 
                        case 5: {
                            long l2 = this.getLongValueData(n2);
                            n4 = (int)l2;
                            break;
                        }
                        case -5: {
                            long l3 = this.getLongValueData(n2);
                            if (l3 < Integer.MIN_VALUE) throw new NumberFormatException();
                            if (l3 > Integer.MAX_VALUE) throw new NumberFormatException();
                            n4 = (int)l3;
                            if ((long)n4 == l3) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 7: {
                            float f2 = this.getFloatValueData(n2);
                            n4 = new Double(f2).intValue();
                            if ((float)n4 == f2) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 6: 
                        case 8: {
                            double d2 = this.getDoubleValueData(n2);
                            n4 = new Double(d2).intValue();
                            if ((double)n4 == d2) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal bigDecimal = this.getDecimalValueData(n2);
                            long l4 = bigDecimal.longValue();
                            if (l4 < Integer.MIN_VALUE) throw new NumberFormatException();
                            if (l4 > Integer.MAX_VALUE) throw new NumberFormatException();
                            n4 = (int)l4;
                            if ((float)n4 == bigDecimal.floatValue()) break;
                            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                            break;
                        }
                        case 91: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        case 92: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        case 93: {
                            SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                            break;
                        }
                        default: {
                            Object object = this.getObject(n2);
                            String string = object.toString();
                            if (string != null) {
                                n4 = Integer.parseInt(string.trim());
                                break;
                            }
                            if (this.resultset == null) break;
                            this.resultset.nullTag = false;
                        }
                    }
                    n3 = n4;
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getInt()", n4);
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getInt()", n4);
            return n5;
        }
        Object var7_11 = null;
        if (!DB2Trace.TraceOn) return n3;
        DB2Trace.methodExit((Object)this, "getInt()", n4);
        return n3;
    }

    protected long getLong(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0L;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        long l2 = 0L;
        switch (this.sqltype[n2]) {
            case -5: 
            case 4: 
            case 5: {
                l2 = this.getLongValueData(n2);
                break;
            }
            case 7: {
                float f2 = this.getFloatValueData(n2);
                l2 = new Double(f2).longValue();
                if ((float)l2 == f2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 6: 
            case 8: {
                double d2 = this.getDoubleValueData(n2);
                l2 = new Double(d2).longValue();
                if ((double)l2 == d2) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = this.getDecimalValueData(n2);
                l2 = bigDecimal.longValue();
                if ((float)l2 == bigDecimal.floatValue()) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            case 91: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 92: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            case 93: {
                SQLExceptionGenerator.throwColumnDataTypeError(this.connection);
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    l2 = Long.parseLong(string.trim());
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return l2;
    }

    protected float getFloat(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0.0f;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        float f2 = 0.0f;
        switch (this.sqltype[n2]) {
            case -5: 
            case 4: 
            case 5: {
                f2 = this.getLongValueData(n2);
                break;
            }
            case 7: {
                f2 = this.getFloatValueData(n2);
                break;
            }
            case 6: 
            case 8: {
                double d2 = this.getDoubleValueData(n2);
                f2 = (float)d2;
                if (Math.abs(d2) == Double.POSITIVE_INFINITY || Math.abs(f2) != Float.POSITIVE_INFINITY) break;
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    Float f3 = new Float(string.trim());
                    f2 = f3.floatValue();
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return f2;
    }

    protected double getDouble(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return 0.0;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        double d2 = 0.0;
        switch (this.sqltype[n2]) {
            case -5: 
            case 4: 
            case 5: {
                d2 = this.getLongValueData(n2);
                break;
            }
            case 7: {
                d2 = this.getFloatValueData(n2);
                break;
            }
            case 6: 
            case 8: {
                d2 = this.getDoubleValueData(n2);
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    Double d3 = new Double(string.trim());
                    d2 = d3;
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return d2;
    }

    protected byte[] getBytes(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        byte[] byArray = null;
        switch (this.sqltype[n2]) {
            case -4: 
            case -3: 
            case -2: {
                byArray = this.getBytesValueData(n2);
                break;
            }
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                if (null == this.resultset) {
                    byArray = this.getBytesValueData(n2);
                    break;
                }
                byArray = this.resultset.getBytesData(n2 + 1);
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    byArray = string.trim().getBytes();
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Date getDate(int n2, Calendar calendar) throws SQLException {
        Object object;
        Date date = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDate(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.elementIsNull(n2)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                Date date2 = null;
                Object var9_6 = null;
                if (!DB2Trace.TraceOn) return date2;
                DB2Trace.methodExit((Object)this, "getDate(...)", date == null ? "NULL" : date.toString());
                return date2;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            if (this.sqltype[n2] == 91) {
                object = (int[])this.getElement((int)n2).oValue;
                int n3 = object[0];
                int n4 = object[1];
                int n5 = object[2];
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year(+1900)", n3 + 1900);
                    DB2Trace.data(10, "Month(+1)", n4 + 1);
                    DB2Trace.data(10, "Date", n5);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(n3 + 1900, n4, n5, 0, 0, 0);
                calendar.set(14, 0);
                date = new Date(calendar.getTime().getTime());
            } else if (this.sqltype[n2] == 93) {
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                object = this.getTimestamp(n2, calendar);
                calendar.setTime((java.util.Date)object);
                date = new Date(calendar.getTime().getTime());
            } else if (this.sqltype[n2] == 92) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "Time sqltype", 92);
                }
                date = null;
            } else {
                object = this.getObject(n2);
                String string = object.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(40, "tmpStr", string);
                }
                if (string != null) {
                    try {
                        date = Date.valueOf(string.trim());
                    }
                    catch (Exception exception) {
                        date = null;
                    }
                } else if (this.resultset != null) {
                    this.resultset.nullTag = false;
                }
            }
            object = date;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDate(...)", date == null ? "NULL" : date.toString());
            throw throwable;
        }
        Object var9_7 = null;
        if (!DB2Trace.TraceOn) return object;
        DB2Trace.methodExit((Object)this, "getDate(...)", date == null ? "NULL" : date.toString());
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Time getTime(int n2, Calendar calendar) throws SQLException {
        Object object;
        Time time = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTime(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.elementIsNull(n2)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                Time time2 = null;
                Object var9_6 = null;
                if (!DB2Trace.TraceOn) return time2;
                DB2Trace.methodExit((Object)this, "getTime(...)", time == null ? "NULL" : time.toString());
                return time2;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            if (this.sqltype[n2] == 92) {
                object = (int[])this.getElement((int)n2).oValue;
                int n3 = object[0];
                Object object2 = object[1];
                Object object3 = object[2];
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "hour", n3);
                    DB2Trace.data(10, "minute", (int)object2);
                    DB2Trace.data(10, "second", (int)object3);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(1970, 0, 1, n3, (int)object2, (int)object3);
                calendar.set(14, 0);
                time = new Time(calendar.getTime().getTime());
            } else if (this.sqltype[n2] == 93) {
                this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                object = this.getTimestamp(n2, calendar);
                calendar.setTime((java.util.Date)object);
                time = new Time(calendar.getTime().getTime());
            } else {
                object = this.getObject(n2);
                String string = object.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "tmpStr", string);
                }
                if (string != null) {
                    string = string.trim().replace('.', ':');
                    time = Time.valueOf(string);
                } else if (this.resultset != null) {
                    this.resultset.nullTag = false;
                }
            }
            object = time;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getTime(...)", time == null ? "NULL" : time.toString());
            throw throwable;
        }
        Object var9_7 = null;
        if (!DB2Trace.TraceOn) return object;
        DB2Trace.methodExit((Object)this, "getTime(...)", time == null ? "NULL" : time.toString());
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Object object;
        Timestamp timestamp = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestamp(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.elementIsNull(n2)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                Timestamp timestamp2 = null;
                Object var13_6 = null;
                if (!DB2Trace.TraceOn) return timestamp2;
                DB2Trace.methodExit((Object)this, "getTimestamp(...)", timestamp == null ? "NULL" : timestamp.toString());
                return timestamp2;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            if (this.sqltype[n2] == 93) {
                object = (int[])this.getElement((int)n2).oValue;
                int n3 = object[0];
                int n4 = object[1];
                Object object2 = object[2];
                Object object3 = object[3];
                Object object4 = object[4];
                Object object5 = object[5];
                Object object6 = object[6];
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "year", n3);
                    DB2Trace.data(10, "month", n4);
                    DB2Trace.data(10, "date", (int)object2);
                    DB2Trace.data(10, "hour", (int)object3);
                    DB2Trace.data(10, "minute", (int)object4);
                    DB2Trace.data(10, "second", (int)object5);
                    DB2Trace.data(10, "nano", (int)object6);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(n3 + 1900, n4, (int)object2, (int)object3, (int)object4, (int)object5);
                calendar.set(14, 0);
                timestamp = new Timestamp(calendar.getTime().getTime());
                timestamp.setNanos((int)object6);
            } else if (this.sqltype[n2] == 91) {
                object = this.getDate(n2, calendar);
                calendar.setTime((java.util.Date)object);
                timestamp = new Timestamp(calendar.getTime().getTime());
            } else {
                object = this.getObject(n2);
                String string = object.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "tmpStr", string);
                }
                if (string != null) {
                    String string2 = "0000-00-00 00:00:00.000000000";
                    StringBuffer stringBuffer = new StringBuffer(string.trim());
                    int n5 = stringBuffer.length();
                    if (n5 >= 10) {
                        stringBuffer.setCharAt(4, '-');
                        stringBuffer.setCharAt(7, '-');
                        if (n5 >= 19) {
                            stringBuffer.setCharAt(10, ' ');
                            stringBuffer.setCharAt(13, ':');
                            stringBuffer.setCharAt(16, ':');
                            if (n5 >= 21) {
                                stringBuffer.setCharAt(19, '.');
                            }
                        }
                    }
                    if (n5 < 29) {
                        stringBuffer.append(string2.substring(n5));
                    }
                    string = stringBuffer.toString();
                    timestamp = Timestamp.valueOf(string);
                } else if (this.resultset != null) {
                    this.resultset.nullTag = false;
                }
            }
            object = timestamp;
        }
        catch (Throwable throwable) {
            Object var13_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getTimestamp(...)", timestamp == null ? "NULL" : timestamp.toString());
            throw throwable;
        }
        Object var13_7 = null;
        if (!DB2Trace.TraceOn) return object;
        DB2Trace.methodExit((Object)this, "getTimestamp(...)", timestamp == null ? "NULL" : timestamp.toString());
        return object;
    }

    protected BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        BigDecimal bigDecimal = null;
        switch (this.sqltype[n2]) {
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                bigDecimal = this.getDecimalValueData(n2);
                break;
            }
            default: {
                Object object = this.getObject(n2);
                String string = object.toString();
                if (string != null) {
                    try {
                        string = DB2ResultSet.cvtScientific(string);
                        bigDecimal = new BigDecimal(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.sqlExcptGen.rsException("22005");
                    }
                    break;
                }
                if (this.resultset == null) break;
                this.resultset.nullTag = false;
            }
        }
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getObject(int n2) throws SQLException {
        Object var15_32;
        block35: {
            URL uRL;
            block34: {
                DB2Clob dB2Clob;
                block33: {
                    DB2Blob dB2Blob;
                    block32: {
                        Timestamp timestamp;
                        block31: {
                            Time time;
                            block30: {
                                Date date;
                                block29: {
                                    byte[] byArray;
                                    block28: {
                                        Double d2;
                                        block27: {
                                            Float f2;
                                            block26: {
                                                Long l2;
                                                block25: {
                                                    Integer n3;
                                                    block24: {
                                                        BigDecimal bigDecimal;
                                                        block23: {
                                                            String string;
                                                            block22: {
                                                                Object var2_2;
                                                                block21: {
                                                                    try {
                                                                        if (DB2Trace.TraceOn) {
                                                                            DB2Trace.methodEntry(this, "getObject( " + n2 + " )");
                                                                        }
                                                                        if (this.elementIsNull(n2)) {
                                                                            if (this.resultset != null) {
                                                                                this.resultset.nullTag = true;
                                                                            }
                                                                            var2_2 = null;
                                                                            Object var17_4 = null;
                                                                            if (!DB2Trace.TraceOn) return var2_2;
                                                                            break block21;
                                                                        }
                                                                        if (this.resultset != null) {
                                                                            this.resultset.nullTag = false;
                                                                        }
                                                                        switch (this.sqltype[n2]) {
                                                                            case -97: 
                                                                            case -96: 
                                                                            case -95: 
                                                                            case -10: 
                                                                            case -9: 
                                                                            case -8: 
                                                                            case -1: 
                                                                            case 1: 
                                                                            case 12: {
                                                                                string = this.getStringValueData(n2);
                                                                                break block22;
                                                                            }
                                                                            case 2: 
                                                                            case 3: {
                                                                                bigDecimal = this.getDecimalValueData(n2);
                                                                                break block23;
                                                                            }
                                                                            case 4: 
                                                                            case 5: {
                                                                                n3 = new Integer((int)this.getLongValueData(n2));
                                                                                break block24;
                                                                            }
                                                                            case -5: {
                                                                                l2 = new Long(this.getLongValueData(n2));
                                                                                break block25;
                                                                            }
                                                                            case 7: {
                                                                                f2 = new Float(this.getFloatValueData(n2));
                                                                                break block26;
                                                                            }
                                                                            case 6: 
                                                                            case 8: {
                                                                                d2 = new Double(this.getDoubleValueData(n2));
                                                                                break block27;
                                                                            }
                                                                            case -4: 
                                                                            case -3: 
                                                                            case -2: {
                                                                                byArray = this.getBytesValueData(n2);
                                                                                break block28;
                                                                            }
                                                                            case 91: {
                                                                                date = this.getDate(n2, Calendar.getInstance());
                                                                                break block29;
                                                                            }
                                                                            case 92: {
                                                                                time = this.getTime(n2, Calendar.getInstance());
                                                                                break block30;
                                                                            }
                                                                            case 93: {
                                                                                timestamp = this.getTimestamp(n2, Calendar.getInstance());
                                                                                break block31;
                                                                            }
                                                                            case -98: 
                                                                            case 31: {
                                                                                dB2Blob = this.getBlob(n2);
                                                                                break block32;
                                                                            }
                                                                            case -351: 
                                                                            case -350: 
                                                                            case -99: 
                                                                            case 41: {
                                                                                dB2Clob = this.getClob(n2);
                                                                                break block33;
                                                                            }
                                                                            case -400: 
                                                                            case 70: {
                                                                                uRL = this.getURL(n2);
                                                                                break block34;
                                                                            }
                                                                            default: {
                                                                                this.sqlExcptGen.rsException("22005");
                                                                                var15_32 = null;
                                                                                break;
                                                                            }
                                                                        }
                                                                        break block35;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        Object var17_19 = null;
                                                                        if (!DB2Trace.TraceOn) throw throwable;
                                                                        DB2Trace.methodExit(this, "getObject()");
                                                                        throw throwable;
                                                                    }
                                                                }
                                                                DB2Trace.methodExit(this, "getObject()");
                                                                return var2_2;
                                                            }
                                                            Object var17_5 = null;
                                                            if (!DB2Trace.TraceOn) return string;
                                                            DB2Trace.methodExit(this, "getObject()");
                                                            return string;
                                                        }
                                                        Object var17_6 = null;
                                                        if (!DB2Trace.TraceOn) return bigDecimal;
                                                        DB2Trace.methodExit(this, "getObject()");
                                                        return bigDecimal;
                                                    }
                                                    Object var17_7 = null;
                                                    if (!DB2Trace.TraceOn) return n3;
                                                    DB2Trace.methodExit(this, "getObject()");
                                                    return n3;
                                                }
                                                Object var17_8 = null;
                                                if (!DB2Trace.TraceOn) return l2;
                                                DB2Trace.methodExit(this, "getObject()");
                                                return l2;
                                            }
                                            Object var17_9 = null;
                                            if (!DB2Trace.TraceOn) return f2;
                                            DB2Trace.methodExit(this, "getObject()");
                                            return f2;
                                        }
                                        Object var17_10 = null;
                                        if (!DB2Trace.TraceOn) return d2;
                                        DB2Trace.methodExit(this, "getObject()");
                                        return d2;
                                    }
                                    Object var17_11 = null;
                                    if (!DB2Trace.TraceOn) return byArray;
                                    DB2Trace.methodExit(this, "getObject()");
                                    return byArray;
                                }
                                Object var17_12 = null;
                                if (!DB2Trace.TraceOn) return date;
                                DB2Trace.methodExit(this, "getObject()");
                                return date;
                            }
                            Object var17_13 = null;
                            if (!DB2Trace.TraceOn) return time;
                            DB2Trace.methodExit(this, "getObject()");
                            return time;
                        }
                        Object var17_14 = null;
                        if (!DB2Trace.TraceOn) return timestamp;
                        DB2Trace.methodExit(this, "getObject()");
                        return timestamp;
                    }
                    Object var17_15 = null;
                    if (!DB2Trace.TraceOn) return dB2Blob;
                    DB2Trace.methodExit(this, "getObject()");
                    return dB2Blob;
                }
                Object var17_16 = null;
                if (!DB2Trace.TraceOn) return dB2Clob;
                DB2Trace.methodExit(this, "getObject()");
                return dB2Clob;
            }
            Object var17_17 = null;
            if (!DB2Trace.TraceOn) return uRL;
            DB2Trace.methodExit(this, "getObject()");
            return uRL;
        }
        Object var17_18 = null;
        if (!DB2Trace.TraceOn) return var15_32;
        DB2Trace.methodExit(this, "getObject()");
        return var15_32;
    }

    private long getLongValueData(int n2) {
        return this.getElement((int)n2).lValue;
    }

    private double getDoubleValueData(int n2) {
        return this.getElement((int)n2).dValue;
    }

    private float getFloatValueData(int n2) {
        return this.getElement((int)n2).fValue;
    }

    private String getStringValueData(int n2) {
        return (String)this.getElement((int)n2).oValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDataAsString(int n2) throws SQLException {
        String string;
        String string2 = "";
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDataAsString( " + n2 + " )");
                DB2Trace.data(10, "sqltype", this.sqltype[n2]);
            }
            switch (this.sqltype[n2]) {
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = (byte[])this.getElement((int)n2).oValue;
                    StringBuffer stringBuffer = new StringBuffer("");
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        byte by = byArray[n3];
                        String string3 = Integer.toHexString(by).toUpperCase();
                        int n4 = string3.length();
                        if (n4 == 1) {
                            stringBuffer.append("0");
                        } else if (n4 > 2) {
                            string3 = string3.substring(n4 - 2);
                        }
                        stringBuffer.append(string3);
                        ++n3;
                    }
                    string2 = stringBuffer.toString();
                    break;
                }
                case 91: {
                    Date date = this.getDate(n2, Calendar.getInstance());
                    if (this.resultset.wasNull()) break;
                    StringBuffer stringBuffer = new StringBuffer("");
                    String string4 = date.toString();
                    int n5 = string4.indexOf(45);
                    if (n5 < 4) {
                        switch (n5) {
                            case 1: {
                                stringBuffer.append("000");
                                break;
                            }
                            case 2: {
                                stringBuffer.append("00");
                                break;
                            }
                            case 3: {
                                stringBuffer.append("0");
                            }
                        }
                    }
                    stringBuffer.append(string4);
                    stringBuffer.setLength(10);
                    string2 = stringBuffer.toString();
                    break;
                }
                case 92: {
                    Time time = this.getTime(n2, Calendar.getInstance());
                    if (this.resultset.wasNull()) break;
                    string2 = time.toString();
                    break;
                }
                case 93: {
                    Timestamp timestamp = this.getTimestamp(n2, Calendar.getInstance());
                    if (this.resultset.wasNull()) break;
                    StringBuffer stringBuffer = new StringBuffer("");
                    String string5 = timestamp.toString();
                    int n6 = string5.indexOf(45);
                    if (n6 < 4) {
                        switch (n6) {
                            case 1: {
                                stringBuffer.append("000");
                                break;
                            }
                            case 2: {
                                stringBuffer.append("00");
                                break;
                            }
                            case 3: {
                                stringBuffer.append("0");
                            }
                        }
                    }
                    stringBuffer.append(string5);
                    stringBuffer.append("000000");
                    stringBuffer.setLength(26);
                    string2 = stringBuffer.toString();
                    break;
                }
                default: {
                    string2 = this.getElement(n2).toString();
                }
            }
            string = string2;
            Object var14_19 = null;
            if (!DB2Trace.TraceOn) return string;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDataAsString()", string2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getDataAsString()", string2);
        return string;
    }

    private byte[] getBytesValueData(int n2) {
        byte[] byArray = (byte[])this.getElement((int)n2).oValue;
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    private byte getByteValueData(int n2) {
        byte[] byArray = (byte[])this.getElement((int)n2).oValue;
        return byArray[0];
    }

    private BigDecimal getDecimalValueData(int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        String string = this.getElement(n2).toString();
        try {
            string = DB2ResultSet.cvtScientific(string);
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.sqlExcptGen.rsException("22005");
        }
        return bigDecimal;
    }

    protected InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = null;
        String string = null;
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n2]) {
            case -351: 
            case -350: 
            case -99: 
            case 41: {
                int n3 = this.sqltype[n2];
                if (-99 == this.sqltype[n2]) {
                    n3 = 41;
                } else if (-350 == this.sqltype[n2]) {
                    n3 = -351;
                }
                int n4 = (int)this.getElement((int)n2).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n4, n3, false);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -98: 
            case 31: {
                int n5 = (int)this.getElement((int)n2).lValue;
                inputStream = new DB2Binary2AsciiInputStream(this.resultset.statement, n5, 31);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = (String)this.getElement((int)n2).oValue;
                break;
            }
            default: {
                string = this.getDataAsString(n2);
            }
        }
        if (inputStream == null) {
            inputStream = string == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(string.getBytes());
        }
        return inputStream;
    }

    protected InputStream getUnicodeStream(int n2) throws SQLException {
        InputStream inputStream = null;
        String string = null;
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n2]) {
            case -351: 
            case -350: 
            case -99: 
            case 41: {
                int n3 = this.sqltype[n2];
                if (-99 == this.sqltype[n2]) {
                    n3 = 41;
                } else if (-350 == this.sqltype[n2]) {
                    n3 = -351;
                }
                int n4 = (int)this.getElement((int)n2).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n4, n3, true);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -98: 
            case 31: {
                int n5 = (int)this.getElement((int)n2).lValue;
                inputStream = new DB2Binary2AsciiInputStream(this.resultset.statement, n5, 31);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            case -97: 
            case -96: 
            case -95: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = (String)this.getElement((int)n2).oValue;
                break;
            }
            default: {
                string = this.getDataAsString(n2);
            }
        }
        if (inputStream == null) {
            if (string == null) {
                inputStream = new ByteArrayInputStream(new byte[0]);
            } else {
                try {
                    inputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.toString());
                }
            }
        }
        return inputStream;
    }

    protected InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        switch (this.sqltype[n2]) {
            case -351: 
            case -350: 
            case -99: 
            case -98: 
            case 31: 
            case 41: {
                int n3 = this.sqltype[n2];
                if (-99 == this.sqltype[n2]) {
                    n3 = 41;
                } else if (-98 == this.sqltype[n2]) {
                    n3 = 31;
                } else if (-350 == this.sqltype[n2]) {
                    n3 = -351;
                }
                int n4 = (int)this.getElement((int)n2).lValue;
                inputStream = new DB2InputStream(this.resultset.statement, n4, n3, false);
                this.resultset.addIsList((DB2InputStream)inputStream);
                break;
            }
            default: {
                inputStream = new ByteArrayInputStream(this.getBytes(n2));
            }
        }
        return inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int fetchScroll(int n2) throws SQLException {
        int n3;
        int n4 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "fetchScroll( " + n2 + " )");
            }
            this.resultset.clearWarnings();
            if (this.cleared) {
                this.activate();
            }
            int n5 = ((DB2ScrollableResultSet)this.resultset).getNumRows();
            if (n2 < 1) {
                this.currentRow = 0;
            } else if (n2 > n5) {
                this.currentRow = n5 + 1;
            } else if (n2 >= this.firstFetchedRow && n2 <= this.firstFetchedRow + this.numFetchedRows - 1) {
                this.currentRow = n2;
            } else {
                n3 = 0;
                int n6 = 1;
                boolean bl = false;
                int n7 = 0;
                int n8 = 0;
                this.currentRow = n2;
                if (this.unboundColumns) {
                    n6 = 1;
                } else if (this.resultset.fetchSize > 0) {
                    n6 = this.resultset.fetchSize;
                } else if (this.statement.CLIBlockSize > 0) {
                    n6 = this.statement.CLIBlockSize;
                }
                if (1 == n6) {
                    n3 = n2;
                } else if (n6 >= n5) {
                    n3 = 1;
                } else if (1001 == this.resultset.fetchDirection) {
                    n3 = n2 - n6 + 1;
                    if (n3 < 1) {
                        n3 = 1;
                    }
                } else {
                    n3 = n2;
                    if (n3 + n6 - 1 > n5) {
                        n3 = n5 - n6 + 1;
                    }
                }
                if (this.fetchedRows != null) {
                    int n9 = n3 + n6 - 1;
                    int n10 = this.firstFetchedRow + this.numFetchedRows - 1;
                    if (n3 >= this.firstFetchedRow && n3 <= n10) {
                        n7 = n10 - n3 + 1;
                        n3 += n7;
                        n6 -= n7;
                    } else if (n9 >= this.firstFetchedRow && n9 <= n10) {
                        n8 = n9 - this.firstFetchedRow + 1;
                        n6 -= n8;
                    }
                }
                try {
                    DB2Request dB2Request = this.db2req;
                    synchronized (dB2Request) {
                        this.db2req.write((short)203);
                        this.db2req.write(this.resultset.stmtHandle);
                        this.db2req.write(n3);
                        this.db2req.write(n6);
                        this.db2req.sendAndRecv();
                        n4 = this.getDataFromBuffer(n3, n6, n7, n8);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            n3 = n4;
            Object var13_14 = null;
            if (!DB2Trace.TraceOn) return n3;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "currentRow", this.currentRow);
            DB2Trace.methodExit((Object)this, "fetchScroll()", n4);
            throw throwable;
        }
        DB2Trace.data(100, "currentRow", this.currentRow);
        DB2Trace.methodExit((Object)this, "fetchScroll()", n4);
        return n3;
    }

    protected int previous() throws SQLException {
        return this.fetchScroll(this.currentRow - 1);
    }

    protected int absolute(int n2) throws SQLException {
        return this.fetchScroll(n2);
    }

    protected int relative(int n2) throws SQLException {
        return this.fetchScroll(this.currentRow + n2);
    }

    protected int first() throws SQLException {
        return this.fetchScroll(1);
    }

    protected Reader getCharacterStream(int n2) throws SQLException {
        Reader reader = null;
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        short s2 = this.sqltype[n2];
        int n3 = 41;
        if (-99 == s2 || -350 == s2) {
            switch (s2) {
                case -99: {
                    n3 = 41;
                    break;
                }
                case -350: {
                    n3 = -351;
                }
            }
            int n4 = (int)this.getElement((int)n2).lValue;
            reader = new DB2CharReader(this.resultset.statement, n4, n3);
        } else {
            String string = this.resultset.getString(n2 + 1);
            if (this.resultset.nullTag) {
                return null;
            }
            if (string == null) {
                return new StringReader(new String());
            }
            reader = new StringReader(string);
        }
        return reader;
    }

    protected DB2Clob getClob(int n2) throws SQLException {
        DB2Clob dB2Clob = null;
        if (this instanceof DB2OutputParameters) {
            String string = this.getString(n2);
            if (null == string) {
                return null;
            }
            dB2Clob = new DB2Clob(string);
        } else {
            if (this.elementIsNull(n2)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                return null;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            short s2 = this.sqltype[n2];
            int n3 = 41;
            if (-99 == s2 || -350 == s2) {
                switch (s2) {
                    case -99: {
                        n3 = 41;
                        break;
                    }
                    case -350: {
                        n3 = -351;
                    }
                }
                int n4 = (int)this.getElement((int)n2).lValue;
                dB2Clob = new DB2Clob(this.resultset.statement, n4, n3);
            }
        }
        return dB2Clob;
    }

    protected DB2Blob getBlob(int n2) throws SQLException {
        DB2Blob dB2Blob = null;
        if (this instanceof DB2OutputParameters) {
            byte[] byArray = this.getBytes(n2);
            if (null == byArray) {
                return null;
            }
            dB2Blob = new DB2Blob(byArray);
        } else {
            if (this.elementIsNull(n2)) {
                if (this.resultset != null) {
                    this.resultset.nullTag = true;
                }
                return null;
            }
            if (this.resultset != null) {
                this.resultset.nullTag = false;
            }
            int n3 = (int)this.getElement((int)n2).lValue;
            dB2Blob = new DB2Blob(this.resultset.statement, n3);
        }
        return dB2Blob;
    }

    protected URL getURL(int n2) throws SQLException {
        if (this.elementIsNull(n2)) {
            if (this.resultset != null) {
                this.resultset.nullTag = true;
            }
            return null;
        }
        if (this.resultset != null) {
            this.resultset.nullTag = false;
        }
        try {
            return new URL((String)this.getElement((int)n2).oValue);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.getMessage());
        }
    }
}

