/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DB2ResultSetMetaData
implements ResultSetMetaData {
    protected DB2Statement statement;
    protected DB2ResultSet resultset;
    protected DB2Request db2req;
    protected boolean mappedRS = false;
    protected int arrayLen = 0;
    protected int colCount;
    protected String[] colNames = null;
    protected int[] colTypes = null;
    protected int[] colBaseTypesNotAdjusted = null;
    protected int[] precisions = null;
    protected int[] scales = null;
    protected boolean gotColCount = false;

    public DB2ResultSetMetaData(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet, int n2, boolean bl) throws SQLException {
        this.statement = dB2Statement;
        this.resultset = dB2ResultSet;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(this.statement.db2req) : new DB2RequestTrace(this.statement.db2req);
        this.mappedRS = bl;
        if (n2 > 0) {
            this.activate(dB2Statement.colCount);
        } else if (dB2Statement instanceof DB2PreparedStatement && (24 == ((DB2PreparedStatement)dB2Statement).statementType || 27 == ((DB2PreparedStatement)dB2Statement).statementType) && !this.gotColCount) {
            n2 = this.getColumnCount();
            this.activate(n2);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "rsMetaData - numCols ", n2);
            DB2Trace.data(10, "rsMetaData - colCount ", this.colCount);
            DB2Trace.data(10, "rsMetaData - gotColCount ", String.valueOf(this.gotColCount));
        }
        this.colCount = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void activate(int n2) throws SQLException {
        block15: {
            block14: {
                block13: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "activate( " + n2 + " )");
                            DB2Trace.data(10, "arrayLen ", this.arrayLen);
                        }
                        if (n2 < 0) {
                            Object var5_2 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block13;
                        }
                        this.colCount = n2;
                        if (n2 > this.arrayLen) {
                            this.arrayLen = n2;
                            this.colTypes = new int[n2];
                            this.colBaseTypesNotAdjusted = new int[n2];
                            this.precisions = new int[n2];
                            this.scales = new int[n2];
                            this.colNames = new String[n2];
                            this.resultset.preFetched = new boolean[n2];
                        }
                        if (n2 < 1) {
                            break block14;
                        }
                        try {
                            this.db2req.write((short)90);
                            this.db2req.write(this.statement.statementHandle);
                            this.db2req.sendAndRecv();
                            int n3 = this.db2req.readInt();
                            if (n3 != 0) {
                                if (n3 != -99) {
                                    this.statement.sqlExcptGen.check_return_code(this.statement, n3);
                                }
                                int n4 = 0;
                                while (true) {
                                    if (n4 >= n2) break;
                                    this.resultset.preFetched[n4] = false;
                                    this.colTypes[n4] = -99999;
                                    this.colBaseTypesNotAdjusted[n4] = -99999;
                                    this.precisions[n4] = 0;
                                    this.scales[n4] = 0;
                                    this.colNames[n4] = "";
                                    ++n4;
                                }
                                Object var5_4 = null;
                                if (!DB2Trace.TraceOn) return;
                                DB2Trace.methodExit(this, "activate()");
                                return;
                            }
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "rc ", n3);
                            }
                            int n5 = 0;
                            while (n5 < n2) {
                                this.resultset.preFetched[n5] = this.db2req.readBoolean();
                                this.colTypes[n5] = this.db2req.readShort();
                                this.colBaseTypesNotAdjusted[n5] = this.db2req.readShort();
                                this.precisions[n5] = this.db2req.readInt();
                                this.scales[n5] = this.db2req.readShort();
                                this.colNames[n5] = this.db2req.readString();
                                ++n5;
                            }
                            break block15;
                        }
                        catch (IOException iOException) {
                            this.statement.sqlExcptGen.socketException("08S01a");
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "activate()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "activate()");
                return;
            }
            Object var5_3 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "activate()");
            return;
        }
        Object var5_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "activate()");
    }

    protected String SQLColAttributes_str(int n2, int n3) throws SQLException {
        n2 = this.resultset.getMappedColumn(n2);
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)91);
                this.db2req.write(this.statement.statementHandle);
                this.db2req.write(n2);
                this.db2req.write(n3);
                this.db2req.sendAndRecv();
                int n4 = this.db2req.readInt();
                if (n4 != 1 && n4 != 0) {
                    this.statement.sqlExcptGen.check_return_code(this.statement, n4);
                }
                string = this.db2req.readString();
            }
        }
        catch (IOException iOException) {
            this.statement.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    protected int SQLColAttributes_int(int n2, int n3) throws SQLException {
        n2 = this.resultset.getMappedColumn(n2);
        int n4 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)92);
                this.db2req.write(this.statement.statementHandle);
                this.db2req.write(n2);
                this.db2req.write(n3);
                this.db2req.sendAndRecv();
                int n5 = this.db2req.readInt();
                if (n5 != 1 && n5 != 0) {
                    this.statement.sqlExcptGen.check_return_code(this.statement, n5);
                }
                n4 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.statement.sqlExcptGen.socketException("08S01a");
        }
        return n4;
    }

    public int getColumnCount() throws SQLException {
        if (this.statement.connection == null || this.statement.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.statement.sqlExcptGen.throwClosedError();
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "gotColCount ", String.valueOf(this.gotColCount));
            DB2Trace.data(10, "colCount ", this.colCount);
        }
        if (this.gotColCount) {
            return this.colCount;
        }
        if (!this.mappedRS) {
            if (this.colCount == 0) {
                this.colCount = this.SQLColAttributes_int(1, 0);
                this.gotColCount = true;
            }
            return this.colCount;
        }
        return this.resultset.getColumnCount();
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 11);
        return 1 == n3;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 12);
        return 1 == n3;
    }

    public boolean isSearchable(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 13);
        return 0 != n3;
    }

    public boolean isCurrency(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 9);
        return 1 == n3;
    }

    public int isNullable(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 7);
        if (1 == n3) {
            return 1;
        }
        if (0 == n3) {
            return 0;
        }
        return 2;
    }

    public boolean isSigned(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 8);
        return 1 != n3;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        return this.SQLColAttributes_int(n2, 6);
    }

    public String getColumnLabel(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        return this.SQLColAttributes_str(n2, 18);
    }

    public String getColumnName(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        String string = null;
        if (null != this.resultset && null != this.resultset.mappedColumnNames && this.resultset.mappedColumnNames.length >= n2 && null != this.resultset.mappedColumnNames[n2 - 1]) {
            return this.resultset.mappedColumnNames[n2 - 1];
        }
        string = this.colNames != null ? this.colNames[n2 - 1] : this.SQLColAttributes_str(n2, 1);
        return string;
    }

    public String getSchemaName(int n2) throws SQLException {
        String string = this.SQLColAttributes_str(n2 = this.checkColumnIndex(n2), 16);
        if (string == null) {
            return new String("");
        }
        return string;
    }

    public int getPrecision(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        if (this.precisions != null) {
            return this.precisions[n2 - 1];
        }
        return this.SQLColAttributes_int(n2, 4);
    }

    public int getScale(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        if (this.scales != null) {
            return this.scales[n2 - 1];
        }
        return this.SQLColAttributes_int(n2, 5);
    }

    public String getTableName(int n2) throws SQLException {
        String string = this.SQLColAttributes_str(n2 = this.checkColumnIndex(n2), 15);
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public String getCatalogName(int n2) throws SQLException {
        String string = this.SQLColAttributes_str(n2 = this.checkColumnIndex(n2), 17);
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public int getColumnType(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        return this.resultset.connection.adjust(this.colTypes[n2 - 1]);
    }

    public String getColumnTypeName(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        return this.SQLColAttributes_str(n2, 14);
    }

    public boolean isReadOnly(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 10);
        return 0 == n3;
    }

    public boolean isWritable(int n2) throws SQLException {
        int n3 = this.SQLColAttributes_int(n2 = this.checkColumnIndex(n2), 10);
        return 0 != n3;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        n2 = this.checkColumnIndex(n2);
        return false;
    }

    protected int checkColumnIndex(int n2) throws SQLException {
        if (this.statement.connection == null || this.statement.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.statement.sqlExcptGen.throwClosedError();
        }
        if (!this.mappedRS) {
            if (n2 < 1 || n2 > this.colCount) {
                this.statement.sqlExcptGen.throwColumnIndexError();
            }
            return n2;
        }
        return this.resultset.getMappedColumn(n2);
    }

    public String getColumnClassName(int n2) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getColumnClassName( " + n2 + " )");
        }
        if (this.statement.connection == null || this.statement.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.statement.sqlExcptGen.throwClosedError();
        }
        String string = null;
        int n3 = this.resultset.connection.adjust(this.colBaseTypesNotAdjusted[n2 - 1]);
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "colBaseType", n3);
        }
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "[B";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case 70: {
                string = "java.net.URL";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2001: {
                string = "java.sql.Distinct";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                this.statement.sqlExcptGen.rsException("S1004");
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "getColumnClassName()", string);
        }
        return string;
    }
}

