/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.net.DB2ResultSetMetaDataTrace;
import COM.ibm.db2.jdbc.net.DB2RowObject;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJResultSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2ResultSet
implements ResultSet,
SQLJResultSet {
    protected Hashtable name2Index;
    protected DB2ResultSetMetaData rsMetaData;
    protected DB2Statement statement;
    protected DB2RowObject rowObj = null;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected int stmtHandle;
    protected boolean nullTag = true;
    protected boolean closed = false;
    protected Vector isList = new Vector();
    protected int colCount;
    protected boolean mappedRS = false;
    protected DB2Connection connection;
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int nano = 0;
    protected String[] mappedColumnNames = null;
    protected boolean[] preFetched = null;
    protected int SQL_NULL_DATA = -1;
    protected int fetchSize = 0;
    protected int currentRowId = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int fetchDirection = 1000;

    public DB2ResultSet(DB2Statement dB2Statement, int n2, boolean bl) throws SQLException {
        this.mappedRS = bl;
        this.statement = dB2Statement;
        this.db2req = dB2Statement.db2req;
        this.sqlExcptGen = dB2Statement.sqlExcptGen;
        this.stmtHandle = this.statement.statementHandle;
        this.colCount = n2;
        this.rowObj = new DB2RowObject(this);
        this.connection = dB2Statement.getDB2Connection();
        this.fetchSize = this.statement.fetchSize;
        this.fetchDirection = this.statement.fetchDirection;
        this.rsMetaData = !DB2Trace.TraceOn ? new DB2ResultSetMetaData(this.statement, this, this.colCount, this.mappedRS) : new DB2ResultSetMetaDataTrace(this.statement, this, this.colCount, this.mappedRS);
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n2) throws SQLException {
        this(dB2Statement, n2, false);
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n2, String[] stringArray) throws SQLException {
        this(dB2Statement, n2, false);
        this.mappedColumnNames = stringArray;
    }

    protected int getColumnCount() throws SQLException {
        return this.colCount;
    }

    protected void addIsList(DB2InputStream dB2InputStream) {
        if (dB2InputStream != null) {
            this.isList.addElement(dB2InputStream);
        }
    }

    protected void clearIsList() throws SQLException {
        if (this.isList.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.isList.elements();
        while (enumeration.hasMoreElements()) {
            DB2InputStream dB2InputStream = (DB2InputStream)enumeration.nextElement();
            dB2InputStream.close();
        }
        this.isList.removeAllElements();
    }

    protected void checkHandlesAndIndex(int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 != Integer.MAX_VALUE && (n2 < 1 || n2 > this.colCount)) {
            this.sqlExcptGen.throwColumnIndexError();
        }
    }

    public boolean next() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        boolean bl = false;
        this.clearIsList();
        this.clearWarnings();
        int n2 = this.rowObj.forwardOnlyNext();
        if (0 == n2) {
            bl = true;
            ++this.currentRowId;
        } else if (100 == n2) {
            bl = false;
            this.currentRowId = 0;
        } else {
            this.sqlExcptGen.check_return_code(this.statement, n2);
            bl = true;
            ++this.currentRowId;
        }
        return bl;
    }

    public void close() throws SQLException {
        if (!this.closed && this.statement != null && !this.statement.closed) {
            this.statement.getMoreResults();
            if (this.statement.moreResults) {
                this.statement.prefetchedMoreResults = true;
                this.closed = true;
            } else {
                this.realClose();
            }
        }
    }

    protected void realClose() throws SQLException {
        this.closed = true;
        if (null == this.statement) {
            if (DB2Trace.TraceOn) {
                DB2Trace.data(5, "statement is null");
            }
            return;
        }
        DB2Statement dB2Statement = this.statement;
        synchronized (dB2Statement) {
            if (this.statement.closed) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "statement is closed");
                }
                return;
            }
            if (null == this.connection) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "connection is null");
                }
                return;
            }
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                if (this.connection.closed) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(25, "connection is closed");
                    }
                    return;
                }
                this.clearIsList();
                if (this.statement.internalStmt) {
                    this.statement.close();
                } else {
                    this.rowObj.reset();
                    try {
                        DB2Request dB2Request = this.db2req;
                        synchronized (dB2Request) {
                            this.db2req.write((short)48);
                            this.db2req.write(this.stmtHandle);
                            this.db2req.sendAndRecv();
                            int n2 = this.db2req.readInt();
                            this.statement.prefetchedMoreResults = false;
                        }
                    }
                    catch (IOException iOException) {
                        this.sqlExcptGen.socketException("08S01a");
                    }
                }
            }
        }
    }

    protected void reset(int n2) throws SQLException {
        this.clearIsList();
        this.colCount = n2;
        this.nullTag = true;
        this.closed = false;
        this.name2Index = null;
        this.rowObj.reset();
        this.rsMetaData.activate(n2);
        this.mappedRS = false;
        this.fetchSize = this.statement.fetchSize;
        this.fetchDirection = this.statement.fetchDirection;
    }

    public boolean wasNull() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        return this.nullTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(int n2) throws SQLException {
        Object object;
        String string = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getString( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            string = this.preFetched[n3] ? this.rowObj.getString(n3) : this.getStringData(n2);
            if (!this.nullTag && this.rsMetaData.colTypes[n3] == -400) {
                object = new StringTokenizer(string, ",");
                String string2 = ((StringTokenizer)object).nextToken();
                string2 = ((StringTokenizer)object).nextToken();
                string2 = ((StringTokenizer)object).nextToken();
                int n4 = Integer.parseInt(string2);
                int n5 = string.lastIndexOf(44) + 1;
                string = string.substring(n5, n5 + n4);
            }
            if (!(this.nullTag || this.statement.maxFieldSize == 0 || string.length() <= this.statement.maxFieldSize || this.rowObj.sqltype[n3] != 1 && this.rowObj.sqltype[n3] != 12 && this.rowObj.sqltype[n3] != -1 && this.rowObj.sqltype[n3] != -2 && this.rowObj.sqltype[n3] != -3 && this.rowObj.sqltype[n3] != -4 && this.rowObj.sqltype[n3] != -95 && this.rowObj.sqltype[n3] != -96 && this.rowObj.sqltype[n3] != -97)) {
                string = string.substring(0, this.statement.maxFieldSize);
            }
            object = string;
            Object var9_8 = null;
            if (!DB2Trace.TraceOn) return object;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getString()", string);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getString()", string);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(int n2) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            String string;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBoolean( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            bl2 = this.preFetched[n3] ? this.rowObj.getBoolean(n3) : (this.rowObj.sqltype[n3] == 1 || this.rowObj.sqltype[n3] == 12 || this.rowObj.sqltype[n3] == -1 || this.rowObj.sqltype[n3] == -99 ? ((string = this.getString(n2)) == null ? false : ((string = string.trim()).equals("1") ? true : new Boolean(string))) : this.getBooleanData(n2));
            bl = bl2;
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getBoolean()", bl2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getBoolean()", bl2);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte getByte(int n2) throws SQLException {
        byte by;
        byte by2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getByte( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            by2 = this.preFetched[n3] ? this.rowObj.getByte(n3) : this.getByteData(n2);
            by = by2;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return by;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getByte()", by2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getByte()", by2);
        return by;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getShort(int n2) throws SQLException {
        short s2;
        short s3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getShort( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            s3 = this.preFetched[n3] ? this.rowObj.getShort(n3) : this.getShortData(n2);
            s2 = s3;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return s2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getShort()", s3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getShort()", s3);
        return s2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(int n2) throws SQLException {
        int n3;
        int n4 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getInt( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n5 = n2 - 1;
            n4 = this.preFetched[n5] ? this.rowObj.getInt(n5) : this.getIntData(n2);
            n3 = n4;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return n3;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getInt()", n4);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getInt()", n4);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(int n2) throws SQLException {
        long l2;
        long l3 = 0L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getLong( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            l3 = this.preFetched[n3] ? this.rowObj.getLong(n3) : this.getLongData(n2);
            l2 = l3;
            Object var8_5 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getLong()", l3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getLong()", l3);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat(int n2) throws SQLException {
        float f2;
        float f3 = 0.0f;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFloat( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            f3 = this.preFetched[n3] ? this.rowObj.getFloat(n3) : this.getFloatData(n2);
            f2 = f3;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return f2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getFloat()", f3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getFloat()", f3);
        return f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble(int n2) throws SQLException {
        double d2;
        double d3 = 0.0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDouble( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            d3 = this.preFetched[n3] ? this.rowObj.getDouble(n3) : this.getDoubleData(n2);
            d2 = d3;
            Object var8_5 = null;
            if (!DB2Trace.TraceOn) return d2;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDouble()", d3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getDouble()", d3);
        return d2;
    }

    protected static String cvtScientific(String string) throws NumberFormatException {
        char c2;
        if (null == string) {
            return string;
        }
        int n2 = string.length();
        if (0 == n2) {
            return string;
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        while (n7 < n2) {
            c2 = string.charAt(n7);
            if (n3 < 0) {
                if (!Character.isWhitespace(c2)) {
                    n3 = n6 = n7;
                    if ('.' == c2 || ',' == c2) {
                        n4 = n7;
                    }
                }
            } else if (n4 < 0 && n5 < 0 && (',' == c2 || '.' == c2)) {
                n4 = n6 = n7;
            } else if (n5 < 0 && ('e' == c2 || 'E' == c2)) {
                n5 = n6 = n7;
            } else if (!Character.isWhitespace(c2)) {
                n6 = n7;
            }
            ++n7;
        }
        if (n3 < 0) {
            return "";
        }
        if (n5 < 0) {
            if (n3 > 0 || n6 < n2 - 1) {
                string = string.substring(n3, n6 + 1);
            }
            if (n4 >= 0 && string.charAt(n4) == ',') {
                string = string.replace(',', '.');
            }
        } else {
            int n8 = 1;
            int n9 = 0;
            n7 = n5 + 1;
            c2 = string.charAt(n7);
            if ('-' == c2) {
                n8 = -1;
                ++n7;
            } else if ('+' == c2) {
                ++n7;
            }
            while (n7 <= n6) {
                if (!Character.isDigit(c2 = string.charAt(n7++))) {
                    throw new NumberFormatException();
                }
                n9 = n9 * 10 + Character.digit(c2, 10);
            }
            n9 *= n8;
            if (n4 >= 0) {
                n9 -= n5 - n4 - 1;
            }
            if ('-' == (c2 = string.charAt(n3))) {
                n8 = -1;
                ++n3;
            } else if ('+' == c2) {
                n8 = 1;
                ++n3;
            } else {
                n8 = 1;
            }
            int n10 = n5 - n3 - (n4 >= 0 ? 1 : 0);
            int n11 = 0;
            int n12 = -1;
            int n13 = 0;
            if (n9 >= 0) {
                n12 = -1;
                n11 = 0;
                n13 = n10 + n9;
            } else if (n9 < 0 && -n9 >= n10) {
                n12 = 0;
                n11 = -n9 - n10 + 1;
                n13 = n11 + n10;
            } else {
                n12 = n10 + n9;
                n11 = 0;
                n13 = n10 + 1;
            }
            if (n8 < 0) {
                if (n12 >= 0) {
                    ++n12;
                }
                ++n11;
                ++n13;
            }
            char[] cArray = new char[n13];
            n7 = 0;
            while (n7 < n13) {
                cArray[n7] = 48;
                ++n7;
            }
            if (n8 < 0) {
                cArray[0] = 45;
            }
            if (n12 >= 0) {
                cArray[n12] = 46;
            }
            n7 = n11;
            int n14 = n3;
            while (n14 < n5) {
                if (n14 == n4 && ++n14 >= n5) break;
                if (n7 == n12) {
                    ++n7;
                }
                cArray[n7] = string.charAt(n14);
                ++n7;
                ++n14;
            }
            string = new String(cArray);
        }
        return string;
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBigDecimal( " + n2 + ", " + n3 + " )");
            }
            if ((bigDecimal = this.getBigDecimal(n2)) != null) {
                bigDecimal = bigDecimal.setScale(n3, 4);
            }
            BigDecimal bigDecimal2 = bigDecimal;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            return bigDecimal2;
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytes(int n2) throws SQLException {
        byte[] byArray;
        byte[] byArray2 = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBytes( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            byArray2 = this.preFetched[n3] ? this.rowObj.getBytes(n3) : this.getBytesData(n2);
            byArray = byArray2;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getBytes()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getBytes()");
        return byArray;
    }

    public Date getDate(int n2) throws SQLException {
        return this.getDateData(n2, Calendar.getInstance());
    }

    public Time getTime(int n2) throws SQLException {
        return this.getTimeData(n2, Calendar.getInstance());
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestampData(n2, Calendar.getInstance());
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBigDecimal( " + n2 + " )");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = n2 - 1;
            bigDecimal = this.preFetched[n3] ? this.rowObj.getBigDecimal(n3) : this.getBigDecimalData(n2);
            BigDecimal bigDecimal2 = bigDecimal;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            return bigDecimal2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block4;
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            throw throwable;
        }
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        int n3 = n2 - 1;
        if (this.preFetched[n3]) {
            return this.rowObj.getAsciiStream(n3);
        }
        String string = this.getASCIIStringData(n3);
        if (this.nullTag) {
            return null;
        }
        if (string == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        int n3 = n2 - 1;
        if (this.preFetched[n3]) {
            return this.rowObj.getUnicodeStream(n3);
        }
        String string = this.getString(n2);
        if (this.nullTag) {
            return null;
        }
        if (string == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            return new ByteArrayInputStream(string.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.toString());
        }
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        int n3 = n2 - 1;
        if (this.preFetched[n3]) {
            return this.rowObj.getBinaryStream(n3);
        }
        byte[] byArray = this.getBytesData(n2);
        if (this.nullTag) {
            return null;
        }
        if (byArray == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDateData(this.findColumn(string), Calendar.getInstance());
    }

    public Time getTime(String string) throws SQLException {
        return this.getTimeData(this.findColumn(string), Calendar.getInstance());
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestampData(this.findColumn(string), Calendar.getInstance());
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        return this.statement.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.statement.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        this.statement.addWarning(sQLWarning);
    }

    public String getCursorName() throws SQLException {
        String string = null;
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)44);
                this.db2req.write(this.stmtHandle);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 == 0 || n2 == 1) {
                    string = this.db2req.readString();
                    if (n2 != 0) {
                        this.sqlExcptGen.check_return_code(this.statement, n2);
                    }
                } else {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        return this.rsMetaData;
    }

    public Object getObject(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        int n3 = n2 - 1;
        if (this.preFetched[n3]) {
            return this.rowObj.getObject(n3);
        }
        return this.getObjectData(n2);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        string = string.toUpperCase(Locale.US);
        if (null == this.name2Index) {
            n3 = this.statement.colCount4JSQL > 0 ? this.statement.colCount4JSQL : this.rsMetaData.getColumnCount();
            this.name2Index = new Hashtable((int)((double)n3 / 0.75 + 0.7));
            int n4 = 1;
            while (n4 <= n3) {
                String string2 = this.statement.colCount4JSQL > 0 ? this.statement.colNames4JSQL[n4 - 1] : this.rsMetaData.getColumnName(n4);
                if (string2 != null && !this.name2Index.containsKey(string2 = string2.toUpperCase(Locale.US))) {
                    this.name2Index.put(string2, new Integer(n4));
                    if (string2.equals(string)) {
                        n2 = n4;
                    }
                }
                ++n4;
            }
        } else {
            Integer n5 = (Integer)this.name2Index.get(string);
            if (n5 != null) {
                return n5;
            }
        }
        if (n2 == 0) {
            this.sqlExcptGen.rsException("S0022");
        }
        return n2;
    }

    protected int getMappedColumn(int n2) throws SQLException {
        return n2;
    }

    protected String getStringData(int n2) throws SQLException {
        int n3 = 0;
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)39);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    string = this.db2req.readString();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    protected String getASCIIStringData(int n2) throws SQLException {
        int n3 = 0;
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)33);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    string = this.db2req.readASCIIString();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    protected boolean getBooleanData(int n2) throws SQLException {
        int n3 = 0;
        boolean bl = false;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)36);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    int n5 = this.db2req.readInt();
                    if (n5 != 0) {
                        bl = true;
                    }
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return bl;
    }

    protected byte getByteData(int n2) throws SQLException {
        int n3 = 0;
        short s2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)35);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    s2 = this.db2req.readShort();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return (byte)s2;
    }

    protected short getShortData(int n2) throws SQLException {
        int n3 = 0;
        short s2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)35);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    s2 = this.db2req.readShort();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return s2;
    }

    protected int getIntData(int n2) throws SQLException {
        int n3 = 0;
        int n4 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n5;
                this.db2req.write((short)36);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n5 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    n4 = this.db2req.readInt();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n4;
    }

    protected long getLongData(int n2) throws SQLException {
        int n3 = 0;
        long l2 = 0L;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)46);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    l2 = this.db2req.readLong();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return l2;
    }

    protected float getFloatData(int n2) throws SQLException {
        int n3 = 0;
        float f2 = 0.0f;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)37);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    f2 = this.db2req.readFloat();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return f2;
    }

    protected double getDoubleData(int n2) throws SQLException {
        int n3 = 0;
        double d2 = 0.0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)38);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    d2 = this.db2req.readDouble();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return d2;
    }

    protected BigDecimal getBigDecimalData(int n2) throws SQLException {
        int n3 = 0;
        BigDecimal bigDecimal = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)39);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    String string = this.db2req.readString();
                    try {
                        string = DB2ResultSet.cvtScientific(string);
                        bigDecimal = new BigDecimal(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.sqlExcptGen.rsException("22005");
                    }
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return bigDecimal;
    }

    protected byte[] getBytesData(int n2) throws SQLException {
        Object object;
        int n3 = 0;
        byte[] byArray = null;
        try {
            object = this.db2req;
            synchronized (object) {
                int n4;
                this.db2req.write((short)40);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    byArray = this.db2req.readBytes();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (0 == this.statement.maxFieldSize || byArray.length <= this.statement.maxFieldSize || this.rowObj.sqltype[n2] != 1 && this.rowObj.sqltype[n2] != 12 && this.rowObj.sqltype[n2] != -1 && this.rowObj.sqltype[n2] != -2 && this.rowObj.sqltype[n2] != -3 && this.rowObj.sqltype[n2] != -4 && this.rowObj.sqltype[n2] != -95 && this.rowObj.sqltype[n2] != -96 && this.rowObj.sqltype[n2] != -97) {
            return byArray;
        }
        object = new byte[this.statement.maxFieldSize];
        System.arraycopy(byArray, 0, object, 0, this.statement.maxFieldSize);
        return object;
    }

    protected Date getDateData(int n2, Calendar calendar) throws SQLException {
        int n3 = 0;
        Date date = null;
        try {
            Object object;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDateData(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            this.checkHandlesAndIndex(n2);
            int n4 = n2 - 1;
            if (this.preFetched[n4]) {
                date = this.rowObj.getDate(n4, calendar);
            } else {
                try {
                    object = this.db2req;
                    synchronized (object) {
                        int n5;
                        this.db2req.write((short)41);
                        this.db2req.write(this.stmtHandle);
                        this.db2req.write((short)n2);
                        this.db2req.sendAndRecv();
                        n3 = this.db2req.readInt();
                        if (n3 != 0 && n3 != 1) {
                            this.sqlExcptGen.check_return_code(this.statement, n3);
                        }
                        if ((n5 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                            this.nullTag = false;
                            this.year = this.db2req.readInt();
                            this.month = this.db2req.readInt();
                            this.day = this.db2req.readInt();
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Year(+1900)", this.year + 1900);
                                DB2Trace.data(10, "Month(+1)", this.month + 1);
                                DB2Trace.data(10, "Day", this.day);
                            }
                            calendar = (Calendar)calendar.clone();
                            calendar.set(this.year + 1900, this.month, this.day, 0, 0, 0);
                            calendar.set(14, 0);
                            date = new Date(calendar.getTime().getTime());
                        } else {
                            this.nullTag = true;
                        }
                    }
                    DB2Trace.data(20, "year");
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            object = date;
            Object var10_10 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getDateData(...)", date == null ? "NULL" : date.toString());
            }
            return object;
        }
        catch (Throwable throwable) {
            block15: {
                Object var10_11 = null;
                if (!DB2Trace.TraceOn) break block15;
                DB2Trace.methodExit((Object)this, "getDateData(...)", date == null ? "NULL" : date.toString());
            }
            throw throwable;
        }
    }

    protected Time getTimeData(int n2, Calendar calendar) throws SQLException {
        int n3 = 0;
        Time time = null;
        try {
            Object object;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimeData(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            this.checkHandlesAndIndex(n2);
            int n4 = n2 - 1;
            if (this.preFetched[n4]) {
                time = this.rowObj.getTime(n4, calendar);
            } else {
                try {
                    object = this.db2req;
                    synchronized (object) {
                        int n5;
                        this.db2req.write((short)42);
                        this.db2req.write(this.stmtHandle);
                        this.db2req.write((short)n2);
                        this.db2req.sendAndRecv();
                        n3 = this.db2req.readInt();
                        if (n3 != 0 && n3 != 1) {
                            this.sqlExcptGen.check_return_code(this.statement, n3);
                        }
                        if ((n5 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                            this.nullTag = false;
                            this.hour = this.db2req.readInt();
                            this.minute = this.db2req.readInt();
                            this.second = this.db2req.readInt();
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Hour", this.hour);
                                DB2Trace.data(10, "Minute", this.minute);
                                DB2Trace.data(10, "Second", this.second);
                            }
                            calendar = (Calendar)calendar.clone();
                            calendar.set(1970, 0, 1, this.hour, this.minute, this.second);
                            calendar.set(14, 0);
                            time = new Time(calendar.getTime().getTime());
                        } else {
                            this.nullTag = true;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            object = time;
            Object var10_10 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTimeData(...)", time == null ? "NULL" : time.toString());
            }
            return object;
        }
        catch (Throwable throwable) {
            block16: {
                Object var10_11 = null;
                if (!DB2Trace.TraceOn) break block16;
                DB2Trace.methodExit((Object)this, "getTimeData(...)", time == null ? "NULL" : time.toString());
            }
            throw throwable;
        }
    }

    protected Timestamp getTimestampData(int n2, Calendar calendar) throws SQLException {
        int n3 = 0;
        Timestamp timestamp = null;
        try {
            Object object;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestampData(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            this.checkHandlesAndIndex(n2);
            int n4 = n2 - 1;
            if (this.preFetched[n4]) {
                timestamp = this.rowObj.getTimestamp(n4, calendar);
            } else {
                try {
                    object = this.db2req;
                    synchronized (object) {
                        int n5;
                        this.db2req.write((short)43);
                        this.db2req.write(this.stmtHandle);
                        this.db2req.write((short)n2);
                        this.db2req.sendAndRecv();
                        n3 = this.db2req.readInt();
                        if (n3 != 0 && n3 != 1) {
                            this.sqlExcptGen.check_return_code(this.statement, n3);
                        }
                        if ((n5 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                            this.nullTag = false;
                            this.year = this.db2req.readInt();
                            this.month = this.db2req.readInt();
                            this.day = this.db2req.readInt();
                            this.hour = this.db2req.readInt();
                            this.minute = this.db2req.readInt();
                            this.second = this.db2req.readInt();
                            this.nano = this.db2req.readInt();
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Year(+1900)", this.year + 1900);
                                DB2Trace.data(10, "Month(+1)", this.month + 1);
                                DB2Trace.data(10, "Day", this.day);
                                DB2Trace.data(10, "Hour", this.hour);
                                DB2Trace.data(10, "Minute", this.minute);
                                DB2Trace.data(10, "Second", this.second);
                                DB2Trace.data(10, "Nano", this.nano);
                            }
                            calendar = (Calendar)calendar.clone();
                            calendar.set(this.year + 1900, this.month, this.day, this.hour, this.minute, this.second);
                            calendar.set(14, 0);
                            timestamp = new Timestamp(calendar.getTime().getTime());
                            timestamp.setNanos(this.nano);
                        } else {
                            this.nullTag = true;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            object = timestamp;
            Object var10_10 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTimestampData(...)", timestamp == null ? "NULL" : timestamp.toString());
            }
            return object;
        }
        catch (Throwable throwable) {
            block16: {
                Object var10_11 = null;
                if (!DB2Trace.TraceOn) break block16;
                DB2Trace.methodExit((Object)this, "getTimestampData(...)", timestamp == null ? "NULL" : timestamp.toString());
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getObjectData(int n2) throws SQLException {
        Object var27_57;
        block53: {
            URL uRL;
            block52: {
                Clob clob;
                block51: {
                    Blob blob;
                    block50: {
                        Timestamp timestamp;
                        block49: {
                            Time time;
                            block48: {
                                Date date;
                                block47: {
                                    byte[] byArray;
                                    block46: {
                                        Double d2;
                                        block45: {
                                            Object var19_48;
                                            block44: {
                                                Float f2;
                                                block43: {
                                                    Object var16_45;
                                                    block42: {
                                                        Long l2;
                                                        block41: {
                                                            Object var14_42;
                                                            block40: {
                                                                Integer n3;
                                                                block39: {
                                                                    Object var11_39;
                                                                    block38: {
                                                                        Integer n4;
                                                                        block37: {
                                                                            Object var9_36;
                                                                            block36: {
                                                                                Integer n5;
                                                                                block35: {
                                                                                    Object var8_34;
                                                                                    block34: {
                                                                                        Boolean bl;
                                                                                        block33: {
                                                                                            Object var7_32;
                                                                                            block32: {
                                                                                                BigDecimal bigDecimal;
                                                                                                block31: {
                                                                                                    String string;
                                                                                                    block30: {
                                                                                                        try {
                                                                                                            int n6 = this.rowObj.sqltype[n2 - 1];
                                                                                                            if (DB2Trace.TraceOn) {
                                                                                                                DB2Trace.methodEntry(this, "getObjectData( " + n2 + " )");
                                                                                                                DB2Trace.data(10, "sqlType", n6);
                                                                                                            }
                                                                                                            if (n6 == -450) {
                                                                                                                n6 = this.rsMetaData.colBaseTypesNotAdjusted[n2 - 1];
                                                                                                            }
                                                                                                            if (DB2Trace.TraceOn) {
                                                                                                                DB2Trace.data(20, "sqlType", n6);
                                                                                                            }
                                                                                                            short s2 = 0;
                                                                                                            switch (n6) {
                                                                                                                case -97: 
                                                                                                                case -96: 
                                                                                                                case -95: 
                                                                                                                case -10: 
                                                                                                                case -9: 
                                                                                                                case -8: 
                                                                                                                case -1: 
                                                                                                                case 1: 
                                                                                                                case 12: {
                                                                                                                    string = this.getStringData(n2);
                                                                                                                    Object var29_5 = null;
                                                                                                                    if (!DB2Trace.TraceOn) return string;
                                                                                                                    break block30;
                                                                                                                }
                                                                                                                case 2: 
                                                                                                                case 3: {
                                                                                                                    bigDecimal = this.getBigDecimalData(n2);
                                                                                                                    break block31;
                                                                                                                }
                                                                                                                case -7: {
                                                                                                                    boolean bl2 = this.getBooleanData(n2);
                                                                                                                    if (this.wasNull()) {
                                                                                                                        var7_32 = null;
                                                                                                                        break block32;
                                                                                                                    }
                                                                                                                    bl = new Boolean(bl2);
                                                                                                                    break block33;
                                                                                                                }
                                                                                                                case -6: {
                                                                                                                    s2 = this.getShortData(n2);
                                                                                                                    if (this.wasNull()) {
                                                                                                                        var8_34 = null;
                                                                                                                        break block34;
                                                                                                                    }
                                                                                                                    n5 = new Integer(s2);
                                                                                                                    break block35;
                                                                                                                }
                                                                                                                case 5: {
                                                                                                                    s2 = this.getShortData(n2);
                                                                                                                    if (this.wasNull()) {
                                                                                                                        var9_36 = null;
                                                                                                                        break block36;
                                                                                                                    }
                                                                                                                    n4 = new Integer(s2);
                                                                                                                    break block37;
                                                                                                                }
                                                                                                                case 4: {
                                                                                                                    int n7 = this.getIntData(n2);
                                                                                                                    if (this.wasNull()) {
                                                                                                                        var11_39 = null;
                                                                                                                        break block38;
                                                                                                                    }
                                                                                                                    n3 = new Integer(n7);
                                                                                                                    break block39;
                                                                                                                }
                                                                                                                case -5: {
                                                                                                                    long l3 = this.getLongData(n2);
                                                                                                                    if (this.wasNull()) {
                                                                                                                        var14_42 = null;
                                                                                                                        break block40;
                                                                                                                    }
                                                                                                                    l2 = new Long(l3);
                                                                                                                    break block41;
                                                                                                                }
                                                                                                                case 6: 
                                                                                                                case 7: {
                                                                                                                    float f3 = this.getFloatData(n2);
                                                                                                                    if (this.wasNull()) {
                                                                                                                        var16_45 = null;
                                                                                                                        break block42;
                                                                                                                    }
                                                                                                                    f2 = new Float(f3);
                                                                                                                    break block43;
                                                                                                                }
                                                                                                                case 8: {
                                                                                                                    double d3 = this.getDoubleData(n2);
                                                                                                                    if (this.wasNull()) {
                                                                                                                        var19_48 = null;
                                                                                                                        break block44;
                                                                                                                    }
                                                                                                                    d2 = new Double(d3);
                                                                                                                    break block45;
                                                                                                                }
                                                                                                                case -4: 
                                                                                                                case -3: 
                                                                                                                case -2: {
                                                                                                                    byArray = this.getBytesData(n2);
                                                                                                                    break block46;
                                                                                                                }
                                                                                                                case 91: {
                                                                                                                    date = this.getDateData(n2, Calendar.getInstance());
                                                                                                                    break block47;
                                                                                                                }
                                                                                                                case 92: {
                                                                                                                    time = this.getTimeData(n2, Calendar.getInstance());
                                                                                                                    break block48;
                                                                                                                }
                                                                                                                case 93: {
                                                                                                                    timestamp = this.getTimestampData(n2, Calendar.getInstance());
                                                                                                                    break block49;
                                                                                                                }
                                                                                                                case -98: 
                                                                                                                case 31: {
                                                                                                                    blob = this.getBlob(n2);
                                                                                                                    break block50;
                                                                                                                }
                                                                                                                case -351: 
                                                                                                                case -350: 
                                                                                                                case -99: 
                                                                                                                case 41: {
                                                                                                                    clob = this.getClob(n2);
                                                                                                                    break block51;
                                                                                                                }
                                                                                                                case -400: 
                                                                                                                case 70: {
                                                                                                                    uRL = this.getURL(n2);
                                                                                                                    break block52;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    this.sqlExcptGen.rsException("S1004");
                                                                                                                    var27_57 = null;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            break block53;
                                                                                                        }
                                                                                                        catch (Throwable throwable) {
                                                                                                            Object var29_29 = null;
                                                                                                            if (!DB2Trace.TraceOn) throw throwable;
                                                                                                            DB2Trace.methodExit(this, "getObjectData()");
                                                                                                            throw throwable;
                                                                                                        }
                                                                                                    }
                                                                                                    DB2Trace.methodExit(this, "getObjectData()");
                                                                                                    return string;
                                                                                                }
                                                                                                Object var29_6 = null;
                                                                                                if (!DB2Trace.TraceOn) return bigDecimal;
                                                                                                DB2Trace.methodExit(this, "getObjectData()");
                                                                                                return bigDecimal;
                                                                                            }
                                                                                            Object var29_7 = null;
                                                                                            if (!DB2Trace.TraceOn) return var7_32;
                                                                                            DB2Trace.methodExit(this, "getObjectData()");
                                                                                            return var7_32;
                                                                                        }
                                                                                        Object var29_8 = null;
                                                                                        if (!DB2Trace.TraceOn) return bl;
                                                                                        DB2Trace.methodExit(this, "getObjectData()");
                                                                                        return bl;
                                                                                    }
                                                                                    Object var29_9 = null;
                                                                                    if (!DB2Trace.TraceOn) return var8_34;
                                                                                    DB2Trace.methodExit(this, "getObjectData()");
                                                                                    return var8_34;
                                                                                }
                                                                                Object var29_10 = null;
                                                                                if (!DB2Trace.TraceOn) return n5;
                                                                                DB2Trace.methodExit(this, "getObjectData()");
                                                                                return n5;
                                                                            }
                                                                            Object var29_11 = null;
                                                                            if (!DB2Trace.TraceOn) return var9_36;
                                                                            DB2Trace.methodExit(this, "getObjectData()");
                                                                            return var9_36;
                                                                        }
                                                                        Object var29_12 = null;
                                                                        if (!DB2Trace.TraceOn) return n4;
                                                                        DB2Trace.methodExit(this, "getObjectData()");
                                                                        return n4;
                                                                    }
                                                                    Object var29_13 = null;
                                                                    if (!DB2Trace.TraceOn) return var11_39;
                                                                    DB2Trace.methodExit(this, "getObjectData()");
                                                                    return var11_39;
                                                                }
                                                                Object var29_14 = null;
                                                                if (!DB2Trace.TraceOn) return n3;
                                                                DB2Trace.methodExit(this, "getObjectData()");
                                                                return n3;
                                                            }
                                                            Object var29_15 = null;
                                                            if (!DB2Trace.TraceOn) return var14_42;
                                                            DB2Trace.methodExit(this, "getObjectData()");
                                                            return var14_42;
                                                        }
                                                        Object var29_16 = null;
                                                        if (!DB2Trace.TraceOn) return l2;
                                                        DB2Trace.methodExit(this, "getObjectData()");
                                                        return l2;
                                                    }
                                                    Object var29_17 = null;
                                                    if (!DB2Trace.TraceOn) return var16_45;
                                                    DB2Trace.methodExit(this, "getObjectData()");
                                                    return var16_45;
                                                }
                                                Object var29_18 = null;
                                                if (!DB2Trace.TraceOn) return f2;
                                                DB2Trace.methodExit(this, "getObjectData()");
                                                return f2;
                                            }
                                            Object var29_19 = null;
                                            if (!DB2Trace.TraceOn) return var19_48;
                                            DB2Trace.methodExit(this, "getObjectData()");
                                            return var19_48;
                                        }
                                        Object var29_20 = null;
                                        if (!DB2Trace.TraceOn) return d2;
                                        DB2Trace.methodExit(this, "getObjectData()");
                                        return d2;
                                    }
                                    Object var29_21 = null;
                                    if (!DB2Trace.TraceOn) return byArray;
                                    DB2Trace.methodExit(this, "getObjectData()");
                                    return byArray;
                                }
                                Object var29_22 = null;
                                if (!DB2Trace.TraceOn) return date;
                                DB2Trace.methodExit(this, "getObjectData()");
                                return date;
                            }
                            Object var29_23 = null;
                            if (!DB2Trace.TraceOn) return time;
                            DB2Trace.methodExit(this, "getObjectData()");
                            return time;
                        }
                        Object var29_24 = null;
                        if (!DB2Trace.TraceOn) return timestamp;
                        DB2Trace.methodExit(this, "getObjectData()");
                        return timestamp;
                    }
                    Object var29_25 = null;
                    if (!DB2Trace.TraceOn) return blob;
                    DB2Trace.methodExit(this, "getObjectData()");
                    return blob;
                }
                Object var29_26 = null;
                if (!DB2Trace.TraceOn) return clob;
                DB2Trace.methodExit(this, "getObjectData()");
                return clob;
            }
            Object var29_27 = null;
            if (!DB2Trace.TraceOn) return uRL;
            DB2Trace.methodExit(this, "getObjectData()");
            return uRL;
        }
        Object var29_28 = null;
        if (!DB2Trace.TraceOn) return var27_57;
        DB2Trace.methodExit(this, "getObjectData()");
        return var27_57;
    }

    protected String getTraceHandle() {
        String string = "??";
        if (this.statement != null) {
            string = this.statement.getTraceHandle();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRow() throws SQLException {
        int n2;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getRow()");
            }
            n2 = this.currentRowId;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
        return n2;
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.rowObj.getCharacterStream(n2 - 1);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public void afterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public boolean first() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean last() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean absolute(int n2) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean relative(int n2) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean previous() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFetchDirection(int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchDirection( " + n2 + " )");
            }
            this.checkHandlesAndIndex(Integer.MAX_VALUE);
            this.statement.checkFetchDirection(n2);
            this.fetchDirection = n2;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "setFetchDirection()", this.fetchDirection);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "setFetchDirection()", this.fetchDirection);
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFetchSize(int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchSize( " + n2 + " )");
            }
            this.checkHandlesAndIndex(Integer.MAX_VALUE);
            this.statement.checkFetchSize(n2);
            this.fetchSize = n2;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "setFetchSize()", this.fetchSize);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "setFetchSize()", this.fetchSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getFetchSize() throws SQLException {
        int n2;
        int n3 = this.statement.CLIBlockSize;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFetchSize()");
            }
            this.checkHandlesAndIndex(Integer.MAX_VALUE);
            if (this.fetchSize > 0) {
                n3 = this.fetchSize;
            }
            n2 = n3;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getFetchSize()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getFetchSize()", n3);
        return n2;
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcur;
    }

    public boolean rowUpdated() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public void updateNull(int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateNull(String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(String string, String string2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void insertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void deleteRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void refreshRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void cancelRowUpdates() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void moveToInsertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void moveToCurrentRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Ref type");
        return null;
    }

    public Blob getBlob(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.rowObj.getBlob(n2 - 1);
    }

    public Clob getClob(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.rowObj.getClob(n2 - 1);
    }

    public URL getURL(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        try {
            String string = this.getString(n2);
            if (string == null) {
                return null;
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.getMessage());
        }
    }

    public Array getArray(int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Ref type");
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
        return null;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDateData(n2, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDateData(this.findColumn(string), calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTimeData(n2, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTimeData(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestampData(n2, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestampData(this.findColumn(string), calendar);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void positionServerToCurrentRow() {
    }

    public long getQueryInstanceIdentifier() {
        return ((DB2PreparedStatement)this.statement).queryInstanceIdentifier;
    }
}

