/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2RequestOutputBuffer;
import COM.ibm.db2.jdbc.net.DB2Socket;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class DB2Request {
    protected DB2Socket db2socket;
    protected static boolean debug = false;
    protected static int inBufferSize = 32768;
    protected static int outBufferSize = 32764;
    protected byte[] inBuffer = new byte[inBufferSize];
    protected DataInputStream inMemory = new DataInputStream(new ByteArrayInputStream(this.inBuffer));
    protected int outTotalLength = 0;
    protected int outCurrentLength = 0;
    protected DB2RequestOutputBuffer outBuffer = new DB2RequestOutputBuffer();
    protected Vector outBufferChain = new Vector(5, 5);
    protected int outBufferChainPos = 0;
    protected int outBufferChainLen = 1;
    protected boolean closed = false;

    public DB2Request(DB2Socket dB2Socket) {
        this.db2socket = dB2Socket;
        this.outBufferChain.addElement(this.outBuffer);
    }

    public DB2Request(DB2Request dB2Request) {
        this.db2socket = dB2Request.db2socket;
        this.outBufferChain.addElement(this.outBuffer);
    }

    public DB2Request(DB2Connection dB2Connection) {
        this.db2socket = dB2Connection.db2socket;
        this.outBufferChain.addElement(this.outBuffer);
    }

    protected void nextOutputBuffer() {
        this.outTotalLength += this.outBuffer.outBuf.size();
        ++this.outBufferChainPos;
        if (debug) {
            System.err.println("nextOutputBuffer: outTotalLength = " + this.outTotalLength + " position = " + this.outBufferChainPos);
        }
        if (this.outBufferChainPos < this.outBufferChainLen) {
            if (debug) {
                System.err.println("nextOutputBuffer: Re-using element # " + this.outBufferChainPos);
            }
            this.outBuffer = (DB2RequestOutputBuffer)this.outBufferChain.elementAt(this.outBufferChainPos);
        } else {
            this.outBuffer = new DB2RequestOutputBuffer();
            this.outBufferChain.addElement(this.outBuffer);
            ++this.outBufferChainLen;
            if (debug) {
                System.err.println("nextOutputBuffer: created new element length =  " + this.outBufferChainLen);
            }
        }
    }

    public void write(short s2) throws IOException {
        this.outCurrentLength += 2;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 2;
        }
        if (debug) {
            System.err.println("write( short = " + s2 + ")");
        }
        this.outBuffer.outMemory.writeShort(s2);
    }

    public void write(int n2) throws IOException {
        this.outCurrentLength += 4;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 4;
        }
        if (debug) {
            System.err.println("write( int = " + n2 + ")");
        }
        this.outBuffer.outMemory.writeInt(n2);
    }

    public void write(long l2) throws IOException {
        this.outCurrentLength += 8;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 8;
        }
        if (debug) {
            System.err.println("write( long = " + l2 + ")");
        }
        this.outBuffer.outMemory.writeLong(l2);
    }

    public void write(float f2) throws IOException {
        if (debug) {
            System.err.println("write( float = " + f2 + ")");
        }
        this.outCurrentLength += 4;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 4;
        }
        this.outBuffer.outMemory.writeFloat(f2);
    }

    public void write(double d2) throws IOException {
        if (debug) {
            System.err.println("write( double = " + d2 + ")");
        }
        this.outCurrentLength += 8;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 8;
        }
        this.outBuffer.outMemory.writeDouble(d2);
    }

    public void write(boolean bl) throws IOException {
        if (debug) {
            System.err.println("write( boolean = " + bl + ")");
        }
        if (bl) {
            this.write((short)1);
        } else {
            this.write((short)0);
        }
    }

    public void write(char c2) throws IOException {
        this.outCurrentLength += 2;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 2;
        }
        if (debug) {
            System.err.println("write( char = " + c2 + ")");
        }
        this.outBuffer.outMemory.writeChar(c2);
    }

    public void write(String string) throws IOException {
        if (string == null) {
            this.write(-1);
            return;
        }
        int n2 = string.length();
        this.write(n2);
        int n3 = 2 * n2;
        this.outCurrentLength += n3;
        if (this.outCurrentLength <= outBufferSize) {
            if (debug) {
                System.err.println("write( String = \"" + string + "\", len = " + n2 + ")");
            }
            this.outBuffer.outMemory.writeChars(string);
        } else {
            this.outCurrentLength -= n3;
            int n4 = (outBufferSize - this.outCurrentLength) / 2;
            int n5 = 0;
            String string2 = null;
            while (n2 > 0) {
                if (n4 < 1) {
                    this.nextOutputBuffer();
                    this.outCurrentLength = 0;
                    n4 = outBufferSize / 2;
                }
                if (n4 >= n2) {
                    if (debug) {
                        System.err.println("Filling last chars length = " + n2);
                    }
                    string2 = 0 == n5 ? string : string.substring(n5, n5 + n2);
                    this.outCurrentLength += n2 * 2;
                    n2 = 0;
                } else {
                    if (debug) {
                        System.err.println("Filling entire buffer length = " + n4 * 2);
                    }
                    string2 = string.substring(n5, n5 + n4);
                    n2 -= n4;
                    n5 += n4;
                    n4 = 0;
                }
                this.outBuffer.outMemory.writeChars(string2);
                if (!debug) continue;
                System.err.println("No. of chars written to the buffer = " + string2.length() + " char position = " + n5);
            }
        }
    }

    public void writeASCII(String string) throws IOException {
        int n2 = string.length();
        if (debug) {
            System.err.println("writeASCII( String = \"" + string + "\", len = " + n2 + ")");
        }
        char[] cArray = new char[n2];
        byte[] byArray = new byte[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)(cArray[n3] & 0xFF);
            ++n3;
        }
        this.write(byArray, n2);
    }

    public void write(byte by) throws IOException {
        ++this.outCurrentLength;
        if (this.outCurrentLength > outBufferSize) {
            this.nextOutputBuffer();
            this.outCurrentLength = 1;
        }
        if (debug) {
            System.err.println("write( byte = " + by + ")");
        }
        this.outBuffer.outMemory.write(by);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n2 = byArray.length;
        this.write(byArray, n2);
    }

    public void write(byte[] byArray, int n2) throws IOException {
        this.outCurrentLength += 4 + n2;
        if (this.outCurrentLength <= outBufferSize) {
            if (debug) {
                System.err.print("write( byte len = " + n2 + " bytes = ->");
                int n3 = 0;
                while (n3 < n2) {
                    System.err.print(byArray[n3]);
                    ++n3;
                }
                System.err.println("<-");
            }
            this.outBuffer.outMemory.writeInt(n2);
            this.outBuffer.outMemory.write(byArray, 0, n2);
        } else {
            if (debug) {
                System.err.println("write byte[] spanning MULTIPLE buffers!!");
            }
            this.outCurrentLength -= 4 + n2;
            this.write(n2);
            int n4 = outBufferSize - this.outCurrentLength;
            this.outBuffer.outMemory.write(byArray, 0, n4);
            int n5 = n4;
            while ((n2 -= n4) > 0) {
                if (debug) {
                    System.err.println("Remaining length in buffer = " + n4 + " buffer position = " + n5);
                }
                this.nextOutputBuffer();
                if (outBufferSize > n2) {
                    if (debug) {
                        System.err.println("Filling last bits length = " + n2);
                    }
                    this.outBuffer.outMemory.write(byArray, n5, n2);
                    this.outCurrentLength = n2;
                    n4 = n2;
                    continue;
                }
                if (debug) {
                    System.err.println("Filling entire buffer length = " + outBufferSize);
                }
                n4 = outBufferSize;
                this.outBuffer.outMemory.write(byArray, n5, n4);
                n5 += n4;
            }
        }
    }

    public short readShort() throws IOException {
        short s2 = this.inMemory.readShort();
        if (debug) {
            System.err.println("readShort - rValue = " + s2);
        }
        return s2;
    }

    public int readInt() throws IOException {
        int n2 = this.inMemory.readInt();
        if (debug) {
            System.err.println("readInt - rValue = " + n2);
        }
        return n2;
    }

    public long readLong() throws IOException {
        long l2 = this.inMemory.readLong();
        if (debug) {
            System.err.println("readLong - rValue = " + l2);
        }
        return l2;
    }

    public float readFloat() throws IOException {
        float f2 = this.inMemory.readFloat();
        return f2;
    }

    public double readDouble() throws IOException {
        double d2 = this.inMemory.readDouble();
        return d2;
    }

    public boolean readBoolean() throws IOException {
        boolean bl = true;
        short s2 = this.readShort();
        if (s2 == 0) {
            bl = false;
        }
        if (debug) {
            System.err.println("readBoolean - rValue = " + bl);
        }
        return bl;
    }

    public byte readByte() throws IOException {
        byte by = this.inMemory.readByte();
        if (debug) {
            System.err.println("readByte - rValue = " + by);
        }
        return by;
    }

    public char readChar() throws IOException {
        char c2 = this.inMemory.readChar();
        if (debug) {
            System.err.println("readChar - rValue = " + c2);
        }
        return c2;
    }

    public String readString() throws IOException {
        int n2 = this.inMemory.readInt();
        int n3 = n2 / 2;
        if (debug) {
            System.err.println("readString - byte length = " + n2 + " char length = " + n3);
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4] = this.inMemory.readChar();
            ++n4;
        }
        String string = new String(cArray);
        if (debug) {
            System.err.println("readString - rValue = " + string);
        }
        return string;
    }

    public String readASCIIString() throws IOException {
        int n2 = this.inMemory.readInt();
        if (debug) {
            System.err.println("readASCIIString - length = " + n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)this.inMemory.readByte();
            if (debug) {
                System.err.println("readASCIIString - reading byte " + n3 + " value = " + cArray[n3]);
            }
            ++n3;
        }
        String string = new String(cArray);
        if (debug) {
            System.err.println("readASCIIString - rValue = " + string);
        }
        return string;
    }

    public byte[] readBytes() throws IOException {
        int n2 = this.inMemory.readInt();
        if (debug) {
            System.err.println("readBytes - length = " + n2);
        }
        byte[] byArray = new byte[n2];
        this.inMemory.readFully(byArray, 0, n2);
        if (debug) {
            System.err.print("bytes = ->");
            int n3 = 0;
            while (n3 < n2) {
                System.err.print(byArray[n3]);
                ++n3;
            }
            System.err.println("<-");
        }
        return byArray;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.inMemory.close();
                this.outBuffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inMemory = null;
            this.outBuffer = null;
            this.outBufferChain.removeAllElements();
            this.outBufferChain = null;
            this.db2socket = null;
        }
    }

    public void sendAndRecv() throws SQLException {
        DB2Socket dB2Socket = this.db2socket;
        synchronized (dB2Socket) {
            this.send();
            this.receive();
        }
    }

    protected void send() throws SQLException {
        DB2Socket dB2Socket = this.db2socket;
        synchronized (dB2Socket) {
            if (this.db2socket == null || this.db2socket.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            try {
                this.outTotalLength += this.outBuffer.outBuf.size();
                if (debug) {
                    System.err.println("send - writing " + this.outTotalLength + " bytes to socket");
                }
                if (debug) {
                    System.err.println("outTotalLength <= outBufferSize --> " + this.outTotalLength + " <= " + outBufferSize);
                }
                if (this.outTotalLength <= outBufferSize) {
                    if (debug) {
                        System.err.println("Sending 1 buffer of size = " + this.outBuffer.outBuf.size());
                    }
                    this.db2socket.sendStream.writeShort(1);
                    this.db2socket.sendStream.writeInt(this.outBuffer.outBuf.size());
                    this.outBuffer.outBuf.writeTo(this.db2socket.sendStream);
                    this.db2socket.sendStream.flush();
                    this.outBuffer.outBuf.reset();
                } else {
                    if (debug) {
                        System.err.println("Sending MULTIPLE buffers of total size = " + this.outTotalLength + " number of buffers = " + (this.outBufferChainPos + 1) + "total length of chain = " + this.outBufferChainLen);
                    }
                    this.db2socket.sendStream.writeShort((short)(this.outBufferChainPos + 1));
                    this.db2socket.sendStream.writeInt(this.outTotalLength);
                    DB2RequestOutputBuffer dB2RequestOutputBuffer = null;
                    int n2 = 0;
                    while (n2 <= this.outBufferChainPos) {
                        if (debug) {
                            System.err.println("Getting output buffer number = " + n2);
                        }
                        dB2RequestOutputBuffer = (DB2RequestOutputBuffer)this.outBufferChain.elementAt(n2);
                        if (debug) {
                            System.err.println("Sending length of buffer = " + dB2RequestOutputBuffer.outBuf.size());
                        }
                        this.db2socket.sendStream.writeInt(dB2RequestOutputBuffer.outBuf.size());
                        if (debug) {
                            System.err.println("Sending  buffer");
                        }
                        dB2RequestOutputBuffer.outBuf.writeTo(this.db2socket.sendStream);
                        if (debug) {
                            System.err.println("Flushing stream");
                        }
                        this.db2socket.sendStream.flush();
                        if (debug) {
                            System.err.println("Resetting the buffer");
                        }
                        dB2RequestOutputBuffer.outBuf.reset();
                        ++n2;
                    }
                    if (debug) {
                        System.err.println("Resetting outBuffer.");
                    }
                    this.outBuffer = (DB2RequestOutputBuffer)this.outBufferChain.elementAt(0);
                }
            }
            catch (IOException iOException) {
                SQLExceptionGenerator.throwSendError();
            }
        }
        this.outBufferChainPos = 0;
        this.outTotalLength = 0;
        this.outCurrentLength = 0;
    }

    protected void receive() throws SQLException {
        try {
            int n2 = this.db2socket.receiveStream.readInt();
            if (debug) {
                System.err.println("receive - reading " + n2 + " bytes from socket");
            }
            if (debug) {
                System.err.println("available bytes = " + this.db2socket.receiveStream.available());
            }
            if (this.inBuffer == null || this.inBuffer.length < n2) {
                if (debug) {
                    System.err.println("creating inBuffer of size " + n2);
                }
                this.inBuffer = new byte[n2];
                this.inMemory = new DataInputStream(new ByteArrayInputStream(this.inBuffer));
            }
            if (n2 <= inBufferSize - 4) {
                this.db2socket.receiveStream.readFully(this.inBuffer, 0, n2);
                if (debug) {
                    System.err.println("data has been read from the socket length = " + n2);
                }
            } else {
                int n3 = 0;
                int n4 = inBufferSize - 4;
                if (debug) {
                    System.err.println("Getting mulitple buffers: inLen = " + n4 + " totalLen = " + n2 + " inPos = " + n3);
                }
                int n5 = n2 - n4;
                this.db2socket.receiveStream.readFully(this.inBuffer, n3, n4);
                n3 += n4;
                while (n5 > 0) {
                    n4 = this.db2socket.receiveStream.readInt();
                    if (debug) {
                        System.err.println("Getting mulitple buffers: inLen = " + n4 + " totalLen = " + n5 + " inPos = " + n3);
                    }
                    this.db2socket.receiveStream.readFully(this.inBuffer, n3, n4);
                    n3 += n4;
                    n5 -= n4;
                }
                if (debug) {
                    System.err.println("Getting mulitple buffers: inLen = " + n4 + " totalLen = " + n5 + " inPos = " + n3);
                }
                if (debug) {
                    System.err.println("data has been read from the socket");
                }
            }
            this.inMemory.reset();
        }
        catch (IOException iOException) {
            SQLExceptionGenerator.throwReceiveError();
        }
    }
}

