/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2BaseConstants;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJPackage;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJResultSet;
import com.ibm.db2.jcc.SQLJSection;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2PreparedStatement
extends DB2Statement
implements PreparedStatement,
SQLJPreparedStatement {
    protected int maxNumParams = 0;
    protected String SQLJCursorName = null;
    protected byte[] SQLJPID = null;
    protected short[] direction;
    protected int[] sqltypes = null;
    protected int[] ctypes = null;
    protected int[] maxWholeDigits;
    protected int[] precisions;
    protected int[] scales;
    protected boolean[] wasBound = null;
    protected short[] described = null;
    protected ParamElement[] paramRow = null;
    protected Vector paramSet = new Vector();
    protected int[] maxParamLength = null;
    protected static final int BUFLEN = 32699;
    protected static final int MAXCHAR = 254;
    protected static final int MAXVCHAR = 4000;
    protected boolean executed = false;
    protected short statementType;
    private boolean[] SQLJParmIsGraphic = null;
    private String sqljDescribeInfo = null;
    SQLJSection section = null;
    SQLJColumnMetaData parameterMetaData = null;
    SQLJColumnMetaData resultSetMetaData = null;
    boolean isSQLJSingletonQuery = false;
    short CLIStatementType = 0;
    Vector SQLJBatchStatements = null;
    long queryInstanceIdentifier;

    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n2, int n3) throws SQLException {
        this.connection = dB2Connection;
        this.sqlExcptGen = dB2Connection.sqlExcptGen;
        if (null == string || 0 == string.trim().length()) {
            this.sqlExcptGen.throwNullError();
        }
        this.rsType = n2;
        this.rsConcur = n3;
        this.checkResultSetType(n2, n3);
        n2 = this.rsType;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
        this.statementType = this.getStatementType(string);
        this.sql = 27 == this.statementType ? this.parseSQLJ(string) : string;
        try {
            this.db2req.write((short)61);
            this.db2req.write(this.sql);
            this.db2req.write((short)this.rsType);
            this.db2req.write(this.SQLJCursorName);
            this.db2req.write(this.SQLJPID);
            this.db2req.sendAndRecv();
            int n4 = this.db2req.readInt();
            this.statementHandle = this.db2req.readInt();
            this.maxNumParams = this.db2req.readInt();
            this.rsType = this.db2req.readInt();
            if (this.rsType != n2) {
                this.connection.addWarning(new SQLWarning("Cursor downgraded to TYPE_FORWARD_ONLY", "01S02", -99999));
            }
            if (n4 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n4);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.initParameterVariables();
        if (27 == this.statementType && this.sqljDescribeInfo != null) {
            this.processSQLJDescribeInfo();
        }
    }

    private void initParameterVariables() {
        this.direction = new short[this.maxNumParams];
        this.sqltypes = new int[this.maxNumParams];
        this.ctypes = new int[this.maxNumParams];
        this.maxWholeDigits = new int[this.maxNumParams];
        this.precisions = new int[this.maxNumParams];
        this.scales = new int[this.maxNumParams];
        this.wasBound = new boolean[this.maxNumParams];
        this.described = new short[this.maxNumParams];
        this.paramRow = new ParamElement[this.maxNumParams];
        this.maxParamLength = new int[this.maxNumParams];
        int n2 = 0;
        while (n2 < this.maxNumParams) {
            this.direction[n2] = 0;
            this.sqltypes[n2] = 0;
            this.ctypes[n2] = 0;
            this.maxWholeDigits[n2] = 0;
            this.precisions[n2] = 0;
            this.scales[n2] = 0;
            this.wasBound[n2] = false;
            this.described[n2] = 0;
            this.paramRow[n2] = new ParamElement();
            this.maxParamLength[n2] = 0;
            ++n2;
        }
    }

    public DB2PreparedStatement(String string, DB2Connection dB2Connection) throws SQLException {
        this(string, dB2Connection, 1003, 1007);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseSQLJ(String var1_1) throws SQLException {
        block27: {
            block26: {
                var2_2 = null;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "parseSQLJ( " + var1_1 + " )");
                    }
                    var2_2 = var1_1.substring(var1_1.indexOf("{"));
                    var3_3 = var2_2.indexOf("db2jrt");
                    var4_4 = 6;
                    var5_5 = var1_1.indexOf(",");
                    var6_6 = Integer.parseInt(var1_1.substring(1, var5_5));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "numOfTokens", var6_6);
                    }
                    if (var6_6 > 0) {
                        var7_7 = new int[var6_6];
                        var8_9 = 0;
                        ++var5_5;
                        var9_10 = 0;
                        while (var9_10 < var6_6) {
                            var8_9 = var1_1.indexOf(",", var5_5);
                            var7_7[var9_10] = Integer.parseInt(var1_1.substring(var5_5, var8_9));
                            var5_5 = var8_9 + 1;
                            ++var9_10;
                        }
                        this.colCount4JSQL = var6_6;
                        this.colNames4JSQL = new String[var6_6];
                        var10_12 = 0;
                        while (var10_12 < var6_6) {
                            var8_9 = var5_5 + var7_7[var10_12];
                            this.colNames4JSQL[var10_12] = new String(var1_1.substring(var5_5, var8_9));
                            var5_5 = var8_9;
                            ++var10_12;
                        }
                    }
                    var7_8 = var1_1.indexOf(",", ++var5_5);
                    var8_9 = Integer.parseInt(var1_1.substring(var5_5, var7_8));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "cursorName_len", var8_9);
                    }
                    if (var8_9 > 0) {
                        var5_5 = var7_8 + 1;
                        var7_8 = var1_1.indexOf(",", var5_5);
                        var9_10 = Integer.parseInt(var1_1.substring(var5_5, var7_8));
                        var5_5 = var7_8 + 1;
                        var7_8 = var1_1.indexOf(",", var5_5);
                        var10_12 = Integer.parseInt(var1_1.substring(var5_5, var7_8));
                        var11_13 = var2_2.substring(var9_10, var10_12);
                        var5_5 = var7_8 + 1;
                        var7_8 = var5_5 + var8_9;
                        this.SQLJCursorName = new String(var1_1.substring(var5_5, var7_8)) + "," + var11_13;
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "cursor_pid_ep", var10_12);
                            DB2Trace.data(20, "cursorName", this.SQLJCursorName);
                        }
                    } else {
                        var10_12 = var2_2.lastIndexOf(125);
                        var10_12 = var2_2.lastIndexOf(41, var10_12 - 1);
                        var10_12 = var2_2.lastIndexOf(39, var10_12 - 1);
                        var9_10 = var2_2.lastIndexOf("','", var10_12 - 1);
                        var11_13 = var2_2.substring(var9_10 + 3, var10_12);
                        var10_12 = var9_10;
                        var12_14 = var2_2.substring((var9_10 = var2_2.lastIndexOf("','", var10_12 - 1)) + 3, var10_12);
                        if (var12_14.length() > 0 || var11_13.length() > 0) {
                            var9_10 = var3_3 + var4_4;
                            var9_10 = var2_2.indexOf("'", var9_10) + 1;
                            var10_12 = var2_2.indexOf(44, var9_10);
                            var13_15 = var2_2.indexOf("',", var10_12);
                            var14_16 = var2_2.substring(var9_10, var10_12);
                            var15_17 = var2_2.substring(var10_12 + 1, var13_15);
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(20, "CursorName", var14_16);
                                DB2Trace.data(20, "PIDString", var15_17);
                            }
                            var2_2 = var12_14 + var14_16 + var11_13;
                            var16_18 = new ByteArrayOutputStream(162);
                            var17_19 = 0;
                            var18_20 = var15_17.length();
                            var20_21 = 0;
                            while (var20_21 < var18_20) {
                                var19_22 = var15_17.charAt(var20_21);
                                if (',' == var19_22) {
                                    var16_18.write(var17_19);
                                    var17_19 = 0;
                                } else if (' ' != var19_22) {
                                    var17_19 = var17_19 * 10 + Character.digit(var19_22, 10);
                                }
                                ++var20_21;
                            }
                            this.SQLJPID = var16_18.toByteArray();
                        }
                    }
                    if (var2_2.indexOf("db2jrt") != -1) {
                        var5_5 = var2_2.indexOf("db2jrt");
                        var9_10 = 0;
                        while (var9_10 < 5) {
                            var5_5 = var2_2.indexOf("'", var5_5 + 1);
                            ++var9_10;
                        }
                        var7_8 = var2_2.indexOf("'", var5_5 + 1);
                        if (var2_2.substring(var5_5, var7_8 + 1).indexOf(",") != -1) {
                            this.sqljDescribeInfo = var2_2.substring(var5_5 + 1, var7_8);
                        }
                    }
                    if (this.sqljDescribeInfo == null) {
                        var5_5 = var2_2.indexOf(39, var3_3 + var4_4 + 1);
                        var5_5 = var2_2.indexOf(39, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var5_5 = var2_2.indexOf(44, var5_5 + 1);
                        var7_8 = var2_2.indexOf(39, (var5_5 = var2_2.indexOf(39, var5_5 + 1)) + 1);
                        if (var7_8 - var5_5 > 1) {
                            this.SQLJParmIsGraphic = new boolean[var7_8 - var5_5 - 1];
                            ++var5_5;
                            var9_10 = 0;
                            while (var9_10 < this.SQLJParmIsGraphic.length) {
                                if (var2_2.charAt(var5_5) == '1') {
                                    this.SQLJParmIsGraphic[var9_10] = true;
                                }
                                ++var9_10;
                                ++var5_5;
                            }
                        }
                    }
                    var9_11 = var2_2;
                    var22_23 = null;
                    if (DB2Trace.TraceOn == false) return var9_11;
                    if (this.SQLJParmIsGraphic == null) break block26;
                    var23_25 = 0;
                    ** while (var23_25 < this.SQLJParmIsGraphic.length)
                }
                catch (Throwable var21_27) {
                    var22_24 = null;
                    if (!DB2Trace.TraceOn) throw var21_27;
                    if (this.SQLJParmIsGraphic == null) break block27;
                    var23_26 = 0;
                    ** while (var23_26 < this.SQLJParmIsGraphic.length)
                }
lbl-1000:
                // 1 sources

                {
                    DB2Trace.data(100, "SQLJParmIsGraphic[" + var23_25 + "]", String.valueOf(this.SQLJParmIsGraphic[var23_25]));
                    ++var23_25;
                    continue;
                }
            }
            DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
            return var9_11;
lbl-1000:
            // 1 sources

            {
                DB2Trace.data(100, "SQLJParmIsGraphic[" + var23_26 + "]", String.valueOf(this.SQLJParmIsGraphic[var23_26]));
                ++var23_26;
                continue;
            }
        }
        DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
        throw var21_27;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForSQLJGraphic(int n2) {
        int n3 = n2 - 1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkForSQLJGraphic( " + n2 + " )");
                DB2Trace.data(10, "sqltypes[" + n3 + "]", this.sqltypes[n3]);
            }
            if (27 == this.statementType && this.SQLJParmIsGraphic != null && this.SQLJParmIsGraphic.length > n3 && this.SQLJParmIsGraphic[n3]) {
                int n4 = this.sqltypes[n3];
                switch (this.sqltypes[n3]) {
                    case 1: {
                        this.sqltypes[n3] = -95;
                        break;
                    }
                    case 12: {
                        this.sqltypes[n3] = -96;
                        break;
                    }
                    case -1: {
                        this.sqltypes[n3] = -97;
                        break;
                    }
                    case -99: {
                        this.sqltypes[n3] = -350;
                    }
                }
                if (this.sqltypes[n3] != n4) {
                    this.wasBound[n3] = false;
                }
            }
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "sqltypes[" + n3 + "]", this.sqltypes[n3]);
            DB2Trace.methodExit(this, "checkForSQLJGraphic()");
            throw throwable;
        }
        DB2Trace.data(100, "sqltypes[" + n3 + "]", this.sqltypes[n3]);
        DB2Trace.methodExit(this, "checkForSQLJGraphic()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSQLJDescribeInfo() {
        try {
            StringTokenizer stringTokenizer;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "processSQLJDescribeInfo()");
            }
            if ((stringTokenizer = new StringTokenizer(this.sqljDescribeInfo, ",", false)).countTokens() > 0) {
                int n2 = stringTokenizer.countTokens() - 1;
                String string = "";
                stringTokenizer.nextToken();
                int n3 = 0;
                while (n3 < n2) {
                    string = stringTokenizer.nextToken();
                    int n4 = 0;
                    int n5 = 0;
                    if (string.indexOf(" ") != -1) {
                        n5 = string.indexOf("(");
                        this.sqltypes[n3] = new Integer(string.substring(n4, n5));
                        n4 = n5 + 1;
                        n5 = string.indexOf(" ");
                        this.precisions[n3] = new Integer(string.substring(n4, n5));
                        string.substring(n4, n5);
                        n4 = n5 + 1;
                        n5 = string.indexOf(")");
                        this.scales[n3] = new Integer(string.substring(n4, n5));
                    } else if (string.indexOf("(") != -1) {
                        n5 = string.indexOf("(");
                        this.sqltypes[n3] = new Integer(string.substring(n4, n5));
                        n4 = n5 + 1;
                        n5 = string.indexOf(")");
                        this.precisions[n3] = new Integer(string.substring(n4, n5));
                    } else {
                        this.sqltypes[n3] = new Integer(string);
                    }
                    ++n3;
                }
            }
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
    }

    protected boolean setDirection(int n2, int n3, int n4) {
        return this.setDirection(n2, n3, n4, -1);
    }

    protected boolean setDirection(int n2, int n3, int n4, int n5) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setDirection( " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + " )");
        }
        int n6 = n2 - 1;
        boolean bl = true;
        if (this.direction[n6] == 4) {
            this.direction[n6] = 2;
            bl = false;
        } else if (this.direction[n6] == 0) {
            this.direction[n6] = 1;
            bl = false;
        }
        if (this.described[n6] != 1 && n3 != 0 && this.sqltypes[n6] != n3) {
            this.sqltypes[n6] = n3;
            bl = false;
        }
        if ((this.sqltypes[n6] == 3 || this.sqltypes[n6] == 2) && n5 != -1 && n5 != this.scales[n6]) {
            this.scales[n6] = n5;
            bl = false;
        }
        if (this.ctypes[n6] != n4) {
            this.ctypes[n6] = n4;
            bl = false;
        }
        if (!bl) {
            this.wasBound[n6] = false;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setDirection()", bl);
        }
        return bl;
    }

    protected int loadParameters() throws SQLException {
        int n2 = -1;
        int n3 = 99;
        boolean bl = true;
        try {
            while (n3 == 99) {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    int n4;
                    this.db2req.write((short)76);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n3 = this.db2req.readInt();
                    if (n3 == 100) {
                        n4 = n3;
                        return n4;
                    }
                    if (n3 != this.SQL_SUCCESS && n3 != this.SQL_SUCCESS_WITH_INFO && n3 != 99) {
                        this.sqlExcptGen.check_return_code(this, n3);
                    }
                    if (n3 == 99) {
                        Object[] objectArray;
                        Object object;
                        n2 = this.db2req.readInt();
                        n4 = n2 - 1;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = this.paramRow[n4].getLength();
                        if (!this.paramRow[n4].doConversion()) {
                            object = (InputStream)this.paramRow[n4].getValue();
                            objectArray = new byte[Math.min(32699, n7)];
                            while (n7 != 0 && (n5 = ((InputStream)object).read((byte[])objectArray, 0, Math.min(32699, n7))) != -1) {
                                n7 -= n5;
                                if (n5 == 0) break;
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                if (this.sqltypes[n4] == -99) {
                                    this.db2req.write((short)1);
                                } else {
                                    this.db2req.write((short)0);
                                }
                                this.db2req.write((byte[])objectArray, n5);
                                this.db2req.sendAndRecv();
                                n6 = this.db2req.readInt();
                                if (n6 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n6);
                            }
                            n5 = ((InputStream)object).read();
                        } else {
                            object = new BufferedReader((Reader)this.paramRow[n4].getValue());
                            objectArray = new char[Math.min(16349, n7)];
                            while (n7 != 0 && (n5 = ((BufferedReader)object).read((char[])objectArray, 0, Math.min(objectArray.length, n7))) != -1) {
                                n7 -= n5;
                                if (n5 == 0) break;
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                this.db2req.write((short)1);
                                this.db2req.write(new String((char[])objectArray, 0, n5));
                                this.db2req.sendAndRecv();
                                n6 = this.db2req.readInt();
                                if (n6 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n6);
                            }
                            n5 = ((BufferedReader)object).read();
                        }
                        if (!Boolean.getBoolean("DB2.ignore.stream.length") && (-1 == n5 && n7 != 0 || -1 != n5 && n7 == 0)) {
                            object = this.db2req;
                            synchronized (object) {
                                this.db2req.write((short)23);
                                this.db2req.write(this.statementHandle);
                                this.db2req.sendAndRecv();
                                n3 = this.db2req.readInt();
                            }
                            DB2Trace.data(30, "Data length provided to stream did not match the stream length sent to server. Throwing an SQLException");
                            throw new SQLException("The stream contains more or less data than was specified");
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n3;
    }

    public ResultSet executeQuery() throws SQLException {
        int n2;
        if (24 != this.statementType && 25 != this.statementType && 27 != this.statementType) {
            this.sqlExcptGen.throwInvalidQueryError();
        }
        if ((n2 = this.execute2()) != 100 && n2 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
        this.getResultSet();
        return this.resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n2;
        if (24 == this.statementType) {
            this.sqlExcptGen.throwInvalidUpdateError();
        }
        if ((n2 = this.execute2()) == 100) {
            this.rowCount = 0;
        } else if (n2 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
        return this.getUpdateCount();
    }

    protected synchronized int execute2() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n2 = 0;
        this.warnings = null;
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        if (this.resultSet != null) {
            this.resultSet.realClose();
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)79);
                this.db2req.write(this.statementHandle);
                this.paramToServer();
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                this.executed = true;
                if (n2 == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                    if (this.resultSet != null) {
                        this.resultSet.closed = false;
                    }
                } else if (n2 == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n2);
                    this.checkForCursorDowngrade();
                    this.getCounts();
                    if (this.resultSet != null) {
                        this.resultSet.closed = false;
                    }
                    n2 = this.SQL_SUCCESS;
                }
            }
            if (n2 == 99) {
                n2 = this.loadParameters();
                if (n2 == this.SQL_SUCCESS) {
                    this.getCounts();
                } else if (n2 == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n2);
                    this.getCounts();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void paramToServer() throws IOException, SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "paramToServer()");
            }
            int n2 = 0;
            while (n2 < this.maxNumParams) {
                block26: {
                    block27: {
                        this.db2req.write(this.direction[n2]);
                        if (this.direction[n2] == 0) break block26;
                        this.db2req.write((short)this.ctypes[n2]);
                        if (27 == this.statementType && this.sqljDescribeInfo == null) {
                            this.checkForSQLJGraphic(n2 + 1);
                        }
                        this.db2req.write((short)this.sqltypes[n2]);
                        if (this.sqltypes[n2] == 2 || this.sqltypes[n2] == 3) {
                            this.db2req.write((short)this.scales[n2]);
                        }
                        this.db2req.write(this.wasBound[n2] ? (short)1 : 0);
                        if (!this.paramRow[n2].isSet()) break block26;
                        if (this.direction[n2] == 4) break block27;
                        if (this.paramRow[n2].isStream()) {
                            this.db2req.write(-2);
                        } else {
                            this.db2req.write(this.paramRow[n2].getLength());
                        }
                        if (this.paramRow[n2].getLength() == -1) break block26;
                        switch (this.ctypes[n2]) {
                            case 5: {
                                this.db2req.write(((PrimitiveData)this.paramRow[n2].getValue()).shortValue());
                                break;
                            }
                            case 4: {
                                this.db2req.write(((PrimitiveData)this.paramRow[n2].getValue()).intValue());
                                break;
                            }
                            case -25: {
                                this.db2req.write(((PrimitiveData)this.paramRow[n2].getValue()).longValue());
                                break;
                            }
                            case 7: {
                                this.db2req.write(((PrimitiveData)this.paramRow[n2].getValue()).floatValue());
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.db2req.write(((PrimitiveData)this.paramRow[n2].getValue()).doubleValue());
                                break;
                            }
                            case 91: {
                                int[] nArray = (int[])this.paramRow[n2].getValue();
                                this.db2req.write((short)nArray[0]);
                                this.db2req.write((short)nArray[1]);
                                this.db2req.write((short)nArray[2]);
                                break;
                            }
                            case 92: {
                                int[] nArray = (int[])this.paramRow[n2].getValue();
                                this.db2req.write((short)nArray[0]);
                                this.db2req.write((short)nArray[1]);
                                this.db2req.write((short)nArray[2]);
                                break;
                            }
                            case 93: {
                                int[] nArray = (int[])this.paramRow[n2].getValue();
                                this.db2req.write((short)nArray[0]);
                                this.db2req.write((short)nArray[1]);
                                this.db2req.write((short)nArray[2]);
                                this.db2req.write((short)nArray[3]);
                                this.db2req.write((short)nArray[4]);
                                this.db2req.write((short)nArray[5]);
                                this.db2req.write(nArray[6]);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.db2req.write(this.paramRow[n2].getValue().toString());
                                break;
                            }
                            case -8: 
                            case 1: {
                                if (this.paramRow[n2].isStream()) break;
                                this.db2req.write((String)this.paramRow[n2].getValue());
                                break;
                            }
                            case -2: {
                                if (this.paramRow[n2].isStream()) break;
                                this.db2req.write((byte[])this.paramRow[n2].getValue());
                                break;
                            }
                            case -351: 
                            case 41: {
                                DB2Clob dB2Clob = (DB2Clob)this.paramRow[n2].getValue();
                                this.db2req.write(dB2Clob.getLocator());
                                break;
                            }
                            case 31: {
                                DB2Blob dB2Blob = (DB2Blob)this.paramRow[n2].getValue();
                                this.db2req.write(dB2Blob.getLocator());
                                break;
                            }
                            default: {
                                this.sqlExcptGen.pstmtException("S1003");
                            }
                        }
                    }
                    this.wasBound[n2] = true;
                }
                ++n2;
            }
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "paramToServer()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "paramToServer()");
    }

    public void setNull(int n2, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (n3 == 0) {
            this.sqlExcptGen.pstmtException("S1003");
        }
        int n4 = this.convert2SQLType(n3);
        int n5 = this.sqlType2cType(n4);
        this.setDirection(n2, n4, n5);
        this.paramRow[n2 - 1].set(-1, null);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setNull()");
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBoolean(n2, bl, 5);
    }

    protected void setBoolean(int n2, boolean bl, int n3) throws SQLException {
        if (bl) {
            this.setShort(n2, (short)1, n3);
        } else {
            this.setShort(n2, (short)0, n3);
        }
    }

    public void setByte(int n2, byte by) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setByte(n2, by, 5);
    }

    protected void setByte(int n2, byte by, int n3) throws SQLException {
        this.setShort(n2, by, n3);
    }

    public void setShort(int n2, short s2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setShort(n2, s2, 5);
    }

    protected void setShort(int n2, short s2, int n3) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n3, 5);
        this.paramRow[n2 - 1].set(0, s2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setInt(n2, n3, 4);
    }

    protected void setInt(int n2, int n3, int n4) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n4, 4);
        this.paramRow[n2 - 1].set(0, n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setLong(n2, l2, -5);
    }

    protected void setLong(int n2, long l2, int n3) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        n3 = -5;
        this.setDirection(n2, n3, -25);
        if (-5 == n3) {
            this.paramRow[n2 - 1].set(0, l2);
        } else {
            this.paramRow[n2 - 1].set(0, (int)l2);
        }
    }

    public void setFloat(int n2, float f2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setFloat(n2, f2, 7);
    }

    protected void setFloat(int n2, float f2, int n3) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n3, 7);
        this.paramRow[n2 - 1].set(0, f2);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setDouble(n2, d2, 8);
    }

    protected void setDouble(int n2, double d2, int n3) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n3, 8);
        this.paramRow[n2 - 1].set(0, d2);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBigDecimal(n2, bigDecimal, 2);
    }

    protected void setBigDecimal(int n2, BigDecimal bigDecimal, int n3) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n4 = n2 - 1;
        if (bigDecimal == null) {
            this.setNull(n2, n3);
            this.maxWholeDigits[n4] = 31;
            return;
        }
        this.setDirection(n2, n3, -8);
        this.setPrecisionAndScale(n4, bigDecimal);
    }

    protected void setPrecisionAndScale(int n2, BigDecimal bigDecimal) {
        String string = bigDecimal.abs().toString();
        int n3 = 0;
        int n4 = string.length();
        if (string.indexOf(46) != -1) {
            n3 = 1;
        }
        int n5 = 0;
        while (n5 < n4) {
            if (!string.startsWith("0", n5)) break;
            ++n3;
            ++n5;
        }
        int n6 = bigDecimal.scale();
        int n7 = n4 - n3;
        int n8 = (n7 = Math.max(n7, 1)) - n6;
        if (n8 > this.maxWholeDigits[n2]) {
            this.maxWholeDigits[n2] = n8;
        }
        if (n6 > this.scales[n2]) {
            this.scales[n2] = n6;
            this.wasBound[n2] = false;
        } else {
            n7 += this.scales[n2] - n6;
        }
        this.paramRow[n2].set(n7, bigDecimal.toString());
    }

    public void setString(int n2, String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (string == null) {
            this.setNull(n2, 12);
            return;
        }
        int n3 = string.length() < 4000 ? 12 : -1;
        this.setString(n2, string, n3, -1);
    }

    protected void setString(int n2, String string, int n3) throws SQLException {
        this.setString(n2, string, n3, -1);
    }

    protected void setString(int n2, String string, int n3, int n4) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n3, -8, n4);
        int n5 = string.length();
        this.paramRow[n2 - 1].set(n5, string);
        if (n4 <= 0) {
            if (n5 > this.maxWholeDigits[n2 - 1]) {
                this.maxWholeDigits[n2 - 1] = n5;
            }
        } else {
            int n6 = n5 - n4;
            if (n6 > this.maxWholeDigits[n2 - 1]) {
                this.maxWholeDigits[n2 - 1] = n6;
            }
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (byArray == null) {
            this.setNull(n2, -3);
            return;
        }
        int n3 = byArray.length;
        int n4 = n3 < 4001 ? -3 : -4;
        this.setBytes(n2, byArray, n4);
    }

    protected void setBytes(int n2, byte[] byArray, int n3) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        switch (n3) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.sqlExcptGen.pstmtException("22003");
            }
        }
        this.setDirection(n2, n3, -2);
        this.paramRow[n2 - 1].set(byArray.length, byArray);
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.setDate(n2, date, 91, Calendar.getInstance());
    }

    protected void setDate(int n2, Date date, int n3) throws SQLException {
        this.setDate(n2, date, n3, Calendar.getInstance());
    }

    protected void setDate(int n2, Date date, int n3, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n2, n3);
            return;
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n3, 91);
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5)};
        this.paramRow[n2 - 1].set(0, nArray);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.setTime(n2, time, 92, Calendar.getInstance());
    }

    protected void setTime(int n2, Time time, int n3) throws SQLException {
        this.setTime(n2, time, n3, Calendar.getInstance());
    }

    protected void setTime(int n2, Time time, int n3, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNull(n2, n3);
            return;
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n3, 92);
        calendar = (Calendar)calendar.clone();
        calendar.setTime(time);
        int[] nArray = new int[]{calendar.get(11), calendar.get(12), calendar.get(13)};
        this.paramRow[n2 - 1].set(0, nArray);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n2, timestamp, 93, Calendar.getInstance());
    }

    protected void setTimestamp(int n2, Timestamp timestamp, int n3) throws SQLException {
        this.setTimestamp(n2, timestamp, n3, Calendar.getInstance());
    }

    protected void setTimestamp(int n2, Timestamp timestamp, int n3, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setNull(n2, n3);
            return;
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setDirection(n2, n3, 93);
        calendar = (Calendar)calendar.clone();
        calendar.setTime(timestamp);
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos()};
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "Year", nArray[0]);
            DB2Trace.data(10, "Month", nArray[1]);
            DB2Trace.data(10, "Day", nArray[2]);
            DB2Trace.data(10, "Hour_of_Day", nArray[3]);
            DB2Trace.data(10, "Minute", nArray[4]);
            DB2Trace.data(10, "Second", nArray[5]);
            DB2Trace.data(10, "Nano", nArray[6]);
        }
        this.paramRow[n2 - 1].set(0, nArray);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n4 = -1;
        if (inputStream == null) {
            this.setNull(n2, 12);
            return;
        }
        if (0 == n3) {
            String string = new String();
            this.setString(n2, string);
            return;
        }
        this.setDirection(n2, n4, 1);
        this.paramRow[n2 - 1].set(n3, inputStream, true, false);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n4 = -1;
        if (null == inputStream) {
            this.setNull(n2, 12);
            return;
        }
        if (0 == n3) {
            String string = new String();
            this.setString(n2, string);
            return;
        }
        this.setDirection(n2, n4, -8);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UnicodeBig");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.paramRow[n2 - 1].set(n3 / 2, inputStreamReader, true, true);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setBinaryStream(n2, inputStream, n3, -4);
    }

    protected void setBinaryStream(int n2, InputStream inputStream, int n3, int n4) throws SQLException {
        if (null == inputStream) {
            this.setNull(n2, n4);
            return;
        }
        if (0 == n3) {
            this.setBytes(n2, new byte[0], n4);
            return;
        }
        this.setDirection(n2, n4, -2);
        this.paramRow[n2 - 1].set(n3, inputStream, true, false);
    }

    public synchronized void clearParameters() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n2 = 0;
        while (n2 < this.maxNumParams) {
            this.wasBound[n2] = false;
            this.paramRow[n2].unset();
            this.direction[n2] = 0;
            ++n2;
        }
        if (this.executed) {
            try {
                int n3;
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)77);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n3 = this.db2req.readInt();
                }
                if (n3 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n3);
                }
                this.executed = false;
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
            }
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.setObject(n2, object, 0, -1);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObject(n2, object, n3, -1);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        block65: {
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n2 < 1 || n2 > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (object == null) {
                this.setNull(n2, n3);
                return;
            }
            if (n3 == 0) {
                try {
                    if (object instanceof String) {
                        this.setString(n2, (String)object);
                        break block65;
                    }
                    if (object instanceof Character) {
                        this.setString(n2, ((Character)object).toString());
                        break block65;
                    }
                    if (object instanceof BigDecimal) {
                        BigDecimal bigDecimal = n4 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n4, 4);
                        this.setBigDecimal(n2, bigDecimal);
                        break block65;
                    }
                    if (object instanceof Boolean) {
                        this.setBoolean(n2, (Boolean)object);
                        break block65;
                    }
                    if (object instanceof Short) {
                        this.setShort(n2, (Short)object);
                        break block65;
                    }
                    if (object instanceof Integer) {
                        this.setInt(n2, (Integer)object);
                        break block65;
                    }
                    if (object instanceof Long) {
                        this.setLong(n2, (Long)object);
                        break block65;
                    }
                    if (object instanceof Float) {
                        this.setFloat(n2, ((Float)object).floatValue());
                        break block65;
                    }
                    if (object instanceof Double) {
                        this.setDouble(n2, (Double)object);
                        break block65;
                    }
                    if (object instanceof byte[]) {
                        this.setBytes(n2, (byte[])object);
                        break block65;
                    }
                    if (object instanceof Date) {
                        this.setDate(n2, (Date)object, 91, Calendar.getInstance());
                        break block65;
                    }
                    if (object instanceof Time) {
                        this.setTime(n2, (Time)object, 92, Calendar.getInstance());
                        break block65;
                    }
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n2, (Timestamp)object, 93, Calendar.getInstance());
                        break block65;
                    }
                    if (object instanceof Blob) {
                        this.setBlob(n2, (Blob)object);
                        break block65;
                    }
                    if (object instanceof Clob) {
                        this.setClob(n2, (Clob)object);
                        break block65;
                    }
                    if (object instanceof URL) {
                        this.setURL(n2, (URL)object);
                        break block65;
                    }
                    this.sqlExcptGen.pstmtException("S1003");
                }
                catch (ClassCastException classCastException) {
                    this.sqlExcptGen.pstmtException("S1003");
                }
            } else {
                n3 = this.convert2SQLType(n3);
                try {
                    if (object instanceof String) {
                        if (n3 == 3 || n3 == 8 || n3 == 6 || n3 == 2 || n3 == 7) {
                            this.setString(n2, DB2PreparedStatement.translateFloat((String)object), n3, n4);
                            break block65;
                        }
                        if (n3 == -400 || n3 == 70) {
                            try {
                                URL uRL = new URL((String)object);
                                this.setURL(n2, uRL, n3);
                                break block65;
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new SQLException(malformedURLException.getMessage());
                            }
                        }
                        this.setString(n2, (String)object, n3);
                        break block65;
                    }
                    if (object instanceof Character) {
                        if (n3 == 3 || n3 == 8 || n3 == 6 || n3 == 2 || n3 == 7) {
                            this.setString(n2, DB2PreparedStatement.translateFloat(((Character)object).toString()), n3, n4);
                        } else {
                            this.setString(n2, ((Character)object).toString(), n3);
                        }
                    } else if (object instanceof BigDecimal) {
                        BigDecimal bigDecimal = n4 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n4, 4);
                        this.setBigDecimal(n2, bigDecimal, n3);
                    } else if (object instanceof Boolean) {
                        if (n3 == 1 || n3 == 12 || n3 == -1 || n3 == -99) {
                            this.setString(n2, ((Boolean)object).toString(), n3);
                        } else {
                            this.setBoolean(n2, (Boolean)object, n3);
                        }
                    } else if (object instanceof Short) {
                        this.setShort(n2, (Short)object, n3);
                    } else if (object instanceof Integer) {
                        this.setInt(n2, (Integer)object, n3);
                    } else if (object instanceof Long) {
                        this.setLong(n2, (Long)object, n3);
                    } else if (object instanceof Float) {
                        this.setFloat(n2, ((Float)object).floatValue(), n3);
                    } else if (object instanceof Double) {
                        this.setDouble(n2, (Double)object, n3);
                    } else if (object instanceof byte[]) {
                        this.setBytes(n2, (byte[])object, n3);
                    } else if (object instanceof Date) {
                        this.setDate(n2, (Date)object, n3, Calendar.getInstance());
                    } else if (object instanceof Time) {
                        this.setTime(n2, (Time)object, n3, Calendar.getInstance());
                    } else if (object instanceof Timestamp) {
                        this.setTimestamp(n2, (Timestamp)object, n3, Calendar.getInstance());
                    } else if (object instanceof Blob) {
                        this.setBlob(n2, (Blob)object, n3);
                    } else if (object instanceof Clob) {
                        this.setClob(n2, (Clob)object, n3);
                    } else if (object instanceof URL) {
                        this.setURL(n2, (URL)object, n3);
                    } else {
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                }
                catch (ClassCastException classCastException) {
                    this.sqlExcptGen.pstmtException("S1003");
                }
            }
        }
    }

    public boolean execute() throws SQLException {
        int n2 = this.execute2();
        if (n2 == 100) {
            this.rowCount = 0;
        } else if (n2 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
        return this.colCount > 0;
    }

    protected int convert2SQLType(int n2) {
        int n3 = n2;
        switch (n3) {
            case -7: 
            case -6: {
                n3 = 5;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            case 6: {
                n3 = 8;
                break;
            }
            case 2004: {
                n3 = -98;
                break;
            }
            case 2005: {
                n3 = -99;
                break;
            }
            case 70: {
                n3 = -400;
            }
        }
        return n3;
    }

    protected int sqlType2cType(int n2) {
        int n3;
        switch (n2) {
            case -5: {
                n3 = -25;
                break;
            }
            case -98: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                n3 = -2;
                break;
            }
            case -99: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 2005: {
                n3 = -8;
                break;
            }
            case -400: 
            case 70: {
                n3 = 1;
                break;
            }
            default: {
                n3 = n2;
            }
        }
        return n3;
    }

    protected void setTargetType(int n2, int n3, String string) throws SQLException {
        try {
            switch (n3) {
                case 5: {
                    this.setShort(n2, Short.parseShort(string));
                    break;
                }
                case 4: {
                    this.setInt(n2, Integer.parseInt(string));
                    break;
                }
                case -5: {
                    this.setLong(n2, Long.parseLong(string));
                    break;
                }
                case 6: 
                case 8: {
                    this.setDouble(n2, Double.valueOf(DB2PreparedStatement.translateFloat(string)));
                    break;
                }
                case 7: {
                    this.setFloat(n2, Float.valueOf(DB2PreparedStatement.translateFloat(string)).floatValue());
                    break;
                }
                case 91: {
                    this.setDate(n2, Date.valueOf(string), 91, Calendar.getInstance());
                    break;
                }
                case 92: {
                    this.setTime(n2, Time.valueOf(string), 92, Calendar.getInstance());
                    break;
                }
                case 93: {
                    this.setTimestamp(n2, Timestamp.valueOf(string), 92, Calendar.getInstance());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n2, new BigDecimal(DB2PreparedStatement.translateFloat(string)));
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -1: 
                case 1: 
                case 12: {
                    this.setString(n2, string);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    int n4 = string.length();
                    byte[] byArray = new byte[n4];
                    int n5 = 0;
                    while (n5 < n4) {
                        byArray[n5] = (byte)string.charAt(n5);
                        ++n5;
                    }
                    this.setBytes(n2, byArray);
                    break;
                }
                case -350: 
                case -99: {
                    this.setString(n2, string);
                    break;
                }
                case -98: {
                    int n6 = string.length();
                    byte[] byArray = new byte[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        byArray[n7] = (byte)string.charAt(n7);
                        ++n7;
                    }
                    this.setBytes(n2, byArray, -98);
                    break;
                }
                default: {
                    this.sqlExcptGen.pstmtException("S1003");
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.sqlExcptGen.pstmtException("S1003");
        }
    }

    private static String translateFloat(String string) {
        char c2 = new DecimalFormatSymbols().getDecimalSeparator();
        if (c2 != '.') {
            return string.replace(c2, '.');
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch()");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.paramSet.addElement(this.paramRow);
            ParamElement[] paramElementArray = new ParamElement[this.maxNumParams];
            int n2 = 0;
            while (n2 < this.maxNumParams) {
                if (this.maxParamLength[n2] < this.paramRow[n2].getLength()) {
                    this.maxParamLength[n2] = this.paramRow[n2].getLength();
                }
                paramElementArray[n2] = new ParamElement();
                ++n2;
            }
            this.paramRow = paramElementArray;
            ++this.batchSize;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "addBatch()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "addBatch()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearBatch()");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchSize = 0;
            this.paramSet.removeAllElements();
            int n2 = 0;
            while (n2 < this.maxNumParams) {
                this.paramRow[n2].unset();
                this.maxParamLength[n2] = 0;
                ++n2;
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "clearBatch()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "clearBatch()");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        block96: {
            block93: {
                try {
                    block94: {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "executeBatch()");
                        }
                        if (this.connection.closed) {
                            SQLExceptionGenerator.throwConnectionClosedError();
                        }
                        if (this.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        this.batchReturn = new int[this.batchSize];
                        if (this.resultSet != null) {
                            this.resultSet.realClose();
                        }
                        if (0 == this.batchSize) {
                            var1_1 = this.batchReturn;
                            var32_2 = null;
                            break block93;
                        }
                        var2_7 = 0;
                        while (true) {
                            if (var2_7 >= this.batchSize) {
                                if (24 != this.statementType) break;
                                throw new BatchUpdateException(SQLExceptionGenerator.errMsgClass.getString("0641"), "HY000", -99999, this.batchReturn);
                            }
                            this.batchReturn[var2_7] = -3;
                            ++var2_7;
                        }
                        var3_8 = null;
                        var4_9 = null;
                        var5_10 = new ParamElement[this.batchSize][this.maxNumParams];
                        var6_11 = 0;
                        var7_12 = 0;
                        var8_13 = 0;
                        var9_14 = -1;
                        var10_15 = null;
                        var11_16 = this.paramSet.elements();
                        while (true) {
                            block95: {
                                if (!var11_16.hasMoreElements()) {
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.data(20, "batchSize", this.batchSize);
                                        DB2Trace.data(20, "batchSizeAdjusted", var9_14);
                                        DB2Trace.data(20, "badRowCnt", var7_12);
                                        DB2Trace.data(20, "goodRowCnt", var8_13);
                                    }
                                    if (var9_14 < 1) {
                                        if (var10_15 == null) break;
                                        throw var10_15;
                                    }
                                    break block94;
                                }
                                var5_10[var6_11] = (ParamElement[])var11_16.nextElement();
                                var12_17 = false;
                                var13_20 = 0;
                                while (true) {
                                    if (var13_20 >= this.maxNumParams) {
                                        if (!var12_17) break;
                                        ++var7_12;
                                        break block95;
                                    }
                                    var14_21 = false;
                                    if (!var5_10[var6_11][var13_20].isSet()) {
                                        if (var3_8 == null || !var3_8[var13_20].isSet()) {
                                            var12_17 = true;
                                            var14_21 = true;
                                        } else {
                                            var5_10[var6_11][var13_20] = var3_8[var13_20];
                                        }
                                        if (var14_21) {
                                            var15_23 = new String[]{String.valueOf(var13_20 + 1), String.valueOf(var6_11 + 1)};
                                            var16_25 = SQLExceptionGenerator.errMsgClass.getString("0628", var15_23);
                                            if (null == var10_15) {
                                                var10_15 = new BatchUpdateException(var16_25, "", -99999, this.batchReturn);
                                            } else {
                                                var10_15.setNextException(new SQLException(var16_25, "", -99999));
                                            }
                                        }
                                    }
                                    ++var13_20;
                                }
                                if (var4_9 == null) {
                                    var9_14 = this.batchSize - var7_12;
                                    var4_9 = new ParamElement[var9_14][this.maxNumParams];
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.data(10, "First row with all params (zero-based)", var6_11);
                                    }
                                }
                                var4_9[var8_13] = var5_10[var6_11];
                                ++var8_13;
                            }
                            var3_8 = var5_10[var6_11];
                            ++var6_11;
                        }
                        var12_18 = this.batchReturn;
                        break block96;
                    }
                    var12_19 = new int[var9_14];
                    var13_20 = 0;
                    while (true) {
                        block98: {
                            if (var13_20 < var9_14) break block98;
                            var14_22 = null;
                            var15_24 = 0;
                            var16_26 = 0;
                            try {
                                block97: {
                                    var17_27 = this.db2req;
                                    synchronized (var17_27) {
                                        block99: {
                                            this.db2req.write((short)202);
                                            this.db2req.write(this.statementHandle);
                                            this.db2req.write((short)var9_14);
                                            if (var9_14 <= 0) break block99;
                                            var16_26 = 0;
                                            while (var16_26 < this.maxNumParams) {
                                                this.db2req.write((short)this.ctypes[var16_26]);
                                                this.db2req.write((short)this.sqltypes[var16_26]);
                                                if (2 == this.sqltypes[var16_26] || 3 == this.sqltypes[var16_26]) {
                                                    this.db2req.write(this.maxWholeDigits[var16_26] + this.scales[var16_26]);
                                                    this.db2req.write((short)this.scales[var16_26]);
                                                }
                                                this.db2req.write(this.maxParamLength[var16_26]);
                                                switch (this.ctypes[var16_26]) {
                                                    case -25: {
                                                        var18_30 = 0;
                                                        while (var18_30 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var18_30][var16_26], var18_30, var16_26)) {
                                                                var14_22 = var4_9[var18_30][var16_26].getValue();
                                                                this.db2req.write(var4_9[var18_30][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    this.db2req.write(((PrimitiveData)var14_22).longValue());
                                                                }
                                                            }
                                                            ++var18_30;
                                                        }
                                                        break;
                                                    }
                                                    case 4: {
                                                        var19_31 = 0;
                                                        while (var19_31 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var19_31][var16_26], var19_31, var16_26)) {
                                                                var14_22 = var4_9[var19_31][var16_26].getValue();
                                                                this.db2req.write(var4_9[var19_31][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    this.db2req.write(((PrimitiveData)var14_22).intValue());
                                                                }
                                                            }
                                                            ++var19_31;
                                                        }
                                                        break;
                                                    }
                                                    case -7: 
                                                    case -6: 
                                                    case 5: {
                                                        var20_36 = 0;
                                                        while (var20_36 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var20_36][var16_26], var20_36, var16_26)) {
                                                                var14_22 = var4_9[var20_36][var16_26].getValue();
                                                                this.db2req.write(var4_9[var20_36][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    this.db2req.write(((PrimitiveData)var14_22).shortValue());
                                                                }
                                                            }
                                                            ++var20_36;
                                                        }
                                                        break;
                                                    }
                                                    case 7: {
                                                        var21_37 = 0;
                                                        while (var21_37 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var21_37][var16_26], var21_37, var16_26)) {
                                                                var14_22 = var4_9[var21_37][var16_26].getValue();
                                                                this.db2req.write(var4_9[var21_37][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    this.db2req.write(((PrimitiveData)var14_22).floatValue());
                                                                }
                                                            }
                                                            ++var21_37;
                                                        }
                                                        break;
                                                    }
                                                    case 6: 
                                                    case 8: {
                                                        var22_38 = 0;
                                                        while (var22_38 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var22_38][var16_26], var22_38, var16_26)) {
                                                                var14_22 = var4_9[var22_38][var16_26].getValue();
                                                                this.db2req.write(var4_9[var22_38][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    this.db2req.write(((PrimitiveData)var14_22).doubleValue());
                                                                }
                                                            }
                                                            ++var22_38;
                                                        }
                                                        break;
                                                    }
                                                    case -8: 
                                                    case 1: {
                                                        var23_39 = 0;
                                                        while (var23_39 < var9_14) {
                                                            if (this.isElementNull(var4_9[var23_39][var16_26], var23_39, var16_26)) ** GOTO lbl177
                                                            var14_22 = var4_9[var23_39][var16_26].getValue();
                                                            if (null == var14_22) ** GOTO lbl176
                                                            if (var4_9[var23_39][var16_26].isStream()) {
                                                                this.db2req.write(-2);
                                                            } else {
                                                                this.db2req.write(var4_9[var23_39][var16_26].getLength());
                                                                this.db2req.write((String)var14_22);
                                                            }
                                                            ** GOTO lbl177
lbl176:
                                                            // 1 sources

                                                            this.db2req.write(var4_9[var23_39][var16_26].getLength());
lbl177:
                                                            // 4 sources

                                                            ++var23_39;
                                                        }
                                                        break;
                                                    }
                                                    case -2: {
                                                        var24_40 = 0;
                                                        while (var24_40 < var9_14) {
                                                            if (this.isElementNull(var4_9[var24_40][var16_26], var24_40, var16_26)) ** GOTO lbl193
                                                            var14_22 = var4_9[var24_40][var16_26].getValue();
                                                            if (null == var14_22) ** GOTO lbl192
                                                            if (var4_9[var24_40][var16_26].isStream()) {
                                                                this.db2req.write(-2);
                                                            } else {
                                                                this.db2req.write(var4_9[var24_40][var16_26].getLength());
                                                                this.db2req.write((byte[])var14_22);
                                                            }
                                                            ** GOTO lbl193
lbl192:
                                                            // 1 sources

                                                            this.db2req.write(var4_9[var24_40][var16_26].getLength());
lbl193:
                                                            // 4 sources

                                                            ++var24_40;
                                                        }
                                                        break;
                                                    }
                                                    case 91: {
                                                        var25_41 = 0;
                                                        while (var25_41 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var25_41][var16_26], var25_41, var16_26)) {
                                                                var14_22 = var4_9[var25_41][var16_26].getValue();
                                                                this.db2req.write(var4_9[var25_41][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    var26_42 = (int[])var14_22;
                                                                    this.db2req.write(var26_42[0]);
                                                                    this.db2req.write(var26_42[1]);
                                                                    this.db2req.write(var26_42[2]);
                                                                }
                                                            }
                                                            ++var25_41;
                                                        }
                                                        break;
                                                    }
                                                    case 92: {
                                                        var26_43 = 0;
                                                        while (var26_43 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var26_43][var16_26], var26_43, var16_26)) {
                                                                var14_22 = var4_9[var26_43][var16_26].getValue();
                                                                this.db2req.write(var4_9[var26_43][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    var27_44 = (int[])var14_22;
                                                                    this.db2req.write(var27_44[0]);
                                                                    this.db2req.write(var27_44[1]);
                                                                    this.db2req.write(var27_44[2]);
                                                                }
                                                            }
                                                            ++var26_43;
                                                        }
                                                        break;
                                                    }
                                                    case 93: {
                                                        var27_45 = 0;
                                                        while (var27_45 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var27_45][var16_26], var27_45, var16_26)) {
                                                                var14_22 = var4_9[var27_45][var16_26].getValue();
                                                                this.db2req.write(var4_9[var27_45][var16_26].getLength());
                                                                if (null != var14_22) {
                                                                    var28_46 = (int[])var14_22;
                                                                    var29_48 = 0;
                                                                    while (var29_48 < 7) {
                                                                        this.db2req.write(var28_46[var29_48]);
                                                                        ++var29_48;
                                                                    }
                                                                }
                                                            }
                                                            ++var27_45;
                                                        }
                                                        break;
                                                    }
                                                    case -351: 
                                                    case 31: 
                                                    case 41: {
                                                        var28_47 = 0;
                                                        while (var28_47 < var9_14) {
                                                            if (!this.isElementNull(var4_9[var28_47][var16_26], var28_47, var16_26)) {
                                                                this.db2req.write(var4_9[var28_47][var16_26].getLength());
                                                                if (31 == this.ctypes[var16_26]) {
                                                                    var29_49 = (DB2Blob)var4_9[var28_47][var16_26].getValue();
                                                                    if (null != var29_49) {
                                                                        this.db2req.write(var29_49.getLocator());
                                                                    }
                                                                } else {
                                                                    var29_49 = (DB2Clob)var4_9[var28_47][var16_26].getValue();
                                                                    if (null != var29_49) {
                                                                        this.db2req.write(var29_49.getLocator());
                                                                    }
                                                                }
                                                            }
                                                            ++var28_47;
                                                        }
                                                        break;
                                                    }
                                                    default: {
                                                        if (this.isElementNull(var4_9[0][var16_26], 0, var16_26)) break;
                                                    }
                                                }
                                                ++var16_26;
                                            }
                                        }
                                        this.db2req.sendAndRecv();
                                        var15_24 = this.db2req.readInt();
                                        var16_26 = 0;
                                        while (true) {
                                            if (var16_26 >= var9_14) {
                                                break;
                                            }
                                            var12_19[var16_26] = this.db2req.readInt();
                                            ++var16_26;
                                        }
                                    }
                                    var18_30 = 0;
                                    while (true) {
                                        if (var18_30 >= var12_19.length) {
                                            ** try [egrp 3[TRYBLOCK] [1 : 2271->2284)] { 
lbl274:
                                            // 1 sources

                                            break;
                                        }
                                        switch (var12_19[var18_30]) {
                                            case 0: 
                                            case 6: {
                                                this.batchReturn[var18_30 + var7_12] = -2;
                                                break;
                                            }
                                            case 5: {
                                                var15_24 = -1;
                                                this.batchReturn[var18_30 + var7_12] = -3;
                                                break;
                                            }
                                            case 7: {
                                                this.batchReturn[var18_30 + var7_12] = 0;
                                                break;
                                            }
                                        }
                                        ++var18_30;
                                    }
                                    {
                                        this.sqlExcptGen.check_return_code(this, var15_24);
                                    }
lbl290:
                                    // 1 sources

                                    catch (SQLException var19_32) {
                                        if (null == var10_15) {
                                            var10_15 = new BatchUpdateException(var19_32.getMessage(), var19_32.getSQLState(), var19_32.getErrorCode(), this.batchReturn);
                                            var19_33 = var19_32.getNextException();
                                        }
                                        if (null == var19_33) break block97;
                                        var10_15.setNextException(var19_33);
                                    }
                                }
                                if (var10_15 != null) {
                                    throw var10_15;
                                }
                                var19_35 = this.batchReturn;
                                var32_4 = null;
                                this.clearBatch();
                                if (DB2Trace.TraceOn == false) return var19_35;
                                DB2Trace.methodExit(this, "executeBatch()");
                                return var19_35;
                            }
                            catch (IOException var17_28) {
                                var17_28.printStackTrace();
                                this.sqlExcptGen.socketException("08S01a");
                                var17_29 = null;
                                var32_5 = null;
                                this.clearBatch();
                                if (DB2Trace.TraceOn == false) return var17_29;
                                DB2Trace.methodExit(this, "executeBatch()");
                                return var17_29;
                            }
                        }
                        var12_19[var13_20] = -3;
                        ++var13_20;
                    }
                }
                catch (Throwable var31_50) {
                    var32_6 = null;
                    this.clearBatch();
                    if (DB2Trace.TraceOn == false) throw var31_50;
                    DB2Trace.methodExit(this, "executeBatch()");
                    throw var31_50;
                }
            }
            this.clearBatch();
            if (DB2Trace.TraceOn == false) return var1_1;
            DB2Trace.methodExit(this, "executeBatch()");
            return var1_1;
        }
        var32_3 = null;
        this.clearBatch();
        if (DB2Trace.TraceOn == false) return var12_18;
        DB2Trace.methodExit(this, "executeBatch()");
        return var12_18;
    }

    protected final boolean isElementNull(ParamElement paramElement, int n2, int n3) throws SQLException {
        if (!paramElement.isSet()) {
            this.db2req = new DB2Request(this.connection);
            this.sqlExcptGen.throwNotSet(n2, n3, this.batchReturn);
        }
        return false;
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setCharacterStream(n2, reader, n3, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setCharacterStream(int n2, Reader reader, int n3, int n4) throws SQLException {
        block7: {
            block6: {
                block5: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setCharacterStream( " + n2 + ", " + reader + ", " + n3 + ", " + n4 + " )");
                        }
                        if (null == reader) {
                            this.setNull(n2, n4);
                            Object var6_5 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block5;
                        }
                        if (0 == n3) {
                            this.setString(n2, new String(), n4);
                            break block6;
                        }
                        this.setDirection(n2, n4, -8);
                        this.paramRow[n2 - 1].set(n3, reader, true, true);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setCharacterStream()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setCharacterStream()");
                return;
            }
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setCharacterStream()");
            return;
        }
        Object var6_7 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setCharacterStream()");
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == blob) {
            this.setNull(n2, -98);
            return;
        }
        this.setBlob(n2, blob, -98);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setBlob(int n2, Blob blob, int n3) throws SQLException {
        block8: {
            block7: {
                try {
                    int n4;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setBlob( " + n2 + ", " + blob + ", " + n3 + " )");
                    }
                    if (0 == (n4 = (int)blob.length())) {
                        this.setBytes(n2, new byte[0], n3);
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block7;
                    }
                    if (blob instanceof DB2Blob && ((DB2Blob)blob).db2is != null && 25 != this.statementType) {
                        DB2Blob dB2Blob = (DB2Blob)blob;
                        this.setDirection(n2, n3, 31);
                        this.paramRow[n2 - 1].set(n4, dB2Blob, false, false);
                        break block8;
                    }
                    if (25 == this.statementType) {
                        this.setBytes(n2, blob.getBytes(1L, (int)blob.length()), n3);
                        break block8;
                    } else {
                        this.setBinaryStream(n2, blob.getBinaryStream(), n4, n3);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setBlob()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setBlob()");
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setBlob()");
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == clob) {
            this.setNull(n2, -99);
            return;
        }
        this.setClob(n2, clob, -99);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setClob(int n2, Clob clob, int n3) throws SQLException {
        block8: {
            block7: {
                try {
                    int n4;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setClob( " + n2 + ", Clob, " + n3 + " )");
                    }
                    if (0 == (n4 = (int)clob.length())) {
                        this.setString(n2, new String(), n3);
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block7;
                    }
                    if (clob instanceof DB2Clob && ((DB2Clob)clob).reader != null && 25 != this.statementType) {
                        DB2Clob dB2Clob = (DB2Clob)clob;
                        n3 = dB2Clob.lobType == 41 ? -99 : -350;
                        this.setDirection(n2, n3, dB2Clob.lobType);
                        this.paramRow[n2 - 1].set(n4, dB2Clob, false, true);
                        break block8;
                    }
                    if (25 == this.statementType) {
                        this.setString(n2, clob.getSubString(1L, (int)clob.length()), n3);
                        break block8;
                    } else {
                        this.setCharacterStream(n2, clob.getCharacterStream(), n4, n3);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setClob()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setClob()");
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setClob()");
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == uRL) {
            this.setNull(n2, -400);
            return;
        }
        this.setURL(n2, uRL, -400);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setURL(int n2, URL uRL, int n3) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setURL( " + n2 + ", URL, " + n3 + " )");
            }
            this.setDirection(n2, n3, 1);
            this.paramRow[n2 - 1].set(uRL.toExternalForm().length(), uRL.toExternalForm());
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "setURL()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "setURL()");
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.resultSet == null) {
            if (this.statementType == 25 || this.statementType == 26) {
                return null;
            }
            this.resultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(this, this.colCount) : new DB2ResultSet(this, this.colCount);
        }
        return this.resultSet.getMetaData();
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.setDate(n2, date, 91, calendar);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.setTime(n2, time, 92, calendar);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n2, timestamp, 93, calendar);
    }

    public int SQLJPrepare(int n2) throws SQLException {
        int n3 = 0;
        try {
            SQLJPackage sQLJPackage = this.section.getPackage();
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)209);
                this.db2req.write(this.statementHandle);
                this.db2req.write(this.sql);
                this.db2req.write((short)n2);
                this.db2req.write(this.CLIStatementType);
                this.db2req.write((short)this.maxNumParams);
                this.db2req.write(this.section.getSectionNumber());
                this.db2req.write(sQLJPackage.getPackageName().getBytes());
                this.db2req.write(sQLJPackage.getConsistencyToken());
                this.db2req.write(sQLJPackage.getCollectionName().getBytes());
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
                this.statementHandle = this.db2req.readInt();
                this.rsType = this.db2req.readInt();
            }
            if (this.rsType != n2) {
                this.connection.addWarning(new SQLWarning("Cursor downgraded to TYPE_FORWARD_ONLY", "01S02", -99999));
            }
            if (n3 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n3);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n2, SQLJSection sQLJSection, SQLJColumnMetaData sQLJColumnMetaData, SQLJColumnMetaData sQLJColumnMetaData2, boolean bl, boolean bl2, int n3, int n4) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2PreparedStatement( \"" + string + "\", " + dB2Connection.connectionHandle + ", " + n2 + ", " + (sQLJSection != null ? "section number=" + sQLJSection.getSectionNumber() : "null") + ", " + (sQLJColumnMetaData != null ? "num parameters=" + sQLJColumnMetaData.getColumns() : "null") + ", " + (sQLJColumnMetaData2 != null ? "num columns=" + sQLJColumnMetaData2.getColumns() : "null") + ", " + bl + ", " + bl2 + ", " + n3 + ", " + n4 + ", " + " )");
            }
            this.connection = dB2Connection;
            this.sqlExcptGen = dB2Connection.sqlExcptGen;
            this.rsType = n3;
            this.rsConcur = n4;
            this.checkResultSetType(n3, n4);
            n3 = this.rsType;
            this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
            this.sql = string;
            this.section = sQLJSection;
            this.statementType = (short)27;
            this.CLIStatementType = DB2BaseConstants.mapSQLJRoleToStmtType(n2, bl);
            this.parameterMetaData = sQLJColumnMetaData;
            this.resultSetMetaData = sQLJColumnMetaData2;
            int[] nArray = null;
            int[] nArray2 = null;
            int[] nArray3 = null;
            if (sQLJColumnMetaData != null) {
                this.maxNumParams = (short)sQLJColumnMetaData.getColumns();
                nArray = sQLJColumnMetaData.getSqlTypes();
                nArray2 = sQLJColumnMetaData.getPrecisions();
                nArray3 = sQLJColumnMetaData.getScales();
            }
            int n5 = this.SQLJPrepare(n3);
            String string2 = sQLJSection.getServerCursorName();
            if (string2 != null && string2.length() > 0) {
                this.setCursorName(string2);
            }
            this.initParameterVariables();
            if (!bl2) {
                int n6 = 0;
                while (n6 < this.maxNumParams) {
                    this.sqltypes[n6] = DB2BaseConstants.mapSQLDATypeToCLISQLType(nArray[n6]);
                    this.precisions[n6] = nArray2[n6];
                    this.scales[n6] = nArray3[n6];
                    if (this.sqltypes[n6] != 0) {
                        this.described[n6] = 1;
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "sqltype[" + n6 + "]", this.sqltypes[n6]);
                        DB2Trace.data(10, "precisions[" + n6 + "]", this.precisions[n6]);
                        DB2Trace.data(10, "scales[" + n6 + "]", this.scales[n6]);
                    }
                    ++n6;
                }
            }
            Object var18_17 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "DB2PreparedStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "DB2PreparedStatement()");
    }

    public void setInputs(Object[] objectArray) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setInputs()");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        DB2PreparedStatement dB2PreparedStatement = (DB2PreparedStatement)objectArray[0];
        this.maxNumParams = dB2PreparedStatement.maxNumParams;
        this.direction = dB2PreparedStatement.direction;
        this.sqltypes = dB2PreparedStatement.sqltypes;
        this.precisions = dB2PreparedStatement.precisions;
        this.ctypes = dB2PreparedStatement.ctypes;
        this.maxWholeDigits = dB2PreparedStatement.maxWholeDigits;
        this.scales = dB2PreparedStatement.scales;
        this.wasBound = dB2PreparedStatement.wasBound;
        this.described = dB2PreparedStatement.described;
        this.paramRow = dB2PreparedStatement.paramRow;
        this.paramSet = dB2PreparedStatement.paramSet;
        int n2 = 0;
        while (n2 < this.maxNumParams) {
            this.wasBound[n2] = false;
            ++n2;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setInputs()");
        }
    }

    public Object[] getInputs() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getInputs()");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        Object[] objectArray = new Object[]{this};
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getInputs()");
        }
        return objectArray;
    }

    public SQLJColumnMetaData getParameterColumnMetaData() {
        return this.parameterMetaData;
    }

    public SQLJColumnMetaData getResultSetColumnMetaData() {
        return this.resultSetMetaData;
    }

    public SQLJSection getSection() {
        return this.section;
    }

    public void setSection(SQLJSection sQLJSection) {
        int n2;
        block4: {
            n2 = 0;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setSection( " + (sQLJSection != null ? "section number=" + sQLJSection.getSectionNumber() : "null") + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.section = sQLJSection;
            try {
                n2 = this.SQLJPrepare(this.rsType);
            }
            catch (SQLException sQLException) {
                if (!DB2Trace.TraceOn) break block4;
                DB2Trace.data(20, "SQLException in SQLJPrepare:", sQLException.toString());
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setSection()", n2);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] executeBatch(boolean var1_1) throws SQLException {
        block17: {
            block16: {
                var2_2 = null;
                var3_3 = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "executeBatch( " + var1_1 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.maxNumParams > 0) {
                        var2_2 = this.executeBatch();
                    } else {
                        var3_3 = this.SQLJBatchStatements.size();
                        var2_2 = new int[var3_3];
                        var4_4 = null;
                        var5_5 = 0;
                        while (var5_5 < var3_3) {
                            try {
                                var2_2[var5_5] = ((PreparedStatement)this.SQLJBatchStatements.elementAt(var5_5)).executeUpdate();
                            }
                            catch (SQLException var6_6) {
                                var2_2[var5_5] = -3;
                                if (null == var4_4) {
                                    var4_4 = new BatchUpdateException(var6_6.getMessage(), var6_6.getSQLState(), var6_6.getErrorCode(), var2_2);
                                    if (var6_6.getNextException() != null) {
                                        var4_4.setNextException(var4_4.getNextException());
                                    }
                                }
                                var4_4.setNextException(var6_6);
                            }
                            ++var5_5;
                        }
                    }
                    var4_4 = var2_2;
                    var8_7 = null;
                    if (this.SQLJBatchStatements != null) {
                        this.SQLJBatchStatements.removeAllElements();
                    }
                    if (!DB2Trace.TraceOn) return var4_4;
                    var9_9 = new StringBuffer();
                    if (var2_2 == null) break block16;
                    var9_9.append('[');
                }
                catch (Throwable var7_13) {
                    var8_8 = null;
                    if (this.SQLJBatchStatements != null) {
                        this.SQLJBatchStatements.removeAllElements();
                    }
                    if (!DB2Trace.TraceOn) throw var7_13;
                    var9_10 = new StringBuffer();
                    if (var2_2 == null) break block17;
                    var9_10.append('[');
                    var10_12 = 0;
                    ** while (var10_12 < var2_2.length)
                }
                var10_11 = 0;
                while (var10_11 < var2_2.length) {
                    if (var10_11 > 0) {
                        var9_9.append(',');
                    }
                    var9_9.append(var2_2[var10_11]);
                    ++var10_11;
                }
                var9_9.append(']');
            }
            DB2Trace.methodExit((Object)this, "executeBatch()", var9_9.toString());
            return var4_4;
lbl-1000:
            // 1 sources

            {
                if (var10_12 > 0) {
                    var9_10.append(',');
                }
                var9_10.append(var2_2[var10_12]);
                ++var10_12;
                continue;
            }
lbl71:
            // 1 sources

            var9_10.append(']');
        }
        DB2Trace.methodExit((Object)this, "executeBatch()", var9_10.toString());
        throw var7_13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addBatch(SQLJPreparedStatement sQLJPreparedStatement) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch( Statement Handle=" + ((DB2PreparedStatement)sQLJPreparedStatement).getTraceHandle() + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.maxNumParams > 0) {
                this.addBatch();
            } else {
                if (null == this.SQLJBatchStatements) {
                    this.SQLJBatchStatements = new Vector();
                }
                this.SQLJBatchStatements.add(sQLJPreparedStatement);
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "addBatch()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "addBatch()");
    }

    public SQLJResultSet getSingletonResultSet() {
        SQLJResultSet sQLJResultSet = null;
        try {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getSingletonResultSet()");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                sQLJResultSet = (SQLJResultSet)this.getResultSet();
            }
            catch (SQLException sQLException) {
                sQLJResultSet = null;
                Object var4_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == sQLJResultSet ? "ResultSet is null" : "ResultSet is not null");
                }
            }
            Object var4_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == sQLJResultSet ? "ResultSet is null" : "ResultSet is not null");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == sQLJResultSet ? "ResultSet is null" : "ResultSet is not null");
            }
            throw throwable;
        }
        return sQLJResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeSetCurrentPackageset() throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeSetCurrentPackageset()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "Collection", (String)this.paramRow[0].getValue());
            }
            this.section.getPackage().changeCollectionName((String)this.paramRow[0].getValue());
            n2 = n3;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "executeSetCurrentPackageset()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "executeSetCurrentPackageset()", n3);
        return n2;
    }

    public void setSQLJSingletonQuery(boolean bl) {
        this.isSQLJSingletonQuery = bl;
    }

    public boolean getSQLJSingletonQuery() {
        return this.isSQLJSingletonQuery;
    }

    public void setQueryInstanceIdentifier(long l2) {
        this.queryInstanceIdentifier = l2;
    }

    class ParamElement {
        int length;
        Object value;
        boolean isStream;
        boolean doConversion;
        boolean fSet = false;
        PrimitiveData primitiveData = new PrimitiveData();

        public ParamElement() {
        }

        public ParamElement(int n2, Object object) {
            this.length = n2;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = false;
            this.doConversion = false;
            this.fSet = true;
        }

        public ParamElement(int n2, Object object, boolean bl, boolean bl2) {
            this(n2, object);
            this.isStream = bl;
            this.doConversion = bl2;
        }

        public void set(int n2, double d2) {
            this.primitiveData.set(d2);
            this.set(n2, this.primitiveData, false, false);
        }

        public void set(int n2, int n3) {
            this.primitiveData.set(n3);
            this.set(n2, this.primitiveData, false, false);
        }

        public void set(int n2, float f2) {
            this.primitiveData.set(f2);
            this.set(n2, this.primitiveData, false, false);
        }

        public void set(int n2, long l2) {
            this.primitiveData.set(l2);
            this.set(n2, this.primitiveData, false, false);
        }

        public void set(int n2, short s2) {
            this.primitiveData.set(s2);
            this.set(n2, this.primitiveData, false, false);
        }

        public void set(int n2, Object object) {
            this.set(n2, object, false, false);
        }

        public void set(int n2, Object object, boolean bl, boolean bl2) {
            this.length = n2;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = bl;
            this.doConversion = bl2;
            this.fSet = true;
        }

        public void unset() {
            this.fSet = false;
        }

        public final boolean isSet() {
            return this.fSet;
        }

        public final int getLength() {
            return this.length;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isStream() {
            return this.isStream;
        }

        public final boolean doConversion() {
            return this.doConversion;
        }
    }

    class PrimitiveData {
        double doubleVal;
        int intVal;
        float floatVal;
        long longVal;
        short shortVal;

        public double doubleValue() {
            return this.doubleVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public float floatValue() {
            return this.floatVal;
        }

        public long longValue() {
            return this.longVal;
        }

        public short shortValue() {
            return this.shortVal;
        }

        public void set(double d2) {
            this.doubleVal = d2;
        }

        public void set(int n2) {
            this.intVal = n2;
        }

        public void set(float f2) {
            this.floatVal = f2;
        }

        public void set(long l2) {
            this.longVal = l2;
        }

        public void set(short s2) {
            this.shortVal = s2;
        }
    }
}

