/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2Convertor;
import java.io.ByteArrayInputStream;
import java.sql.SQLException;

public class DB2Message {
    protected byte[] outMsg = new byte[0];
    protected int lenInMsg = 0;
    protected byte[] buffer;
    protected int current;

    protected byte[] int2AofB(int n2) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n2 & 0xFF);
        byArray[2] = (byte)((n2 & 0xFF00) >> 8);
        byArray[1] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[0] = (byte)((n2 & 0xFF000000) >> 24);
        return byArray;
    }

    protected byte[] short2AofB(short s2) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(s2 & 0xFF);
        byArray[0] = (byte)((s2 & 0xFF00) >> 8);
        return byArray;
    }

    public synchronized void reset() {
        this.outMsg = new byte[0];
    }

    protected void append(byte[] byArray) {
        byte[] byArray2 = new byte[this.outMsg.length + byArray.length];
        System.arraycopy(this.outMsg, 0, byArray2, 0, this.outMsg.length);
        System.arraycopy(byArray, 0, byArray2, this.outMsg.length, byArray.length);
        this.outMsg = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.outMsg, 0, this.outMsg.length);
    }

    public synchronized void addParam(int n2) {
        this.append(this.int2AofB(n2));
    }

    public synchronized void addParam(String string) {
        this.addParam(new DB2Convertor(string).toAsciiByteArray());
    }

    public void addParam(byte by) {
        byte[] byArray = new byte[]{by};
        this.append(byArray);
    }

    public void addParam(byte[] byArray) {
        if (null == byArray) {
            this.addParam(0);
        } else {
            this.append(this.int2AofB(byArray.length));
            this.append(byArray);
        }
    }

    public void addParam(short s2) {
        this.append(this.int2AofB(s2));
    }

    public void addParamShort(short s2) {
        this.append(this.short2AofB(s2));
    }

    public void addParam(double d2) {
        String string = String.valueOf(d2);
        this.addParam(string);
    }

    public synchronized byte[] outMessage() {
        byte[] byArray = new byte[this.outMsg.length + 6];
        System.arraycopy(this.short2AofB((short)1), 0, byArray, 0, 2);
        System.arraycopy(this.int2AofB(this.outMsg.length), 2, byArray, 0, 4);
        System.arraycopy(this.outMsg, 0, byArray, 6, this.outMsg.length);
        this.outMsg = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.outMsg, 0, this.outMsg.length);
        return this.outMsg;
    }

    public synchronized void recv(byte[] byArray) throws SQLException {
        this.lenInMsg = byArray.length;
        this.buffer = new byte[this.lenInMsg];
        System.arraycopy(byArray, 0, this.buffer, 0, this.lenInMsg);
        this.current = 0;
    }

    public String nextAsciiStr() {
        byte[] byArray = this.nextAofB();
        if (null == byArray) {
            return "";
        }
        char[] cArray = new char[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            cArray[n2] = (char)byArray[n2];
            ++n2;
        }
        return new String(cArray);
    }

    public String nextUnicodeStr() {
        byte[] byArray = this.nextAofB();
        if (null == byArray) {
            return "";
        }
        return new DB2Convertor(byArray).toStr();
    }

    public byte nextByte() {
        byte by = this.buffer[this.current];
        ++this.current;
        return by;
    }

    public int nextInt() {
        int n2 = 0;
        boolean bl = false;
        byte[] byArray = new byte[4];
        int n3 = 0;
        while (n3 < 4) {
            byArray[n3] = this.buffer[this.current + n3];
            ++n3;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n4 = byteArrayInputStream.read();
        int n5 = byteArrayInputStream.read();
        int n6 = byteArrayInputStream.read();
        int n7 = byteArrayInputStream.read();
        n2 = n4 << 24 | n5 << 16 | n6 << 8 | n7;
        this.current += 4;
        return n2;
    }

    public long nextLong() {
        String string = this.nextAsciiStr();
        Long l2 = new Long(string);
        return l2;
    }

    public short nextShort() {
        int n2 = 0;
        boolean bl = false;
        short s2 = 0;
        byte[] byArray = new byte[2];
        int n3 = 0;
        while (n3 < 2) {
            byArray[n3] = this.buffer[this.current + n3];
            ++n3;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n4 = byteArrayInputStream.read();
        int n5 = byteArrayInputStream.read();
        n2 = n4 << 8 | n5;
        s2 = (short)n2;
        this.current += 2;
        return s2;
    }

    public float nextFloat() {
        String string = this.nextAsciiStr();
        Float f2 = new Float(string);
        return f2.floatValue();
    }

    public double nextDouble() {
        String string = this.nextAsciiStr();
        Double d2 = new Double(string);
        return d2;
    }

    public byte[] nextAofB() {
        int n2 = this.nextInt();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.buffer[n3 + this.current];
            ++n3;
        }
        this.current += n2;
        return byArray;
    }
}

