/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DB2InputStream
extends InputStream {
    protected DB2Statement statement;
    protected SQLExceptionGenerator sqlExcptGen;
    protected DB2Request db2req;
    protected int locator;
    protected long currentPosition;
    protected long docLength;
    protected int lobType;
    protected int marked;
    protected boolean closed = false;
    protected boolean doConversion = false;
    protected int bufferPos = 0;
    protected int bufferEnd = 0;
    protected static final int defaultBufferSize = 32000;
    protected byte[] buffer = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2InputStream(DB2Statement dB2Statement, int n2, int n3, boolean bl) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2InputStream( stmt, " + n2 + ", " + n3 + ", " + bl + " )");
            }
            DB2Connection dB2Connection = dB2Statement.connection;
            this.sqlExcptGen = dB2Statement.sqlExcptGen;
            this.db2req = dB2Statement.db2req;
            this.statement = dB2Connection.getInputStreamStmt();
            this.locator = n2;
            this.currentPosition = 1L;
            this.marked = 1;
            this.lobType = n3;
            this.doConversion = bl;
            this.docLength = this.SQLGetLength();
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "docLength", (int)this.docLength);
            DB2Trace.methodExit(this, "DB2InputStream()");
            throw throwable;
        }
        DB2Trace.data(10, "docLength", (int)this.docLength);
        DB2Trace.methodExit(this, "DB2InputStream()");
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        int n2 = 0;
        if (this.buffer != null) {
            n2 = this.bufferEnd - this.bufferPos;
        }
        if (this.currentPosition <= this.docLength) {
            n2 += (int)(this.docLength - this.currentPosition + 1L);
        }
        return n2;
    }

    private int SQLGetLength() throws SQLException {
        int n2 = 0;
        try {
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.db2req.write((short)51);
                this.db2req.write(this.statement.getHandle());
                this.db2req.write(this.locator);
                this.db2req.write(this.lobType);
                if (this.doConversion) {
                    this.db2req.write((byte)1);
                } else {
                    this.db2req.write((byte)0);
                }
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                if (n3 != 0 && n3 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n3);
                } else {
                    n2 = this.db2req.readInt();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    public long getLength() throws SQLException {
        this.docLength = this.SQLGetLength();
        return this.docLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int read() throws IOException {
        int n2;
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        int n3 = 0;
        try {
            byte[] byArray;
            int n4;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read()");
            }
            n3 = (n4 = this.read(byArray = new byte[1])) == -1 ? n4 : (byArray[0] < 0 ? byArray[0] + 256 : byArray[0]);
            n2 = n3;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n3);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray) throws IOException {
        int n2;
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b )");
            }
            if (this.available() == 0) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(5, "No more data available from the database");
                }
                n3 = -1;
            } else {
                int n4;
                n2 = byArray.length;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "bytesToRead", n2);
                }
                if (this.buffer != null) {
                    n4 = this.bufferEnd - this.bufferPos;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "bytesAvailable", n4);
                    }
                    if (n4 != 0) {
                        if (n2 <= n4) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n2);
                            this.bufferPos += n2;
                            n3 = n2;
                            n2 = 0;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n4);
                            this.bufferPos += n4;
                            n3 = n4;
                            n2 -= n4;
                        }
                    }
                }
                if (n2 != 0) {
                    n4 = (int)Math.min(this.docLength - this.currentPosition + 1L, (long)Math.max(32000, n2));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(30, "currentPosition", (int)this.currentPosition);
                        DB2Trace.data(30, "bytesToRead", n2);
                        DB2Trace.data(30, "bufferLength", n4);
                    }
                    int n5 = 0;
                    int n6 = 0;
                    if (n4 != 0) {
                        try {
                            DB2Statement dB2Statement = this.statement;
                            synchronized (dB2Statement) {
                                this.db2req.write((short)52);
                                this.db2req.write(this.statement.getHandle());
                                this.db2req.write(n4);
                                this.db2req.write(this.locator);
                                this.db2req.write((int)this.currentPosition);
                                this.db2req.write(this.lobType);
                                if (this.doConversion) {
                                    this.db2req.write((byte)1);
                                } else {
                                    this.db2req.write((byte)0);
                                }
                                this.db2req.sendAndRecv();
                                int n7 = this.db2req.readInt();
                                if (n7 != 0 && n7 != 1) {
                                    this.sqlExcptGen.check_return_code(this.statement, n7);
                                }
                                n5 = this.db2req.readInt();
                                this.buffer = this.db2req.readBytes();
                                n6 = this.db2req.readInt();
                            }
                            if (this.doConversion) {
                                String string = new String(this.buffer, "UnicodeBig");
                                this.buffer = string.getBytes("UTF8");
                                n5 = this.buffer.length;
                            } else if (this.lobType == -351) {
                                String string = new String(this.buffer, "UnicodeBig");
                                this.buffer = string.getBytes();
                                n5 = this.buffer.length;
                            }
                            this.currentPosition += (long)n6;
                        }
                        catch (SQLException sQLException) {
                            throw new IOException(sQLException.toString());
                        }
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(40, "bytesAvailable", n5);
                    }
                    this.bufferPos = 0;
                    this.bufferEnd = n5;
                    if (n5 != 0) {
                        if (n2 <= n5) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n3, n2);
                            this.bufferPos += n2;
                            n3 += n2;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n3, n5);
                            this.bufferPos += n5;
                            n3 += n5;
                        }
                    }
                }
            }
            n2 = n3;
            Object var11_13 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n3);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        int n5 = -1;
        try {
            byte[] byArray2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b, " + n2 + ", " + n3 + " )");
            }
            if ((n5 = this.read(byArray2 = new byte[n3])) != -1) {
                System.arraycopy(byArray2, 0, byArray, n2, n5);
            }
            n4 = n5;
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return n4;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n5);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n5);
        return n4;
    }

    public synchronized long skip(long l2) throws IOException {
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        if (this.buffer != null && l2 >= (long)(this.bufferEnd - this.bufferPos)) {
            this.buffer = null;
            l2 -= (long)(this.bufferEnd - this.bufferPos);
        }
        if (this.buffer == null) {
            if (this.currentPosition + (long)((int)l2) > this.docLength) {
                this.currentPosition = this.docLength + 1L;
                l2 = this.docLength - this.currentPosition;
            } else {
                this.currentPosition += (long)((int)l2);
            }
        }
        return l2;
    }

    public synchronized void mark(int n2) {
        this.marked = n2;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        this.currentPosition = this.marked;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() {
        this.closed = true;
    }

    protected boolean hasMore() {
        return this.currentPosition <= this.docLength;
    }

    void moveTo(int n2) {
        this.currentPosition = (long)n2 < this.docLength ? (long)n2 : this.docLength;
    }
}

