/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2CharReader;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;

public class DB2Clob
implements Clob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected DB2CharReader reader;
    protected DB2Request db2req;
    protected String data = null;

    public DB2Clob(DB2Statement dB2Statement, int n2, int n3) throws SQLException {
        this.connection = (DB2Connection)dB2Statement.getConnection();
        this.locator = n2;
        this.lobType = n3;
        this.reader = new DB2CharReader(dB2Statement, n2, n3);
        this.statement = this.connection.getInputStreamStmt();
        this.db2req = this.statement.db2req;
    }

    public DB2Clob(String string) {
        this.data = null == string ? new String() : string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            if (!this.closed && this.reader != null) {
                this.reader.close();
            }
            this.closed = true;
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "close()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "close()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "finalize()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "finalize()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        long l2;
        long l3 = 0L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            l3 = null == this.reader ? (long)this.data.length() : this.reader.getLength();
            l2 = l3;
            Object var6_3 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "length()", l3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "length()", l3);
        return l2;
    }

    public String getSubString(long l2, int n2) throws SQLException {
        String string = null;
        if (null == this.reader) {
            if (l2 > (long)this.data.length() || 0 == n2) {
                string = new String();
            } else if (1L == l2 && n2 >= this.data.length()) {
                string = this.data;
            } else {
                n2 = (int)Math.min((long)this.data.length() - l2 + 1L, (long)n2);
                string = this.data.substring((int)(--l2), (int)l2 + n2);
            }
        } else {
            this.reader.moveTo((int)l2);
            char[] cArray = new char[n2];
            int n3 = 0;
            try {
                n3 = this.reader.read(cArray, 0, n2);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            string = new String(cArray, 0, n3);
        }
        return string;
    }

    public Reader getCharacterStream() throws SQLException {
        if (null == this.reader) {
            return new StringReader(this.data);
        }
        return this.reader;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (null == this.reader) {
            return new ByteArrayInputStream(this.data.getBytes());
        }
        return new DB2InputStream(this.statement, this.locator, this.lobType, false);
    }

    public long position(String string, long l2) throws SQLException {
        int n2 = -1;
        if (null == this.reader) {
            n2 = this.data.indexOf(string, (int)l2 - 1);
            if (-1 != n2) {
                ++n2;
            }
        } else {
            n2 = this.SQLGetPosition(string, (int)l2);
        }
        return n2;
    }

    protected int SQLGetPosition(String string, int n2) throws SQLException {
        int n3 = -1;
        try {
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.db2req.write((short)206);
                this.db2req.write(this.statement.getHandle());
                this.db2req.write(this.locator);
                this.db2req.write(this.lobType);
                this.db2req.write(string);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                int n4 = this.db2req.readInt();
                this.connection.sqlExcptGen.check_return_code(this.statement, n4);
                n3 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.connection.sqlExcptGen.throw_IOException(iOException);
        }
        return n3;
    }

    public long position(Clob clob, long l2) throws SQLException {
        if (clob instanceof DB2Clob && ((DB2Clob)clob).reader != null && this.reader != null) {
            DB2Clob dB2Clob = (DB2Clob)clob;
            int n2 = dB2Clob.getLocator();
            int n3 = -1;
            try {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    this.db2req.write((short)208);
                    this.db2req.write(this.statement.getHandle());
                    this.db2req.write(this.locator);
                    this.db2req.write(this.lobType);
                    this.db2req.write(n2);
                    this.db2req.write((int)l2);
                    this.db2req.sendAndRecv();
                    int n4 = this.db2req.readInt();
                    this.connection.sqlExcptGen.check_return_code(this.statement, n4);
                    n3 = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.connection.sqlExcptGen.throw_IOException(iOException);
            }
            return n3;
        }
        return this.position(clob.getSubString(0L, (int)clob.length()), l2);
    }

    int getLocator() {
        return this.locator;
    }
}

