/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2OutputParameters;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJCallableStatement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJSection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DB2CallableStatement
extends DB2PreparedStatement
implements CallableStatement,
SQLJCallableStatement {
    private DB2OutputParameters outParams = null;
    protected boolean wasNull = false;

    public DB2CallableStatement(String string, DB2Connection dB2Connection) throws SQLException {
        super(string, dB2Connection);
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection, int n2, SQLJSection sQLJSection, SQLJColumnMetaData sQLJColumnMetaData, SQLJColumnMetaData sQLJColumnMetaData2, boolean bl, boolean bl2, int n3, int n4) throws SQLException {
        super(string, dB2Connection, n2, sQLJSection, sQLJColumnMetaData, sQLJColumnMetaData2, bl, bl2, n3, n4);
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n5 = n2 - 1;
        n3 = this.convert2SQLType(n3);
        switch (this.direction[n5]) {
            case 0: {
                this.direction[n5] = 4;
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.direction[n5] = 2;
            }
        }
        this.sqltypes[n5] = n3;
        if (this.ctypes[n5] == 0) {
            this.ctypes[n5] = this.sqlType2cType(n3);
        }
        if ((n3 == 3 || n3 == 2) && n4 < this.scales[n5]) {
            n4 = this.scales[n5];
        }
        this.scales[n5] = (short)n4;
        this.executed = false;
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.registerOutParameter(n2, n3, 0);
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private int validateParameter(int n2) throws SQLException {
        return this.validateParameter(n2, 0, false);
    }

    private int validateParameter(int n2, int n3) throws SQLException {
        return this.validateParameter(n2, n3, true);
    }

    private int validateParameter(int n2, int n3, boolean bl) throws SQLException {
        int n4;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (!this.executed) {
            this.sqlExcptGen.throwNotExecutedError();
        }
        if (this.direction[n4 = n2 - 1] != 4 && this.direction[n4] != 2) {
            this.sqlExcptGen.throwNotOutputParameterError();
        }
        if (bl && this.sqltypes[n4] != n3) {
            this.sqlExcptGen.throwTypeError();
        }
        return n4;
    }

    public String getString(int n2) throws SQLException {
        int n3 = this.validateParameter(n2);
        int n4 = this.sqltypes[n3];
        if (n4 != 1 && n4 != 12 && n4 != -1 && n4 != -99) {
            this.sqlExcptGen.throwTypeError();
        }
        n3 = this.outParams.mapOutputParameter(n3);
        return this.outParams.getString(n3);
    }

    public boolean getBoolean(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 5));
        return this.outParams.getBoolean(n3);
    }

    public byte getByte(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 5));
        return this.outParams.getByte(n3);
    }

    public short getShort(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 5));
        return this.outParams.getShort(n3);
    }

    public int getInt(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 4));
        return this.outParams.getInt(n3);
    }

    public long getLong(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, -5));
        return this.outParams.getLong(n3);
    }

    public float getFloat(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 7));
        return this.outParams.getFloat(n3);
    }

    public double getDouble(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 8));
        return this.outParams.getDouble(n3);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        int n4 = this.outParams.mapOutputParameter(this.validateParameter(n2, 2));
        BigDecimal bigDecimal = this.outParams.getBigDecimal(n4);
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(n3, 4);
    }

    public byte[] getBytes(int n2) throws SQLException {
        int n3 = this.validateParameter(n2);
        int n4 = this.sqltypes[n3];
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "type", n4);
        }
        if (n4 != -2 && n4 != -3 && n4 != -4 && n4 != -98) {
            this.sqlExcptGen.throwTypeError();
        }
        n3 = this.outParams.mapOutputParameter(n3);
        return this.outParams.getBytes(n3);
    }

    public Date getDate(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 91));
        return this.outParams.getDate(n3, Calendar.getInstance());
    }

    public Time getTime(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 92));
        return this.outParams.getTime(n3, Calendar.getInstance());
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 93));
        return this.outParams.getTimestamp(n3, Calendar.getInstance());
    }

    public Object getObject(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2));
        return this.outParams.getObject(n3);
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet;
        DB2Request dB2Request = this.db2req;
        synchronized (dB2Request) {
            resultSet = super.executeQuery();
            this.createOutputParamObj();
        }
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n2;
        DB2Request dB2Request = this.db2req;
        synchronized (dB2Request) {
            n2 = super.executeUpdate();
            this.createOutputParamObj();
        }
        return n2;
    }

    public boolean execute() throws SQLException {
        boolean bl;
        DB2Request dB2Request = this.db2req;
        synchronized (dB2Request) {
            bl = super.execute();
            this.createOutputParamObj();
        }
        return bl;
    }

    private void createOutputParamObj() throws SQLException {
        this.outParams = new DB2OutputParameters(this, this.maxNumParams, this.direction, this.sqltypes);
    }

    protected synchronized int execute2() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        int n2 = 0;
        this.warnings = null;
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        if (this.resultSet != null) {
            this.resultSet.realClose();
        }
        try {
            this.db2req.write((short)80);
            this.db2req.write(this.statementHandle);
            this.paramToServer();
            this.db2req.sendAndRecv();
            n2 = this.db2req.readInt();
            this.executed = true;
            if (n2 == this.SQL_SUCCESS) {
                this.rowCount = this.db2req.readInt();
                this.colCount = this.db2req.readShort();
                this.CLIBlockSize = this.db2req.readInt();
                if (this.resultSet != null) {
                    this.resultSet.reset(this.colCount);
                }
            } else if (n2 == this.SQL_SUCCESS_WITH_INFO) {
                n2 = this.db2req.readInt();
                if (n2 == this.SQL_SUCCESS) {
                    String string = this.db2req.readString();
                    String string2 = this.db2req.readString();
                    int n3 = this.db2req.readInt();
                    this.addWarning(new SQLWarning(string, string2, n3));
                }
                this.rowCount = this.db2req.readInt();
                this.colCount = this.db2req.readShort();
                this.CLIBlockSize = this.db2req.readInt();
                if (this.resultSet != null) {
                    this.resultSet.reset(this.colCount);
                }
                this.checkForCursorDowngrade();
                n2 = this.SQL_SUCCESS;
            }
            if (n2 == 99) {
                n2 = this.loadParameters();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    protected int loadParameters() throws SQLException {
        int n2 = -1;
        int n3 = 99;
        try {
            while (n3 == 99) {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)81);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n3 = this.db2req.readInt();
                    if (n3 != this.SQL_SUCCESS && n3 != this.SQL_SUCCESS_WITH_INFO && n3 != 99) {
                        this.sqlExcptGen.check_return_code(this, n3);
                    }
                    if (n3 == 99) {
                        int n4;
                        n2 = this.db2req.readInt();
                        int n5 = n2 - 1;
                        int n6 = this.paramRow[n5].getLength();
                        if (!this.paramRow[n5].doConversion()) {
                            InputStream inputStream = (InputStream)this.paramRow[n5].getValue();
                            byte[] byArray = new byte[Math.min(32699, n6)];
                            while ((n4 = inputStream.read(byArray, 0, Math.min(32699, n6))) != -1 && n6 != 0) {
                                n6 -= n4;
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                if (this.sqltypes[n5] == -99) {
                                    this.db2req.write((short)1);
                                } else {
                                    this.db2req.write((short)0);
                                }
                                this.db2req.write(byArray, n4);
                                this.db2req.sendAndRecv();
                                int n7 = this.db2req.readInt();
                                if (n7 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n7);
                            }
                        } else {
                            int n8;
                            BufferedReader bufferedReader = new BufferedReader((Reader)this.paramRow[n5].getValue());
                            int n9 = this.paramRow[n5].getLength();
                            n4 = Math.min(16349, n9);
                            char[] cArray = new char[n4];
                            while ((n8 = bufferedReader.read(cArray, 0, n4)) != -1 && n9 != 0) {
                                n4 = Math.min(16349, n9 -= n8);
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                this.db2req.write((short)1);
                                this.db2req.write(new String(cArray, 0, n8));
                                this.db2req.sendAndRecv();
                                int n10 = this.db2req.readInt();
                                if (n10 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n10);
                            }
                        }
                    } else if (n3 == this.SQL_SUCCESS) {
                        int n11;
                        int n12 = this.db2req.readInt();
                        if (n12 != this.SQL_SUCCESS) {
                            this.sqlExcptGen.check_return_code(this, n12);
                        }
                        this.rowCount = this.db2req.readInt();
                        this.colCount = this.db2req.readShort();
                        if (this.colCount > 0 && (n11 = this.db2req.readInt()) != this.SQL_SUCCESS) {
                            this.sqlExcptGen.check_return_code(this, n11);
                        }
                        this.CLIBlockSize = this.db2req.readInt();
                        if (this.resultSet != null) {
                            this.resultSet.reset(this.colCount);
                        }
                    } else if (n3 == this.SQL_SUCCESS_WITH_INFO) {
                        n3 = this.db2req.readInt();
                        if (n3 == this.SQL_SUCCESS) {
                            String string = this.db2req.readString();
                            String string2 = this.db2req.readString();
                            int n13 = this.db2req.readInt();
                            this.addWarning(new SQLWarning(string, string2, n13));
                        }
                        this.rowCount = this.db2req.readInt();
                        this.colCount = this.db2req.readShort();
                        this.CLIBlockSize = this.db2req.readInt();
                        if (this.resultSet != null) {
                            this.resultSet.reset(this.colCount);
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n3;
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection, int n2, int n3) throws SQLException {
        super(string, dB2Connection, n2, n3);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 2));
        return this.outParams.getBigDecimal(n3);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Ref type");
        return null;
    }

    public Blob getBlob(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        if (null == byArray) {
            return null;
        }
        return new DB2Blob(byArray);
    }

    public Clob getClob(int n2) throws SQLException {
        String string = this.getString(n2);
        if (null == string) {
            return null;
        }
        return new DB2Clob(string);
    }

    public Array getArray(int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
        return null;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 91));
        return this.outParams.getDate(n3, calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 92));
        return this.outParams.getTime(n3, calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        int n3 = this.outParams.mapOutputParameter(this.validateParameter(n2, 93));
        return this.outParams.getTimestamp(n3, calendar);
    }
}

