/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class DB2Blob
implements Blob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected DB2InputStream db2is;
    protected DB2Request db2req;
    protected boolean closed = false;
    protected byte[] data = null;

    public DB2Blob(DB2Statement dB2Statement, int n2) throws SQLException {
        this.connection = (DB2Connection)dB2Statement.getConnection();
        this.locator = n2;
        this.lobType = 31;
        this.db2is = new DB2InputStream(dB2Statement, n2, this.lobType, false);
        this.statement = this.connection.getInputStreamStmt();
        this.db2req = this.statement.db2req;
    }

    public DB2Blob(byte[] byArray) {
        this.data = null == byArray ? new byte[0] : byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            if (!this.closed && this.db2is != null) {
                this.db2is.close();
            }
            this.closed = true;
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "close()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "close()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "finalize()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "finalize()");
    }

    public long length() throws SQLException {
        long l2 = 0L;
        l2 = null == this.db2is ? (long)this.data.length : this.db2is.getLength();
        return l2;
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        byte[] byArray = null;
        if (null == this.db2is) {
            if (l2 > (long)this.data.length || 0 == n2) {
                byArray = new byte[]{};
            } else {
                n2 = (int)Math.min((long)this.data.length - l2 + 1L, (long)n2);
                byArray = new byte[n2];
                System.arraycopy(this.data, (int)l2 - 1, byArray, 0, n2);
            }
        } else {
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            try {
                this.db2is.moveTo((int)l2);
                n3 = this.db2is.read(byArray2);
                if (n3 >= 0) {
                    if (n3 != n2) {
                        byArray = new byte[n3];
                        System.arraycopy(byArray2, 0, byArray, 0, n3);
                    } else {
                        byArray = byArray2;
                    }
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws SQLException {
        DB2InputStream dB2InputStream;
        block5: {
            ByteArrayInputStream byteArrayInputStream;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getBinaryStream()");
                    }
                    if (null == this.db2is) {
                        byteArrayInputStream = new ByteArrayInputStream(this.data);
                        Object var4_3 = null;
                        if (!DB2Trace.TraceOn) return byteArrayInputStream;
                        break block4;
                    }
                    DB2InputStream dB2InputStream2 = null;
                    dB2InputStream = dB2InputStream2 = new DB2InputStream(this.statement, this.locator, this.lobType, false);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
            return byteArrayInputStream;
        }
        Object var4_4 = null;
        if (!DB2Trace.TraceOn) return dB2InputStream;
        DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
        return dB2InputStream;
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        long l3 = -1L;
        if (null == byArray || byArray.length == 0) {
            l3 = -1L;
        } else if (null == this.db2is) {
            while (l2 + (long)byArray.length - 1L < (long)this.data.length) {
                int n2 = (int)l2 - 1;
                int n3 = 0;
                while (n3 < byArray.length && this.data[n2] == byArray[n3]) {
                    ++n2;
                    ++n3;
                }
                if (byArray.length == n3) {
                    l3 = l2;
                }
                ++l2;
            }
        } else {
            l3 = this.SQLGetPosition(byArray, (int)l2);
        }
        return l3;
    }

    protected int SQLGetPosition(byte[] byArray, int n2) throws SQLException {
        int n3 = -1;
        try {
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.db2req.write((short)207);
                this.db2req.write(this.statement.getHandle());
                this.db2req.write(this.locator);
                this.db2req.write(byArray);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                int n4 = this.db2req.readInt();
                this.connection.sqlExcptGen.check_return_code(this.statement, n4);
                n3 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.connection.sqlExcptGen.throw_IOException(iOException);
        }
        return n3;
    }

    public long position(Blob blob, long l2) throws SQLException {
        if (blob instanceof DB2Blob && ((DB2Blob)blob).db2is != null && this.db2is != null) {
            DB2Blob dB2Blob = (DB2Blob)blob;
            int n2 = dB2Blob.getLocator();
            int n3 = -1;
            try {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    this.db2req.write((short)208);
                    this.db2req.write(this.statement.getHandle());
                    this.db2req.write(this.locator);
                    this.db2req.write(this.lobType);
                    this.db2req.write(n2);
                    this.db2req.write((int)l2);
                    this.db2req.sendAndRecv();
                    int n4 = this.db2req.readInt();
                    this.connection.sqlExcptGen.check_return_code(this.statement, n4);
                    n3 = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.connection.sqlExcptGen.throw_IOException(iOException);
            }
            return n3;
        }
        return this.position(blob.getBytes(0L, (int)blob.length()), l2);
    }

    int getLocator() {
        return this.locator;
    }
}

