/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2BaseConstants;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.sql.SQLException;

public class DB2Binary2AsciiInputStream
extends DB2InputStream {
    private byte[] cvtBuffer;
    private int cvtBufPos = 0;
    private int cvtAvailable = 0;

    public DB2Binary2AsciiInputStream(DB2Statement dB2Statement, int n2, int n3) throws SQLException {
        super(dB2Statement, n2, n3, false);
    }

    public int available() throws IOException {
        return super.available() * 2;
    }

    public void mark(int n2) {
        super.mark(n2 / 2);
    }

    private byte[] getData(int n2) throws IOException {
        if (0 == this.cvtAvailable && !this.hasMore()) {
            return null;
        }
        if (this.cvtAvailable >= n2) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, n2);
            this.cvtAvailable -= n2;
            this.cvtBufPos += n2;
            return byArray;
        }
        if (!this.hasMore()) {
            byte[] byArray = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, this.cvtAvailable);
            this.cvtAvailable = 0;
            return byArray;
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.cvtAvailable != 0) {
            byArray = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, this.cvtAvailable);
            byArray2 = new byte[(n2 - this.cvtAvailable + 1) / 2];
        } else {
            byArray2 = new byte[(n2 + 1) / 2];
        }
        int n3 = super.read(byArray2);
        if (n3 > 0) {
            this.cvtBuffer = new byte[n3 * 2];
            int n4 = 0;
            while (n4 < n3) {
                this.cvtBuffer[n4 * 2] = DB2BaseConstants.TOCHAR[(byte)((byArray2[n4] & 0xF0) >> 4)];
                this.cvtBuffer[n4 * 2 + 1] = DB2BaseConstants.TOCHAR[(byte)(byArray2[n4] & 0xF)];
                ++n4;
            }
            this.cvtAvailable = this.cvtBuffer.length;
            this.cvtBufPos = 0;
            if (byArray != null) {
                int n5 = Math.min(n2 - byArray.length, this.cvtAvailable);
                byte[] byArray3 = new byte[byArray.length + n5];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray3, byArray.length, n5);
                this.cvtBufPos += n5;
                this.cvtAvailable -= n5;
                return byArray3;
            }
            int n6 = Math.min(n2, this.cvtAvailable);
            byte[] byArray4 = new byte[n6];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray4, 0, n6);
            this.cvtBufPos += n6;
            this.cvtAvailable -= n6;
            return byArray4;
        }
        return byArray;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        byte[] byArray = this.getData(1);
        if (byArray == null) {
            return -1;
        }
        if (byArray[0] < 0) {
            return byArray[0] + 256;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        byte[] byArray2 = this.getData(byArray.length);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        return byArray2.length;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException(SQLExceptionGenerator.errMsgClass.getString("0620"));
        }
        byte[] byArray2 = this.getData(n3);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }
}

