/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DB2XAResource
implements XAResource {
    public static final int TMTIMEOUT = 256;
    private XAConnection xacon;
    private int hdbc;
    private byte[] xaResourcePtr;
    private int retCode;

    private native int xaCommit(int var1, byte[] var2, byte[] var3, int var4);

    private native int xaEnd(int var1, byte[] var2, byte[] var3, int var4);

    private native int xaForget(int var1, byte[] var2, byte[] var3);

    private native int xaGetTransTimeOut(Integer var1);

    private native int xaSetTransTimeOut(int var1);

    private native Xid[] xaRecover(int var1);

    private native int xaPrepare(int var1, byte[] var2, byte[] var3);

    private native int xaRollback(int var1, byte[] var2, byte[] var3);

    private native int xaStart(int var1, byte[] var2, byte[] var3, int var4);

    private native boolean cliIsSameRM(int var1, int var2);

    public DB2XAResource(XAConnection xAConnection, int n2, byte[] byArray) {
        this.xacon = xAConnection;
        this.hdbc = n2;
        this.xaResourcePtr = byArray;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n2;
        int n3 = 0;
        if (bl) {
            n3 = 0x40000000;
        }
        if ((n2 = this.xaCommit(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), n3)) != 0) {
            this.throwXAException(n2);
        }
    }

    public void end(Xid xid, int n2) throws XAException {
        int n3 = this.xaEnd(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), n2);
        if (n3 != 0) {
            this.throwXAException(n3);
        }
    }

    public void forget(Xid xid) throws XAException {
        int n2 = this.xaForget(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        if (n2 != 0) {
            this.throwXAException(n2);
        }
    }

    public int getTransactionTimeout() throws XAException {
        Integer n2 = new Integer(0);
        int n3 = this.xaGetTransTimeOut(n2);
        if (n3 != 0) {
            this.throwXAException(n3);
        }
        return n2;
    }

    public int prepare(Xid xid) throws XAException {
        int n2 = this.xaPrepare(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        if (n2 != 0 && n2 != 3) {
            this.throwXAException(n2);
        }
        return n2;
    }

    public Xid[] recover(int n2) throws XAException {
        Xid[] xidArray = this.xaRecover(n2);
        if (this.retCode < 0) {
            this.throwXAException(this.retCode);
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        int n2 = this.xaRollback(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        if (n2 != 0) {
            this.throwXAException(n2);
        }
    }

    public boolean setTransactionTimeout(int n2) throws XAException {
        return false;
    }

    public void start(Xid xid, int n2) throws XAException {
        int n3 = this.xaStart(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), n2);
        if (n3 != 0) {
            this.throwXAException(n3);
        }
    }

    private void throwXAException(int n2) throws XAException {
        throw new XAException(n2);
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof DB2XAResource)) {
            return false;
        }
        DB2XAResource dB2XAResource = (DB2XAResource)xAResource;
        return this.cliIsSameRM(this.hdbc, dB2XAResource.hdbc);
    }
}

