/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DB2ResultSetMetaData
implements ResultSetMetaData {
    protected DB2Statement statement;
    protected DB2Connection connection;
    protected DB2ResultSet resultset;
    protected int numberOfColumns;
    protected boolean mappedRS;
    protected int[] colBaseTypesNotAdjusted = null;

    protected native String SQLColAttributes(int var1, int var2, Integer var3, Integer var4, int var5, int var6);

    public DB2ResultSetMetaData(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet, int n2, boolean bl) {
        this.statement = dB2Statement;
        this.connection = dB2Statement.getDB2Connection();
        this.resultset = dB2ResultSet;
        this.numberOfColumns = n2;
        this.mappedRS = bl;
    }

    public DB2ResultSetMetaData(DB2PreparedStatement dB2PreparedStatement) {
        this.statement = dB2PreparedStatement;
        this.connection = dB2PreparedStatement.getDB2Connection();
        this.resultset = null;
        this.numberOfColumns = 0;
        this.mappedRS = false;
    }

    public int getColumnCount() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (null == this.resultset || this.resultset.numCols <= 0) {
            Integer n2 = new Integer(0);
            Integer n3 = new Integer(0);
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                String string = this.SQLColAttributes(1, 0, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
            }
            int n4 = n3;
            if (n4 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n4);
            }
            this.numberOfColumns = n2;
            if (this.resultset != null) {
                this.resultset.numCols = this.numberOfColumns;
            }
        } else {
            this.numberOfColumns = this.resultset.numCols;
        }
        return this.numberOfColumns;
    }

    protected int getMappedColumn(int n2) throws SQLException {
        if (this.mappedRS) {
            int n3 = this.resultset.getMappedColumn(n2);
            return n3;
        }
        return n2;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 11, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return 1 == n3;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 12, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return 1 == n3;
    }

    public boolean isSearchable(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 13, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return 0 != n3;
    }

    public boolean isCurrency(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 9, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return 1 == n3;
    }

    public int isNullable(int n2) throws SQLException {
        int n3;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n4 = new Integer(0);
        Integer n5 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 7, n5, n4, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n6 = n5;
        if (n6 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n6);
        }
        if (1 == (n3 = n4.intValue())) {
            return 1;
        }
        if (0 == n3) {
            return 0;
        }
        return 2;
    }

    public boolean isSigned(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 8, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return 1 != n3;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 6, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return n3;
    }

    public String getColumnLabel(int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n2, 18, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return string;
    }

    public String getColumnName(int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (null != this.resultset && null != this.resultset.mappedColumnNames && this.resultset.mappedColumnNames.length >= n2 && null != this.resultset.mappedColumnNames[n2 - 1]) {
            return this.resultset.mappedColumnNames[n2 - 1];
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n2, 1, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return string;
    }

    public String getSchemaName(int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n2, 16, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public int getPrecision(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 4, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return n3;
    }

    public int getScale(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 5, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return n3;
    }

    public String getTableName(int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n2, 15, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public String getCatalogName(int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n2, 17, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        if (null == string) {
            return new String("");
        }
        return string;
    }

    public int getColumnType(int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n7, 2, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n8 = n4;
        if (n8 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n8);
        }
        if ((n6 = n3.intValue()) == -450) {
            DB2Connection dB2Connection2 = this.connection;
            synchronized (dB2Connection2) {
                string = this.SQLColAttributes(n7, 1098, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
            }
            n8 = n4;
            if (n8 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n8);
            }
            if ((n5 = n3.intValue()) == 1) {
                n5 = 2001;
            } else if (n5 == 2) {
                n5 = 2002;
            } else if (n5 == 3) {
                n5 = 2006;
            }
            DB2Connection dB2Connection3 = this.connection;
            synchronized (dB2Connection3) {
                string = this.SQLColAttributes(n7, 1254, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
            }
            n8 = n4;
            if (n8 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n8);
            }
            n6 = n3;
        } else {
            n5 = this.connection.adjust(n6);
        }
        if (this.colBaseTypesNotAdjusted == null || this.colBaseTypesNotAdjusted.length < n2) {
            int n9 = this.getColumnCount();
            this.colBaseTypesNotAdjusted = new int[n9];
            int n10 = 0;
            while (n10 < n9) {
                this.colBaseTypesNotAdjusted[n10] = -99999;
                ++n10;
            }
        }
        this.colBaseTypesNotAdjusted[n2 - 1] = n6;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(30, "DB2ColType", n5);
            DB2Trace.data(30, "DB2ColBaseTypeNotAdjusted", n6);
        }
        return n5;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n2, 14, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return string;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n2 = this.getMappedColumn(n2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n2, 10, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        return 0 == n3;
    }

    public boolean isWritable(int n2) throws SQLException {
        return !this.isReadOnly(n2);
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        return false;
    }

    public String getColumnClassName(int n2) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getColumnClassName( " + n2 + " )");
        }
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        String string = null;
        if (this.colBaseTypesNotAdjusted == null || this.colBaseTypesNotAdjusted[n2 - 1] == -99999) {
            this.getColumnType(n2);
        }
        int n3 = this.connection.adjust(this.colBaseTypesNotAdjusted[n2 - 1]);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "[B";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case 70: {
                string = "java.net.URL";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2001: {
                string = "java.sql.Distinct";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                this.connection.sqlExcptGen.rsException("S1004");
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "getColumnClassName()", string);
        }
        return string;
    }
}

