/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.app.DB2Binary2UnicodeInputStream;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2CharReader;
import COM.ibm.db2.jdbc.app.DB2Clob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaDataTrace;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.DB2UnicodeStream;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJResultSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2ResultSet
implements ResultSet,
SQLJResultSet {
    private Hashtable name2Index;
    private DB2ResultSetMetaData rsMetaData;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected SQLExceptionGenerator sqlExcptGen;
    protected int numCols = 0;
    protected boolean mappedRS = false;
    protected boolean nullTag = true;
    protected boolean closed = false;
    protected Vector isList = new Vector();
    protected int currentRowId = 0;
    private int year = 0;
    private int month = 0;
    private int date = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int nano = 0;
    private int sqlSuccess = 0;
    protected int[] colTypes = null;
    protected int[] colSizes = null;
    protected String[] mappedColumnNames = null;
    protected int returnCode = 0;
    protected int returnLen = 0;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int maxRows = 0;

    protected native int SQLGetColumnCount(int var1);

    protected native int SQLSetPos(int var1, int var2, int var3, int var4);

    protected native int SQLFetchScroll(int var1, int var2, int var3, int var4);

    protected native int SQLFetch(int var1);

    protected native int SQLFreeStmtClose(int var1);

    protected native String SQLGetCursorName(int var1, int var2);

    protected native int SQLGetDateData(int var1, int var2);

    protected native double SQLGetDoubleData(int var1, int var2);

    protected native int SQLGetIntegerData(int var1, int var2);

    protected native long SQLGetLongData(int var1, int var2);

    protected native int SQLGetLocator(int var1, int var2, Integer var3, int var4);

    protected native byte[] SQLGetLongBinaryData(int var1, int var2, int var3, int var4, int var5);

    protected native byte[] SQLGetLongCharData(int var1, int var2, int var3);

    protected native String SQLGetNumericStringData(int var1, int var2);

    protected native int SQLGetSmallIntData(int var1, int var2);

    protected native String SQLGetStringData(int var1, int var2, int var3, int var4, int var5);

    protected native int SQLGetTimeData(int var1, int var2);

    protected native int SQLGetTimestampData(int var1, int var2);

    protected native int SQLGetType(int var1, int var2, int var3);

    protected native byte[] SQLGetRowDataInternal(int var1);

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2ResultSet \r\n" + string + "{");
        if (bl) {
            if (this.statement != null) {
                stringBuffer.append(this.statement.toString(string + "    Statement -> ", false) + "\r\n");
            } else {
                stringBuffer.append(string + "    Statement -> null\r\n    ");
            }
        } else {
            stringBuffer.append("\r\n");
        }
        stringBuffer.append(string + "    numCols = " + this.numCols + "\r\n");
        stringBuffer.append(string + "    mappedRS = " + this.mappedRS + "\r\n");
        stringBuffer.append(string + "    nullTag = " + this.nullTag + "\r\n");
        stringBuffer.append(string + "    closed = " + this.closed + "\r\n");
        stringBuffer.append(string + "    maxFieldSize = " + this.statement.maxFieldSize + "\r\n");
        stringBuffer.append(string + "    returnCode = " + this.returnCode + "\r\n");
        stringBuffer.append(string + "    returnLen = " + this.returnLen + "\r\n");
        int n2 = 0;
        while (n2 < this.numCols) {
            stringBuffer.append(string + "    colTypes[" + n2 + "] = " + this.colTypes[n2] + "\r\n");
            stringBuffer.append(string + "    colSizes[" + n2 + "] = " + this.colSizes[n2] + "\r\n");
            ++n2;
        }
        stringBuffer.append(string + "}\r\n");
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2ResultSet(DB2Statement dB2Statement, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2ResultSet( stmt, nCols=" + n2 + ")");
            }
            this.statement = dB2Statement;
            this.connection = this.statement.getDB2Connection();
            this.fetchSize = this.statement.fetchSize;
            this.fetchDirection = this.statement.fetchDirection;
            this.sqlExcptGen = dB2Statement.sqlExcptGen;
            this.numCols = this.getColCount();
            this.nullTag = true;
            this.closed = false;
            this.mappedRS = false;
            this.rsMetaData = null;
            this.name2Index = null;
            this.colTypes = new int[this.numCols];
            this.colSizes = new int[this.numCols];
            int n3 = 0;
            while (n3 < this.numCols) {
                this.colTypes[n3] = 0;
                this.colSizes[n3] = 0;
                ++n3;
            }
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "numCols", this.numCols);
            DB2Trace.methodExit(this, "DB2ResultSet()");
            throw throwable;
        }
        DB2Trace.data(10, "numCols", this.numCols);
        DB2Trace.methodExit(this, "DB2ResultSet()");
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n2, int n3) throws SQLException {
        this(dB2Statement, n2);
        this.numCols = n3;
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n2, int n3, String[] stringArray) throws SQLException {
        this(dB2Statement, n2);
        this.mappedColumnNames = stringArray;
        this.numCols = n3;
    }

    protected void addIsList(DB2InputStream dB2InputStream) {
        if (null != dB2InputStream) {
            this.isList.addElement(dB2InputStream);
        }
    }

    protected void clearIsList() throws SQLException {
        if (!this.isList.isEmpty()) {
            Enumeration enumeration = this.isList.elements();
            while (enumeration.hasMoreElements()) {
                DB2InputStream dB2InputStream = (DB2InputStream)enumeration.nextElement();
                dB2InputStream.close();
            }
            this.isList.removeAllElements();
        }
    }

    protected void checkHandlesAndIndex(int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n2 != Integer.MAX_VALUE && (n2 < 1 || n2 > this.numCols)) {
            this.sqlExcptGen.throwColumnIndexError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getColType(int n2, boolean bl) throws SQLException {
        int n3;
        int n4 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getColType( " + n2 + ", " + bl + " ) ");
            }
            if (this.colTypes != null) {
                n4 = this.colTypes[n2 - 1];
            }
            if (n4 == 0) {
                n3 = 0;
                if (bl) {
                    n3 = 1;
                }
                this.returnCode = this.sqlSuccess;
                this.returnLen = 0;
                n4 = this.SQLGetType(n2, n3, this.statement.statementHandle);
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "sqlType", n4);
                }
                if (n4 == -450) {
                    if (this.rsMetaData == null) {
                        this.rsMetaData = this.getMetaData2();
                    }
                    if (this.rsMetaData.colBaseTypesNotAdjusted == null || this.rsMetaData.colBaseTypesNotAdjusted[n2 - 1] == -99999) {
                        this.rsMetaData.getColumnType(n2);
                    }
                    n4 = this.rsMetaData.colBaseTypesNotAdjusted[n2 - 1];
                }
                switch (n4) {
                    case -97: 
                    case -10: {
                        n4 = -1;
                        break;
                    }
                    case -95: 
                    case -8: {
                        n4 = 1;
                        break;
                    }
                    case -96: 
                    case -9: {
                        n4 = 12;
                        break;
                    }
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "sqlType", n4);
                    DB2Trace.data(20, "returnLen", this.returnLen);
                }
                this.colTypes[n2 - 1] = n4;
                this.colSizes[n2 - 1] = this.returnLen;
            }
            n3 = n4;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return n3;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getColType()", n4);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getColType()", n4);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClosed() {
        boolean bl;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "isClosed()");
            }
            bl = this.closed;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "isClosed()", this.closed);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "isClosed()", this.closed);
        return bl;
    }

    protected void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean next() throws SQLException {
        boolean bl;
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.clearIsList();
        this.clearWarnings();
        int n2 = this.SQLFetch(this.statement.statementHandle);
        if (n2 != 100) {
            if (n2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n2);
            }
            this.closed = false;
            bl = true;
            ++this.currentRowId;
        } else {
            bl = false;
            this.currentRowId = 0;
        }
        return bl;
    }

    public boolean wasNull() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        return this.nullTag;
    }

    public String getString(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getString2(n2);
    }

    protected String getString2(int n2) throws SQLException {
        String string;
        if (this.colTypes[n2 - 1] == 0) {
            this.getColType(n2, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetStringData(n2, this.colTypes[n2 - 1], this.colSizes[n2 - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            string = "";
        } else if (this.colTypes[n2 - 1] == -400) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string2);
            int n4 = string.lastIndexOf(44) + 1;
            string = string.substring(n4, n4 + n3);
        }
        this.nullTag = false;
        if (0 == this.statement.maxFieldSize || string.length() <= this.statement.maxFieldSize || this.colTypes[n2 - 1] != 1 && this.colTypes[n2 - 1] != 12 && this.colTypes[n2 - 1] != -1 && this.colTypes[n2 - 1] != -2 && this.colTypes[n2 - 1] != -3 && this.colTypes[n2 - 1] != -4 && this.colTypes[n2 - 1] != -95 && this.colTypes[n2 - 1] != -96 && this.colTypes[n2 - 1] != -97) {
            return string;
        }
        return string.substring(0, this.statement.maxFieldSize);
    }

    public boolean getBoolean(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getBoolean2(n2);
    }

    protected boolean getBoolean2(int n2) throws SQLException {
        short s2;
        String string;
        boolean bl = false;
        if (this.colTypes[n2 - 1] == 0) {
            this.getColType(n2, false);
        }
        bl = this.colTypes[n2 - 1] == 1 || this.colTypes[n2 - 1] == 12 || this.colTypes[n2 - 1] == -1 || this.colTypes[n2 - 1] == -99 ? ((string = this.getString(n2)) == null ? false : ((string = string.trim()).equals("1") ? true : new Boolean(string))) : (s2 = this.getShort2(n2)) != 0;
        return bl;
    }

    public byte getByte(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getByte2(n2);
    }

    protected byte getByte2(int n2) throws SQLException {
        return (byte)this.getShort2(n2);
    }

    public short getShort(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getShort2(n2);
    }

    protected short getShort2(int n2) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int n3 = this.SQLGetSmallIntData(n2, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return (short)n3;
    }

    public int getInt(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getInt2(n2);
    }

    protected int getInt2(int n2) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int n3 = this.SQLGetIntegerData(n2, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return n3;
    }

    public long getLong(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getLong2(n2);
    }

    protected long getLong2(int n2) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        long l2 = this.SQLGetLongData(n2, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return l2;
    }

    public float getFloat(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getFloat2(n2);
    }

    protected float getFloat2(int n2) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        double d2 = this.SQLGetDoubleData(n2, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        float f2 = (float)d2;
        if (Math.abs(d2) != Double.POSITIVE_INFINITY && Math.abs(f2) == Float.POSITIVE_INFINITY) {
            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
        }
        return f2;
    }

    public double getDouble(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getDouble2(n2);
    }

    protected double getDouble2(int n2) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        double d2 = this.SQLGetDoubleData(n2, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return d2;
    }

    protected static String cvtScientific(String string) throws NumberFormatException {
        char c2;
        if (null == string) {
            return string;
        }
        int n2 = string.length();
        if (0 == n2) {
            return string;
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        while (n7 < n2) {
            c2 = string.charAt(n7);
            if (n3 < 0) {
                if (!Character.isWhitespace(c2)) {
                    n3 = n6 = n7;
                    if ('.' == c2 || ',' == c2) {
                        n4 = n7;
                    }
                }
            } else if (n4 < 0 && n5 < 0 && (',' == c2 || '.' == c2)) {
                n4 = n6 = n7;
            } else if (n5 < 0 && ('e' == c2 || 'E' == c2)) {
                n5 = n6 = n7;
            } else if (!Character.isWhitespace(c2)) {
                n6 = n7;
            }
            ++n7;
        }
        if (n3 < 0) {
            return "";
        }
        if (n5 < 0) {
            if (n3 > 0 || n6 < n2 - 1) {
                string = string.substring(n3, n6 + 1);
            }
            if (n4 >= 0 && string.charAt(n4) == ',') {
                string = string.replace(',', '.');
            }
        } else {
            int n8 = 1;
            int n9 = 0;
            n7 = n5 + 1;
            c2 = string.charAt(n7);
            if ('-' == c2) {
                n8 = -1;
                ++n7;
            } else if ('+' == c2) {
                ++n7;
            }
            while (n7 <= n6) {
                if (!Character.isDigit(c2 = string.charAt(n7++))) {
                    throw new NumberFormatException();
                }
                n9 = n9 * 10 + Character.digit(c2, 10);
            }
            n9 *= n8;
            if (n4 >= 0) {
                n9 -= n5 - n4 - 1;
            }
            if ('-' == (c2 = string.charAt(n3))) {
                n8 = -1;
                ++n3;
            } else if ('+' == c2) {
                n8 = 1;
                ++n3;
            } else {
                n8 = 1;
            }
            int n10 = n5 - n3 - (n4 >= 0 ? 1 : 0);
            int n11 = 0;
            int n12 = -1;
            int n13 = 0;
            if (n9 >= 0) {
                n12 = -1;
                n11 = 0;
                n13 = n10 + n9;
            } else if (n9 < 0 && -n9 >= n10) {
                n12 = 0;
                n11 = -n9 - n10 + 1;
                n13 = n11 + n10;
            } else {
                n12 = n10 + n9;
                n11 = 0;
                n13 = n10 + 1;
            }
            if (n8 < 0) {
                if (n12 >= 0) {
                    ++n12;
                }
                ++n11;
                ++n13;
            }
            char[] cArray = new char[n13];
            n7 = 0;
            while (n7 < n13) {
                cArray[n7] = 48;
                ++n7;
            }
            if (n8 < 0) {
                cArray[0] = 45;
            }
            if (n12 >= 0) {
                cArray[n12] = 46;
            }
            n7 = n11;
            int n14 = n3;
            while (n14 < n5) {
                if (n14 == n4 && ++n14 >= n5) break;
                if (n7 == n12) {
                    ++n7;
                }
                cArray[n7] = string.charAt(n14);
                ++n7;
                ++n14;
            }
            string = new String(cArray);
        }
        return string;
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getBigDecimal2(n2, n3);
    }

    protected BigDecimal getBigDecimal2(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal2(n2);
        if (bigDecimal == null || n3 == -1) {
            return bigDecimal;
        }
        return bigDecimal.setScale(n3, 4);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getBigDecimal2(n2);
    }

    protected BigDecimal getBigDecimal2(int n2) throws SQLException {
        int n3 = this.getColType(n2, false);
        if (-2 == n3 || -3 == n3 || -4 == n3 || 91 == n3 || 92 == n3 || 93 == n3) {
            this.sqlExcptGen.rsException("07006");
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        String string = this.SQLGetNumericStringData(n2, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 != this.returnLen) {
            this.nullTag = false;
            BigDecimal bigDecimal = null;
            try {
                string = DB2ResultSet.cvtScientific(string);
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.sqlExcptGen.rsException("22005");
            }
            return bigDecimal;
        }
        this.nullTag = true;
        return null;
    }

    public byte[] getBytes(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getBytes2(n2);
    }

    protected byte[] getBytes2(int n2) throws SQLException {
        if (this.colTypes[n2 - 1] == 0) {
            this.getColType(n2, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 0;
        byte[] byArray = this.SQLGetLongBinaryData(n2, this.colTypes[n2 - 1], this.colSizes[n2 - 1], this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (0 == this.statement.maxFieldSize || byArray.length <= this.statement.maxFieldSize || this.colTypes[n2 - 1] != 1 && this.colTypes[n2 - 1] != 12 && this.colTypes[n2 - 1] != -1 && this.colTypes[n2 - 1] != -2 && this.colTypes[n2 - 1] != -3 && this.colTypes[n2 - 1] != -4 && this.colTypes[n2 - 1] != -95 && this.colTypes[n2 - 1] != -96 && this.colTypes[n2 - 1] != -97) {
            return byArray;
        }
        byte[] byArray2 = new byte[this.statement.maxFieldSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.statement.maxFieldSize);
        return byArray2;
    }

    public Date getDate(int n2) throws SQLException {
        return this.getDate2(n2, Calendar.getInstance());
    }

    protected Date getDate2(int n2) throws SQLException {
        return this.getDate2(n2, Calendar.getInstance());
    }

    protected Date getDate2(int n2, Calendar calendar) throws SQLException {
        Date date = null;
        this.nullTag = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDate2(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            this.checkHandlesAndIndex(n2);
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.year = this.SQLGetDateData(n2, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (-1 != this.returnLen) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year from DB", this.year);
                    DB2Trace.data(10, "Month from DB (1 less)", this.month);
                    DB2Trace.data(10, "Date from DB", this.date);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(this.year + 1900, this.month, this.date, 0, 0, 0);
                calendar.set(14, 0);
                date = new Date(calendar.getTime().getTime());
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Date", date.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Date date2 = date;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getDate2()", date == null ? "NULL" : date.toString());
            }
            return date2;
        }
        catch (Throwable throwable) {
            block9: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block9;
                DB2Trace.methodExit((Object)this, "getDate2()", date == null ? "NULL" : date.toString());
            }
            throw throwable;
        }
    }

    public Time getTime(int n2) throws SQLException {
        return this.getTime2(n2, Calendar.getInstance());
    }

    protected Time getTime2(int n2) throws SQLException {
        return this.getTime2(n2, Calendar.getInstance());
    }

    protected Time getTime2(int n2, Calendar calendar) throws SQLException {
        Time time = null;
        this.nullTag = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTime2(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            this.checkHandlesAndIndex(n2);
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.hour = this.SQLGetTimeData(n2, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (-1 != this.returnLen) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Hour", this.hour);
                    DB2Trace.data(10, "Minute", this.minute);
                    DB2Trace.data(10, "Second", this.second);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(1970, 0, 1, this.hour, this.minute, this.second);
                calendar.set(14, 0);
                time = new Time(calendar.getTime().getTime());
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Time", time.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Time time2 = time;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTime2()", time == null ? "NULL" : time.toString());
            }
            return time2;
        }
        catch (Throwable throwable) {
            block9: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block9;
                DB2Trace.methodExit((Object)this, "getTime2()", time == null ? "NULL" : time.toString());
            }
            throw throwable;
        }
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestamp2(n2, Calendar.getInstance());
    }

    protected Timestamp getTimestamp2(int n2) throws SQLException {
        return this.getTimestamp2(n2, Calendar.getInstance());
    }

    protected Timestamp getTimestamp2(int n2, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        this.nullTag = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestamp2(" + n2 + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            this.checkHandlesAndIndex(n2);
            int n3 = this.getColType(n2, false);
            if (92 == n3) {
                this.sqlExcptGen.rsException("07006");
            }
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.year = this.SQLGetTimestampData(n2, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (-1 != this.returnLen) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year", this.year);
                    DB2Trace.data(10, "Month", this.month);
                    DB2Trace.data(10, "Date", this.date);
                    DB2Trace.data(10, "Hour", this.hour);
                    DB2Trace.data(10, "Minute", this.minute);
                    DB2Trace.data(10, "Second", this.second);
                    DB2Trace.data(10, "Nano", this.nano);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(this.year + 1900, this.month, this.date, this.hour, this.minute, this.second);
                calendar.set(14, 0);
                timestamp = new Timestamp(calendar.getTime().getTime());
                timestamp.setNanos(this.nano);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Timestamp", timestamp.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Timestamp timestamp2 = timestamp;
            Object var7_6 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTimestamp2()", timestamp == null ? "NULL" : timestamp.toString());
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            block10: {
                Object var7_7 = null;
                if (!DB2Trace.TraceOn) break block10;
                DB2Trace.methodExit((Object)this, "getTimestamp2()", timestamp == null ? "NULL" : timestamp.toString());
            }
            throw throwable;
        }
    }

    protected byte[] getAsciiString(int n2) throws SQLException {
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        byte[] byArray = this.SQLGetLongCharData(n2, this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (0 == this.statement.maxFieldSize || byArray.length <= this.statement.maxFieldSize || this.colTypes[n2 - 1] != 1 && this.colTypes[n2 - 1] != 12 && this.colTypes[n2 - 1] != -1 && this.colTypes[n2 - 1] != -2 && this.colTypes[n2 - 1] != -3 && this.colTypes[n2 - 1] != -4 && this.colTypes[n2 - 1] != -95 && this.colTypes[n2 - 1] != -96 && this.colTypes[n2 - 1] != -97) {
            return byArray;
        }
        byte[] byArray2 = new byte[this.statement.maxFieldSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.statement.maxFieldSize);
        return byArray2;
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        if (this.connection.materializeLobData) {
            byte[] byArray = this.getAsciiString(n2);
            if (byArray != null) {
                return new ByteArrayInputStream(byArray);
            }
            return null;
        }
        return this.getAsciiStream2(n2);
    }

    protected InputStream getAsciiStream2(int n2) throws SQLException {
        int n3 = 41;
        int n4 = this.getColType(n2, true);
        if (-99 == n4 || -98 == n4 || -350 == n4) {
            switch (n4) {
                case -99: {
                    n3 = 41;
                    break;
                }
                case -98: {
                    n3 = 31;
                    break;
                }
                case -350: {
                    n3 = -351;
                }
            }
            Integer n5 = new Integer(this.sqlSuccess);
            int n6 = this.SQLGetLocator(n2, n3, n5, this.statement.statementHandle);
            int n7 = n5;
            if (n7 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n7);
            }
            if (-1 != this.returnLen) {
                this.nullTag = false;
                if (31 != n3) {
                    DB2InputStream dB2InputStream = new DB2InputStream(this.statement, n6, n3);
                    this.addIsList(dB2InputStream);
                    return dB2InputStream;
                }
                DB2Binary2AsciiInputStream dB2Binary2AsciiInputStream = new DB2Binary2AsciiInputStream(this.statement, n6, n3);
                this.addIsList(dB2Binary2AsciiInputStream);
                return dB2Binary2AsciiInputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getAsciiString(n2);
        if (byArray != null) {
            this.nullTag = false;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        this.nullTag = true;
        return null;
    }

    protected byte[] getUniString(int n2) throws SQLException {
        String string = null;
        if (this.colTypes[n2 - 1] == 0) {
            this.getColType(n2, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetStringData(n2, this.colTypes[n2 - 1], this.colSizes[n2 - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen || this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            string = "";
        }
        this.nullTag = false;
        byte[] byArray = null;
        try {
            byArray = 0 == this.statement.maxFieldSize || string.length() <= this.statement.maxFieldSize ? string.getBytes("UTF8") : string.substring(0, this.statement.maxFieldSize).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getUnicodeStream2(n2);
    }

    protected InputStream getUnicodeStream2(int n2) throws SQLException {
        int n3 = 41;
        int n4 = this.getColType(n2, true);
        if (-99 == n4 || -98 == n4 || -350 == n4) {
            switch (n4) {
                case -99: {
                    n3 = 41;
                    break;
                }
                case -98: {
                    n3 = 31;
                    break;
                }
                case -350: {
                    n3 = -351;
                }
            }
            Integer n5 = new Integer(this.sqlSuccess);
            int n6 = this.SQLGetLocator(n2, n3, n5, this.statement.statementHandle);
            int n7 = n5;
            if (n7 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n7);
            }
            if (-1 != this.returnLen) {
                this.nullTag = false;
                DB2InputStream dB2InputStream = null;
                switch (n3) {
                    case -351: 
                    case 41: {
                        dB2InputStream = new DB2UnicodeStream(this.statement, n6, n3);
                        break;
                    }
                    case 31: {
                        dB2InputStream = new DB2Binary2UnicodeInputStream(this.statement, n6, n3);
                    }
                }
                this.addIsList(dB2InputStream);
                return dB2InputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getUniString(n2);
        if (null == byArray) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        return this.getBinaryStream2(n2);
    }

    protected InputStream getBinaryStream2(int n2) throws SQLException {
        int n3 = 41;
        int n4 = this.getColType(n2, true);
        if (n4 == -99 || n4 == -98 || n4 == -350) {
            switch (n4) {
                case -99: {
                    n3 = 41;
                    break;
                }
                case -98: {
                    n3 = 31;
                    break;
                }
                case -350: {
                    n3 = -351;
                }
            }
            Integer n5 = new Integer(this.sqlSuccess);
            int n6 = this.SQLGetLocator(n2, n3, n5, this.statement.statementHandle);
            int n7 = n5;
            if (n7 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n7);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                DB2InputStream dB2InputStream = new DB2InputStream(this.statement, n6, n3);
                this.addIsList(dB2InputStream);
                return dB2InputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getBytes(n2);
        if (null == byArray) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public void close() throws SQLException {
        if (!this.closed && this.statement != null && !this.statement.closed) {
            this.statement.getMoreResults();
            if (this.statement.moreResults) {
                this.statement.prefetchedMoreResults = true;
                this.closed = true;
            } else if (this.connection != null && !this.connection.SPConnected) {
                this.realClose();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void realClose() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "realClose()");
            }
            this.closed = true;
            if (null == this.statement) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(5, "statement is null");
                }
                Object var7_1 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit(this, "realClose()");
                return;
            }
            DB2Statement dB2Statement = this.statement;
            // MONITORENTER : dB2Statement
            if (this.statement.closed) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "statement is closed");
                }
                // MONITOREXIT : dB2Statement
                Object var7_2 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit(this, "realClose()");
                return;
            }
            if (this.connection == null) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "connection is null");
                }
                // MONITOREXIT : dB2Statement
                Object var7_3 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit(this, "realClose()");
                return;
            }
            DB2Connection dB2Connection = this.connection;
            // MONITORENTER : dB2Connection
            if (this.connection.closed) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(25, "connection is closed");
                }
                // MONITOREXIT : dB2Connection
                // MONITOREXIT : dB2Statement
                Object var7_4 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit(this, "realClose()");
                return;
            }
            this.clearIsList();
            int n2 = this.SQLFreeStmtClose(this.statement.statementHandle);
            if (n2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n2);
            }
            this.statement.prefetchedMoreResults = false;
            // MONITOREXIT : dB2Connection
            // MONITOREXIT : dB2Statement
            if (this.statement.internalStmt) {
                this.statement.close2(true);
            }
            Object var7_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "realClose()");
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "realClose()");
            throw throwable;
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString2(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean2(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte2(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort2(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt2(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong2(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat2(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble2(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal2(this.findColumn(string), n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes2(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream2(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream2(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream2(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        return this.statement.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.statement.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        this.statement.addWarning(sQLWarning);
    }

    public String getCursorName() throws SQLException {
        String string;
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetCursorName(this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return string;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        if (this.rsMetaData != null) {
            return this.rsMetaData;
        }
        return this.getMetaData2();
    }

    public DB2ResultSetMetaData getMetaData2() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.rsMetaData = DB2Trace.TraceOn ? new DB2ResultSetMetaDataTrace(this.statement, this, this.numCols, this.mappedRS) : new DB2ResultSetMetaData(this.statement, this, this.numCols, this.mappedRS);
        return this.rsMetaData;
    }

    protected Object getObject(int n2, int n3, int n4) throws SQLException {
        Object object = null;
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n2);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n2, n4);
                break;
            }
            case -7: {
                boolean bl = this.getBoolean(n2);
                if (this.wasNull()) break;
                object = new Boolean(bl);
                break;
            }
            case -6: {
                short s2 = this.getShort(n2);
                if (this.wasNull()) break;
                object = new Integer(s2);
                break;
            }
            case 5: {
                short s3 = this.getShort(n2);
                if (this.wasNull()) break;
                object = new Integer(s3);
                break;
            }
            case 4: {
                int n5 = this.getInt(n2);
                if (this.wasNull()) break;
                object = new Integer(n5);
                break;
            }
            case -5: {
                long l2 = this.getLong(n2);
                if (this.wasNull()) break;
                object = new Long(l2);
                break;
            }
            case 7: {
                float f2 = this.getFloat(n2);
                if (this.wasNull()) break;
                object = new Float(f2);
                break;
            }
            case 6: 
            case 8: {
                double d2 = this.getDouble(n2);
                if (this.wasNull()) break;
                object = new Double(d2);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n2);
                break;
            }
            case 91: {
                object = this.getDate(n2);
                break;
            }
            case 92: {
                object = this.getTime(n2);
                break;
            }
            case 93: {
                object = this.getTimestamp(n2);
                break;
            }
            case -98: {
                object = this.getBlob(n2);
                break;
            }
            case -350: 
            case -99: {
                object = this.getClob(n2);
                break;
            }
            case -400: 
            case 70: {
                object = this.getURL(n2);
                break;
            }
            default: {
                this.sqlExcptGen.rsException("22005");
            }
        }
        return object;
    }

    protected Object getObject(int n2, int n3) throws SQLException {
        return this.getObject(n2, n3, -1);
    }

    public Object getObject(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        int n3 = this.getColType(n2, true);
        return this.getObject(n2, n3);
    }

    protected Object getObject(String string, int n2, int n3) throws SQLException {
        return this.getObject(this.findColumn(string), n2, n3);
    }

    protected Object getObject(String string, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n2);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        int n2 = 0;
        int n3 = 0;
        if (this.rsMetaData == null) {
            this.rsMetaData = this.getMetaData2();
        }
        string = string.toUpperCase(Locale.US);
        if (null == this.name2Index) {
            n3 = this.statement.colCount4JSQL > 0 ? this.statement.colCount4JSQL : this.rsMetaData.getColumnCount();
            this.name2Index = new Hashtable((int)((double)n3 / 0.75 + 0.7));
            int n4 = 1;
            while (n4 <= n3) {
                String string2 = this.statement.colCount4JSQL > 0 ? this.statement.colNames4JSQL[n4 - 1] : this.rsMetaData.getColumnName(n4);
                if (string2 != null && !this.name2Index.containsKey(string2 = string2.toUpperCase(Locale.US))) {
                    this.name2Index.put(string2, new Integer(n4));
                    if (string2.equals(string)) {
                        n2 = n4;
                    }
                }
                ++n4;
            }
        } else {
            Integer n5 = (Integer)this.name2Index.get(string);
            if (n5 != null) {
                return n5;
            }
        }
        if (n2 == 0) {
            this.sqlExcptGen.rsException("S0022");
        }
        return n2;
    }

    protected DB2Statement getStmt() {
        return this.statement;
    }

    protected int getMappedColumn(int n2) throws SQLException {
        return n2;
    }

    protected int getColCount() throws SQLException {
        int n2 = this.SQLGetColumnCount(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return n2;
    }

    protected void reset(int n2, int n3) throws SQLException {
        this.reset(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reset(int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "reset( " + n2 + ") ");
            }
            this.numCols = this.statement.moreResults ? this.getColCount() : 0;
            this.currentRowId = 0;
            this.nullTag = true;
            this.closed = false;
            this.mappedRS = false;
            this.name2Index = null;
            if (this.colTypes.length < this.numCols) {
                this.colTypes = new int[this.numCols];
                this.colSizes = new int[this.numCols];
            }
            int n3 = 0;
            while (n3 < this.numCols) {
                this.colTypes[n3] = 0;
                this.colSizes[n3] = 0;
                ++n3;
            }
            if (this.rsMetaData != null) {
                this.rsMetaData.numberOfColumns = this.numCols;
                if (this.rsMetaData.colBaseTypesNotAdjusted != null) {
                    if (this.rsMetaData.colBaseTypesNotAdjusted.length < this.numCols) {
                        this.rsMetaData.colBaseTypesNotAdjusted = null;
                    } else {
                        int n4 = 0;
                        while (n4 < this.numCols) {
                            this.rsMetaData.colBaseTypesNotAdjusted[n4] = -99999;
                            ++n4;
                        }
                    }
                }
            }
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "reset()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "reset()");
    }

    protected void resetRows(int n2) throws SQLException {
    }

    public synchronized byte[] getDB2RowData() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        byte[] byArray = this.SQLGetRowDataInternal(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return byArray;
    }

    protected String getTraceHandle() {
        String string = "??";
        if (this.statement != null) {
            string = this.statement.getTraceHandle();
        }
        return string;
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        int n3;
        this.checkHandlesAndIndex(n2);
        if (this.connection.materializeLobData) {
            String string = this.getString(n2);
            if (string != null) {
                return new StringReader(string);
            }
            return null;
        }
        int n4 = this.getColType(n2, false);
        if (n4 != -99 && n4 != -350 && n4 != -98) {
            String string = this.getString(n2);
            if (string != null) {
                return new StringReader(string);
            }
            return null;
        }
        if (n4 == -99) {
            n3 = 41;
        } else {
            n3 = -351;
            if (n4 == -98) {
                this.sqlExcptGen.rsException("22005");
            }
        }
        Integer n5 = new Integer(this.sqlSuccess);
        int n6 = this.SQLGetLocator(n2, n3, n5, this.statement.statementHandle);
        int n7 = n5;
        if (n7 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, n7);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        return new DB2CharReader(this.statement, n3, n6);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public void afterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public boolean first() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean last() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRow() throws SQLException {
        int n2;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getRow()");
            }
            n2 = this.currentRowId;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
        return n2;
    }

    public boolean absolute(int n2) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean relative(int n2) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean previous() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.statement.checkFetchDirection(this.rsType, n2);
        this.fetchDirection = n2;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n2) throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.statement.checkFetchSize(this.maxRows, n2);
        this.fetchSize = n2;
    }

    public int getFetchSize() throws SQLException {
        if (this.fetchSize > 0) {
            return this.fetchSize;
        }
        return 1;
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcur;
    }

    public boolean rowUpdated() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public void updateNull(int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateNull(String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(String string, String string2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void insertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void deleteRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void refreshRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void moveToInsertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void moveToCurrentRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int n2) throws SQLException {
        return null;
    }

    public Blob getBlob(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        int n3 = 31;
        int n4 = this.getColType(n2, false);
        if (-98 == n4) {
            n3 = 31;
            Integer n5 = new Integer(this.sqlSuccess);
            int n6 = this.SQLGetLocator(n2, n3, n5, this.statement.statementHandle);
            int n7 = n5;
            if (n7 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n7);
            }
            if (-1 != this.returnLen) {
                this.nullTag = false;
                return new DB2Blob(this.statement, n6, n3);
            }
            this.nullTag = true;
            return null;
        }
        this.sqlExcptGen.rsException("22005");
        return null;
    }

    public Clob getClob(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        int n3 = this.getColType(n2, false);
        if (n3 != -99 && n3 != -350) {
            this.sqlExcptGen.rsException("22005");
            return null;
        }
        if (this.connection.materializeLobData) {
            String string = this.getString(n2);
            if (string != null) {
                return new DB2Clob(string);
            }
            return null;
        }
        int n4 = 41;
        n4 = -99 == n3 ? 41 : -351;
        Integer n5 = new Integer(this.sqlSuccess);
        int n6 = this.SQLGetLocator(n2, n4, n5, this.statement.statementHandle);
        int n7 = n5;
        if (n7 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, n7);
        }
        if (-1 != this.returnLen) {
            this.nullTag = false;
            return new DB2Clob(this.statement, n6, n4);
        }
        this.nullTag = true;
        return null;
    }

    public URL getURL(int n2) throws SQLException {
        this.checkHandlesAndIndex(n2);
        try {
            String string = this.getString(n2);
            if (string == null) {
                return null;
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.getMessage());
        }
    }

    public Array getArray(int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array Type");
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array Type");
        return null;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate2(n2, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate2(this.findColumn(string), calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime2(n2, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime2(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp2(n2, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp2(this.findColumn(string), calendar);
    }

    public void cancelRowUpdates() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void positionServerToCurrentRow() {
    }

    public long getQueryInstanceIdentifier() {
        return ((DB2PreparedStatement)this.statement).queryInstanceIdentifier;
    }
}

