/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DB2InputStream
extends InputStream {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int currentPosition;
    protected int docLength;
    protected int lobType;
    protected int marked;
    protected int bufferPos = 0;
    protected int bufferEnd = 0;
    protected static final int defaultBufferSize = 32000;
    protected byte[] buffer = null;
    protected int numBytesRead = 0;
    protected boolean closed = false;

    protected native int SQLGetLength(Integer var1, int var2, int var3, int var4);

    protected native int SQLReadArrayOfByte(byte[] var1, Integer var2, int var3, int var4, int var5, int var6);

    public DB2InputStream() {
        this.closed = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2InputStream(DB2Statement dB2Statement, int n2, int n3) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2InputStream( stmt, " + n2 + ", " + n3 + " )");
            }
            this.connection = dB2Statement.getDB2Connection();
            this.statement = this.connection.getInputStreamStmt();
            this.locator = n2;
            this.currentPosition = 1;
            this.marked = 1;
            this.lobType = n3;
            Integer n4 = new Integer(0);
            DB2Statement dB2Statement2 = this.statement;
            synchronized (dB2Statement2) {
                int n5;
                this.docLength = this.SQLGetLength(n4, this.lobType, this.locator, this.statement.statementHandle);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "docLength", this.docLength);
                }
                if ((n5 = n4.intValue()) != 0) {
                    this.connection.sqlExcptGen.check_return_code(this.statement, n5);
                }
            }
            this.closed = false;
            Object var9_8 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "DB2InputStream()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "DB2InputStream()");
    }

    protected boolean hasMore() {
        return this.currentPosition <= this.docLength;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n2 = 0;
        if (this.buffer != null) {
            n2 = this.bufferEnd - this.bufferPos;
        }
        if (this.currentPosition <= this.docLength) {
            n2 += this.docLength - this.currentPosition + 1;
        }
        return n2;
    }

    public synchronized int read() throws IOException {
        byte[] byArray;
        int n2;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "read()");
        }
        int n3 = (n2 = this.read(byArray = new byte[1])) == -1 ? n2 : (byArray[0] < 0 ? byArray[0] + 256 : byArray[0]);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "read()", n3);
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray) throws IOException {
        int n2;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b )");
            }
            if (this.available() == 0) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(5, "No more data available from the database");
                }
                n3 = -1;
            } else {
                int n4;
                n2 = byArray.length;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "bytesToRead", n2);
                }
                if (this.buffer != null) {
                    n4 = this.bufferEnd - this.bufferPos;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "bytesAvailable", n4);
                    }
                    if (n4 != 0) {
                        if (n2 <= n4) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n2);
                            this.bufferPos += n2;
                            n3 = n2;
                            n2 = 0;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n4);
                            this.bufferPos += n4;
                            n3 = n4;
                            n2 -= n4;
                        }
                    }
                }
                if (n2 != 0) {
                    this.buffer = new byte[Math.min(this.docLength - this.currentPosition + 1, Math.max(32000, n2))];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(30, "currentPosition", this.currentPosition);
                        DB2Trace.data(30, "bytesToRead", n2);
                        DB2Trace.data(30, "buffer.length", this.buffer.length);
                    }
                    n4 = 0;
                    if (this.buffer.length != 0) {
                        Integer n5 = new Integer(0);
                        try {
                            this.numBytesRead = 0;
                            DB2Statement dB2Statement = this.statement;
                            synchronized (dB2Statement) {
                                n4 = this.SQLReadArrayOfByte(this.buffer, n5, this.lobType, this.locator, this.currentPosition, this.statement.statementHandle);
                                int n6 = n5;
                                if (n6 != 0) {
                                    this.connection.sqlExcptGen.check_return_code(this.statement, n6);
                                }
                            }
                            this.currentPosition += this.numBytesRead;
                            if (this.lobType == -351) {
                                String string = null;
                                String string2 = System.getProperty("os.arch");
                                string = string2.indexOf("86") == -1 && string2.indexOf("ia64") == -1 ? new String(this.buffer, 0, n4, "UnicodeBig") : new String(this.buffer, 0, n4, "UnicodeLittle");
                                this.buffer = string.getBytes();
                                n4 = this.buffer.length;
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new IOException(sQLException.toString());
                        }
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(40, "bytesAvailable", n4);
                    }
                    this.bufferPos = 0;
                    this.bufferEnd = n4;
                    if (n4 != 0) {
                        if (n2 <= n4) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n3, n2);
                            this.bufferPos += n2;
                            n3 += n2;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n3, n4);
                            this.bufferPos += n4;
                            n3 += n4;
                        }
                    }
                }
            }
            n2 = n3;
            Object var10_12 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n3);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n5 = -1;
        try {
            byte[] byArray2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b, " + n2 + ", " + n3 + " )");
            }
            if ((n5 = this.read(byArray2 = new byte[n3])) != -1) {
                System.arraycopy(byArray2, 0, byArray, n2, n5);
            }
            n4 = n5;
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return n4;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n5);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n5);
        return n4;
    }

    public synchronized long skip(long l2) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (this.buffer != null && l2 >= (long)(this.bufferEnd - this.bufferPos)) {
            this.buffer = null;
            l2 -= (long)(this.bufferEnd - this.bufferPos);
        }
        if (this.buffer == null) {
            if (this.currentPosition + (int)l2 > this.docLength) {
                this.currentPosition = this.docLength + 1;
                l2 = this.docLength - this.currentPosition;
            } else {
                this.currentPosition += (int)l2;
            }
        }
        return l2;
    }

    public synchronized void mark(int n2) {
        this.marked = n2;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        this.currentPosition = this.marked;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() {
        this.closed = true;
    }

    public void finalize() {
        if (!this.closed) {
            this.close();
        }
    }

    final long getLength() throws SQLException {
        Integer n2 = new Integer(0);
        DB2Statement dB2Statement = this.statement;
        synchronized (dB2Statement) {
            this.docLength = this.SQLGetLength(n2, this.lobType, this.locator, this.statement.statementHandle);
            int n3 = n2;
            if (n3 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n3);
            }
        }
        return this.docLength;
    }

    void moveTo(int n2) {
        this.currentPosition = n2 < this.docLength ? n2 : this.docLength;
    }
}

