/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.mri.DB2Messages;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DB2Driver
implements Driver {
    private static DB2Driver ourDriver = null;
    public static final int MajorVersion = 8;
    public static final int MinorVersion = 1;
    private static final String libraryName = "libdb2jdbc.so";
    private static final String HPlibraryName = "libdb2jdbc.sl";
    private static final String libpath_unix = "lib";
    private static final String libpath32_unix = "lib32";
    private static final String libpath_nt = "bin";
    private static final String libpath_os2 = "dll";
    private static final String DLLName = "db2jdbc";
    private static final String MSDLLName = "db2jms";
    private static final String DLLName64 = "db2jdbc64";
    private static String language = "C";
    public static boolean loaded = false;
    protected int traceOn = 0;
    protected static int jvmHenv = 0;
    public static final String buildLevel = "s040812";

    protected native int SQLAllocEnv(int[] var1);

    protected native String SQLGetTracePath(Integer var1, Integer var2, Integer var3, int var4);

    protected native int SQLFreeEnv(int var1);

    public native String getDLLVersion();

    protected native int currentSPNestLevel();

    public String toString() {
        return "DB2Driver: JDBC 2.0 s040812";
    }

    public DB2Driver() throws SQLException {
        if (!loaded) {
            Object object;
            String string;
            Object object2;
            Object object3;
            String[] stringArray;
            Object[] objectArray;
            this.traceOn = 0;
            Object object4 = null;
            String string2 = null;
            try {
                objectArray = new String[5];
                AccessController.doPrivileged(new PrivilegedAction((String[])objectArray){
                    private final /* synthetic */ String[] val$sysProps;
                    {
                        this.val$sysProps = stringArray;
                    }

                    public Object run() {
                        this.val$sysProps[0] = System.getProperty("ibm.db2.instance.path");
                        this.val$sysProps[1] = System.getProperty("file.separator");
                        this.val$sysProps[2] = System.getProperty("os.arch");
                        this.val$sysProps[3] = System.getProperty("os.name");
                        this.val$sysProps[4] = System.getProperty("java.vendor");
                        return null;
                    }
                });
                string2 = objectArray[0];
                stringArray = objectArray[1];
                object3 = objectArray[2];
                object2 = objectArray[3];
                string = objectArray[4];
                if (string2 != null) {
                    if (stringArray != null && stringArray.equals("/")) {
                        object = null;
                        object4 = string2 + "/" + libpath_unix + "/";
                        object = string2 + "/" + libpath32_unix + "/";
                        if (object3 != null && ((String)object3).startsWith("PA_RISC")) {
                            object4 = (String)object4 + HPlibraryName;
                            object = (String)object + HPlibraryName;
                        } else {
                            object4 = (String)object4 + libraryName;
                            object = (String)object + libraryName;
                        }
                        if (object3 != null && object2 != null && ((String)object3).indexOf("64") == -1 && ((String)object2).indexOf("Linux") != -1 && new File((String)object).exists()) {
                            object4 = object;
                        }
                    } else {
                        object4 = string2 + "\\";
                        if (object2 != null && ((String)object2).startsWith("OS/2")) {
                            object4 = (String)object4 + "dll\\db2jdbc";
                        } else {
                            object4 = (String)object4 + "bin\\";
                            object4 = string != null && string.toLowerCase().indexOf("microsoft") != -1 ? (String)object4 + MSDLLName : (object3 != null && ((String)object3).indexOf("64") != -1 ? (String)object4 + DLLName64 : (String)object4 + DLLName);
                        }
                        object4 = (String)object4 + ".dll";
                    }
                    final String string3 = object4;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.load(string3);
                            return null;
                        }
                    });
                } else {
                    object4 = string != null && string.toLowerCase().indexOf("microsoft") != -1 ? MSDLLName : (stringArray != null && stringArray.equals("\\") && object3 != null && ((String)object3).indexOf("64") != -1 ? DLLName64 : DLLName);
                    final String string4 = object4;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.loadLibrary(string4);
                            return null;
                        }
                    });
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String[] stringArray2 = new String[]{object4};
                String string5 = new DB2Messages().getString("0646", stringArray2);
                DriverManager.println(string5);
                DriverManager.println(unsatisfiedLinkError.toString());
                throw new SQLException(unsatisfiedLinkError.toString());
            }
            objectArray = new int[1];
            int n2 = this.SQLAllocEnv((int[])objectArray);
            jvmHenv = (int)objectArray[0];
            if (n2 != 0) {
                stringArray = new String[]{String.valueOf(n2)};
                object3 = new DB2Messages().getString("0647", stringArray);
                DriverManager.println((String)object3);
                throw new SQLException((String)object3);
            }
            if (this.traceOn == 1) {
                stringArray = new Integer(0);
                object3 = new Integer(0);
                object2 = new Integer(0);
                string = this.SQLGetTracePath((Integer)stringArray, (Integer)object3, (Integer)object2, jvmHenv);
                if ((Integer)object2 != 0) {
                    DB2Trace.setTraceFlush(true);
                }
                if (stringArray.intValue() == 0 && string != null) {
                    DB2Trace.setTracePath(string);
                }
                if (!DB2Trace.isInitialized()) {
                    object = new DB2Trace((Integer)object3);
                    DB2Trace.methodEntry(this, "DB2Driver()");
                    if (string2 != null) {
                        ((DB2Trace)object).println("Loaded " + (String)object4);
                    } else {
                        ((DB2Trace)object).println("Loaded db2jdbc from java.library.path");
                    }
                    ((DB2Trace)object).println("DB2Driver: JDBC 2.0,  BuildLevel: s040812");
                    DB2Trace.methodExit(this, "DB2Driver()");
                }
            }
            loaded = true;
        }
    }

    public static void setLanguage(String string) {
        language = string;
    }

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        int n2 = string.indexOf(58);
        if (-1 == n2) {
            return null;
        }
        string2 = string.substring(0, n2);
        int n3 = string.indexOf(58, n2 + 1);
        if (-1 == n3) {
            return null;
        }
        string3 = string.substring(n2 + 1, n3);
        string4 = string.substring(n3 + 1);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect(" + string + ")\n");
        }
        if (string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//")) {
            ((Hashtable)properties).put("language", language);
            return new DB2Connection(string4, properties, this);
        }
        return null;
    }

    public Connection connect() throws SQLException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("language", language);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect()\n");
        }
        return new DB2Connection(properties, this);
    }

    public int getMajorVersion() {
        return 8;
    }

    public int getMinorVersion() {
        return 1;
    }

    public int getRelease() {
        return 0;
    }

    public boolean acceptsURL(String string) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().traceEntry(this.getClass().getName(), "DB2Connection(" + string + ")");
        }
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        int n2 = string.indexOf(58);
        string2 = string.substring(0, n2);
        int n3 = string.indexOf(58, n2 + 1);
        string3 = string.substring(n2 + 1, n3);
        string4 = string.substring(n3 + 1);
        boolean bl = string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//");
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().traceExit(this.getClass().getName(), "DB2Connection - Return value = " + bl);
        }
        return bl;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{new DriverPropertyInfo("user", null), new DriverPropertyInfo("password", null)};
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("user")) {
                driverPropertyInfoArray[0].value = properties.getProperty("user");
                continue;
            }
            if (!string2.equals("password")) continue;
            driverPropertyInfoArray[1].value = properties.getProperty("password");
        }
        return driverPropertyInfoArray;
    }

    public static int getJVMHenv() throws SQLException {
        return jvmHenv;
    }

    public void finalize() throws SQLException {
        if (this == ourDriver) {
            this.SQLFreeEnv(jvmHenv);
            ourDriver = null;
            loaded = false;
            language = "C";
            jvmHenv = 0;
        }
    }

    static {
        try {
            if (ourDriver == null) {
                ourDriver = new DB2Driver();
                DriverManager.registerDriver(ourDriver);
            }
        }
        catch (SQLException sQLException) {
            String[] stringArray = new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", sQLException.getMessage(), sQLException.getSQLState(), String.valueOf(sQLException.getErrorCode())};
            String string = new DB2Messages().getString("0645", stringArray);
            DriverManager.println(string);
        }
    }
}

