/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CharReader;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;

public class DB2Clob
implements Clob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected long cachedLength = -1L;
    protected int[] retCode = new int[1];
    protected String data = null;
    protected final String freeMe = "FREE LOCATOR ?";

    protected native int SQLGetStrPosition(int var1, int var2, int var3, String var4, int var5, int var6, int[] var7);

    protected native int SQLGetClobPosition(int var1, int var2, int var3, int var4, int var5, int var6, int[] var7);

    protected native long SQLGetLength(int var1, int var2, int var3, int[] var4);

    protected native String SQLGetClobSubString(int var1, int var2, int var3, long var4, int var6, int[] var7);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2Clob(DB2Statement dB2Statement, int n2, int n3) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Clob( stmt, " + n2 + ", " + n3 + " )");
            }
            this.locator = n2;
            this.lobType = n3;
            this.connection = (DB2Connection)dB2Statement.getConnection();
            this.statement = this.connection.getInputStreamStmt();
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "DB2Clob()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "DB2Clob()");
    }

    public DB2Clob(String string) {
        this.data = null == string ? new String() : string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            this.closed = true;
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "close()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "close()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "finalize()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "finalize()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        long l2;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            if (this.cachedLength < 0L) {
                if (this.data != null) {
                    this.cachedLength = this.data.length();
                } else {
                    this.cachedLength = this.SQLGetLength(this.statement.statementHandle, this.locator, this.lobType, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            l2 = this.cachedLength;
            Object var4_2 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "length()", this.cachedLength);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "length()", this.cachedLength);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSubString(long l2, int n2) throws SQLException {
        String string;
        String string2 = null;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getSubString( " + l2 + ", " + n2 + " )");
            }
            if (this.data != null) {
                if (l2 < 1L) {
                    throw new SQLException("Index out of bounds", "-99999");
                }
                if (l2 > (long)this.data.length() || 0 == n2) {
                    string2 = new String();
                } else if (1L == l2 && n2 >= this.data.length()) {
                    string2 = this.data;
                } else {
                    n2 = (int)Math.min((long)this.data.length() - l2 + 1L, (long)n2);
                    string2 = this.data.substring((int)(--l2), (int)l2 + n2);
                }
            } else {
                string2 = this.SQLGetClobSubString(this.statement.statementHandle, this.lobType, this.locator, l2, n2, this.retCode);
                if (this.retCode[0] != 0) {
                    this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                }
            }
            string = string2;
            Object var7_5 = null;
            if (!DB2Trace.TraceOn) return string;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getSubString()", string2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getSubString()", string2);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader getCharacterStream() throws SQLException {
        DB2CharReader dB2CharReader;
        block5: {
            StringReader stringReader;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getCharacterStream()");
                    }
                    if (this.data != null) {
                        stringReader = new StringReader(this.data);
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return stringReader;
                        break block4;
                    }
                    dB2CharReader = new DB2CharReader(this.statement, this.lobType, this.locator);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
            return stringReader;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return dB2CharReader;
        DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
        return dB2CharReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getAsciiStream() throws SQLException {
        DB2InputStream dB2InputStream;
        block5: {
            ByteArrayInputStream byteArrayInputStream;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getAsciiStream()");
                    }
                    if (this.data != null) {
                        byteArrayInputStream = new ByteArrayInputStream(this.data.getBytes());
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return byteArrayInputStream;
                        break block4;
                    }
                    dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
            return byteArrayInputStream;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return dB2InputStream;
        DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
        return dB2InputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(String string, long l2) throws SQLException {
        long l3;
        int n2 = -1;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( " + string + ", " + l2 + " )");
            }
            if (this.data != null) {
                n2 = this.data.indexOf(string, (int)l2 - 1);
                if (-1 != n2) {
                    ++n2;
                }
            } else {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    n2 = this.SQLGetStrPosition(this.statement.statementHandle, this.lobType, this.locator, string, (int)l2, this.connection.connectionHandle, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            l3 = n2;
            Object var8_7 = null;
            if (!DB2Trace.TraceOn) return l3;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", n2);
        return l3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long position(Clob clob, long l2) throws SQLException {
        long l3;
        long l4 = -1L;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern, " + l2 + " )");
            }
            if (clob instanceof DB2Clob && ((DB2Clob)clob).data == null && this.data == null) {
                int n2 = 0;
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    n2 = this.SQLGetClobPosition(this.statement.statementHandle, this.lobType, this.locator, ((DB2Clob)clob).getLocator(), (int)l2, this.connection.connectionHandle, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
                l4 = n2;
            } else {
                String string = clob.getSubString(0L, (int)clob.length());
                l4 = this.position(string, l2);
            }
            l3 = l4;
            Object var10_9 = null;
            if (!DB2Trace.TraceOn) return l3;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "position()", l4);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "position()", l4);
        return l3;
    }

    int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }
}

