/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DB2CharReader
extends Reader {
    protected int lobType;
    protected int lobLocator;
    protected int docLength;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected boolean closed;
    protected boolean markSupported = true;
    protected int rc = 0;
    protected int encoding;
    protected int currentPosition;
    protected int numBytesRead;
    protected int markedPosition;
    protected int bufferPos = 0;
    protected int bufferEnd = 0;
    protected static final int defaultBufferSize = 16000;
    protected char[] buffer = null;

    protected native int SQLGetLength(int var1);

    protected native String SQLReadStr(int var1, int var2, int var3);

    public DB2CharReader(DB2Statement dB2Statement, int n2, int n3) throws SQLException {
        this.lobType = n2;
        this.lobLocator = n3;
        DB2Connection dB2Connection = this.connection = (DB2Connection)dB2Statement.getConnection();
        synchronized (dB2Connection) {
            this.statement = this.connection.getInputStreamStmt();
            this.docLength = this.SQLGetLength(this.statement.statementHandle);
            this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
            this.closed = false;
            this.currentPosition = 1;
            this.markedPosition = 1;
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        char[] cArray = new char[1];
        int n2 = this.read(cArray, 0, 1);
        if (n2 == -1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        return this.read(cArray, 0, cArray.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int n5 = 0;
        try {
            int n6;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( buf, " + n2 + ", " + n3 + " )");
            }
            int n7 = n3;
            if (this.buffer != null && (n6 = this.bufferEnd - this.bufferPos) != 0) {
                if (n7 <= n6) {
                    System.arraycopy(this.buffer, this.bufferPos, cArray, n2, n7);
                    this.bufferPos += n7;
                    n5 = n7;
                    n7 = 0;
                } else {
                    System.arraycopy(this.buffer, this.bufferPos, cArray, n2, n6);
                    this.bufferPos += n6;
                    n5 = n6;
                    n7 -= n6;
                }
            }
            if (n7 != 0 && this.currentPosition <= this.docLength) {
                String string;
                n6 = 0;
                n3 = Math.max(16000, n7);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "currentPosition", this.currentPosition);
                    DB2Trace.data(30, "charsToRead", n7);
                    DB2Trace.data(30, "len", n3);
                }
                try {
                    this.numBytesRead = 0;
                    DB2Statement dB2Statement = this.statement;
                    synchronized (dB2Statement) {
                        string = this.SQLReadStr(n3, this.statement.statementHandle, this.connection.connectionHandle);
                        if (this.rc != 0) {
                            this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
                if (string != null) {
                    int n8 = string.length();
                    this.buffer = string.toCharArray();
                    n6 = n8;
                    this.currentPosition = this.lobType == 41 ? (this.currentPosition += this.numBytesRead) : (this.currentPosition += n8);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(40, "numBytesRead", this.numBytesRead);
                    DB2Trace.data(40, "charsAvailable", n6);
                }
                this.bufferPos = 0;
                this.bufferEnd = n6;
                if (n6 != 0) {
                    if (n7 <= n6) {
                        System.arraycopy(this.buffer, this.bufferPos, cArray, n2 + n5, n7);
                        this.bufferPos += n7;
                        n5 += n7;
                    } else {
                        System.arraycopy(this.buffer, this.bufferPos, cArray, n2 + n5, n6);
                        this.bufferPos += n6;
                        n5 += n6;
                    }
                }
            }
            if (n5 == 0) {
                n5 = -1;
            }
            n4 = n5;
            Object var11_13 = null;
            if (!DB2Trace.TraceOn) return n4;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n5);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n5);
        return n4;
    }

    public void close() {
        this.closed = true;
    }

    public boolean markSupported() {
        return this.markSupported;
    }

    public void mark(int n2) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("Mark()");
        }
        this.markedPosition = this.currentPosition;
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("reset()");
        }
        this.currentPosition = this.markedPosition;
    }

    public long skip(long l2) throws IOException {
        int n2;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("skip()");
        }
        if ((long)(n2 = this.docLength - this.currentPosition) < l2) {
            this.currentPosition = this.docLength;
            return n2;
        }
        this.currentPosition = (int)((long)this.currentPosition + l2);
        return l2;
    }

    int getLocator() {
        return this.lobLocator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getLength() throws SQLException {
        long l2;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getLength()");
            }
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.docLength = this.SQLGetLength(this.statement.statementHandle);
                this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
            }
            n2 = this.docLength;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "docLength", this.docLength);
            }
            l2 = n2;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return l2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getLength()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getLength()", n2);
        return l2;
    }

    void moveTo(int n2) {
        this.currentPosition = n2 < this.docLength ? n2 : this.docLength;
    }
}

