/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.app.DB2Driver;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2Socket;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class DB2Trace {
    protected static String NEWLINE = "\n";
    public static int TracePid = 0;
    protected static String jvmHenv = "";
    public static boolean TraceOn = false;
    public static boolean TraceFlush = false;
    protected static String TracePathName = "";
    protected static Hashtable threadTable = new Hashtable(43);
    protected static Stack timeStack = new Stack();
    protected static boolean fApplet = false;
    static DB2Socket TraceSocket = null;
    private static boolean fInitialized = false;
    protected StringBuffer sb = new StringBuffer("");
    protected FileWriter fw = null;
    protected String TraceThreadName = "";
    protected StringBuffer traceBuffer = new StringBuffer("");
    protected DB2Socket db2socket = null;
    protected DB2Request db2req = null;

    public DB2Trace() {
        if (fApplet) {
            this.DB2TraceNet();
        } else {
            this.DB2TraceApp();
        }
    }

    public DB2Trace(int n2) {
        fApplet = false;
        TracePid = n2;
        try {
            jvmHenv = "_" + DB2Driver.getJVMHenv() + "_";
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + " - DB2Trace(pid) Error: " + exception.toString());
        }
        NEWLINE = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
        this.DB2TraceApp();
        fInitialized = true;
    }

    public DB2Trace(String string, int n2) {
        fApplet = true;
        if (TraceSocket == null) {
            try {
                Socket socket = null;
                final String string2 = string;
                final int n3 = n2;
                try {
                    socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new Socket(string2, n3);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                TraceSocket = new DB2Socket(socket);
            }
            catch (IOException iOException) {
                System.err.println(this.getClass().getName() + " - DB2Trace( " + string + ", " + n2 + " ) Error: " + iOException.toString());
                TraceSocket = null;
            }
        }
        this.DB2TraceNet();
        fInitialized = true;
    }

    public void DB2TraceApp() {
        try {
            Properties properties = null;
            String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
            final String string2 = TracePid + jvmHenv + string + ".trc";
            final String string3 = TracePathName;
            try {
                properties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return System.getProperties();
                    }
                });
                this.fw = (FileWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new FileWriter(new File(string3, string2).getAbsolutePath(), true);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            String string4 = NEWLINE + "========================================================" + NEWLINE + "|    DB2 JDBC App Driver                                " + NEWLINE + "|                                                       " + NEWLINE + "|    Trace beginning on " + DB2Trace.getTimeStamp() + NEWLINE + "========================================================" + NEWLINE + NEWLINE + "System Properties:" + NEWLINE + "------------------" + NEWLINE;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string5;
                final String string6 = string5 = (String)enumeration.nextElement();
                String string7 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(string6);
                    }
                });
                string4 = string4 + string5 + " = " + string7 + NEWLINE;
            }
            string4 = string4 + "----------------------------------------" + NEWLINE + NEWLINE;
            threadTable.put(string2, this);
            TraceOn = true;
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + " - DB2TraceApp() Error: " + exception.toString());
        }
    }

    public void DB2TraceNet() {
        this.db2socket = TraceSocket;
        this.db2req = new DB2Request(this.db2socket);
        try {
            String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
            this.TraceThreadName = string + ".trc";
            String string2 = "java.version";
            String string3 = string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "java.vendor";
            string3 = string3 + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "java.class.version";
            string3 = string3 + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "os.name";
            string3 = string3 + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "os.arch";
            string3 = string3 + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "os.version";
            string3 = string3 + string2 + " = " + System.getProperty(string2) + NEWLINE;
            String string4 = NEWLINE + "========================================================" + NEWLINE + "|    DB2 JDBC Net Driver                                " + NEWLINE + "|                                                       " + NEWLINE + "|    Trace beginning on " + DB2Trace.getTimeStamp() + NEWLINE + "========================================================" + NEWLINE + NEWLINE + "db2java version: " + 2 + NEWLINE + "db2jd   version: " + DB2Connection.DB2JDBC_SERVER_VERSION + NEWLINE + NEWLINE + "System Properties:" + NEWLINE + "------------------" + NEWLINE + string3 + NEWLINE + "----------------------------------------" + NEWLINE + NEWLINE;
            this.sendToServer(string4);
            threadTable.put(this.TraceThreadName, this);
            TraceOn = true;
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + " - DB2TraceNet() Error: " + exception.toString());
        }
    }

    public static boolean isInitialized() {
        return fInitialized;
    }

    public static DB2Trace getTraceObj() {
        String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
        String string2 = null;
        DB2Trace dB2Trace = null;
        string2 = fApplet ? string + ".trc" : TracePid + jvmHenv + string + ".trc";
        dB2Trace = (DB2Trace)threadTable.get(string2);
        if (dB2Trace == null) {
            dB2Trace = new DB2Trace();
        }
        return dB2Trace;
    }

    public static DB2Trace getTraceObj(DB2Connection dB2Connection) {
        String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
        String string2 = string + ".trc";
        DB2Trace dB2Trace = (DB2Trace)threadTable.get(string2);
        if (dB2Trace == null) {
            dB2Trace = new DB2Trace();
        }
        return dB2Trace;
    }

    public static void setTraceOff() {
        TraceOn = false;
    }

    public static void setTraceOn() {
        TraceOn = true;
    }

    public static void setTraceFlush(boolean bl) {
        TraceFlush = bl;
    }

    public static void setTracePath(String string) {
        TracePathName = string;
    }

    public static long timer() {
        long l2 = DB2Trace.timeInMilli();
        return l2;
    }

    public static double computeTimeDiff(long l2, long l3) {
        return (double)(l3 - l2) / 1000.0;
    }

    public static long timeInMilli() {
        long l2 = System.currentTimeMillis();
        return l2;
    }

    public static String getTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = calendar.get(14);
        String string = n2 + "-" + n3 + "-" + n4 + " " + n5 + ":" + n6 + ":" + n7 + "." + n8;
        return string;
    }

    public void finalize() {
        this.close();
    }

    public void close() {
        if (fApplet) {
            if (this.isFlushNeeded()) {
                this.flushToServer();
            }
        } else if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (Exception exception) {
                System.err.println(this.getClass().getName() + " - close() Error: " + exception.toString());
            }
            this.fw = null;
        }
    }

    public void traceEntry(Object object) {
        this.traceEntry(object, "");
    }

    public void traceEntry(Object object, String string) {
        if (object != null) {
            this.traceEntry(object.getClass().getName().substring(12), string);
        }
    }

    public void traceEntry(Object object, String string, String string2) {
        if (object != null) {
            this.traceEntry(object.getClass().getName().substring(12), string, string2);
        }
    }

    public void traceEntry(String string, String string2) {
        this.traceEntry(string, string2, DB2Trace.getTimeStamp());
    }

    public void traceEntry(String string, String string2, String string3) {
        this.println(string + " -> " + string2 + " (" + string3 + ")");
        this.sb.append("| ");
    }

    public void traceExit(Object object) {
        this.traceExit(object, "");
    }

    public void traceExit(Object object, String string) {
        this.traceExit(object, string, "", -1.0);
    }

    public void traceExit(String string, String string2) {
        this.traceExit(string, string2, "", -1.0);
    }

    public void traceExit(Object object, String string, String string2, double d2) {
        if (object != null) {
            this.traceExit(object.getClass().getName().substring(12), string, string2, d2, DB2Trace.getTimeStamp());
        }
    }

    public void traceExit(Object object, String string, String string2, double d2, String string3) {
        if (object != null) {
            this.traceExit(object.getClass().getName().substring(12), string, string2, d2, string3);
        }
    }

    private void traceExit(String string, String string2, String string3, double d2, String string4) {
        int n2 = this.sb.length() - 2;
        if (n2 < 0) {
            n2 = 0;
        }
        this.sb.setLength(n2);
        String string5 = "";
        if (this.sb.length() == 0) {
            string5 = NEWLINE;
        }
        this.println(string + " <- " + string2 + (string3 == "" ? "" : " returns " + string3) + (d2 == -1.0 ? "" : " [Time Elapsed = " + d2 + "]") + (string4 == "" ? "" : " (" + string4 + ")") + string5);
    }

    public static void methodEntry(Object object, String string) {
        if (TraceOn) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            timeStack.push(timestamp);
            DB2Trace.getTraceObj().traceEntry(object, string, timestamp.toString());
        }
    }

    public static void methodExit(Object object, String string) {
        DB2Trace.methodExit(object, string, "");
    }

    public static void methodExit(Object object, String string, boolean bl) {
        DB2Trace.methodExit(object, string, String.valueOf(bl));
    }

    public static void methodExit(Object object, String string, short s2) {
        DB2Trace.methodExit(object, string, String.valueOf(s2));
    }

    public static void methodExit(Object object, String string, int n2) {
        DB2Trace.methodExit(object, string, String.valueOf(n2));
    }

    public static void methodExit(Object object, String string, long l2) {
        DB2Trace.methodExit(object, string, String.valueOf(l2));
    }

    public static void methodExit(Object object, String string, float f2) {
        DB2Trace.methodExit(object, string, String.valueOf(f2));
    }

    public static void methodExit(Object object, String string, double d2) {
        DB2Trace.methodExit(object, string, String.valueOf(d2));
    }

    public static void methodExit(Object object, String string, String string2) {
        if (TraceOn) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            Timestamp timestamp2 = timeStack.empty() ? timestamp : (Timestamp)timeStack.pop();
            long l2 = ((Date)timestamp2).getTime() + (long)(timestamp2.getNanos() / 1000000);
            long l3 = ((Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000);
            DB2Trace.getTraceObj().traceExit(object, string, string2, DB2Trace.computeTimeDiff(l2, l3), timestamp.toString());
        }
    }

    public static void data(int n2, String string, long l2) {
        DB2Trace.data(n2, string + " = " + l2);
    }

    public static void data(int n2, String string, int n3) {
        DB2Trace.data(n2, string + " = " + n3);
    }

    public static void data(int n2, String string, String string2) {
        DB2Trace.data(n2, string + " = " + string2);
    }

    public static void data(int n2, String string) {
        if (TraceOn) {
            DB2Trace.getTraceObj().println(n2 + ": " + string);
        }
    }

    public static String getNewline() {
        if (TraceOn) {
            return NEWLINE + DB2Trace.getTraceObj().sb.toString() + "| ";
        }
        return "";
    }

    public void println(String string, byte[] byArray) {
        if (byArray != null) {
            String string2 = "";
            int n2 = Math.min(4096, byArray.length);
            int n3 = 0;
            while (n3 < n2) {
                string2 = string2 + byArray[n3];
                ++n3;
            }
            this.println(string + string2);
        } else {
            this.println(string + "null");
        }
    }

    public void println(String string) {
        this.print(this.sb + string + NEWLINE);
    }

    public void print(String string) {
        if (string != null) {
            int n2 = string.length();
            if (n2 > 500) {
                String string2 = string.substring(0, 500);
                this.write(string2 + "(Truncated! Length was =" + n2 + ") " + NEWLINE);
            } else {
                this.write(string);
            }
        } else {
            this.print("null");
        }
    }

    public void write(String string) {
        if (fApplet) {
            this.sendToServer(string);
        } else {
            this.writeToFile(string);
        }
    }

    public void print(int n2) {
        String string = " " + n2;
        this.print(string);
    }

    public void println(int n2) {
        String string = " " + n2;
        this.println(string);
    }

    public void listProperties(Properties properties) {
        if (fApplet || properties == null) {
            return;
        }
        if (this.fw == null) {
            String string = "";
            Enumeration<?> enumeration = properties.propertyNames();
            String string2 = this.sb.toString();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                if (string3.equals("password")) {
                    string4 = "XXXXXX";
                }
                string2 = string2 + string + string3 + " = " + string4;
                string = ", ";
            }
            string2 = string2 + NEWLINE;
            this.writeToFile(string2);
        }
    }

    public static void flush() {
        if (TraceOn) {
            DB2Trace dB2Trace = DB2Trace.getTraceObj();
            if (fApplet) {
                if (dB2Trace.isFlushNeeded()) {
                    dB2Trace.flushToServer();
                }
            } else {
                dB2Trace.flushToFile();
            }
        }
    }

    public boolean isFlushNeeded() {
        return this.traceBuffer.length() > 0;
    }

    private void sendToServer(String string) {
        this.traceBuffer.append(string);
        if (TraceFlush || this.traceBuffer.length() > 16300) {
            this.flushToServer();
        }
    }

    private void flushToServer() {
        if (this.db2socket == null) {
            return;
        }
        try {
            this.db2req.write((short)118);
            this.db2req.write(this.TraceThreadName);
            this.db2req.write(this.traceBuffer.toString());
            this.db2req.sendAndRecv();
            int n2 = this.db2req.readInt();
            if (n2 != 0) {
                TraceOn = false;
            }
            this.traceBuffer.setLength(0);
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + " - sendToServer() Error: " + exception.toString());
        }
    }

    private void writeToFile(String string) {
        if (this.fw == null) {
            return;
        }
        try {
            final String string2 = string;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    DB2Trace.this.fw.write(string2);
                    if (TraceFlush) {
                        DB2Trace.this.fw.flush();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            System.err.println(this.getClass().getName() + " - writeToFile() Error: " + exception.toString());
            this.fw = null;
        }
    }

    private void flushToFile() {
        if (this.fw == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    DB2Trace.this.fw.flush();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            System.err.println(this.getClass().getName() + " - flushToFile() Error: " + exception.toString());
            this.fw = null;
        }
    }
}

