/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2BaseDataSource;
import COM.ibm.db2.jdbc.DB2ConnectionPool;
import COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class DB2DataSource
extends DB2BaseDataSource
implements DataSource {
    static final long serialVersionUID = 5015223647496639101L;
    private transient DB2ConnectionPool pool;
    private DB2ConnectionPoolDataSource cpds = new DB2ConnectionPoolDataSource();

    public void setDatabaseName(String string) {
        super.setDatabaseName(string);
        this.cpds.setDatabaseName(string);
    }

    public void setServerName(String string) {
        super.setServerName(string);
        this.cpds.setServerName(string);
    }

    public void setPortNumber(int n2) {
        super.setPortNumber(n2);
        this.cpds.setPortNumber(n2);
    }

    public void setConnectionAttribute(String string) {
        super.setConnectionAttribute(string);
        this.cpds.setConnectionAttribute(string);
    }

    public void setFullyMaterializeLobData(boolean bl) {
        super.setFullyMaterializeLobData(bl);
        this.cpds.setFullyMaterializeLobData(bl);
    }

    public Connection getConnection() throws SQLException {
        this.printToLog("getConnection() with no user or password");
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection;
        this.printToLog("getConnection(): user = " + string);
        if (null == this.pool) {
            this.pool = new DB2ConnectionPool();
        }
        if ((pooledConnection = this.pool.lookup(string, string2)) == null) {
            pooledConnection = this.cpds.getPooledConnection(string, string2);
            pooledConnection.addConnectionEventListener(this.pool);
        }
        return pooledConnection.getConnection();
    }

    public void finalize() throws SQLException {
        this.pool.clear();
        this.pool = null;
        this.cpds = null;
    }
}

