/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2ConnectionInfo;
import COM.ibm.db2.jdbc.DB2PooledConnection;
import COM.ibm.db2.jdbc.DB2Trace;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

class DB2ConnectionPool
implements ConnectionEventListener {
    private DB2ConnectionInfo[] connectionList = new DB2ConnectionInfo[1024];
    private int numConnections = 0;
    private int lastEntryChecked = -1;

    DB2ConnectionPool() {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "connectionClosed( event )");
        }
        DB2PooledConnection dB2PooledConnection = (DB2PooledConnection)connectionEvent.getSource();
        int n2 = dB2PooledConnection.getID();
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "numConnections", this.numConnections);
        }
        DB2ConnectionPool dB2ConnectionPool = this;
        synchronized (dB2ConnectionPool) {
            if (n2 > 0) {
                this.connectionList[n2 - 1].setAvailable(true);
            } else if (this.numConnections < this.connectionList.length) {
                this.connectionList[this.numConnections] = new DB2ConnectionInfo();
                this.connectionList[this.numConnections].setPooledConnection(dB2PooledConnection);
                ++this.numConnections;
                dB2PooledConnection.setID(this.numConnections);
            } else {
                int n3 = 0;
                while (n3 < this.numConnections) {
                    if (!this.connectionList[n3].isValid() && this.connectionList[n3].isAvailable()) {
                        dB2PooledConnection.setID(n3 + 1);
                        this.connectionList[n3].setPooledConnection(dB2PooledConnection);
                        this.connectionList[n3].setAvailable(true);
                        break;
                    }
                    ++n3;
                }
                if (dB2PooledConnection.getID() == 0) {
                    try {
                        dB2PooledConnection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "connectionClosed()");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "connectionErrorOccurred( event )");
        }
        DB2PooledConnection dB2PooledConnection = (DB2PooledConnection)connectionEvent.getSource();
        int n2 = dB2PooledConnection.getID();
        DB2ConnectionPool dB2ConnectionPool = this;
        synchronized (dB2ConnectionPool) {
            if (n2 != 0) {
                this.connectionList[n2 - 1].setInvalid();
            }
        }
        try {
            dB2PooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "connectionErrorOccurred()");
        }
    }

    PooledConnection lookup(String string, String string2) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "lookup()");
        }
        PooledConnection pooledConnection = null;
        int n2 = this.lastEntryChecked + 1;
        pooledConnection = this.searchList(n2, this.numConnections, string, string2);
        if (pooledConnection == null) {
            pooledConnection = this.searchList(0, n2, string, string2);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "lookup()");
        }
        return pooledConnection;
    }

    synchronized PooledConnection searchList(int n2, int n3, String string, String string2) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "searchList( " + n2 + ", " + n3 + ", " + string + ", <password> )");
        }
        DB2ConnectionInfo dB2ConnectionInfo = null;
        DB2PooledConnection dB2PooledConnection = null;
        if (null == string) {
            string = "";
        }
        if (null == string2) {
            string2 = "";
        }
        int n4 = n2;
        while (n4 < n3) {
            this.lastEntryChecked = n4;
            dB2ConnectionInfo = this.connectionList[n4];
            if (dB2ConnectionInfo.isAvailable() && dB2ConnectionInfo.isValid()) {
                dB2PooledConnection = (DB2PooledConnection)dB2ConnectionInfo.getPooledConnection();
                if (string.equals(dB2PooledConnection.info.getProperty("user", "")) && string2.equals(dB2PooledConnection.info.getProperty("password", ""))) {
                    dB2ConnectionInfo.setAvailable(false);
                    break;
                }
                dB2PooledConnection = null;
            }
            ++n4;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "searchList()", dB2PooledConnection == null ? "null" : "PooledConnection(id=" + (n4 + 1) + ")");
        }
        return dB2PooledConnection;
    }

    synchronized void clear() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "clear()");
        }
        DB2ConnectionInfo dB2ConnectionInfo = null;
        int n2 = 0;
        while (n2 < this.numConnections) {
            dB2ConnectionInfo = this.connectionList[n2];
            if (dB2ConnectionInfo.isValid()) {
                dB2ConnectionInfo.getPooledConnection().close();
                dB2ConnectionInfo.setInvalid();
            }
            ++n2;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "clear()");
        }
    }
}

