/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

class JarResource
implements ClassLoaderResource {
    String resourceName;
    File jarFile;

    JarResource(File file, String string) {
        this.resourceName = string;
        this.jarFile = file;
    }

    public InputStream getInputStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.resourceName.startsWith("/")) {
            this.resourceName = this.resourceName.substring(1, this.resourceName.length());
        }
        try {
            JarFile jarFile = new JarFile(this.jarFile);
            ZipEntry zipEntry = jarFile.getEntry(this.resourceName);
            if (zipEntry == null) {
                jarFile.close();
                return byteArrayInputStream;
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = inputStream.read(byArray);
            while (n2 != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            jarFile.close();
        }
        catch (IOException iOException) {
            byteArrayInputStream = null;
        }
        return byteArrayInputStream;
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public long getLastModified() {
        return this.jarFile.lastModified();
    }
}

