/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassLoaderTemplate;
import COM.ibm.db2.app.classloader.ClassLoaderTracer;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DynamicClassLoader
extends ClassLoaderTemplate
implements Validatable {
    ClassLoaderTracer tracer = ClassLoaderTracer.instance();
    Vector providers;
    Vector loaderListeners;
    Hashtable classes = new Hashtable();

    DynamicClassLoader() {
        if (this.tracer.isTracing) {
            this.tracer.trace("DynamicClassLoader::DynamicClassLoader()");
        }
        this.providers = new Vector();
        this.loaderListeners = new Vector();
    }

    protected void addClassProvider(ClassProvider classProvider) {
        if (this.tracer.isTracing) {
            this.tracer.trace("DynamicClassLoader:addClassProvider. add ClassProvider for path: " + classProvider.getClassPath(), 1);
        }
        this.providers.addElement(classProvider);
        if (this.tracer.isTracing) {
            this.tracer.trace("DynamicClassLoader:addClassProvider. classpath: " + this.getClassPath(), 3);
        }
    }

    protected void removeClassProvider(ClassProvider classProvider) {
        if (this.tracer.isTracing) {
            this.tracer.trace("remove ClassProvider for path: " + classProvider.getClassPath(), 3);
        }
        this.providers.removeElement(classProvider);
        if (this.tracer.isTracing) {
            this.tracer.trace("classpath: " + this.getClassPath(), 3);
        }
    }

    protected URL getNonSystemResource(String string) {
        if (this.tracer.isTracing) {
            this.tracer.trace("getNonSystemResource: not supported" + string, 3);
        }
        return null;
    }

    protected InputStream getNonSystemResourceAsStream(String string) {
        int n2 = this.providers.size();
        int n3 = 0;
        while (n3 < n2) {
            ClassProvider classProvider = (ClassProvider)this.providers.elementAt(n3);
            if (classProvider.hasResource(string)) {
                ClassLoaderResource classLoaderResource = classProvider.getResource(string);
                if (this.tracer.isTracing) {
                    this.tracer.trace("getNonSystemResourceAsStream: " + string + "[" + this.getAbsoluteResourcePath(string) + "]", 3);
                }
                return classLoaderResource.getInputStream();
            }
            ++n3;
        }
        return null;
    }

    protected Class loadNonSystemClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.getClass(string = string.replace('/', '.'));
        if (null != clazz) {
            return clazz;
        }
        DynamicClassLoader dynamicClassLoader = this;
        synchronized (dynamicClassLoader) {
            clazz = this.getClass(string);
            if (null != clazz) {
                Class<?> clazz2 = clazz;
                return clazz2;
            }
            int n2 = this.providers.size();
            byte[] byArray = null;
            int n3 = 0;
            while (byArray == null && n3 < n2) {
                ClassProvider classProvider = (ClassProvider)this.providers.elementAt(n3);
                byArray = classProvider.getClassBytes(string);
                ++n3;
            }
            if (byArray == null) {
                if (this.tracer.isTracing) {
                    this.tracer.trace("non-system class not found: " + string, 4);
                }
                throw new ClassNotFoundException(string);
            }
            if (this.tracer.isTracing) {
                this.tracer.trace("DynamicClassLoader:loadNonSystemClass. defineClass: " + string, 2);
            }
            if (null == clazz) {
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                this.cacheClass(string, clazz);
            }
        }
        return clazz;
    }

    public void validate() throws InvalidationException {
        int n2 = this.providers.size();
        int n3 = 0;
        while (n3 < n2) {
            ClassProvider classProvider = (ClassProvider)this.providers.elementAt(n3);
            try {
                classProvider.validate();
            }
            catch (InvalidationException invalidationException) {
                throw new InvalidationException("DynamicClassLoader is invalid", invalidationException.getDetailedMessage());
            }
            ++n3;
        }
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (InvalidationException invalidationException) {
            this.tracer.trace("ClassLoader is invalid", invalidationException);
            return false;
        }
        return true;
    }

    public String getAbsoluteResourcePath(String string) {
        int n2 = this.providers.size();
        int n3 = 0;
        while (n3 < n2) {
            ClassProvider classProvider = (ClassProvider)this.providers.elementAt(n3);
            String string2 = classProvider.getAbsoluteResourcePath(string);
            if (string2 != null) {
                return string2;
            }
            ++n3;
        }
        return null;
    }

    protected Enumeration getClassProviders() {
        return this.providers.elements();
    }

    public String getClassPath() {
        String string = null;
        Enumeration enumeration = this.getClassProviders();
        if (enumeration.hasMoreElements()) {
            string = ((ClassProvider)enumeration.nextElement()).getClassPath();
        }
        while (enumeration.hasMoreElements()) {
            string = string + File.pathSeparator + ((ClassProvider)enumeration.nextElement()).getClassPath();
        }
        return string;
    }

    protected Class getClass(String string) {
        return (Class)this.classes.get(string);
    }

    protected void cacheClass(String string, Class clazz) {
        this.classes.put(string, clazz);
    }

    public void finalize() {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::finalize()");
        }
    }
}

