/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.FileDependency;
import COM.ibm.db2.app.classloader.FileResource;
import COM.ibm.db2.app.classloader.NilResource;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class DirClassProvider
implements ClassProvider,
Validatable {
    File directory;
    Hashtable dependency;
    long timeStamp;

    public DirClassProvider(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(this.directory.getAbsolutePath() + " is not a directory");
        }
        this.directory = file;
        this.dependency = new Hashtable();
    }

    public byte[] getClassBytes(String string) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        try {
            string = string.replace('.', '/');
            String string2 = this.getRealResourcePath(string + ".class");
            File file = new File(string2);
            fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[(int)file.length()];
            dataInputStream.readFully(byArray);
            this.addDependency(string, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public boolean hasResource(String string) {
        try {
            string = string.replace('/', File.separatorChar);
            String string2 = this.getRealResourcePath(string);
            File file = new File(string2);
            return file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getAbsoluteResourcePath(String string) {
        if (this.hasResource(string)) {
            return this.getRealResourcePath(string);
        }
        return null;
    }

    public ClassLoaderResource getResource(String string) {
        try {
            if (this.hasResource(string)) {
                string = this.getRealResourcePath(string);
                File file = new File(string);
                this.addDependency(string, file);
                FileResource fileResource = new FileResource(file);
                return fileResource;
            }
            return null;
        }
        catch (Exception exception) {
            return NilResource.instance();
        }
    }

    public void validate() throws InvalidationException {
        Enumeration enumeration = this.dependency.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FileDependency fileDependency = (FileDependency)this.dependency.get(string);
            fileDependency.validate();
        }
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }

    void addDependency(String string, File file) {
        this.dependency.put(string, new FileDependency(file));
    }

    String getRealResourcePath(String string) {
        String string2;
        String string3;
        int n2 = string.lastIndexOf("/");
        if (string.startsWith("/")) {
            string = string.substring(0);
        }
        if (n2 == -1) {
            string3 = string;
            string2 = this.directory.getPath();
        } else {
            string3 = string.substring(n2 + 1);
            string2 = string.substring(0, n2);
            if (string2.startsWith("/")) {
                string2 = string2.substring(0);
            }
            string2 = string2.equals("") ? this.directory.getPath() : this.directory.getPath() + File.separator + string2;
        }
        string2 = string2.replace('/', File.separatorChar);
        return string2 + File.separator + string3;
    }

    public String getClassPath() {
        return this.directory.getAbsolutePath();
    }
}

