/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.util.UnicodeEscapeWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;
import javax.annotation.Nonnull;

public class JavaUnicodeEscapeWriter
extends UnicodeEscapeWriter {
    private static final BitSet ESCAPE = new BitSet(128);
    private final CharsetEncoder m_aEncoder;

    public JavaUnicodeEscapeWriter(@Nonnull OutputStreamWriter outputStreamWriter) {
        super(outputStreamWriter);
        this.m_aEncoder = Charset.forName(outputStreamWriter.getEncoding()).newEncoder();
    }

    @Override
    protected boolean requireEscaping(int n) {
        if (ESCAPE.get(n)) {
            return true;
        }
        if (n < 128) {
            return false;
        }
        return !this.m_aEncoder.canEncode((char)n);
    }

    static {
        for (int i = 0; i < 32; ++i) {
            if (i == 9 || i == 13 || i == 10) continue;
            ESCAPE.set(i, true);
        }
    }
}

