/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import com.helger.jcodemodel.ChangeInV4;
import com.helger.jcodemodel.util.JCStringHelper;
import java.io.File;
import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JCFilenameHelper {
    public static final String PATH_CURRENT = ".";
    public static final String PATH_PARENT = "..";
    public static final char UNIX_SEPARATOR = '/';
    public static final String UNIX_SEPARATOR_STR = Character.toString('/');
    public static final char WINDOWS_SEPARATOR = '\\';
    public static final String WINDOWS_SEPARATOR_STR = Character.toString('\\');
    public static final String UNIX_UNC_PREFIX = "//";
    public static final String WINDOWS_UNC_PREFIX = "\\\\";
    public static final String WINDOWS_UNC_PREFIX_LOCAL1 = "\\\\.\\";
    public static final String WINDOWS_UNC_PREFIX_LOCAL2 = "\\\\?\\";
    private static final char[] WINDOWS_ILLEGAL_CHARACTERS = new char[]{'\u0000', '<', '>', '?', '*', ':', '|', '\"'};
    private static final char[] UNIX_ILLEGAL_CHARACTERS = new char[]{'\u0000'};
    private static final String[] WINDOWS_ILLEGAL_PREFIXES = new String[]{"CLOCK$", "CON", "PRN", "AUX", "NUL", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final char[] WINDOWS_ILLEGAL_SUFFIXES = new char[]{'.', ' ', '\t'};

    private JCFilenameHelper() {
    }

    @ChangeInV4
    static boolean isFileSystemCaseSensitive() {
        try {
            if (System.getProperty("com.sun.codemodel.FileSystemCaseSensitive") != null) {
                System.err.println("Dear JCodeModel user: the currently defined system property 'com.sun.codemodel.FileSystemCaseSensitive' will not be evaluated in the upcoming v4. Use JCodeMode.setFileSystemConvention instead.");
                return true;
            }
            if (System.getProperty("com.helger.jcodemodel.FileSystemCaseSensitive") != null) {
                System.err.println("Dear JCodeModel user: the currently defined system property 'com.helger.jcodemodel.FileSystemCaseSensitive' will not be evaluated in the upcoming v4. Use JCodeMode.setFileSystemConvention instead.");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return File.separatorChar == '/';
    }

    @Nullable
    public static String getPathUsingUnixSeparator(@Nullable File file) {
        return file == null ? null : JCFilenameHelper.getPathUsingUnixSeparator(file.getPath());
    }

    @Nullable
    public static String getPathUsingUnixSeparator(@Nullable String string) {
        return string == null ? null : JCStringHelper.replaceAll(string, '\\', '/');
    }

    public static boolean isValidLinuxFilename(@Nullable String string) {
        if (JCStringHelper.hasNoText(string)) {
            return false;
        }
        if (JCFilenameHelper.containsPathSeparatorChar(string)) {
            return false;
        }
        if (PATH_CURRENT.equals(string) || PATH_PARENT.equals(string)) {
            return false;
        }
        for (char c : UNIX_ILLEGAL_CHARACTERS) {
            if (string.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidWindowsFilename(@Nullable String string) {
        if (JCStringHelper.hasNoText(string)) {
            return false;
        }
        if (JCFilenameHelper.containsPathSeparatorChar(string)) {
            return false;
        }
        if (PATH_CURRENT.equals(string) || PATH_PARENT.equals(string)) {
            return false;
        }
        if (JCStringHelper.endsWithAny(string, WINDOWS_ILLEGAL_SUFFIXES)) {
            return false;
        }
        for (char c : WINDOWS_ILLEGAL_CHARACTERS) {
            if (string.indexOf(c) == -1) continue;
            return false;
        }
        for (char c : (Object)WINDOWS_ILLEGAL_PREFIXES) {
            if (!string.equalsIgnoreCase((String)c)) continue;
            return false;
        }
        Object object = string.toUpperCase(Locale.ROOT);
        for (String string2 : WINDOWS_ILLEGAL_PREFIXES) {
            if (!((String)object).startsWith(string2 + PATH_CURRENT)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSecureFilenameCharacter(char c) {
        return c >= ' ' && c < '\u0080';
    }

    public static boolean isPathSeparatorChar(char c) {
        return c == '/' || c == '\\';
    }

    public static boolean startsWithPathSeparatorChar(@Nullable CharSequence charSequence) {
        return JCFilenameHelper.isPathSeparatorChar(JCStringHelper.getFirstChar(charSequence));
    }

    public static boolean endsWithPathSeparatorChar(@Nullable CharSequence charSequence) {
        return JCFilenameHelper.isPathSeparatorChar(JCStringHelper.getLastChar(charSequence));
    }

    public static boolean containsPathSeparatorChar(@Nullable String string) {
        return string != null && (string.indexOf(47) >= 0 || string.indexOf(92) >= 0);
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathStartingWithSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return JCFilenameHelper.startsWithPathSeparatorChar(string) ? string : File.separator + string;
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathEndingWithoutSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        while (JCFilenameHelper.endsWithPathSeparatorChar(string2)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathEndingWithSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return JCFilenameHelper.endsWithPathSeparatorChar(string) ? string : string + File.separator;
    }
}

